/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.ws.exchange;

import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import io.slingr.services.ws.exchange.UploadedFile;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class WebServiceRequest
implements JsonSource {
    private final RestMethod method;
    private final String path;
    private final Object body;
    private final Json headers;
    private final Json parameters;
    private final Json requestInfo;
    private final List<UploadedFile> files;
    private final Json variables = Json.map();
    private String rawBody;

    public WebServiceRequest(RestMethod method, String path, Object body, Json headers, Json parameters, Json requestInfo, List<UploadedFile> files) {
        this.method = method;
        this.path = path;
        this.body = body;
        if (headers != null) {
            Json lowerCaseHeaders = Json.map();
            headers.forEachMap((key, value) -> lowerCaseHeaders.set(key.toLowerCase(), value));
            this.headers = lowerCaseHeaders;
        } else {
            this.headers = null;
        }
        this.parameters = parameters;
        this.requestInfo = requestInfo;
        this.files = files == null ? new ArrayList() : files;
    }

    public RestMethod getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Object getBody() {
        return this.body;
    }

    public String getRawBody() {
        return this.rawBody;
    }

    public void setRawBody(String rawBody) {
        this.rawBody = rawBody;
    }

    public Json getJsonBody() {
        Object bd = this.getBody();
        if (bd == null) {
            return Json.map();
        }
        if (bd instanceof Json) {
            return (Json)bd;
        }
        return Json.fromObject(bd);
    }

    public Json getHeaders() {
        if (this.headers == null) {
            return null;
        }
        return this.headers.cloneJson();
    }

    public String getHeader(String header) {
        if (this.headers != null && StringUtils.isNotBlank((String)header)) {
            return this.headers.string(header.toLowerCase());
        }
        return null;
    }

    public Object getObjectHeader(String header) {
        if (this.headers != null && StringUtils.isNotBlank((String)header)) {
            return this.headers.object(header.toLowerCase());
        }
        return null;
    }

    public void setHeader(String header, String value) {
        if (this.headers != null && StringUtils.isNotBlank((String)header)) {
            this.headers.set(header.toLowerCase(), value);
        }
    }

    public Json getParameters() {
        return this.parameters;
    }

    public String getParameter(String parameter) {
        if (this.parameters != null && StringUtils.isNotBlank((String)parameter)) {
            return this.parameters.string(parameter);
        }
        return null;
    }

    public Json getRequestInfo() {
        return this.requestInfo;
    }

    public List<UploadedFile> getFiles() {
        return this.files;
    }

    public Json getPathVariables() {
        return this.variables;
    }

    public void setPathVariable(String variable, String value) {
        if (StringUtils.isNotBlank((String)variable)) {
            this.variables.set(variable, value);
        }
    }

    public String getPathVariable(String variable) {
        if (StringUtils.isNotBlank((String)variable)) {
            return this.variables.string(variable);
        }
        return null;
    }

    @Override
    public Json toJson() {
        Object bd = this.getBody();
        return Json.map().set("method", this.method.toString()).set("path", this.getPath()).setIfNotNull("body", bd instanceof JsonSource ? ((JsonSource)bd).toJson() : (bd != null ? bd.toString() : null)).setIfNotEmpty("headers", this.getHeaders()).setIfNotEmpty("parameters", this.getParameters()).setIfNotEmpty("requestInfo", this.getRequestInfo()).setIfNotEmpty("files", this.getFiles().stream().map(UploadedFile::toJson).collect(Collectors.toList())).setIfNotEmpty("pathVariables", this.getPathVariables());
    }

    public String toString() {
        return this.toJson().toString();
    }
}

