/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.utils.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBConfigurations {
    private static final Logger logger = LoggerFactory.getLogger(EBConfigurations.class);
    private final ExtensionBrokerApi api;
    private final boolean debug;

    public EBConfigurations(ExtensionBrokerApi api, boolean debug) {
        this.api = api;
        this.debug = debug;
    }

    public Json get() {
        if (this.debug) {
            logger.info(String.format("%s getting Extension Broker configuration", "DEBUG>"));
        }
        try {
            Json response = this.api.getConfiguration();
            if (this.debug) {
                logger.info(String.format("%s received Extension Broker configuration [%s]", "DEBUG>", response != null ? response.toString() : "-"));
            }
            return response;
        }
        catch (ServiceException ex) {
            logger.warn(String.format("Exception when get Extension Broker configuration: [%s]", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            String log = String.format("Exception when get Extension Broker configuration: [%s]", ex.getMessage());
            logger.warn(log, (Throwable)ex);
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)log, ex);
        }
    }
}

