/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework.annotations.processor;

import io.slingr.services.framework.IHttpService;
import io.slingr.services.framework.IPerUserService;
import io.slingr.services.framework.annotations.ApplicationLogger;
import io.slingr.services.framework.annotations.ServiceConfiguration;
import io.slingr.services.framework.annotations.ServiceDataStore;
import io.slingr.services.framework.annotations.ServiceFunction;
import io.slingr.services.framework.annotations.ServiceFunctions;
import io.slingr.services.framework.annotations.ServiceProperty;
import io.slingr.services.framework.annotations.ServiceUserDataStore;
import io.slingr.services.framework.annotations.ServiceWebService;
import io.slingr.services.framework.annotations.ServiceWebServices;
import io.slingr.services.framework.annotations.SlingrService;
import io.slingr.services.framework.annotations.classes.ClassApplicationLogger;
import io.slingr.services.framework.annotations.classes.ClassDataStore;
import io.slingr.services.framework.annotations.classes.ClassFunction;
import io.slingr.services.framework.annotations.classes.ClassProperty;
import io.slingr.services.framework.annotations.classes.ClassService;
import io.slingr.services.framework.annotations.classes.ClassUserDataStore;
import io.slingr.services.framework.annotations.classes.ClassWebService;
import io.slingr.services.framework.annotations.processor.AnnotationsUtils;
import io.slingr.services.services.rest.RestMethod;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class SlingrServiceProcessor
extends AbstractProcessor {
    private Elements elementUtils;
    private Filer filer;
    private ClassService slingrClassService = null;
    private boolean generatedRunner = false;

    @Override
    public synchronized void init(ProcessingEnvironment environment) {
        super.init(environment);
        this.elementUtils = environment.getElementUtils();
        this.filer = environment.getFiler();
        AnnotationsUtils.set(environment);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(SlingrService.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element2 : roundEnv.getElementsAnnotatedWith(SlingrService.class)) {
            AnnotationsUtils.note(element2, "Processing [@%s] on [%s] element ", ClassService.SE_NAME, element2.getSimpleName());
            if (element2.getKind() == ElementKind.CLASS) {
                try {
                    TypeMirror superClassType;
                    ClassService classService = new ClassService(element2);
                    if (!classService.isValidClass()) {
                        return true;
                    }
                    if (this.slingrClassService != null) {
                        AnnotationsUtils.error(element2, "Conflict: The class [%s] is annotated with @%s but [%s] already implements the service", classService.getQualifiedName(), ClassService.SE_NAME, this.slingrClassService.getQualifiedName());
                        return false;
                    }
                    String simpleName = classService.getSimpleName();
                    AnnotationsUtils.note(element2, "[%s] is a valid service", simpleName);
                    TypeElement currentClass = classService.getTypeElement();
                    this.processElements(roundEnv, currentClass, classService);
                    this.slingrClassService = classService;
                    boolean addedPerUserElements = false;
                    boolean addedHttpElements = false;
                    while (!((superClassType = currentClass.getSuperclass()) instanceof NoType)) {
                        String canonicalName = superClassType.toString();
                        currentClass = (TypeElement)AnnotationsUtils.asElement(superClassType);
                        if (!addedPerUserElements && currentClass.getInterfaces().stream().map(Object::toString).anyMatch(s -> IPerUserService.class.getCanonicalName().equals(s))) {
                            AnnotationsUtils.note(currentClass, "Processing PER USER elements > " + canonicalName, new Object[0]);
                            classService.registerCodeGenerator(builder -> builder.addCode("\n", new Object[0]).addComment("PER USER functions and events are initialized.", new Object[0]));
                            currentClass.getEnclosedElements().forEach(element -> {
                                String name = element.getSimpleName().toString();
                                if (element.getKind() == ElementKind.METHOD) {
                                    switch (name) {
                                        case "defaultMethodConnectUsers": {
                                            this.registerDefaultFunction("connectUser", "PER USER connect", classService, (Element)element, name, IPerUserService.class);
                                            break;
                                        }
                                        case "defaultMethodDisconnectUsers": {
                                            this.registerDefaultFunction("disconnectUser", "PER USER disconnect", classService, (Element)element, name, IPerUserService.class);
                                            break;
                                        }
                                        case "defaultExternalConnectUser": {
                                            this.registerDefaultWebService("WEBHOOK", classService, (Element)element, "/sys/users/{userId}/connect", Arrays.asList(RestMethod.PUT, RestMethod.POST), (Class<?>)IPerUserService.class);
                                            break;
                                        }
                                        case "defaultExternalDisconnectUser": {
                                            this.registerDefaultWebService("WEBHOOK", classService, (Element)element, "/sys/users/{userId}/disconnect", Arrays.asList(RestMethod.PUT, RestMethod.POST), (Class<?>)IPerUserService.class);
                                        }
                                    }
                                }
                            });
                            addedPerUserElements = true;
                        }
                        if (addedHttpElements || !currentClass.getInterfaces().stream().map(Object::toString).anyMatch(s -> IHttpService.class.getCanonicalName().equals(s))) continue;
                        AnnotationsUtils.note(currentClass, "Processing HTTP elements > " + canonicalName, new Object[0]);
                        classService.registerCodeGenerator(builder -> builder.addCode("\n", new Object[0]).addComment("HTTP functions and events are initialized.", new Object[0]));
                        currentClass.getEnclosedElements().forEach(element -> {
                            String name = element.getSimpleName().toString();
                            if (element.getKind() == ElementKind.METHOD) {
                                switch (name) {
                                    case "defaultGetRequest": {
                                        this.registerDefaultFunction(classService.getFunctionPrefix() + "get", "GET", classService, (Element)element, name, IHttpService.class);
                                        break;
                                    }
                                    case "defaultPostRequest": {
                                        this.registerDefaultFunction(classService.getFunctionPrefix() + "post", "POST", classService, (Element)element, name, IHttpService.class);
                                        break;
                                    }
                                    case "defaultPutRequest": {
                                        this.registerDefaultFunction(classService.getFunctionPrefix() + "put", "PUT", classService, (Element)element, name, IHttpService.class);
                                        break;
                                    }
                                    case "defaultDeleteRequest": {
                                        this.registerDefaultFunction(classService.getFunctionPrefix() + "delete", "DELETE", classService, (Element)element, name, IHttpService.class);
                                        break;
                                    }
                                    case "defaultHeadRequest": {
                                        this.registerDefaultFunction(classService.getFunctionPrefix() + "head", "HEAD", classService, (Element)element, name, IHttpService.class);
                                        break;
                                    }
                                    case "defaultPatchRequest": {
                                        this.registerDefaultFunction(classService.getFunctionPrefix() + "patch", "PATCH", classService, (Element)element, name, IHttpService.class);
                                        break;
                                    }
                                    case "defaultOptionsRequest": {
                                        this.registerDefaultFunction(classService.getFunctionPrefix() + "options", "OPTIONS", classService, (Element)element, name, IHttpService.class);
                                        break;
                                    }
                                    case "defaultWebhookProcessor": {
                                        this.registerDefaultWebService("WEBHOOK", classService, (Element)element, "/", RestMethod.all(), (Class<?>)IHttpService.class);
                                    }
                                }
                            }
                        });
                        addedHttpElements = true;
                    }
                    continue;
                }
                catch (IllegalArgumentException e) {
                    AnnotationsUtils.error(element2, e.getMessage(), new Object[0]);
                    return true;
                }
            }
            AnnotationsUtils.error(element2, "[@%s] is used on [%s]. The annotation only can be used on classes.", element2.getSimpleName());
            return true;
        }
        if (!this.generatedRunner) {
            try {
                if (this.slingrClassService != null) {
                    AnnotationsUtils.note(this.slingrClassService.getTypeElement(), "Generating runner for service [%s]", this.slingrClassService.getTypeElement().getSimpleName());
                    this.slingrClassService.generateRunner(this.elementUtils, this.filer);
                    this.generatedRunner = true;
                    return false;
                }
                AnnotationsUtils.error(null, "Service [@%s] not found", SlingrService.class.getSimpleName());
            }
            catch (Exception e) {
                AnnotationsUtils.error(this.slingrClassService != null ? this.slingrClassService.getTypeElement() : null, "Exception when generates runner [%s]: %s", e.getClass(), e.getMessage());
            }
        }
        return true;
    }

    private void registerDefaultFunction(String serviceFunction, String functionLabel, ClassService serviceClass, Element element, String elementName, Class<?> methodClass) {
        AnnotationsUtils.note(element, "- default %s function [%s]", functionLabel, elementName);
        if (!serviceClass.isFunctionRegistered(serviceFunction)) {
            ClassFunction function = new ClassFunction(element, serviceFunction, methodClass, true);
            AnnotationsUtils.note(element, "  - processor [%s]", function.getName());
            serviceClass.registerFunction(function);
        } else {
            AnnotationsUtils.note(element, "  - %s function processor is already registered", functionLabel);
        }
    }

    private void registerDefaultWebService(String webServiceLabel, ClassService serviceClass, Element element, String processorPath, List<RestMethod> processorMethods, Class<?> methodClass) {
        String path = ClassWebService.normalizePath(processorPath);
        List<RestMethod> methods = processorMethods == null || processorMethods.isEmpty() ? RestMethod.all() : processorMethods;
        for (RestMethod method : methods) {
            this.registerDefaultWebService(webServiceLabel, serviceClass, element, path, method, methodClass);
        }
    }

    private void registerDefaultWebService(String webServiceLabel, ClassService serviceClass, Element element, String processorPath, RestMethod processorMethod, Class<?> methodClass) {
        AnnotationsUtils.note(element, "- default %s web service [%s %s]", new Object[]{webServiceLabel, processorMethod, processorPath});
        if (!serviceClass.isWebServiceRegistered(processorPath, processorMethod)) {
            ClassWebService webService = new ClassWebService(element, processorPath, new RestMethod[]{processorMethod}, methodClass, true);
            AnnotationsUtils.note(element, "  - processor [%s]", webService.getName());
            serviceClass.registerWebService(webService);
        } else {
            AnnotationsUtils.note(element, "  - %s web service processor is already registered", webServiceLabel);
        }
    }

    private void processElements(RoundEnvironment processor, Element serviceElement, ClassService classService) {
        String simpleName = classService.getSimpleName();
        AnnotationsUtils.note(serviceElement, "Processing config on [%s]", simpleName);
        processor.getElementsAnnotatedWith(ServiceConfiguration.class).stream().filter(sPropertyElement -> sPropertyElement.getEnclosingElement().equals(serviceElement)).filter(sPropertyElement -> sPropertyElement.getKind() == ElementKind.FIELD).forEach(sPropertyElement -> {
            AnnotationsUtils.note(sPropertyElement, "- Service configuration [%s]", sPropertyElement.toString());
            ClassProperty property = new ClassProperty((Element)sPropertyElement, true);
            classService.registerProperty(property);
        });
        AnnotationsUtils.note(serviceElement, "Config processed on [%s]: [%s]", simpleName, classService.getPropertiesNames());
        AnnotationsUtils.note(serviceElement, "Processing fields on [%s]", simpleName);
        processor.getElementsAnnotatedWith(ServiceProperty.class).stream().filter(sConfigElement -> sConfigElement.getEnclosingElement().equals(serviceElement)).filter(sConfigElement -> sConfigElement.getKind() == ElementKind.FIELD).forEach(sConfigElement -> {
            AnnotationsUtils.note(sConfigElement, "- ClassProperty [%s]", sConfigElement.toString());
            ClassProperty property = new ClassProperty((Element)sConfigElement, false);
            classService.registerProperty(property);
        });
        AnnotationsUtils.note(serviceElement, "Fields processed on [%s]: [%s]", simpleName, classService.getPropertiesNames());
        AnnotationsUtils.note(serviceElement, "Processing data stores on [%s]", simpleName);
        processor.getElementsAnnotatedWith(ServiceDataStore.class).stream().filter(sDataStoreElement -> sDataStoreElement.getEnclosingElement().equals(serviceElement)).filter(sDataStoreElement -> sDataStoreElement.getKind() == ElementKind.FIELD).forEach(sDataStoreElement -> {
            AnnotationsUtils.note(sDataStoreElement, "- Data store [%s]", sDataStoreElement.toString());
            ClassDataStore dataStore = new ClassDataStore((Element)sDataStoreElement);
            classService.registerDataStore(dataStore);
        });
        AnnotationsUtils.note(serviceElement, "Data stores processed on [%s]: [%s]", simpleName, classService.getDataStoreNames());
        AnnotationsUtils.note(serviceElement, "Processing user data stores on [%s]", simpleName);
        processor.getElementsAnnotatedWith(ServiceUserDataStore.class).stream().filter(sUserDataStoreElement -> sUserDataStoreElement.getEnclosingElement().equals(serviceElement)).filter(sUserDataStoreElement -> sUserDataStoreElement.getKind() == ElementKind.FIELD).forEach(sUserDataStoreElement -> {
            AnnotationsUtils.note(sUserDataStoreElement, "- User data store [%s]", sUserDataStoreElement.toString());
            ClassUserDataStore userDataStore = new ClassUserDataStore((Element)sUserDataStoreElement);
            classService.registerUserDataStore(userDataStore);
        });
        AnnotationsUtils.note(serviceElement, "User data stores processed on [%s]: [%s]", simpleName, classService.getUserDataStoreNames());
        AnnotationsUtils.note(serviceElement, "Processing app loggers on [%s]", simpleName);
        processor.getElementsAnnotatedWith(ApplicationLogger.class).stream().filter(sLoggerElement -> sLoggerElement.getEnclosingElement().equals(serviceElement)).filter(sLoggerElement -> sLoggerElement.getKind() == ElementKind.FIELD).forEach(sLoggerElement -> {
            AnnotationsUtils.note(sLoggerElement, "- App logger [%s]", sLoggerElement.toString());
            ClassApplicationLogger appLogger = new ClassApplicationLogger((Element)sLoggerElement);
            classService.registerAppLogger(appLogger);
        });
        AnnotationsUtils.note(serviceElement, "App loggers processed on [%s]: [%s]", simpleName, classService.getAppLoggerNames());
        AnnotationsUtils.note(serviceElement, "Processing functions on [%s]", simpleName);
        processor.getElementsAnnotatedWith(ServiceFunction.class).stream().filter(sFunctionElement -> sFunctionElement.getEnclosingElement().equals(serviceElement)).filter(sFunctionElement -> sFunctionElement.getKind() == ElementKind.METHOD).forEach(sFunctionElement -> {
            AnnotationsUtils.note(sFunctionElement, "- Function [%s]", sFunctionElement.toString());
            ClassFunction function = new ClassFunction((Element)sFunctionElement, false);
            AnnotationsUtils.note(sFunctionElement, "  - processor [%s]", function.getName());
            classService.registerFunction(function);
        });
        processor.getElementsAnnotatedWith(ServiceFunctions.class).stream().filter(sFunctionElement -> sFunctionElement.getEnclosingElement().equals(serviceElement)).filter(sFunctionElement -> sFunctionElement.getKind() == ElementKind.METHOD).forEach(sFunctionElement -> {
            AnnotationsUtils.note(sFunctionElement, "- Function (multiple) [%s]", sFunctionElement.toString());
            for (ServiceFunction serviceFunction : (ServiceFunction[])sFunctionElement.getAnnotationsByType(ServiceFunction.class)) {
                ClassFunction function = new ClassFunction((Element)sFunctionElement, serviceFunction, false);
                AnnotationsUtils.note(sFunctionElement, "  - processor [%s]", function.getName());
                classService.registerFunction(function);
            }
        });
        AnnotationsUtils.note(serviceElement, "Functions processed on [%s]: [%s]", simpleName, classService.getFunctionsNames());
        AnnotationsUtils.note(serviceElement, "Processing web services on [%s]", simpleName);
        processor.getElementsAnnotatedWith(ServiceWebService.class).stream().filter(sWebServiceElement -> sWebServiceElement.getEnclosingElement().equals(serviceElement)).filter(sWebServiceElement -> sWebServiceElement.getKind() == ElementKind.METHOD).forEach(sWebServiceElement -> {
            AnnotationsUtils.note(sWebServiceElement, "- Web service [%s]", sWebServiceElement.toString());
            ClassWebService webService = new ClassWebService((Element)sWebServiceElement, false);
            AnnotationsUtils.note(sWebServiceElement, "  - processor [%s]", webService.getName());
            classService.registerWebService(webService);
        });
        processor.getElementsAnnotatedWith(ServiceWebServices.class).stream().filter(sWebServicesElement -> sWebServicesElement.getEnclosingElement().equals(serviceElement)).filter(sWebServicesElement -> sWebServicesElement.getKind() == ElementKind.METHOD).forEach(sWebServicesElement -> {
            AnnotationsUtils.note(sWebServicesElement, "- Web services (multiple) [%s]", sWebServicesElement.toString());
            for (ServiceWebService serviceWebService : (ServiceWebService[])sWebServicesElement.getAnnotationsByType(ServiceWebService.class)) {
                ClassWebService webService = new ClassWebService((Element)sWebServicesElement, serviceWebService, false);
                AnnotationsUtils.note(sWebServicesElement, "  - processor [%s]", webService.getName());
                classService.registerWebService(webService);
            }
        });
        AnnotationsUtils.note(serviceElement, "Web services processed on [%s]: [%s]", simpleName, classService.getWebServicesNames());
    }
}

