/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.exceptions;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.PermanentException;
import io.slingr.services.exceptions.RetryableException;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ServiceException
extends RuntimeException
implements JsonSource {
    private static final Logger logger = LoggerFactory.getLogger(ServiceException.class);
    public static final String REST_CODE_EXCEPTION = "Invalid response code ";
    private static final String PARSE_ADDITIONAL_INFO = "additionalInfo";
    private static final String PARSE_ORIGINAL_MESSAGE = "originalMessage";
    private static final String PARSE_MESSAGE = "message";
    private static final String PARSE_DETAILS = "details";
    private static final String PARSE_BODY = "body";
    private final ErrorCode code;
    private final Json additionalInfo;
    private int returnCode = 500;

    ServiceException(ErrorCode code, String message, Json additionalInfo, Throwable cause) {
        super((String)StringUtils.defaultIfEmpty((CharSequence)message, (CharSequence)""), cause);
        this.code = code != null ? code : ErrorCode.GENERAL;
        this.additionalInfo = additionalInfo != null ? additionalInfo : Json.map();
    }

    public boolean isRetryable() {
        return false;
    }

    public final boolean isPermanent() {
        return !this.isRetryable();
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public Json getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void addData(String key, Object value) {
        this.additionalInfo.set(key, value);
    }

    public int getHttpStatusCode() {
        if (this.getCause() instanceof WebApplicationException) {
            WebApplicationException wae = (WebApplicationException)this.getCause();
            Response r = wae.getResponse();
            return r.getStatus();
        }
        return -1;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public ServiceException returnCode(int returnCode) {
        this.setReturnCode(returnCode);
        return this;
    }

    public static Json json(ErrorCode error, Object description) {
        return ServiceException.newException(error, description, null, true, null).toJson();
    }

    public static Json json(ErrorCode error, Object description, Json additionalInfo) {
        return ServiceException.newException(error, description, additionalInfo, true, null).toJson();
    }

    public static Json json(ErrorCode error, Object description, Throwable cause) {
        return ServiceException.newException(error, description, null, true, cause).toJson();
    }

    public static Json json(ErrorCode error, Object description, Json additionalInfo, Throwable cause) {
        return ServiceException.newException(error, description, additionalInfo, true, cause).toJson();
    }

    public static Json json(boolean includeFlag, ErrorCode error, Object description) {
        return ServiceException.newException(error, description, null, true, null).toJson(includeFlag);
    }

    public static Json json(boolean includeFlag, ErrorCode error, Object description, Json additionalInfo) {
        return ServiceException.newException(error, description, additionalInfo, true, null).toJson(includeFlag);
    }

    public static Json json(boolean includeFlag, ErrorCode error, Object description, Throwable cause) {
        return ServiceException.newException(error, description, null, true, cause).toJson(includeFlag);
    }

    public static Json json(boolean includeFlag, ErrorCode error, Object description, Json additionalInfo, Throwable cause) {
        return ServiceException.newException(error, description, additionalInfo, true, cause).toJson(includeFlag);
    }

    public static RetryableException retryable(ErrorCode error, Object description) {
        return (RetryableException)ServiceException.newException(error, description, null, false, null);
    }

    public static RetryableException retryable(ErrorCode error, Object description, Json additionalInfo) {
        return (RetryableException)ServiceException.newException(error, description, additionalInfo, false, null);
    }

    public static RetryableException retryable(ErrorCode error, Object description, Throwable cause) {
        return (RetryableException)ServiceException.newException(error, description, null, false, cause);
    }

    public static RetryableException retryable(ErrorCode error, Object description, Json additionalInfo, Throwable cause) {
        return (RetryableException)ServiceException.newException(error, description, additionalInfo, false, cause);
    }

    public static PermanentException permanent(ErrorCode error, Object description) {
        return (PermanentException)ServiceException.newException(error, description, null, true, null);
    }

    public static PermanentException permanent(ErrorCode error, Object description, Json additionalInfo) {
        return (PermanentException)ServiceException.newException(error, description, additionalInfo, true, null);
    }

    public static PermanentException permanent(ErrorCode error, Object description, Throwable cause) {
        return (PermanentException)ServiceException.newException(error, description, null, true, cause);
    }

    public static PermanentException permanent(ErrorCode error, Object description, Json additionalInfo, Throwable cause) {
        return (PermanentException)ServiceException.newException(error, description, additionalInfo, true, cause);
    }

    public static ServiceException exception(ErrorCode error, Object description, boolean permanent) {
        return ServiceException.newException(error, description, null, permanent, null);
    }

    public static ServiceException exception(ErrorCode error, Object description, Json additionalInfo, boolean permanent) {
        return ServiceException.newException(error, description, additionalInfo, permanent, null);
    }

    public static ServiceException exception(ErrorCode error, Object description, boolean permanent, Throwable cause) {
        return ServiceException.newException(error, description, null, permanent, cause);
    }

    public static ServiceException exception(ErrorCode error, Object description, Json additionalInfo, boolean permanent, Throwable cause) {
        return ServiceException.newException(error, description, additionalInfo, permanent, cause);
    }

    private static ServiceException newException(ErrorCode error, Object description, Json additionalInfo, boolean permanent, Throwable cause) {
        String finalDescription = "Exception";
        ErrorCode finalErrorCode = ErrorCode.GENERAL;
        if (description instanceof ServiceException) {
            finalErrorCode = ((ServiceException)description).getCode();
            finalDescription = ((ServiceException)description).getMessage();
        } else {
            String d;
            if (error != null) {
                finalErrorCode = error;
            }
            if (description instanceof Exception) {
                finalDescription = StringUtils.isNotBlank((CharSequence)((Exception)description).getMessage()) ? ((Exception)description).getMessage() : description.toString();
            } else if (description != null && StringUtils.isNotBlank((CharSequence)(d = description.toString()))) {
                finalDescription = d;
            }
        }
        Json json = additionalInfo = additionalInfo != null ? additionalInfo : Json.map();
        if (cause != null) {
            if (cause instanceof WebApplicationException) {
                WebApplicationException wae = (WebApplicationException)cause;
                Response r = wae.getResponse();
                if (r.hasEntity()) {
                    String entity = (String)r.readEntity(String.class);
                    if (r.getHeaderString("Content-Type") != null && r.getHeaderString("Content-Type").contains(ContentType.APPLICATION_JSON.getMimeType())) {
                        try {
                            additionalInfo.set(PARSE_DETAILS, Json.parse(entity));
                        }
                        catch (Exception e) {
                            logger.warn(String.format("There was a problem trying to parse error body [%s] - exception: %s", entity, e.getMessage()), (Throwable)e);
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)additionalInfo.string(PARSE_DETAILS))) {
                        additionalInfo.set(PARSE_DETAILS, entity);
                    }
                }
                Json headers = Json.map();
                if (r.getHeaders() != null && !r.getHeaders().isEmpty()) {
                    for (String k : r.getHeaders().keySet()) {
                        headers.set(k, r.getHeaderString(k));
                    }
                }
                additionalInfo.setIfNotEmpty("headers", headers);
            } else if (cause instanceof ProcessingException) {
                additionalInfo.set("causeMessage", ServiceException.getProcessingExceptionMessage((ProcessingException)cause));
            } else if (cause instanceof SAXException) {
                SAXException saxException = (SAXException)cause;
                additionalInfo.set("causeMessage", saxException.getMessage());
                if (saxException instanceof SAXParseException) {
                    SAXParseException saxParseException = (SAXParseException)saxException;
                    additionalInfo.setIfNotEmpty("columnNumber", saxParseException.getColumnNumber());
                    additionalInfo.setIfNotEmpty("lineNumber", saxParseException.getLineNumber());
                    additionalInfo.setIfNotEmpty("publicId", saxParseException.getPublicId());
                    additionalInfo.setIfNotEmpty("systemId", saxParseException.getSystemId());
                }
            } else {
                if (cause instanceof InvocationTargetException) {
                    return ServiceException.newException(error, description, additionalInfo, permanent, ((InvocationTargetException)cause).getTargetException());
                }
                if (cause instanceof ServiceException) {
                    additionalInfo.set("causeMessage", cause.getMessage());
                    additionalInfo.set("cause", ((ServiceException)cause).toJson(false).json(PARSE_ADDITIONAL_INFO));
                } else {
                    additionalInfo.set("causeMessage", cause.getMessage());
                    additionalInfo.set("causeType", cause.getClass().getCanonicalName());
                }
            }
        }
        if (permanent) {
            return new PermanentException(finalErrorCode, finalDescription, additionalInfo, cause);
        }
        return new RetryableException(finalErrorCode, finalDescription, additionalInfo, cause);
    }

    @Override
    public Json toJson() {
        return this.toJson(true);
    }

    public Json toJson(boolean includeFlag) {
        Json json = Json.map().setIfNotEmpty("error", this.code.toJson()).setIfNotEmpty(PARSE_MESSAGE, this.getMessage()).setIfNotEmpty(PARSE_ADDITIONAL_INFO, this.additionalInfo);
        if (includeFlag) {
            json.set("__service_exception__", true);
            json.set("retryable", this.isRetryable());
        }
        return json;
    }

    public String getJson(boolean includeFlag) {
        return this.toJson(includeFlag).toString();
    }

    public Map<String, Object> toMap() {
        return this.toJson(true).toMap();
    }

    public Map<String, Object> toMap(boolean includeFlag) {
        return this.toJson(includeFlag).toMap();
    }

    @Override
    public String toString() {
        return this.getJson(false);
    }

    public boolean equals(Object o) {
        return o instanceof ServiceException && this.toJson(true).equals(((ServiceException)o).toJson(true));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static ServiceException parseHTTPExceptions(Exception exception, String detailMessage, String code) {
        if (exception instanceof ServiceException) {
            Json ex = ((ServiceException)exception).toJson(true);
            if ((ex.string(PARSE_MESSAGE).startsWith("HTTP ") || ex.string(PARSE_MESSAGE).startsWith(REST_CODE_EXCEPTION)) && ex.contains(PARSE_ADDITIONAL_INFO)) {
                Json ai = ex.json(PARSE_ADDITIONAL_INFO);
                Object odt = ai.object(PARSE_DETAILS);
                if (odt == null) {
                    odt = ai.object(PARSE_BODY);
                }
                if (odt != null) {
                    try {
                        Json dt = Json.fromObject(odt);
                        if (dt.contains(detailMessage) && StringUtils.isNotBlank((CharSequence)dt.string(detailMessage))) {
                            ai.set(PARSE_ORIGINAL_MESSAGE, ex.string(PARSE_MESSAGE));
                            String msg = dt.contains(code) && StringUtils.isNotBlank((CharSequence)dt.string(code)) ? String.format("%s [code: %s]", dt.string(detailMessage), dt.string(code)) : dt.string(detailMessage);
                            return new PermanentException(((ServiceException)exception).getCode(), msg, ai, exception);
                        }
                    }
                    catch (Exception pdEx) {
                        ai.set(PARSE_ORIGINAL_MESSAGE, ex.string(PARSE_MESSAGE));
                        String msg = ex.string(PARSE_MESSAGE).replaceFirst("HTTP\\s+\\d+\\s*", "");
                        return new PermanentException(((ServiceException)exception).getCode(), msg, ai, exception);
                    }
                }
            }
            return (ServiceException)exception;
        }
        return ServiceException.permanent(ErrorCode.API, (Object)exception.getMessage(), exception);
    }

    public static String getProcessingExceptionMessage(ProcessingException cause) {
        Object processingException = cause;
        String cm = ((Throwable)processingException).getMessage();
        String lastMessage = cm != null ? cm : "";
        for (int tries = 10; tries > 0 && (cm == null || cm.startsWith("org.apache.http")) && ((Throwable)processingException).getCause() != null; --tries) {
            cm = ((Throwable)(processingException = ((Throwable)processingException).getCause())).getMessage();
            if (!StringUtils.isNotBlank((CharSequence)cm)) continue;
            lastMessage = cm;
        }
        return lastMessage;
    }
}

