/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest.authentication.strategy;

import io.slingr.services.services.rest.HttpRequest;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.services.rest.authentication.strategy.AuthenticationStrategy;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsAuthenticationStrategy
implements AuthenticationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AwsAuthenticationStrategy.class);
    private final String accessKeyID;
    private final String secretAccessKey;
    private final String region;
    private final String serviceName;

    public AwsAuthenticationStrategy(Map<String, String> params) {
        this.accessKeyID = params.get("accessKeyID");
        this.secretAccessKey = params.get("secretAccessKey");
        this.region = params.get("region");
        this.serviceName = params.get("serviceName");
    }

    @Override
    public void addAuthentication(Client client, WebTarget apiTarget, HttpRequest request) {
        String hostHeader = apiTarget.getUri().getHost();
        String canonicalURI = apiTarget.getUri().getPath();
        TreeMap<String, String> awsHeaders = new TreeMap<String, String>(request.getHeaders().toMapString());
        awsHeaders.put("host", hostHeader);
        TreeMap<String, String> queryParams = new TreeMap<String, String>(request.getParams().toMapString());
        RestMethod method = request.getRestMethod();
        String body = (method == RestMethod.POST || method == RestMethod.PUT || method == RestMethod.PATCH) && request.getJsonBody().isNotEmpty() ? request.getJsonBody().toString() : null;
        AWSSignatureV4Generator aWSV4Auth = new AWSSignatureV4Generator.Builder(this.accessKeyID, this.secretAccessKey).regionName(this.region).serviceName(this.serviceName).httpMethodName(method.name()).canonicalURI(canonicalURI).queryParameters(queryParams).awsHeaders(awsHeaders).payload(body).build();
        try {
            client.register((Object)AwsAuthenticationStrategy.getClientRequestFilter(aWSV4Auth, hostHeader));
        }
        catch (Exception e) {
            logger.info(String.format("Unable to generate the AWS signature [%s]", e.getMessage()));
        }
    }

    private static ClientRequestFilter getClientRequestFilter(AWSSignatureV4Generator aWSV4Auth, String hostHeader) throws Exception {
        Map<String, String> header = aWSV4Auth.getHeaders();
        return requestContext -> {
            for (Map.Entry entrySet : header.entrySet()) {
                requestContext.getHeaders().add((Object)((String)entrySet.getKey()), entrySet.getValue());
            }
            requestContext.getHeaders().add((Object)"host", (Object)hostHeader);
        };
    }

    public static class AWSSignatureV4Generator {
        private final String accessKeyID;
        private final String secretAccessKey;
        private final String regionName;
        private final String serviceName;
        private final String httpMethodName;
        private String canonicalURI;
        private final TreeMap<String, String> queryParameters;
        private final TreeMap<String, String> awsHeaders;
        private String payload;
        private String signedHeaderString;
        private final String xAmzDate;
        private final String currentDate;

        private AWSSignatureV4Generator(Builder builder) {
            this.accessKeyID = builder.accessKeyID;
            this.secretAccessKey = builder.secretAccessKey;
            this.regionName = builder.regionName;
            this.serviceName = builder.serviceName;
            this.httpMethodName = builder.httpMethodName;
            this.canonicalURI = builder.canonicalURI;
            this.queryParameters = builder.queryParameters;
            this.awsHeaders = builder.awsHeaders;
            this.payload = builder.payload;
            this.xAmzDate = this.getTimeStamp();
            this.currentDate = this.getDate();
        }

        private String prepareCanonicalRequest() throws Exception {
            StringBuilder canonicalURL = new StringBuilder();
            canonicalURL.append(this.httpMethodName).append("\n");
            this.canonicalURI = this.canonicalURI == null || this.canonicalURI.trim().isEmpty() ? "/" : this.canonicalURI;
            canonicalURL.append(this.canonicalURI).append("\n");
            this.addCanonicalQueryString(canonicalURL);
            StringBuilder signedHeaders = new StringBuilder();
            if (this.awsHeaders != null && !this.awsHeaders.isEmpty()) {
                for (Map.Entry<String, String> entrySet : this.awsHeaders.entrySet()) {
                    String key = entrySet.getKey();
                    signedHeaders.append(key).append(";");
                    canonicalURL.append(key).append(":").append(entrySet.getValue()).append("\n");
                }
                canonicalURL.append("\n");
            } else {
                canonicalURL.append("\n");
            }
            this.signedHeaderString = signedHeaders.substring(0, signedHeaders.length() - 1);
            canonicalURL.append(this.signedHeaderString).append("\n");
            if (this.payload == null) {
                this.payload = "";
            }
            canonicalURL.append(this.hash(this.payload));
            return canonicalURL.toString();
        }

        private void addCanonicalQueryString(StringBuilder canonicalURL) {
            StringBuilder queryString = new StringBuilder();
            if (this.queryParameters != null && !this.queryParameters.isEmpty()) {
                for (Map.Entry<String, String> entrySet : this.queryParameters.entrySet()) {
                    String key = entrySet.getKey();
                    String value = entrySet.getValue();
                    queryString.append(key).append("=").append(this.encodeParameter(value)).append("&");
                }
                queryString.deleteCharAt(queryString.lastIndexOf("&"));
                queryString.append("\n");
            } else {
                queryString.append("\n");
            }
            canonicalURL.append((CharSequence)queryString);
        }

        private String prepareStringToSign(String canonicalURL) throws Exception {
            Object stringToSign = "AWS4-HMAC-SHA256\n";
            stringToSign = (String)stringToSign + this.xAmzDate + "\n";
            stringToSign = (String)stringToSign + this.currentDate + "/" + this.regionName + "/" + this.serviceName + "/aws4_request\n";
            stringToSign = (String)stringToSign + this.hash(canonicalURL);
            return stringToSign;
        }

        private String calculateSignature(String stringToSign) throws Exception {
            try {
                byte[] signatureKey = this.getSignatureKey(this.secretAccessKey, this.currentDate, this.regionName, this.serviceName);
                byte[] signature = this.hmacSHA256(signatureKey, stringToSign);
                return this.bytesToHex(signature);
            }
            catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException ex) {
                throw new Exception("Error while calculating the signature." + ex);
            }
        }

        public Map<String, String> getHeaders() throws Exception {
            this.awsHeaders.put("x-amz-date", this.xAmzDate);
            String canonicalURL = this.prepareCanonicalRequest();
            String stringToSign = this.prepareStringToSign(canonicalURL);
            String signature = this.calculateSignature(stringToSign);
            HashMap<String, String> header = new HashMap<String, String>(0);
            header.put("x-amz-date", this.xAmzDate);
            header.put("Authorization", this.buildAuthorizationString(signature));
            return header;
        }

        private String buildAuthorizationString(String strSignature) {
            return "AWS4-HMAC-SHA256 Credential=" + this.accessKeyID + "/" + this.getDate() + "/" + this.regionName + "/" + this.serviceName + "/aws4_request,SignedHeaders=" + this.signedHeaderString + ",Signature=" + strSignature;
        }

        private String hash(String data) throws Exception {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                messageDigest.update(data.getBytes(StandardCharsets.UTF_8));
                byte[] digest = messageDigest.digest();
                return String.format("%064x", new BigInteger(1, digest));
            }
            catch (NoSuchAlgorithmException e) {
                throw new Exception("Error while hashing the string contents." + e);
            }
        }

        private byte[] hmacSHA256(byte[] key, String data) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
            String algorithm = "HmacSHA256";
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }

        private byte[] getSignatureKey(String key, String date, String regionName, String serviceName) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
            byte[] kSecret = ("AWS4" + key).getBytes(StandardCharsets.UTF_8);
            byte[] kDate = this.hmacSHA256(kSecret, date);
            byte[] kRegion = this.hmacSHA256(kDate, regionName);
            byte[] kService = this.hmacSHA256(kRegion, serviceName);
            return this.hmacSHA256(kService, "aws4_request");
        }

        private String bytesToHex(byte[] bytes) {
            char[] hexArray = "0123456789ABCDEF".toCharArray();
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            return new String(hexChars).toLowerCase();
        }

        private String getTimeStamp() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GTM"));
            return dateFormat.format(new Date());
        }

        private String getDate() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GTM"));
            return dateFormat.format(new Date());
        }

        private String encodeParameter(String param) {
            return URLEncoder.encode(param, StandardCharsets.UTF_8);
        }

        public static class Builder {
            private final String accessKeyID;
            private final String secretAccessKey;
            private String regionName;
            private String serviceName;
            private String httpMethodName;
            private String canonicalURI;
            private TreeMap<String, String> queryParameters;
            private TreeMap<String, String> awsHeaders;
            private String payload;

            public Builder(String accessKeyID, String secretAccessKey) {
                this.accessKeyID = accessKeyID;
                this.secretAccessKey = secretAccessKey;
            }

            public Builder regionName(String regionName) {
                this.regionName = regionName;
                return this;
            }

            public Builder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public Builder httpMethodName(String httpMethodName) {
                this.httpMethodName = httpMethodName;
                return this;
            }

            public Builder canonicalURI(String canonicalURI) {
                this.canonicalURI = canonicalURI;
                return this;
            }

            public Builder queryParameters(TreeMap<String, String> queryParameters) {
                this.queryParameters = queryParameters;
                return this;
            }

            public Builder awsHeaders(TreeMap<String, String> awsHeaders) {
                this.awsHeaders = awsHeaders;
                return this;
            }

            public Builder payload(String payload) {
                this.payload = payload;
                return this;
            }

            public AWSSignatureV4Generator build() {
                return new AWSSignatureV4Generator(this);
            }
        }
    }
}

