/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.exceptions;

import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;

public enum ErrorCode implements JsonSource
{
    ARGUMENT("argumentException", "Argument invalid"),
    API("apiException", "API exception"),
    CONVERSION("conversionException", "Conversion exception"),
    CLIENT("clientException", "Client handling exception"),
    GENERAL("general", "General exception");

    private final String code;
    private final String name;

    private ErrorCode(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Json toJson() {
        Json json = Json.map();
        json.set("code", this.code);
        json.set("name", this.name);
        return json;
    }

    public static ErrorCode fromString(String errorCode) {
        for (ErrorCode tmpErrorCode : ErrorCode.values()) {
            if (!tmpErrorCode.getCode().equalsIgnoreCase(errorCode)) continue;
            return tmpErrorCode;
        }
        return null;
    }

    public String toString() {
        return String.format("%s (%s)", this.name, this.code);
    }
}

