/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.Files;
import io.slingr.services.services.rest.DownloadedFile;
import io.slingr.services.services.rest.HttpRequest;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.services.rest.authentication.AuthenticationService;
import io.slingr.services.utils.FilesUtils;
import io.slingr.services.utils.FormUtils;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.XmlUtils;
import io.slingr.services.utils.converters.ContentTypeFormat;
import io.slingr.services.utils.converters.JsonConverter;
import io.slingr.services.utils.converters.JsonSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.mail.Multipart;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(RestClientFactory.class);
    public static final String UTF8_BOM = "\ufeff";
    private final Client client;
    protected boolean debug = false;
    private boolean rememberCookies = false;
    private final ReentrantLock cookiesLock = new ReentrantLock();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final String[] acceptedMediaTypes;
    private final List<String> history = new ArrayList<String>();
    private final AuthenticationService authService = new AuthenticationService();

    public RestClientFactory() {
        try {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.register(MultiPartFeature.class);
            clientConfig.register(JacksonFeature.class);
            clientConfig.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
            clientConfig.property("jersey.config.client.followRedirects", (Object)true);
            clientConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
            ApacheConnectorProvider provider = new ApacheConnectorProvider();
            clientConfig.connectorProvider((ConnectorProvider)provider);
            this.client = ClientBuilder.newClient((Configuration)clientConfig);
            this.client.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
            this.enableSSL(true);
            this.acceptedMediaTypes = ContentTypeFormat.getAcceptedFormats();
        }
        catch (Exception e) {
            logger.error("Error creating rest client", (Throwable)e);
            throw new RuntimeException("Error creating rest client", e);
        }
    }

    private static SSLConnectionSocketFactory configureSSL() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new TrustAllHostNameVerifier());
    }

    public RestClientFactory enableSSL(boolean useSSL) {
        try {
            Registry registry = useSSL ? RegistryBuilder.create().register("https", (Object)RestClientFactory.configureSSL()).register("http", (Object)new PlainConnectionSocketFactory()).build() : RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
            connectionManager.setMaxTotal(100);
            connectionManager.setDefaultMaxPerRoute(100);
            this.client.property("jersey.config.apache.client.connectionManager", (Object)connectionManager);
            this.client.property("jersey.config.apache.client.connectionManagerShared", (Object)true);
        }
        catch (Exception e) {
            logger.error("Error enabling ssl certification", (Throwable)e);
            throw new RuntimeException("Error enabling ssl certification", e);
        }
        return this;
    }

    public WebTarget setupAuthentication(WebTarget apiTarget, HttpRequest request) {
        this.authService.setupAuthentication(request);
        this.authService.addAuthentication(this.client, apiTarget, request);
        return this.client.target(apiTarget.getUri());
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setRememberCookies(boolean rememberCookies) {
        this.rememberCookies = rememberCookies;
    }

    public WebTarget uri(String apiUri) {
        return this.client.target(apiUri);
    }

    public WebTarget setupBasicAuthentication(WebTarget uri, String username, String password) {
        HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)username, (String)password);
        this.client.register((Object)feature);
        return this.client.target(uri.getUri());
    }

    public WebTarget setupDigestAuthentication(WebTarget uri, String username, String password) {
        HttpAuthenticationFeature feature = HttpAuthenticationFeature.digest((String)username, (String)password);
        this.client.register((Object)feature);
        return this.client.target(uri.getUri());
    }

    Json processResponse(Response response, RestMethod method, boolean fullResponse) throws ServiceException {
        if (response == null) {
            throw ServiceException.permanent(ErrorCode.CLIENT, "Invalid response");
        }
        try {
            boolean errorResponse;
            Object entity;
            InputStream responseContent = method == RestMethod.HEAD ? ((entity = response.getEntity()) instanceof InputStream ? (InputStream)entity : (entity != null ? new ByteArrayInputStream(response.getEntity().toString().getBytes()) : new ByteArrayInputStream("".getBytes()))) : (InputStream)response.readEntity(InputStream.class);
            byte[] responseAsBytes = IOUtils.toByteArray((InputStream)responseContent);
            String responseAsString = IOUtils.toString((byte[])responseAsBytes, (String)"UTF-8");
            String contentType = response.getHeaderString("Content-Type");
            Json responseAsJson = JsonConverter.convertString(RestClientFactory.removeUTF8BOM(responseAsString), contentType, true);
            boolean bl = errorResponse = response.getStatus() < 200 || response.getStatus() > 299;
            if (errorResponse && !fullResponse && responseAsJson != null && responseAsJson.json("data") != null && responseAsJson.json("data").isMap() && responseAsJson.json("data").bool("__service_exception__").booleanValue()) {
                response.close();
                Json jsonData = responseAsJson.json("data");
                Json errorData = jsonData.json("error");
                ErrorCode errorCode = errorData == null || StringUtils.isBlank((String)errorData.string("code")) ? ErrorCode.CLIENT : ErrorCode.fromString(errorData.string("code"));
                throw ServiceException.permanent(errorCode != null ? errorCode : ErrorCode.CLIENT, (Object)jsonData.string("message"), jsonData.json("additionalInfo"));
            }
            if (errorResponse || fullResponse) {
                Object res;
                if (responseAsJson != null) {
                    res = responseAsJson;
                } else {
                    String ct;
                    boolean asBytes = false;
                    if (StringUtils.isNotBlank((String)contentType) && ((ct = contentType.toLowerCase()).contains("image") || ct.contains("audio") || ct.contains("video") || ct.contains("application") || ct.contains("multipart"))) {
                        asBytes = true;
                    }
                    res = asBytes ? (Object)responseAsBytes : responseAsString;
                }
                responseAsJson = RestClientFactory.processFullResponse(response, res);
            }
            response.close();
            if (errorResponse) {
                if (response.getStatus() == 408 || response.getStatus() == 500 || response.getStatus() == 502 || response.getStatus() == 503 || response.getStatus() == 504 || response.getStatus() == 522) {
                    throw ServiceException.retryable(ErrorCode.API, (Object)String.format("%s[%s]", "Invalid response code ", response.getStatus()), responseAsJson).returnCode(response.getStatus());
                }
                throw ServiceException.permanent(ErrorCode.API, (Object)String.format("%s[%s]", "Invalid response code ", response.getStatus()), responseAsJson).returnCode(response.getStatus());
            }
            return responseAsJson;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CONVERSION, (Object)ex.getMessage(), ex);
        }
    }

    private static String removeUTF8BOM(String s) {
        if (s.startsWith(UTF8_BOM)) {
            s = s.substring(1);
        }
        return s;
    }

    DownloadedFile processDownloadedFile(Response response) throws ServiceException {
        try {
            if (response != null) {
                Json headers = Json.map();
                for (String header : response.getHeaders().keySet()) {
                    headers.set(header, response.getHeaders().getFirst((Object)header));
                }
                String contentType = headers.string("Content-Type");
                if (StringUtils.isNotBlank((String)contentType) && contentType.startsWith("data:")) {
                    contentType = contentType.substring(5);
                    headers.set("Content-Type", contentType);
                    response.getHeaders().putSingle((Object)"Content-Type", (Object)contentType);
                }
                InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                int status = response.getStatus();
                if (inputStream != null && status >= 200 && status < 300) {
                    return new DownloadedFile(status, inputStream, headers);
                }
                String message = "Exception when try to download a file";
                Json json = null;
                if (inputStream != null && (json = JsonConverter.convertString(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), contentType)) != null && json.contains("message")) {
                    message = json.string("message");
                }
                throw ServiceException.permanent(ErrorCode.CLIENT, (Object)message, json);
            }
            throw ServiceException.permanent(ErrorCode.CLIENT, "Exception when try to download a file");
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CONVERSION, (Object)ex.getMessage(), ex);
        }
    }

    Object processMultipart(HttpRequest request, Files files) throws ServiceException {
        if (!request.isMultipart()) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "Request is not multipart");
        }
        try {
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            for (HttpRequest.Part part : request.getParts()) {
                if (part.getType() == HttpRequest.PartType.FILE) {
                    Json descriptor = files.metadata(part.getFileId());
                    if (descriptor != null && !descriptor.isEmpty()) {
                        DownloadedFile file = files.download(part.getFileId());
                        StreamDataBodyPart filePart = new StreamDataBodyPart(part.getName(), file.getFile(), descriptor.string("fileName"));
                        MediaType mediaType = FilesUtils.getMediaTypeForMultipart(descriptor.string("contentType"), descriptor.string("fileName"));
                        filePart.setMediaType(mediaType);
                        formDataMultiPart.bodyPart((BodyPart)filePart);
                        continue;
                    }
                    throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("File with id [%s] not found", part.getFileId()));
                }
                Object content = part.getContent();
                if (content instanceof JsonSource) {
                    formDataMultiPart.field(part.getName(), (Object)((JsonSource)content).toJson().toString(), MediaType.APPLICATION_JSON_TYPE);
                    continue;
                }
                if (!StringUtils.isBlank((String)part.getContentType())) {
                    formDataMultiPart.field(part.getName(), (Object)content.toString(), MediaType.valueOf((String)part.getContentType()));
                    continue;
                }
                formDataMultiPart.field(part.getName(), content.toString());
            }
            return formDataMultiPart;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CONVERSION, (Object)ex.getMessage(), ex);
        }
    }

    Object processUploadFile(InputStream inputStream, String filename, String contentType, String fileParameter, String contentParameter, Object content) throws ServiceException {
        if (inputStream == null) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "Invalid file to upload");
        }
        try {
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            String paramName = StringUtils.isNotBlank((String)fileParameter) ? fileParameter : "file";
            StreamDataBodyPart filePart = new StreamDataBodyPart(paramName, inputStream, filename);
            MediaType mediaType = FilesUtils.getMediaTypeForMultipart(contentType, filename);
            if (mediaType != null) {
                filePart.setMediaType(mediaType);
            }
            formDataMultiPart.bodyPart((BodyPart)filePart);
            if (content != null) {
                String bodyName;
                String string = bodyName = StringUtils.isNotBlank((String)contentParameter) ? contentParameter : "data";
                if (content instanceof JsonSource) {
                    formDataMultiPart.field(bodyName, (Object)((JsonSource)content).toJson().toString(), MediaType.APPLICATION_JSON_TYPE);
                } else {
                    formDataMultiPart.field(bodyName, content.toString());
                }
            }
            return formDataMultiPart;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CONVERSION, (Object)ex.getMessage(), ex);
        }
    }

    static Json processFullResponse(Response response, Object body) {
        int status = 0;
        Json headers = Json.map();
        if (response != null) {
            status = response.getStatus();
            if (response.getHeaders() != null) {
                response.getHeaders().forEach((k, objects) -> {
                    Json header;
                    if (objects != null && !objects.isEmpty() && (header = objects.size() == 1 ? objects.get(0) : Json.fromList(objects)) != null) {
                        headers.set((String)k, header);
                    }
                });
            }
        }
        return RestClientFactory.processFullResponse(status, headers, body);
    }

    static Json processFullResponse(int status, Json headers, Object body) {
        if (headers == null) {
            headers = Json.map();
        }
        if (body instanceof JsonSource) {
            body = ((JsonSource)body).toJson();
        }
        if (body instanceof Json && ((Json)body).isMap() && ((Json)body).size() == 1 && ((Json)body).contains("body")) {
            body = ((Json)body).object("body");
        } else if (body instanceof Map && ((Map)body).size() == 1 && ((Map)body).containsKey("body")) {
            body = ((Map)body).get("body");
        }
        if (body == null) {
            body = Json.map();
        }
        return Json.map().set("status", status).set("headers", headers).set("body", body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response request(RestMethod method, WebTarget target, Object content, Json headers, HttpRequest request) throws ServiceException {
        Response response;
        if (target == null) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "Web target is empty.");
        }
        String uri = target.getUri().toString();
        if (this.debug) {
            logger.info(String.format("%s Preparing request [%s %s]...", "DEBUG>", method.name(), uri));
        }
        if (method == null) {
            method = RestMethod.GET;
        }
        if (headers == null) {
            headers = Json.map();
        }
        Entity postData = null;
        if (method == RestMethod.POST || method == RestMethod.PUT || method == RestMethod.PATCH) {
            if (content == null) {
                content = Json.map();
            }
            String contentType = headers.string("Content-Type");
            if (content instanceof JsonSource || content instanceof Map || content instanceof List || content instanceof Multipart) {
                content = Json.fromObject(content);
                if (StringUtils.isNotBlank((String)contentType)) {
                    if (ContentTypeFormat.isXmlContentType(contentType)) {
                        String xml = XmlUtils.jsonToXml((Json)content);
                        postData = Entity.entity((Object)xml, (String)contentType);
                    } else if (ContentTypeFormat.isUrlEncodedFormContentType(contentType)) {
                        Form form = FormUtils.convertFromJsonToForm((Json)content);
                        postData = Entity.form((Form)form);
                    } else {
                        postData = Entity.entity((Object)content.toString(), (String)contentType);
                    }
                } else {
                    postData = Entity.json((Object)content.toString());
                }
            } else if (content instanceof Form) {
                postData = Entity.form((Form)((Form)content));
            } else if (content instanceof MultiPart) {
                MediaType mediaType = MediaType.MULTIPART_FORM_DATA_TYPE;
                mediaType = Boundary.addBoundary((MediaType)mediaType);
                postData = Entity.entity((Object)content, (MediaType)mediaType);
            } else if (content instanceof String) {
                postData = StringUtils.isNotBlank((String)contentType) && ContentTypeFormat.isXmlContentType(contentType) ? Entity.xml((Object)content) : Entity.text((Object)content);
            }
        }
        target = (WebTarget)target.property("jersey.config.client.followRedirects", (Object)false);
        Invocation.Builder invocationBuilder = target.request();
        invocationBuilder.accept(this.acceptedMediaTypes);
        invocationBuilder.property("jersey.config.client.connectTimeout", (Object)request.getConnectionTimeout());
        invocationBuilder.property("jersey.config.client.readTimeout", (Object)request.getReadTimeout());
        headers.forEachMap((arg_0, arg_1) -> ((Invocation.Builder)invocationBuilder).header(arg_0, arg_1));
        if (this.rememberCookies && !request.isForceDisableCookies()) {
            this.cookiesLock.lock();
            try {
                this.cookies.forEach(arg_0 -> ((Invocation.Builder)invocationBuilder).cookie(arg_0));
            }
            catch (Exception ex) {
                if (this.debug) {
                    logger.info(String.format("%s Exception when try to process cookies [%s]", "DEBUG>", ex.getMessage()), (Throwable)ex);
                } else {
                    logger.debug(String.format("Exception when try to process cookies [%s]", ex.getMessage()), (Throwable)ex);
                }
            }
            finally {
                this.cookiesLock.unlock();
            }
        }
        try {
            if (this.debug) {
                logger.info(String.format("%s Executing method [%s %s] - Content [%s]", "DEBUG>", method.name(), uri, postData));
            }
            switch (method) {
                case POST: {
                    response = invocationBuilder.post(postData);
                    break;
                }
                case PUT: {
                    response = invocationBuilder.put(postData);
                    break;
                }
                case PATCH: {
                    response = invocationBuilder.method(RestMethod.PATCH.name(), postData);
                    break;
                }
                case DELETE: {
                    response = invocationBuilder.delete();
                    break;
                }
                case HEAD: {
                    response = invocationBuilder.head();
                    break;
                }
                case OPTIONS: {
                    response = invocationBuilder.options();
                    break;
                }
                default: {
                    response = invocationBuilder.get();
                }
            }
            if (this.debug) {
                logger.info(String.format("%s Response to method [%s %s] - Response [%s]", "DEBUG>", method.name(), uri, response.getStatus()));
            }
            if (request.getMaxRedirects() > 0 && request.isFollowRedirects() && response.getStatus() >= 300 && response.getStatus() < 400) {
                request.setMaxRedirects(request.getMaxRedirects() - 1);
                String locationHeader = response.getHeaderString("Location");
                if (locationHeader == null || locationHeader.trim().isEmpty()) {
                    logger.info("Exception when trying to process redirect: Location is null or empty.");
                    throw ServiceException.permanent(ErrorCode.GENERAL, "Location is null or empty.");
                }
                if (!locationHeader.startsWith("http")) {
                    URI baseUri = target.getUri();
                    URI resolvedUri = baseUri.resolve(locationHeader);
                    target = this.client.target(resolvedUri);
                } else {
                    target = this.client.target(locationHeader);
                }
                if (!request.isFollowAuthorizationHeader()) {
                    headers.remove("Authorization");
                }
                if (!request.isRemoveRefererHeaderOnRedirect()) {
                    this.history.add(this.history.isEmpty() ? request.getPath() : uri);
                    headers.set("Referer", this.history.get(this.history.size() - 1));
                }
                if (!request.isFollowOriginalHttpMethod()) {
                    method = RestMethod.GET;
                }
                response = this.request(method, target, content, headers, request);
                if (!request.isRemoveRefererHeaderOnRedirect()) {
                    this.history.remove(this.history.size() - 1);
                }
            }
            if (this.rememberCookies && !request.isForceDisableCookies()) {
                this.cookiesLock.lock();
                try {
                    response.getCookies().forEach((s, newCookie) -> this.cookies.add((Cookie)newCookie));
                }
                catch (Exception ex) {
                    if (this.debug) {
                        logger.info(String.format("%s Exception when try to process cookies [%s]", "DEBUG>", ex.getMessage()), (Throwable)ex);
                    } else {
                        logger.debug(String.format("Exception when try to process cookies [%s]", ex.getMessage()), (Throwable)ex);
                    }
                }
                finally {
                    this.cookiesLock.unlock();
                }
            }
            if (!this.rememberCookies || request.isForceDisableCookies()) {
                this.cookies.clear();
            }
        }
        catch (ServiceException ee) {
            throw ee;
        }
        catch (ResponseProcessingException rpe) {
            throw ServiceException.permanent(ErrorCode.API, (Object)String.format("Error processing response [%s]: %s", rpe.getMessage(), rpe.getResponse() != null ? rpe.getResponse() : "-"), rpe).returnCode(500);
        }
        catch (ProcessingException pe) {
            if (pe.getCause() instanceof IOException) {
                throw ServiceException.permanent(ErrorCode.CLIENT, (Object)String.format("Error processing request [%s]", ServiceException.getProcessingExceptionMessage(pe)), pe).returnCode(500);
            }
            throw ServiceException.retryable(ErrorCode.API, (Object)String.format("Error processing request [%s]", pe.getMessage()), pe).returnCode(400);
        }
        catch (WebApplicationException wae) {
            Response r = wae.getResponse();
            if (r != null && (r.getStatus() == 408 || r.getStatus() == 500 || r.getStatus() == 502 || r.getStatus() == 503 || r.getStatus() == 504 || r.getStatus() == 522)) {
                throw ServiceException.retryable(ErrorCode.API, (Object)wae.getMessage(), wae).returnCode(r.getStatus());
            }
            throw ServiceException.permanent(ErrorCode.API, (Object)wae.getMessage(), wae).returnCode(r.getStatus());
        }
        catch (Exception e) {
            throw ServiceException.permanent(ErrorCode.GENERAL, (Object)e.getMessage(), e).returnCode(500);
        }
        return response;
    }

    private static class TrustAllHostNameVerifier
    implements HostnameVerifier {
        private TrustAllHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

