/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.configurations;

import io.slingr.services.configurations.ServiceDefinitions;
import io.slingr.services.utils.Json;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Definitions
implements ServiceDefinitions {
    private final String label;
    private final String type;
    private final String apiVersion;
    private final boolean internal;
    private final boolean perUserService;
    private final List<Json> deploymentProfiles;
    private final boolean allowMultipleInstances;
    private final String icon;
    private final String configurationHelpUrl;
    private final boolean active;
    private final List<Json> dataStores;
    private final List<Json> events;
    private final List<Json> functions;
    private final List<Json> configuration;
    private final List<Json> userConfiguration;
    private final Json userConfigurationButtons;

    Definitions(String label, String type, String apiVersion, boolean internal, boolean perUserService, List<Json> deploymentProfiles, boolean allowMultipleInstances, String icon, String configurationHelpUrl, boolean active, List<Json> dataStores, List<Json> events, List<Json> functions, List<Json> configuration, List<Json> userConfiguration, Json userConfigurationButtons) {
        this.label = label;
        this.type = type;
        this.apiVersion = apiVersion;
        this.internal = internal;
        this.deploymentProfiles = deploymentProfiles;
        this.allowMultipleInstances = allowMultipleInstances;
        this.icon = icon;
        this.configurationHelpUrl = configurationHelpUrl;
        this.active = active;
        this.configuration = configuration;
        this.userConfiguration = userConfiguration;
        this.userConfigurationButtons = userConfigurationButtons;
        this.perUserService = perUserService;
        if (this.perUserService) {
            ArrayList<Json> arrayList = dataStores = dataStores != null ? dataStores : new ArrayList<Json>();
            if (dataStores.stream().noneMatch(json -> "name".equals(json.string("__services_users__")))) {
                dataStores.add(Json.map().set("name", "__services_users__"));
            }
            ArrayList<Json> arrayList2 = events = events != null ? events : new ArrayList<Json>();
            if (events.stream().noneMatch(json -> "name".equals(json.string("userConnected")))) {
                events.add(Json.map().set("label", "User connected").set("name", "userConnected").set("eventType", "PER_USER").set("description", "Event triggered when the current user is connected to the service."));
            }
            if (events.stream().noneMatch(json -> "name".equals(json.string("userDisconnected")))) {
                events.add(Json.map().set("label", "User disconnected").set("name", "userDisconnected").set("eventType", "PER_USER").set("description", "Event triggered when the current user is disconnected from the service."));
            }
            ArrayList<Json> arrayList3 = functions = functions != null ? functions : new ArrayList<Json>();
            if (functions.stream().noneMatch(json -> "name".equals(json.string("connectUser")))) {
                functions.add(Json.map().set("label", "Connect User").set("name", "connectUser").set("eventType", "PER_USER").set("description", "Connects the user to the service.").set("callbacks", Json.list().push(Json.map().set("name", "userConnected").set("maxWaitingTime", 60000).set("maxExpectedResponses", 1)).push(Json.map().set("name", "userDisconnected").set("maxWaitingTime", 60000).set("maxExpectedResponses", 1))));
            }
            if (functions.stream().noneMatch(json -> "name".equals(json.string("disconnectUser")))) {
                functions.add(Json.map().set("label", "Disconnect User").set("name", "disconnectUser").set("eventType", "PER_USER").set("description", "Disconnects the user from the service.").set("callbacks", Json.list().push(Json.map().set("name", "userDisconnected").set("maxWaitingTime", 60000).set("maxExpectedResponses", 1))));
            }
        }
        this.dataStores = dataStores;
        this.events = events;
        this.functions = functions;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public String getConfigurationType() {
        return this.isPerUserService() ? "PER_USER" : "GLOBAL";
    }

    @Override
    public boolean isPerUserService() {
        return this.perUserService;
    }

    @Override
    public Json getDeployment() {
        return Json.map().set("profiles", this.getDeploymentProfiles()).set("allowMultipleInstances", this.allowMultipleInstances());
    }

    @Override
    public List<Json> getDeploymentProfiles() {
        return this.deploymentProfiles;
    }

    @Override
    public boolean isValidDeploymentProfile(String profileName) {
        Json profile = this.getDeploymentProfile(profileName);
        return profile != null;
    }

    @Override
    public Json getDeploymentProfile(String profileName) {
        if (StringUtils.isBlank((CharSequence)profileName)) {
            return null;
        }
        for (Json profile : this.deploymentProfiles) {
            String name = profile.string("name");
            if (!profileName.equals(name)) continue;
            return profile;
        }
        return null;
    }

    @Override
    public boolean allowMultipleInstances() {
        return this.allowMultipleInstances;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public String getConfigurationHelpUrl() {
        return this.configurationHelpUrl;
    }

    @Override
    public String getStatus() {
        return this.isActive() ? "ACTIVE" : "DISABLED";
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public List<Json> getDataStores() {
        return this.dataStores;
    }

    @Override
    public List<String> getDataStoresNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Json dataStore : this.dataStores) {
            String name = dataStore.string("name");
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            names.add(name);
        }
        return names;
    }

    @Override
    public boolean isValidDataStore(String dataStoreName) {
        Json dataStore = this.getDataStore(dataStoreName);
        return dataStore != null;
    }

    @Override
    public Json getDataStore(String dataStoreName) {
        if (StringUtils.isBlank((CharSequence)dataStoreName)) {
            return null;
        }
        for (Json dataStore : this.dataStores) {
            String name = dataStore.string("name");
            if (!dataStoreName.equals(name)) continue;
            return dataStore;
        }
        return null;
    }

    @Override
    public List<Json> getEvents() {
        return this.events;
    }

    @Override
    public boolean isValidEvent(String eventName) {
        Json event = this.getEvent(eventName);
        return event != null;
    }

    @Override
    public Json getEvent(String eventName) {
        if (StringUtils.isBlank((CharSequence)eventName)) {
            return null;
        }
        for (Json event : this.events) {
            String name = event.string("name");
            if (!eventName.equals(name)) continue;
            return event;
        }
        return null;
    }

    @Override
    public List<Json> getFunctions() {
        return this.functions;
    }

    @Override
    public boolean isValidFunction(String functionName) {
        Json function = this.getFunction(functionName);
        return function != null;
    }

    @Override
    public Json getFunction(String functionName) {
        if (StringUtils.isBlank((CharSequence)functionName)) {
            return null;
        }
        for (Json function : this.functions) {
            String name = function.string("name");
            if (!functionName.equals(name)) continue;
            return function;
        }
        return null;
    }

    @Override
    public List<Json> getUIConfiguration() {
        return this.configuration;
    }

    @Override
    public List<Json> getUIUserConfiguration() {
        return this.userConfiguration;
    }

    @Override
    public Json getUIUserConfigurationButtons() {
        return this.userConfigurationButtons;
    }

    @Override
    public Json toJson() {
        return Json.map().set("label", this.getLabel()).set("name", this.getType()).set("apiVersion", this.getApiVersion()).set("internal", this.isInternal()).set("configurationType", this.getConfigurationType()).set("deployment", this.getDeployment()).setIfNotEmpty("icon48", this.getIcon()).setIfNotEmpty("configurationHelpUrl", this.getConfigurationHelpUrl()).set("status", this.getStatus()).setIfNotEmpty("stores", this.getDataStores()).setIfNotEmpty("events", this.getEvents()).setIfNotEmpty("functions", this.getFunctions()).setIfNotEmpty("configuration", this.getUIConfiguration()).setIfNotEmpty("userConfiguration", this.getUIUserConfiguration()).setIfNotEmpty("userConfigurationButtons", this.getUIUserConfigurationButtons());
    }
}

