/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework.annotations.classes;

import io.slingr.services.framework.annotations.ServiceFunction;
import io.slingr.services.framework.annotations.classes.FunctionResponseType;
import io.slingr.services.framework.annotations.classes.MethodAccessorType;
import io.slingr.services.framework.annotations.classes.MethodParameterType;
import io.slingr.services.framework.annotations.processor.AnnotationsUtils;
import io.slingr.services.utils.Json;
import io.slingr.services.ws.exchange.FunctionRequest;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;

public class ClassFunction {
    public static final String SF_NAME = ServiceFunction.class.getSimpleName();
    private final ExecutableElement annotatedElement;
    private final String simpleName;
    private final String name;
    private final MethodParameterType parameterType;
    private final FunctionResponseType responseType;
    private final MethodAccessorType accessorType;
    private final Class<?> methodClass;
    private final boolean generated;

    public ClassFunction(Element sFunctionElement, boolean generated) throws IllegalArgumentException {
        this(sFunctionElement, sFunctionElement.getAnnotation(ServiceFunction.class), generated);
    }

    public ClassFunction(Element sFunctionElement, ServiceFunction annotation, boolean generated) throws IllegalArgumentException {
        this(sFunctionElement, annotation != null ? annotation.name() : null, generated);
    }

    public ClassFunction(Element sFunctionElement, String serviceFunctionName, boolean generated) throws IllegalArgumentException {
        this(sFunctionElement, serviceFunctionName, null, generated);
    }

    public ClassFunction(Element sFunctionElement, String serviceFunctionName, Class<?> methodClass, boolean generated) throws IllegalArgumentException {
        this.generated = generated;
        this.annotatedElement = (ExecutableElement)sFunctionElement;
        this.simpleName = this.annotatedElement.getSimpleName().toString().trim();
        this.name = StringUtils.isNotBlank((CharSequence)serviceFunctionName) ? serviceFunctionName : this.simpleName;
        this.methodClass = methodClass;
        AnnotationsUtils.checkNotEmpty(this.name, "name", SF_NAME, "method", this.name);
        Element typeElement = this.annotatedElement.getEnclosingElement();
        if (!this.isValidFunction(typeElement)) {
            throw new IllegalStateException(String.format("Method [%s] is not valid", this.getName()));
        }
        this.parameterType = this.hasValidParameters(typeElement);
        if (this.parameterType == null) {
            throw new IllegalStateException(String.format("Parameters for method [%s] is not valid", this.getName()));
        }
        this.responseType = this.getResponse();
        this.accessorType = this.annotatedElement.getModifiers().contains((Object)Modifier.PROTECTED) || this.annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE) ? MethodAccessorType.PRIVATE : MethodAccessorType.PUBLIC;
    }

    public ClassFunction clone(String serviceFunctionName, boolean generated) {
        return new ClassFunction(this.annotatedElement, serviceFunctionName, this.methodClass, generated);
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.name;
    }

    public FunctionResponseType getResponseType() {
        return this.responseType;
    }

    public MethodParameterType getParameterType() {
        return this.parameterType;
    }

    public MethodAccessorType getAccessorType() {
        return this.accessorType;
    }

    public Class<?> getMethodClass() {
        return this.methodClass;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    private boolean isValidFunction(Element typeElement) {
        if (this.annotatedElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            AnnotationsUtils.error(this.annotatedElement, "Method [%s] on [%s] must be a non-abstract method", this.simpleName, typeElement.getSimpleName());
            return false;
        }
        return true;
    }

    private MethodParameterType hasValidParameters(Element typeElement) {
        int parametersCount = this.annotatedElement.getParameters().size();
        if (parametersCount == 0) {
            return MethodParameterType.NONE;
        }
        if (parametersCount > 1) {
            AnnotationsUtils.error(this.annotatedElement, "Method [%s] on [%s] must accept zero or one parameter (Object, String, Json or FunctionRequest). Parameters count [%s]", this.simpleName, typeElement.getSimpleName(), parametersCount);
            return null;
        }
        VariableElement parameter = this.annotatedElement.getParameters().get(0);
        TypeKind kind = parameter.asType().getKind();
        if (!kind.equals((Object)TypeKind.DECLARED)) {
            AnnotationsUtils.error(this.annotatedElement, "Method [%s] on [%s] must accept zero or one parameter (Object, String, Json or FunctionRequest). Parameter type [%s]", this.simpleName, typeElement.getSimpleName(), parameter.asType().toString());
            return null;
        }
        if (parameter.asType().toString().equals(Json.class.getCanonicalName())) {
            return MethodParameterType.JSON;
        }
        if (parameter.asType().toString().equals(FunctionRequest.class.getCanonicalName())) {
            return MethodParameterType.REQUEST;
        }
        if (parameter.asType().toString().equals(String.class.getCanonicalName())) {
            return MethodParameterType.STRING;
        }
        if (parameter.asType().toString().equals(Object.class.getCanonicalName())) {
            return MethodParameterType.OBJECT;
        }
        AnnotationsUtils.error(this.annotatedElement, "Method [%s] on [%s] must accept zero or one parameter (Object, String, Json or FunctionRequest). Parameter type [%s]", this.simpleName, typeElement.getSimpleName(), parameter.asType().toString());
        return null;
    }

    private FunctionResponseType getResponse() {
        TypeMirror returnType = this.annotatedElement.getReturnType();
        TypeKind kind = returnType.getKind();
        if (kind == TypeKind.VOID) {
            return FunctionResponseType.VOID;
        }
        if (kind == TypeKind.DECLARED && returnType.toString().equals(Json.class.getCanonicalName())) {
            return FunctionResponseType.JSON;
        }
        return FunctionResponseType.OTHER;
    }
}

