/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils.converters;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.utils.Json;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlToJsonParser
extends DefaultHandler {
    static final Pattern NUMBER_PATTERN = Pattern.compile("\\s*[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?\\s*");
    private Json response = Json.map();
    private final List<Json> stack = new ArrayList<Json>();

    public static Json parse(String xml) throws ServiceException {
        try {
            return new XmlToJsonParser(xml).getResponse();
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CONVERSION, (Object)ex.getMessage(), ex);
        }
    }

    private XmlToJsonParser(String xml) throws ServiceException {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.setEntityResolver(this);
            xr.parse(new InputSource(new ByteArrayInputStream(xml.getBytes())));
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CONVERSION, (Object)ex.getMessage(), ex);
        }
    }

    public Json getResponse() {
        return this.response;
    }

    public String attributeName(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return String.format("@%s", name);
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void startDocument() {
        this.stack.clear();
        this.stack.add(0, Json.map());
    }

    @Override
    public void endDocument() {
        this.response = this.stack.get(0);
    }

    @Override
    public void startElement(String uri, String elementName, String qName, Attributes attributes) {
        Json work = Json.map();
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String aName = this.attributeName(attributes.getLocalName(i));
                if (!StringUtils.isNotBlank((CharSequence)aName)) continue;
                work.setIfNotEmpty(aName, attributes.getValue(i));
            }
        }
        this.stack.add(0, work);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        Json currentElement = this.stack.get(0);
        if (currentElement != null) {
            String value;
            String newValue = new String(ch, start, length);
            if (StringUtils.isEmpty((CharSequence)newValue)) {
                newValue = "";
            }
            if (StringUtils.isEmpty((CharSequence)(value = currentElement.string("keyValue")))) {
                value = "";
            }
            currentElement.set("keyValue", String.format("%s%s", value, newValue));
        }
    }

    @Override
    public void endElement(String uri, String elementName, String qName) {
        Json currentElement = this.stack.remove(0);
        Object elementToStore = currentElement;
        if (currentElement.isEmpty()) {
            elementToStore = "";
        } else if (currentElement.contains("keyValue")) {
            String value = currentElement.string("keyValue");
            if (StringUtils.isNotBlank((CharSequence)value)) {
                value = value.replaceAll("\\s+", " ").trim();
            }
            if (currentElement.size() == 1) {
                elementToStore = StringUtils.isBlank((CharSequence)value) ? "" : this.convertToPrimitiveValue(value);
            } else if (StringUtils.isBlank((CharSequence)value)) {
                currentElement.remove("keyValue");
            } else {
                currentElement.set("keyValue", this.convertToPrimitiveValue(value));
            }
        }
        Json parentElement = this.stack.get(0);
        if (parentElement != null) {
            if (parentElement.isEmpty() || !parentElement.contains(elementName)) {
                parentElement.set(elementName, elementToStore);
            } else {
                Object elementWithSameName = parentElement.object(elementName);
                if (elementWithSameName instanceof Json) {
                    ((Json)elementWithSameName).push(elementToStore);
                } else if (elementWithSameName instanceof List) {
                    ((List)elementWithSameName).add(elementToStore);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(elementWithSameName);
                    list.add(elementToStore);
                    parentElement.set(elementName, list);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object convertToPrimitiveValue(String value) {
        Object newValue = value;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            if (value.equalsIgnoreCase("true")) {
                newValue = true;
            } else if (value.equalsIgnoreCase("false")) {
                newValue = false;
            } else {
                String newNumber = value.trim().replaceAll("-\\s*", "-");
                if (NUMBER_PATTERN.matcher(newNumber).matches()) {
                    Number number = null;
                    try {
                        number = NumberFormat.getInstance().parse(newNumber);
                    }
                    catch (ParseException parseException) {
                    }
                    finally {
                        if (number != null) {
                            newValue = number;
                        }
                    }
                }
            }
        } else {
            newValue = true;
        }
        return newValue;
    }
}

