/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils;

import io.slingr.services.utils.Json;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Form;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

public class FormUtils {
    public static Form convertFromJsonToForm(Json content) {
        Form form = new Form();
        if (content != null && content.isMap()) {
            FormUtils.flattenJson("", content.toMap(), form);
        }
        return form;
    }

    private static void flattenJson(String parentKey, Map<String, Object> map, Form form) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                FormUtils.flattenJson((String)(parentKey.isEmpty() ? key : parentKey + "[" + key + "]"), (Map<String, Object>)((Map)value), form);
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    String indexedKey = parentKey.isEmpty() ? key + "[" + i + "]" : parentKey + "[" + key + "][" + i + "]";
                    form.param(indexedKey, list.get(i).toString());
                }
                continue;
            }
            if (value == null) continue;
            String finalKey = parentKey.isEmpty() ? key : parentKey + "[" + key + "]";
            form.param(finalKey, value.toString());
        }
    }

    public static FormDataMultiPart convertFromJsonToFormDataMultiPart(Json content) {
        FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
        if (content != null && content.isMap()) {
            FormUtils.flattenJson("", content.toMap(), formDataMultiPart);
        }
        return formDataMultiPart;
    }

    private static void flattenJson(String parentKey, Map<String, Object> map, FormDataMultiPart formDataMultiPart) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                FormUtils.flattenJson((String)(parentKey.isEmpty() ? key : parentKey + "[" + key + "]"), (Map<String, Object>)((Map)value), formDataMultiPart);
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    String indexedKey = parentKey.isEmpty() ? key + "[" + i + "]" : parentKey + "[" + key + "][" + i + "]";
                    formDataMultiPart.field(indexedKey, list.get(i).toString());
                }
                continue;
            }
            if (value == null) continue;
            String finalKey = parentKey.isEmpty() ? key : parentKey + "[" + key + "]";
            formDataMultiPart.field(finalKey, value.toString());
        }
    }
}

