/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.datastores;

import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.DataStores;
import io.slingr.services.services.datastores.DataStoreResponse;
import io.slingr.services.utils.Json;

public class DataStore {
    private final String dataStoreName;
    private final DataStores dataStores;

    public DataStore(String dataStoreName, DataStores dataStores) {
        this.dataStoreName = dataStoreName;
        this.dataStores = dataStores;
    }

    public String getName() {
        return this.dataStoreName;
    }

    public DataStoreResponse find() throws ServiceException {
        return this.dataStores.find(this.dataStoreName, null);
    }

    public DataStoreResponse find(Json filter) throws ServiceException {
        return this.dataStores.find(this.dataStoreName, filter);
    }

    public DataStoreResponse find(Json filter, String offset, Integer size) throws ServiceException {
        return this.dataStores.find(this.dataStoreName, filter, offset, size);
    }

    public int count() throws ServiceException {
        return this.dataStores.count(this.dataStoreName);
    }

    public int count(Json filter) throws ServiceException {
        return this.dataStores.count(this.dataStoreName, filter);
    }

    public Json findById(String documentId) throws ServiceException {
        return this.dataStores.findById(this.dataStoreName, documentId);
    }

    public Json findOne(Json filter) throws ServiceException {
        return this.dataStores.findOne(this.dataStoreName, filter);
    }

    public Json save(Json document) throws ServiceException {
        return this.dataStores.save(this.dataStoreName, document);
    }

    public Json update(Json document) throws ServiceException {
        return this.dataStores.update(this.dataStoreName, document);
    }

    public Json update(String documentId, Json document) throws ServiceException {
        return this.dataStores.update(this.dataStoreName, documentId, document);
    }

    public boolean remove() throws ServiceException {
        return this.dataStores.remove(this.dataStoreName);
    }

    public boolean remove(Json filter) throws ServiceException {
        return this.dataStores.remove(this.dataStoreName, filter);
    }

    public void removeById(String documentId) throws ServiceException {
        this.dataStores.removeById(this.dataStoreName, documentId);
    }
}

