/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Random;
import javax.activation.MimetypesFileTypeMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesUtils {
    private static final Logger logger = LoggerFactory.getLogger(FilesUtils.class);
    private static final String TEMP_FILE_PREFIX_PATTER = "sl_tmp_%s";
    private static final int BUFFER_8KB = 8192;
    private static final int FLUSH_STEP_1MB = 0x100000;
    private static final Random RANDOM = new Random();

    public static String readLocalFile(String pathName) throws IOException {
        if (StringUtils.isBlank((String)pathName)) {
            throw new IllegalArgumentException("Empty path name");
        }
        File file = new File(pathName);
        if (!file.exists()) {
            throw new IllegalStateException(String.format("File [%s] does not exist.", pathName));
        }
        return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
    }

    public static InputStream getLocalFile(String pathName) throws IOException {
        if (StringUtils.isBlank((String)pathName)) {
            throw new IllegalArgumentException("Empty path name");
        }
        File file = new File(pathName);
        if (!file.exists()) {
            throw new IllegalStateException(String.format("File [%s] does not exist.", pathName));
        }
        return new FileInputStream(file);
    }

    public static String readInternalFile(String filename) throws IOException {
        return FilesUtils.readInternalFile(filename, false);
    }

    public static String readInternalFile(String filename, boolean absolute) throws IOException {
        File file = FileUtils.toFile((URL)FilesUtils.getInternalFileURL(filename, absolute));
        if (file == null || !file.exists()) {
            throw new IllegalStateException(String.format("Internal file [%s] does not exist.", filename));
        }
        return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
    }

    public static InputStream getInternalFile(String filename) throws IOException {
        return FilesUtils.getInternalFile(filename, false);
    }

    public static InputStream getInternalFile(String filename, boolean absolute) throws IOException {
        File file = FileUtils.toFile((URL)FilesUtils.getInternalFileURL(filename, absolute));
        if (file == null || !file.exists()) {
            throw new IllegalStateException(String.format("File [%s] does not exist.", filename));
        }
        return new FileInputStream(file);
    }

    public static URL getInternalFileURL(String filename, boolean absolute) {
        if (StringUtils.isBlank((String)filename)) {
            throw new IllegalArgumentException("Empty filename");
        }
        if (absolute && !((String)filename).startsWith("/")) {
            filename = "/" + (String)filename;
        }
        return FileUtils.class.getClassLoader().getResource((String)filename);
    }

    public static void copyStreamAndFlush(InputStream is, OutputStream os) throws IOException {
        FilesUtils.copyStreamAndFlush(is, os, 0x100000);
    }

    public static void copyStreamAndFlush(InputStream is, OutputStream os, int flushStep) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        int bytesBuffered = 0;
        while ((bytesRead = is.read(buffer)) > -1) {
            os.write(buffer, 0, bytesRead);
            if ((bytesBuffered += bytesRead) <= flushStep) continue;
            bytesBuffered = 0;
            os.flush();
        }
        os.flush();
    }

    public static File copyInputStreamToTemporaryFile(String filename, InputStream inputStream) {
        return FilesUtils.copyInputStreamToTemporaryFile(filename, inputStream, true);
    }

    public static File copyInputStreamToTemporaryFile(String filename, InputStream inputStream, boolean closeStream) {
        File tmp = null;
        if (inputStream == null) {
            logger.warn(String.format("The input stream for the file [%s] is null. It is not possible to create file.", FilesUtils.convertNameForLog(filename)));
        } else {
            try {
                tmp = File.createTempFile(FilesUtils.convertNameForTmpFile(filename), null);
                FileOutputStream tf = new FileOutputStream(tmp);
                FilesUtils.copyStreamAndFlush(inputStream, tf);
                tf.close();
                if (closeStream) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                logger.warn(String.format("An exception occurs when try to save the input stream of the file [%s] - Exception: %s", FilesUtils.convertNameForLog(filename), ex.getMessage()), (Throwable)ex);
            }
        }
        return tmp;
    }

    public static void copyFileToOutputStream(File file, OutputStream outputStream) {
        try {
            FileInputStream tmpIs = new FileInputStream(file);
            FilesUtils.copyStreamAndFlush(tmpIs, outputStream);
            ((InputStream)tmpIs).close();
        }
        catch (IOException ex) {
            logger.warn(String.format("An exception occurs when try to copy the file [%s] on the output stream - Exception: %s", FilesUtils.convertNameForLog(file.getName()), ex.getMessage()), (Throwable)ex);
        }
    }

    private static String convertNameForLog(String filename) {
        return StringUtils.isNotBlank((String)filename) ? filename : "-no name-";
    }

    private static String convertNameForTmpFile(String postfix) {
        return String.format(TEMP_FILE_PREFIX_PATTER, StringUtils.isNotBlank((String)postfix) ? postfix : Integer.valueOf(RANDOM.nextInt(1024)));
    }

    public static MediaType getMediaTypeForMultipart(String contentType, String filename) {
        MediaType mediaType = FilesUtils.getMediaType(contentType, filename);
        if (mediaType == null) {
            mediaType = FilesUtils.getMediaType(contentType, filename);
        }
        return mediaType;
    }

    public static MediaType getMediaType(String contentType) {
        return FilesUtils.getMediaType(contentType, null);
    }

    public static MediaType getMediaType(String contentType, String filename) {
        String normalizedContentType = FilesUtils.getContentType(contentType, filename);
        MediaType mediaType = null;
        if (StringUtils.isNotBlank((String)normalizedContentType)) {
            try {
                mediaType = MediaType.valueOf((String)normalizedContentType);
            }
            catch (Exception ex) {
                logger.warn(String.format("Error when try to generate media type from content type [%s]. Exception [%s]", contentType, ex.getMessage()));
            }
        }
        return mediaType;
    }

    public static String getContentType(String contentType, String filename) {
        if (StringUtils.isBlank((String)contentType) && StringUtils.isBlank((String)(contentType = URLConnection.guessContentTypeFromName(filename)))) {
            contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(filename);
        }
        return contentType;
    }
}

