/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework;

import io.slingr.services.framework.annotations.classes.ClassWebService;
import io.slingr.services.framework.annotations.classes.MethodAccessorType;
import io.slingr.services.framework.annotations.classes.MethodParameterType;
import io.slingr.services.framework.annotations.classes.WebServiceResponseType;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.Json;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegisteredWebService
implements Comparable<RegisteredWebService> {
    private final String key;
    private final String name;
    private final RestMethod restMethod;
    private final String path;
    private final String method;
    private final MethodParameterType parameterType;
    private final WebServiceResponseType responseType;
    private final MethodAccessorType accessorType;
    private final Map<String, Integer> variables = new HashMap<String, Integer>();
    private final Pattern pattern;
    private final Pattern extractPattern;
    private final Class<?> serviceClass;

    public RegisteredWebService(String name, RestMethod restMethod, String path, String method, MethodParameterType parameterType, WebServiceResponseType responseType, MethodAccessorType accessorType) {
        this(name, restMethod, path, method, parameterType, responseType, accessorType, null);
    }

    public RegisteredWebService(String name, RestMethod restMethod, String path, String method, MethodParameterType parameterType, WebServiceResponseType responseType, MethodAccessorType accessorType, Class<?> serviceClass) {
        this.name = name;
        this.restMethod = restMethod;
        this.path = path;
        this.method = method;
        this.parameterType = parameterType;
        this.responseType = responseType;
        this.accessorType = accessorType;
        this.serviceClass = serviceClass;
        String cleanedPath = ClassWebService.cleanPath(path);
        String regex = cleanedPath.replaceAll("/", "\\/").replaceAll("\\{\\w+:(.*)}", "$1").replaceAll("\\{\\w+}", "[\\\\w\\\\-\\\\.]+").replaceAll("\\*", ".+");
        String extractRegex = cleanedPath.replaceAll("/", "\\/").replaceAll("\\{(\\w+):(.*)}", "(?<$1>$2)").replaceAll("\\{(\\w+)}", "(?<$1>[\\\\w\\\\-\\\\.]+)").replaceAll("\\*", ".+");
        this.pattern = Pattern.compile(String.format("\\/?%s\\/?", regex), 2);
        this.extractPattern = Pattern.compile(String.format("\\/?%s\\/?", extractRegex), 2);
        try {
            Matcher extractMatcher = this.extractPattern.matcher("");
            for (int i = 1; i <= extractMatcher.groupCount(); ++i) {
                String groupName = extractMatcher.group(i);
                if (groupName == null) continue;
                this.variables.put(groupName, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.key = name.replaceAll("\\{[\\w\\-.]+:([\\w\\-\\.]+)}", "aaaaaaa-filter-zz$1").replaceAll("\\{[\\w\\-.]+}", "aaaaaaa-filter-aa").replaceAll("\\*", "aaaaaaa-filter").toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public RestMethod getRestMethod() {
        return this.restMethod;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public MethodParameterType getParameterType() {
        return this.parameterType;
    }

    public WebServiceResponseType getResponseType() {
        return this.responseType;
    }

    public MethodAccessorType getAccessorType() {
        return this.accessorType;
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public Json getPathVariables(String route) {
        Matcher matcher;
        Json vars = Json.map();
        if (!this.variables.isEmpty() && (route = this.checkRoute(route)) != null && (matcher = this.extractPattern.matcher(route)).matches()) {
            this.variables.forEach((key, index) -> vars.set((String)key, matcher.group((int)index)));
        }
        return vars;
    }

    public boolean isValidRoute(String route) {
        return this.checkRoute(route) != null;
    }

    private String checkRoute(String route) {
        route = StringUtils.isBlank((CharSequence)route) ? "" : route.trim();
        return this.pattern.matcher(route).matches() ? route : null;
    }

    @Override
    public int compareTo(RegisteredWebService o) {
        return -1 * this.getKey().compareTo(o.getKey());
    }
}

