/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework.annotations.classes;

import io.slingr.services.framework.annotations.ServiceWebService;
import io.slingr.services.framework.annotations.classes.MethodAccessorType;
import io.slingr.services.framework.annotations.classes.MethodParameterType;
import io.slingr.services.framework.annotations.classes.WebServiceResponseType;
import io.slingr.services.framework.annotations.processor.AnnotationsUtils;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.Json;
import io.slingr.services.ws.exchange.WebServiceRequest;
import io.slingr.services.ws.exchange.WebServiceResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;

public class ClassWebService {
    public static final String SW_NAME = ServiceWebService.class.getSimpleName();
    private final ExecutableElement annotatedElement;
    private final String simpleName;
    private final String path;
    private final List<RestMethod> methods;
    private final String name;
    private final MethodParameterType parameterType;
    private final WebServiceResponseType responseType;
    private final MethodAccessorType accessorType;
    private final Class<?> methodClass;

    public ClassWebService(Element sWebServiceElement, boolean generated) throws IllegalArgumentException {
        this(sWebServiceElement, sWebServiceElement.getAnnotation(ServiceWebService.class), generated);
    }

    public ClassWebService(Element sWebServiceElement, ServiceWebService annotation, boolean generated) throws IllegalArgumentException {
        this(sWebServiceElement, annotation != null ? annotation.path() : null, annotation != null ? annotation.methods() : null, null, generated);
    }

    public ClassWebService(Element sWebServiceElement, String processorPath, RestMethod[] processorMethods, Class<?> methodClass, boolean generated) throws IllegalArgumentException {
        this.annotatedElement = (ExecutableElement)sWebServiceElement;
        this.simpleName = this.annotatedElement.getSimpleName().toString().trim();
        this.methodClass = methodClass;
        this.path = ClassWebService.normalizePath(processorPath);
        AnnotationsUtils.checkNotEmpty(this.path, "path", SW_NAME, "web service", this.simpleName);
        this.methods = new ArrayList<RestMethod>();
        if (processorMethods != null) {
            for (RestMethod method : processorMethods) {
                if (this.methods.contains((Object)method)) continue;
                this.methods.add(method);
            }
        }
        if (this.methods.isEmpty()) {
            this.methods.addAll(RestMethod.all());
        }
        this.methods.sort(Comparator.comparing(Enum::name));
        this.name = ClassWebService.generateName(this.path, this.methods);
        Element typeElement = this.annotatedElement.getEnclosingElement();
        if (!this.isValidWebService(typeElement)) {
            throw new IllegalStateException(String.format("Web service [%s] is not valid", this.getName()));
        }
        this.parameterType = this.isValidParameter(typeElement);
        if (this.parameterType == null) {
            throw new IllegalStateException(String.format("Parameters type for web service [%s] is not valid", this.getName()));
        }
        this.responseType = this.isValidResponse();
        if (this.responseType == null) {
            throw new IllegalStateException(String.format("Return type for web service [%s] is not valid", this.getName()));
        }
        this.accessorType = this.annotatedElement.getModifiers().contains((Object)Modifier.PROTECTED) || this.annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE) ? MethodAccessorType.PRIVATE : MethodAccessorType.PUBLIC;
    }

    public static String generateName(String path, List<RestMethod> methods) {
        String m = methods == null || methods.isEmpty() || methods.size() == RestMethod.values().length ? "all" : StringUtils.join((Iterable)methods.stream().map(RestMethod::toInitials).collect(Collectors.toList()), (String)":");
        return ClassWebService.generateName(path, m);
    }

    public static String generateName(String path, String method) {
        if (StringUtils.isBlank((CharSequence)method)) {
            method = "all";
        }
        return String.format("/%s~%s", ClassWebService.cleanPath(path), method).toLowerCase();
    }

    public static String cleanPath(String path) {
        String p;
        String string = p = StringUtils.isNotBlank((CharSequence)path) ? path.trim() : "";
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    public static String normalizePath(String path) {
        Object p;
        Object object = p = StringUtils.isNotBlank((CharSequence)path) ? path.trim() : "/";
        if (!((String)p).startsWith("/")) {
            p = "/" + (String)p;
        }
        if (!((String)p).endsWith("/")) {
            p = (String)p + "/";
        }
        return p;
    }

    public Class<?> getMethodClass() {
        return this.methodClass;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<RestMethod> getMethods() {
        return this.methods;
    }

    public MethodParameterType getParameterType() {
        return this.parameterType;
    }

    public WebServiceResponseType getResponseType() {
        return this.responseType;
    }

    public MethodAccessorType getAccessorType() {
        return this.accessorType;
    }

    private boolean isValidWebService(Element typeElement) {
        if (this.annotatedElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            AnnotationsUtils.error(this.annotatedElement, "Method [%s] on [%s] must be a non-abstract method", this.simpleName, typeElement.getSimpleName());
            return false;
        }
        return true;
    }

    private MethodParameterType isValidParameter(Element typeElement) {
        int parametersCount = this.annotatedElement.getParameters().size();
        if (parametersCount == 0) {
            return MethodParameterType.NONE;
        }
        if (parametersCount > 1) {
            AnnotationsUtils.error(this.annotatedElement, "Method [%s] on [%s] must accept zero or one parameter (Json, String, WebServiceRequest or Object). Parameters count [%s]", this.simpleName, typeElement.getSimpleName(), parametersCount);
            return null;
        }
        VariableElement parameter = this.annotatedElement.getParameters().get(0);
        TypeKind kind = parameter.asType().getKind();
        if (!kind.equals((Object)TypeKind.DECLARED)) {
            AnnotationsUtils.error(this.annotatedElement, "Method [%s] on [%s] must accept zero or one parameter (Json, String, WebServiceRequest or Object). Parameter type [%s]", this.simpleName, typeElement.getSimpleName(), parameter.asType().toString());
            return null;
        }
        String className = parameter.asType().toString();
        if (className.equals(Json.class.getCanonicalName())) {
            return MethodParameterType.JSON;
        }
        if (className.equals(String.class.getCanonicalName())) {
            return MethodParameterType.STRING;
        }
        if (className.equals(WebServiceRequest.class.getCanonicalName())) {
            return MethodParameterType.REQUEST;
        }
        if (className.equals(Object.class.getCanonicalName())) {
            return MethodParameterType.OBJECT;
        }
        AnnotationsUtils.error(this.annotatedElement, "Method [%s] on [%s] must accept zero or one parameter (Json, String, WebServiceRequest or Object). Parameter type [%s]", this.simpleName, typeElement.getSimpleName(), parameter.asType().toString());
        return null;
    }

    private WebServiceResponseType isValidResponse() {
        TypeMirror returnType = this.annotatedElement.getReturnType();
        TypeKind kind = returnType.getKind();
        if (kind == TypeKind.VOID) {
            return WebServiceResponseType.VOID;
        }
        if (kind == TypeKind.DECLARED) {
            if (returnType.toString().equals(Json.class.getCanonicalName())) {
                return WebServiceResponseType.JSON;
            }
            if (returnType.toString().equals(String.class.getCanonicalName())) {
                return WebServiceResponseType.STRING;
            }
            if (returnType.toString().equals(WebServiceResponse.class.getCanonicalName())) {
                return WebServiceResponseType.RESPONSE;
            }
            return WebServiceResponseType.OBJECT;
        }
        return WebServiceResponseType.OBJECT;
    }
}

