/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework.annotations.processor;

import io.slingr.services.framework.annotations.classes.PropertyType;
import io.slingr.services.utils.Json;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;

public abstract class AnnotationsUtils {
    private static Messager messager = null;
    private static Types typeUtils = null;
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    public static void checkIfInitialized() {
        if (!initialized.get()) {
            throw new IllegalStateException("Annotation utils not initialed yet");
        }
    }

    public static void set(ProcessingEnvironment environment) {
        typeUtils = environment.getTypeUtils();
        messager = environment.getMessager();
        initialized.set(true);
    }

    public static void note(Element e, String msg, Object ... args) {
        AnnotationsUtils.checkIfInitialized();
        messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args), e);
    }

    public static void error(Element e, String msg, Object ... args) {
        AnnotationsUtils.checkIfInitialized();
        messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public static Element asElement(TypeMirror classType) {
        AnnotationsUtils.checkIfInitialized();
        return typeUtils.asElement(classType);
    }

    public static void checkNotEmpty(String var, String annotationProperty, String annotation, String typeAnnotated, String nameAnnotated) {
        if (StringUtils.isEmpty((CharSequence)var)) {
            throw new IllegalArgumentException(String.format("Empty [%s] in @%s for %s [%s]", annotationProperty, annotation, typeAnnotated, nameAnnotated));
        }
    }

    public static void checkNotNull(Object var, String annotationProperty, String annotation, String typeAnnotated, String nameAnnotated) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Empty [%s] in @%s for %s [%s]", annotationProperty, annotation, typeAnnotated, nameAnnotated));
        }
    }

    public static PropertyType isValid(Class<?> clazz, VariableElement element, String name, boolean isProperty, String accessor) {
        return AnnotationsUtils.isValid(clazz, element, name, isProperty, accessor, false);
    }

    public static PropertyType isValid(Class<?> clazz, VariableElement element, String name, boolean isProperty, String accessor, boolean isServiceConfiguration) {
        PropertyType type = isProperty ? AnnotationsUtils.isValidProperty(clazz, element, name, accessor, isServiceConfiguration) : AnnotationsUtils.isValidSetter2(clazz, element, name, accessor, isServiceConfiguration);
        return type;
    }

    public static PropertyType isValidProperty(Class<?> clazz, VariableElement element, String name, String property) {
        return AnnotationsUtils.isValidProperty(clazz, element, name, property, false);
    }

    public static PropertyType isValidProperty(Class<?> clazz, VariableElement element, String name, String property, boolean isServiceConfiguration) {
        PropertyType type = PropertyType.OTHER;
        Element typeElement = element.getEnclosingElement();
        if (clazz == null) {
            type = AnnotationsUtils.isValidPropertyVariable(element, isServiceConfiguration);
            if (type == null) {
                AnnotationsUtils.error(element, "ServiceProperty [%s] on [%s] must be String, Boolean or Json in order to set [%s]", property, typeElement.getSimpleName(), name);
                return null;
            }
        } else {
            boolean valid = AnnotationsUtils.isValidVariable(clazz, element);
            if (!valid) {
                AnnotationsUtils.error(element, "ServiceProperty [%s] on [%s] must be of type %s in order to set [%s]", property, typeElement.getSimpleName(), clazz.getSimpleName(), name);
                return null;
            }
        }
        return type;
    }

    public static PropertyType isValidSetter(Class<?> clazz, VariableElement element, String name, String setter) {
        return AnnotationsUtils.isValidSetter(clazz, element, name, setter, false);
    }

    public static PropertyType isValidSetter(Class<?> clazz, VariableElement element, String name, String setter, boolean isServiceConfiguration) {
        PropertyType type = PropertyType.OTHER;
        Element typeElement = element.getEnclosingElement();
        Element am = null;
        for (Element element2 : typeElement.getEnclosedElements()) {
            if (!element2.getSimpleName().toString().equals(setter)) continue;
            am = element2;
            break;
        }
        if (am == null) {
            AnnotationsUtils.note(element, "Accessor [%s()] was not found for %s [%s] on [%s]", setter, clazz == null ? "property" : clazz.getSimpleName(), name, typeElement.getSimpleName());
            return null;
        }
        if (!am.getKind().equals((Object)ElementKind.METHOD)) {
            AnnotationsUtils.note(element, "Accessor [%s()] must be a public method on [%s] in order to set [%s]", setter, typeElement.getSimpleName(), name);
            return null;
        }
        if (am.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            AnnotationsUtils.note(element, "Accessor [%s()] on [%s] must be a non-abstract method in order to set [%s]", setter, typeElement.getSimpleName(), name);
            return null;
        }
        if (am.getModifiers().contains((Object)Modifier.PROTECTED) || am.getModifiers().contains((Object)Modifier.PRIVATE)) {
            AnnotationsUtils.note(element, "Accessor [%s()] must be public on [%s] in order to set [%s]", setter, typeElement.getSimpleName(), name);
            return null;
        }
        ExecutableElement method = (ExecutableElement)am;
        if (clazz == null) {
            if (method.getParameters().size() != 1) {
                AnnotationsUtils.note(element, "Accessor [%s()] on [%s] must accept only one parameter of type either String or Boolean in order to set [%s]", setter, typeElement.getSimpleName(), name);
                return null;
            }
            VariableElement variableElement = method.getParameters().get(0);
            type = AnnotationsUtils.isValidPropertyVariable(variableElement, isServiceConfiguration);
            if (type == null) {
                AnnotationsUtils.note(element, "Accessor [%s()] on [%s] must accept only one parameter of type either String or Boolean in order to set [%s]", setter, typeElement.getSimpleName(), name);
                return null;
            }
        } else {
            if (method.getParameters().size() != 1) {
                AnnotationsUtils.note(element, "Accessor [%s()] on [%s] must accept only one parameter of type %s in order to set [%s]", setter, typeElement.getSimpleName(), clazz.getSimpleName(), name);
                return null;
            }
            VariableElement variableElement = method.getParameters().get(0);
            boolean valid = AnnotationsUtils.isValidVariable(clazz, variableElement);
            if (!valid) {
                AnnotationsUtils.note(element, "Accessor [%s()] on [%s] must accept only one parameter of type %s in order to set [%s]", setter, typeElement.getSimpleName(), clazz.getSimpleName(), name);
                return null;
            }
        }
        return type;
    }

    public static PropertyType isValidSetter2(Class<?> clazz, VariableElement element, String name, String setter) {
        return AnnotationsUtils.isValidSetter2(clazz, element, name, setter, false);
    }

    public static PropertyType isValidSetter2(Class<?> clazz, VariableElement element, String name, String setter, boolean isServiceConfiguration) {
        PropertyType type = PropertyType.OTHER;
        Element typeElement = element.getEnclosingElement();
        Element am = null;
        for (Element element2 : typeElement.getEnclosedElements()) {
            if (!element2.getSimpleName().toString().equals(setter)) continue;
            am = element2;
            break;
        }
        if (am == null) {
            AnnotationsUtils.error(element, "Accessor [%s()] was not found for %s [%s] on [%s]", setter, clazz == null ? "property" : clazz.getSimpleName(), name, typeElement.getSimpleName());
            return null;
        }
        if (!am.getKind().equals((Object)ElementKind.METHOD)) {
            AnnotationsUtils.error(element, "Accessor [%s()] must be a public method on [%s] in order to set [%s]", setter, typeElement.getSimpleName(), name);
            return null;
        }
        if (!am.getModifiers().contains((Object)Modifier.PUBLIC)) {
            AnnotationsUtils.error(element, "Accessor [%s()] must be public on [%s] in order to set [%s]", setter, typeElement.getSimpleName(), name);
            return null;
        }
        if (am.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            AnnotationsUtils.error(element, "Accessor [%s()] on [%s] must be a non-abstract method in order to set [%s]", setter, typeElement.getSimpleName(), name);
            return null;
        }
        ExecutableElement method = (ExecutableElement)am;
        if (clazz == null) {
            if (method.getParameters().size() != 1) {
                AnnotationsUtils.error(element, "Accessor [%s()] on [%s] must accept only one parameter of type either String or Boolean in order to set [%s]", setter, typeElement.getSimpleName(), name);
                return null;
            }
            VariableElement variableElement = method.getParameters().get(0);
            type = AnnotationsUtils.isValidPropertyVariable(variableElement, isServiceConfiguration);
            if (type == null) {
                AnnotationsUtils.error(element, "Accessor [%s()] on [%s] must accept only one parameter of type either String or Boolean in order to set [%s]", setter, typeElement.getSimpleName(), name);
                return null;
            }
        } else {
            if (method.getParameters().size() != 1) {
                AnnotationsUtils.error(element, "Accessor [%s()] on [%s] must accept only one parameter of type %s in order to set [%s]", setter, typeElement.getSimpleName(), clazz.getSimpleName(), name);
                return null;
            }
            VariableElement variableElement = method.getParameters().get(0);
            boolean valid = AnnotationsUtils.isValidVariable(clazz, variableElement);
            if (!valid) {
                AnnotationsUtils.error(element, "Accessor [%s()] on [%s] must accept only one parameter of type %s in order to set [%s]", setter, typeElement.getSimpleName(), clazz.getSimpleName(), name);
                return null;
            }
        }
        return type;
    }

    public static boolean isValidVariable(Class<?> clazz, VariableElement parameter) {
        return parameter.asType().getKind().equals((Object)TypeKind.DECLARED) && parameter.asType().toString().equals(clazz.getCanonicalName());
    }

    private static PropertyType isValidPropertyVariable(VariableElement parameter) {
        return AnnotationsUtils.isValidPropertyVariable(parameter, false);
    }

    private static PropertyType isValidPropertyVariable(VariableElement parameter, boolean isServiceConfiguration) {
        PropertyType type = null;
        TypeKind kind = parameter.asType().getKind();
        if (kind.isPrimitive()) {
            if (kind.equals((Object)TypeKind.BOOLEAN)) {
                type = PropertyType.BOOLEAN;
            }
        } else if (kind.equals((Object)TypeKind.DECLARED)) {
            if (parameter.asType().toString().equals(Boolean.class.getCanonicalName())) {
                type = PropertyType.BOOLEAN;
            } else if (parameter.asType().toString().equals(String.class.getCanonicalName())) {
                type = PropertyType.STRING;
            } else if (parameter.asType().toString().equals(Json.class.getCanonicalName())) {
                type = isServiceConfiguration ? PropertyType.CONFIG : PropertyType.JSON;
            }
        }
        return type;
    }
}

