/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.Events;
import io.slingr.services.services.datastores.DataStore;
import io.slingr.services.utils.Json;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Users {
    private static final Logger logger = LoggerFactory.getLogger(Users.class);
    protected final DataStore users;
    protected final Events events;
    protected final boolean debug;

    public Users(DataStore users, Events events, boolean debug) {
        this.users = users;
        this.events = events;
        this.debug = debug;
    }

    public DataStore getUserDataStore() {
        return this.users;
    }

    public Json save(String userId, Json newConfiguration) {
        return this.save(userId, newConfiguration, true);
    }

    public Json save(String userId, Json newConfiguration, boolean mergeConfiguration) {
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            if (this.debug) {
                logger.info(String.format("%s save user configuration [%s]", "DEBUG>", userId));
            }
            if (this.users == null) {
                logger.warn("User data store is not ready to be used yet");
            } else {
                try {
                    Json user;
                    Json json = user = mergeConfiguration ? this.findById(userId) : null;
                    if (user == null) {
                        user = Json.map();
                    }
                    if (newConfiguration != null) {
                        user.merge(newConfiguration);
                    }
                    user.set("_id", userId);
                    this.users.save(user);
                    if (this.debug) {
                        logger.info(String.format("%s user configuration [%s] was saved [%s]", "DEBUG>", userId, user));
                    }
                    return user;
                }
                catch (Exception ex) {
                    logger.warn(String.format("Error when try to save user configuration [%s] [%s]", userId, ex.getMessage()), (Throwable)ex);
                }
            }
        } else {
            logger.warn(String.format("User id is empty [%s]", userId));
        }
        return null;
    }

    public void removeById(String userId) {
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            if (this.debug) {
                logger.info(String.format("%s remove user configuration [%s]", "DEBUG>", userId));
            }
            if (this.users == null) {
                logger.warn("User data store is not ready to be used yet");
            } else {
                try {
                    this.users.removeById(userId);
                    if (this.debug) {
                        logger.info(String.format("%s user configuration [%s] was deleted", "DEBUG>", userId));
                    }
                }
                catch (Exception ex) {
                    logger.warn(String.format("Error when try to delete user configuration [%s] [%s]", userId, ex.getMessage()), (Throwable)ex);
                }
            }
        }
    }

    public Json findById(String userId) {
        Json response = null;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            if (this.debug) {
                logger.info(String.format("%s checking user configuration [%s]", "DEBUG>", userId));
            }
            if (this.users == null) {
                logger.warn("User data store is not ready to be used yet");
            } else {
                block8: {
                    try {
                        response = this.users.findById(userId);
                    }
                    catch (Exception ex) {
                        if (!this.debug) break block8;
                        logger.info(String.format("%s Error when try to find user configuration [%s] [%s]", "DEBUG>", userId, ex.getMessage()));
                    }
                }
                if (response != null && !response.isEmpty()) {
                    logger.info(String.format("User configuration [%s] was found", userId));
                } else {
                    logger.info(String.format("User configuration [%s] was not found", userId));
                }
            }
        }
        return response;
    }

    public Json checkUserConnection(String userId, Json newConfiguration) throws ServiceException {
        Json userConf = null;
        String error = null;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            Json conf = this.findById(userId);
            if (conf != null && !conf.isEmpty()) {
                userConf = conf;
            } else {
                error = String.format("User [%s] is not connected", userId);
            }
        } else {
            error = String.format("Invalid user id [%s]", userId);
        }
        if (userConf == null) {
            throw ServiceException.permanent(ErrorCode.CLIENT, error != null ? error : "User validation error").returnCode(404);
        }
        Json data = Objects.requireNonNullElseGet(newConfiguration, Json::map);
        userConf.forEachMap(data::set);
        return data;
    }

    public void sendUserConnectedEvent(String userId, Json userConfiguration) {
        this.sendUserConnectedEvent(null, userId, userConfiguration);
    }

    public void sendUserConnectedEvent(String functionId, String userId, Json userConfiguration) {
        this.events.send("userConnected", userConfiguration, functionId, userId);
    }

    public void sendUserDisconnectedEvent(String userId) {
        this.sendUserDisconnectedEvent(null, userId);
    }

    public void sendUserDisconnectedEvent(String functionId, String userId) {
        this.events.send(null, "userDisconnected", null, functionId, userId, null);
    }

    public Json connect(String userId, Json userConfiguration) throws ServiceException {
        return this.connect(userId, userConfiguration, null);
    }

    public Json connect(String userId, Json userConfiguration, String functionId) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "User ID is required").returnCode(400);
        }
        Json savedConfiguration = this.save(userId, userConfiguration);
        if (savedConfiguration == null) {
            throw ServiceException.permanent(ErrorCode.CLIENT, "Error when try to connect to Extension Broker app");
        }
        logger.info(String.format("User connected [%s] [%s]", userId, savedConfiguration));
        this.sendUserConnectedEvent(functionId, userId, savedConfiguration);
        return savedConfiguration;
    }

    public void disconnect(String userId) throws ServiceException {
        this.disconnect(userId, null);
    }

    public void disconnect(String userId, String functionId) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "User ID is required").returnCode(400);
        }
        this.removeById(userId);
        this.sendUserDisconnectedEvent(functionId, userId);
    }
}

