/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest.authentication.strategy;

import io.slingr.services.services.rest.HttpRequest;
import io.slingr.services.services.rest.authentication.strategy.AuthenticationStrategy;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.codec.binary.Base64;

public class OAuthTwitterAuthenticationStrategy
implements AuthenticationStrategy {
    private final String oauth_token;
    private final String oauth_token_secret;
    private final String apiKey;
    private final String apiSecret;

    public OAuthTwitterAuthenticationStrategy(Map<String, String> params) {
        this.oauth_token = params.get("oauth_token");
        this.oauth_token_secret = params.get("oauth_token_secret");
        this.apiKey = params.get("apiKey");
        this.apiSecret = params.get("apiSecret");
    }

    @Override
    public void addAuthentication(Client client, WebTarget apiTarget, HttpRequest request) {
        client.register(requestContext -> {
            HashMap<String, String> otherHeaders = new HashMap<String, String>();
            otherHeaders.put("oauth_token", this.encode(this.oauth_token));
            requestContext.getHeaders().add((Object)"Authorization", (Object)this.getOauthHeader(requestContext.getMethod(), this.getTargetUrl(requestContext), otherHeaders, this.apiKey, this.apiSecret.concat("&").concat(this.encode(this.oauth_token_secret))));
        });
    }

    private String getOauthHeader(String method, String url, Map<String, String> headers, String apiKey, String secretKey) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("oauth_consumer_key", apiKey);
        headers.put("oauth_signature_method", "HMAC-SHA1");
        headers.put("oauth_nonce", Strings.randomUUIDString().replaceAll("-", ""));
        headers.put("oauth_timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        headers.put("oauth_version", "1.0");
        HashMap<String, String> otherParams = new HashMap<String, String>();
        String cleanUrl = url;
        if (url.contains("?")) {
            String[] params;
            int i = url.indexOf("?");
            cleanUrl = url.substring(0, i);
            for (String param : params = url.substring(i + 1).split("&")) {
                String[] p = param.split("=");
                if (p.length != 2) continue;
                otherParams.put(p[0], p[1]);
            }
        }
        HashMap<String, String> complete = new HashMap<String, String>(headers);
        if (!otherParams.isEmpty()) {
            complete.putAll(otherParams);
        }
        ArrayList keys = new ArrayList(complete.keySet());
        Collections.sort(keys);
        String parameterString = "";
        String prefix = "";
        for (String key : keys) {
            parameterString = parameterString.concat(prefix).concat(key).concat("=").concat((String)complete.get(key));
            prefix = "&";
        }
        String baseString = method + "&" + this.encode(cleanUrl) + "&" + this.encode(parameterString);
        String signature = OAuthTwitterAuthenticationStrategy.computeSignature(baseString, secretKey);
        Object authHeader = "OAuth ";
        prefix = "";
        for (String key : headers.keySet()) {
            authHeader = ((String)authHeader).concat(prefix).concat(key).concat("=\"").concat(headers.get(key)).concat("\"");
            prefix = ",";
        }
        authHeader = (String)authHeader + ",oauth_signature=\"" + this.encode(signature) + "\"";
        return authHeader;
    }

    private String encode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8).replace("*", "%2A").replace("+", "%20").replace("%7E", "~");
    }

    private static String computeSignature(String baseString, String keyString) {
        byte[] keyBytes = keyString.getBytes();
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "HmacSHA1");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
        if (mac != null) {
            byte[] text = baseString.getBytes();
            return new String(Base64.encodeBase64((byte[])mac.doFinal(text))).trim();
        }
        return null;
    }

    private String getTargetUrl(ClientRequestContext requestContext) {
        StringBuilder url = new StringBuilder(requestContext.getUri().toString());
        Object entity = requestContext.getEntity();
        if (entity instanceof Json) {
            Json json = (Json)entity;
            if (!json.isEmpty("url")) {
                url.append(json.string("url"));
            }
            if (!json.isEmpty("params")) {
                Map<String, Object> params = json.json("params").toMap();
                String prefix = url.toString().contains("?") ? "&" : "?";
                for (String key : params.keySet()) {
                    url.append(prefix).append(key).append("=").append(this.encode(params.get(key).toString()));
                    prefix = "&";
                }
            }
        }
        return url.toString();
    }
}

