/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.application;

import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AppUser
implements JsonSource {
    private final String id;
    private final String version;
    private final String email;
    private final String firstName;
    private final String lastName;
    private final String fullName;
    private final String status;
    private final boolean active;
    private final boolean developer;
    private final List<Json> groups;
    private final Json localization;
    private final Json permissions;

    public AppUser(String id, String version, String email, String firstName, String lastName, String fullName, String status, boolean developer, List<Json> groups, Json localization, Json permissions) {
        this.id = id;
        this.version = version;
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.fullName = fullName;
        this.status = status;
        this.active = StringUtils.isNotBlank((String)status) && status.equalsIgnoreCase("ACTIVE");
        this.developer = developer;
        this.groups = groups != null ? groups : new ArrayList();
        this.localization = localization != null && localization.isMap() ? localization : Json.map();
        this.permissions = permissions != null && permissions.isMap() ? permissions : Json.map();
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isDeveloper() {
        return this.developer;
    }

    public List<Json> getGroups() {
        return this.groups;
    }

    public Json getLocalization() {
        return this.localization;
    }

    public Json getPermissions() {
        return this.permissions;
    }

    @Override
    public Json toJson() {
        ArrayList<Json> gps = new ArrayList<Json>();
        for (Json group : this.groups) {
            gps.add(group.cloneJson());
        }
        return Json.map().setIfNotEmpty("id", this.id).setIfNotEmpty("version", this.version).setIfNotEmpty("email", this.email).setIfNotEmpty("firstName", this.firstName).setIfNotEmpty("lastName", this.lastName).setIfNotEmpty("fullName", this.fullName).setIfNotEmpty("status", this.status).set("developer", this.developer).setIfNotEmpty("groups", gps).setIfNotEmpty("localization", this.localization.cloneJson()).setIfNotEmpty("permissions", this.permissions.cloneJson());
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static AppUser fromJson(Json json) {
        if (json == null) {
            return null;
        }
        return new AppUser(json.string("id"), json.string("version"), json.string("email"), json.string("firstName"), json.string("lastName"), json.string("fullName"), json.string("status"), json.bool("developer", false), json.jsons("groups"), json.json("localization"), json.json("permissions"));
    }
}

