/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest;

import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HttpRequest
implements JsonSource {
    private RestMethod restMethod;
    private String path = null;
    private final Json params = Json.map();
    private final Json headers = Json.map();
    private final Json settings = Json.map();
    private final Json authorization = Json.map();
    private Object body = null;
    private int connectionTimeout = 5000;
    private int readTimeout = 60000;
    private boolean followRedirects = true;
    private boolean fullResponse = false;
    private String filename = "file";
    private boolean forceDownload = false;
    private boolean downloadSync = false;
    private boolean forceDisableCookies = false;
    private int maxRedirects = 10;
    private Boolean encodeUrl = null;
    private boolean followAuthorizationHeader = false;
    private boolean removeRefererHeaderOnRedirect = false;
    private boolean followOriginalHttpMethod = false;
    private boolean useSSL = true;
    private boolean multipart;
    private List<Part> parts = new ArrayList<Part>();

    public HttpRequest(HttpRequestBuilder builder) {
        this.restMethod = builder.restMethod;
        this.path = builder.path;
        this.body = builder.body;
        this.connectionTimeout = builder.connectionTimeout;
        this.readTimeout = builder.readTimeout;
        this.followRedirects = builder.followRedirects;
        this.fullResponse = builder.fullResponse;
        this.filename = builder.filename;
        this.forceDownload = builder.forceDownload;
        this.downloadSync = builder.downloadSync;
        this.forceDisableCookies = builder.forceDisableCookies;
        this.removeRefererHeaderOnRedirect = builder.removeRefererHeaderOnRedirect;
        this.maxRedirects = builder.maxRedirects;
        this.encodeUrl = builder.encodeUrl;
        this.followAuthorizationHeader = builder.followAuthorizationHeader;
        this.followOriginalHttpMethod = builder.followOriginalHttpMethod;
        this.useSSL = builder.useSSL;
    }

    public Json getJsonBody() {
        Object bd = this.getBody();
        if (bd == null) {
            return Json.map();
        }
        if (bd instanceof Json) {
            return (Json)bd;
        }
        return Json.fromObject(bd);
    }

    public HttpRequest() {
    }

    public HttpRequest(RestMethod restMethod, String path) {
        this.restMethod = restMethod;
        this.path = path;
    }

    public HttpRequest(RestMethod restMethod, String path, Object body) {
        this.restMethod = restMethod;
        this.path = path;
        this.body = body;
    }

    public RestMethod getRestMethod() {
        return this.restMethod;
    }

    public void setRestMethod(RestMethod restMethod) {
        this.restMethod = restMethod;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Json getParams() {
        return this.params;
    }

    public Json getHeaders() {
        return this.headers;
    }

    public Json getAuthorization() {
        return this.authorization;
    }

    public Json getSettings() {
        return this.settings;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout >= 0 ? connectionTimeout : 5000;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects >= 0 ? maxRedirects : 10;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout >= 0 ? readTimeout : 60000;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isFullResponse() {
        return this.fullResponse;
    }

    public void setFullResponse(boolean fullResponse) {
        this.fullResponse = fullResponse;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = StringUtils.isNotBlank((CharSequence)filename) ? filename : "file";
    }

    public boolean isForceDownload() {
        return this.forceDownload;
    }

    public void setForceDownload(boolean forceDownload) {
        this.forceDownload = forceDownload;
    }

    public Boolean isEncodeUrl() {
        return this.encodeUrl;
    }

    public void setEncodeUrl(Boolean encodeUrl) {
        this.encodeUrl = encodeUrl;
    }

    public boolean isDownloadSync() {
        return this.downloadSync;
    }

    public void setDownloadSync(boolean downloadSync) {
        this.downloadSync = downloadSync;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public boolean isForceDisableCookies() {
        return this.forceDisableCookies;
    }

    public void setForceDisableCookies(boolean forceDisableCookies) {
        this.forceDisableCookies = forceDisableCookies;
    }

    public boolean isRemoveRefererHeaderOnRedirect() {
        return this.removeRefererHeaderOnRedirect;
    }

    public void setRemoveRefererHeaderOnRedirect(boolean removeRefererHeaderOnRedirect) {
        this.removeRefererHeaderOnRedirect = removeRefererHeaderOnRedirect;
    }

    public boolean isFollowOriginalHttpMethod() {
        return this.followOriginalHttpMethod;
    }

    public void setFollowOriginalHttpMethod(boolean followOriginalHttpMethod) {
        this.followOriginalHttpMethod = followOriginalHttpMethod;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public void setParts(List<Part> parts) {
        this.parts = parts;
    }

    public boolean isFollowAuthorizationHeader() {
        return this.followAuthorizationHeader;
    }

    public void setFollowAuthorizationHeader(boolean followAuthorizationHeader) {
        this.followAuthorizationHeader = followAuthorizationHeader;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    @Override
    public Json toJson() {
        Json json = Json.map().setIfNotEmpty("url", this.getPath()).setIfNotEmpty("params", this.getParams()).setIfNotEmpty("headers", this.getHeaders()).setIfNotEmpty("authorization", this.getAuthorization()).setIfNotNull("body", this.getBody()).setIf(this.getConnectionTimeout() != 5000, "connectionTimeout", this.getConnectionTimeout()).setIf(this.getReadTimeout() != 60000, "readTimeout", this.getReadTimeout()).setIf(this.getMaxRedirects() != 10, "maxRedirects", this.getMaxRedirects()).setIf(!this.isFollowRedirects(), "followRedirects", this.isFollowRedirects()).setIf(this.isFullResponse(), "fullResponse", this.isFullResponse()).setIf(this.isForceDownload(), "forceDownload", this.isForceDownload()).setIf(this.isDownloadSync(), "downloadSync", this.isDownloadSync()).setIf(this.isForceDisableCookies(), "forceDisableCookies", this.isForceDisableCookies()).setIf(this.isEncodeUrl(), "encodeUrl", this.isEncodeUrl()).setIf(this.isFollowAuthorizationHeader(), "followAuthorizationHeader", this.isFollowAuthorizationHeader()).setIf(this.isRemoveRefererHeaderOnRedirect(), "removeRefererHeaderOnRedirect", this.isRemoveRefererHeaderOnRedirect()).setIf(this.isFollowOriginalHttpMethod(), "followOriginalHttpMethod", this.isFollowOriginalHttpMethod()).setIf(this.isUseSSL(), "useSSL", this.isUseSSL()).setIf(this.isMultipart(), "multipart", this.isMultipart());
        if (!"file".equals(this.getFilename()) && StringUtils.isNotBlank((CharSequence)this.getFilename())) {
            json.set("fileName", this.getFilename());
        }
        if (this.isMultipart()) {
            json.set("parts", Json.list(this.getParts(), Part::toJson));
        }
        return json;
    }

    public static HttpRequest fromJson(RestMethod restMethod, Json json) {
        HttpRequest request = new HttpRequest();
        request.restMethod = restMethod;
        if (json != null) {
            Json settings;
            Object body;
            Json authorization;
            Json headers;
            Json params;
            String path = json.string("url");
            if (StringUtils.isNotBlank((CharSequence)path)) {
                request.setPath(path);
            }
            if ((params = json.json("params")) != null && params.isMap()) {
                params.forEachMap((k, o) -> request.getParams().set((String)k, o));
            }
            if ((headers = json.json("headers")) != null && headers.isMap()) {
                headers.forEachMap((k, o) -> request.getHeaders().set((String)k, o));
            }
            if ((authorization = json.json("authorization")) != null && authorization.isMap()) {
                authorization.forEachMap((k, o) -> request.getAuthorization().set((String)k, o));
            }
            if ((body = json.object("body")) != null) {
                request.setBody(body);
            }
            if ((settings = json.json("settings")) != null) {
                Boolean multipart;
                String filename;
                Boolean useSSL;
                Boolean followOriginalHttpMethod;
                Boolean followAuthorizationHeader;
                Boolean removeRefererHeaderOnRedirect;
                Boolean forceDisableCookies;
                Boolean encodeUrl;
                Boolean downloadSync;
                Boolean forceDownload;
                Boolean fullResponse;
                Integer maxRedirects;
                Boolean followRedirects;
                Integer readTimeout;
                Integer connectionTimeout = settings.integer("connectionTimeout");
                if (connectionTimeout != null) {
                    request.setConnectionTimeout(connectionTimeout);
                }
                if ((readTimeout = settings.integer("readTimeout")) != null) {
                    request.setReadTimeout(readTimeout);
                }
                if ((followRedirects = settings.bool("followRedirects")) != null) {
                    request.setFollowRedirects(followRedirects);
                }
                if ((maxRedirects = settings.integer("maxRedirects")) != null) {
                    request.setMaxRedirects(maxRedirects);
                }
                if ((fullResponse = settings.bool("fullResponse")) != null) {
                    request.setFullResponse(fullResponse);
                }
                if ((forceDownload = settings.bool("forceDownload")) != null) {
                    request.setForceDownload(forceDownload);
                }
                if ((downloadSync = settings.bool("downloadSync")) != null) {
                    request.setDownloadSync(downloadSync);
                }
                if ((encodeUrl = settings.bool("encodeUrl")) != null) {
                    request.setEncodeUrl(encodeUrl);
                }
                if ((forceDisableCookies = settings.bool("forceDisableCookies")) != null) {
                    request.setForceDisableCookies(forceDisableCookies);
                }
                if ((removeRefererHeaderOnRedirect = settings.bool("removeRefererHeaderOnRedirect")) != null) {
                    request.setRemoveRefererHeaderOnRedirect(removeRefererHeaderOnRedirect);
                }
                if ((followAuthorizationHeader = settings.bool("followAuthorizationHeader")) != null) {
                    request.setFollowAuthorizationHeader(followAuthorizationHeader);
                }
                if ((followOriginalHttpMethod = settings.bool("followOriginalHttpMethod")) != null) {
                    request.setFollowOriginalHttpMethod(followOriginalHttpMethod);
                }
                if ((useSSL = settings.bool("useSSL")) != null) {
                    request.setUseSSL(useSSL);
                }
                if ((filename = settings.string("fileName")) != null) {
                    request.setFilename(filename);
                }
                if ((multipart = settings.bool("multipart")) != null && multipart.booleanValue()) {
                    request.setMultipart(true);
                    for (Json partJson : settings.jsons("parts")) {
                        Part part = new Part();
                        part.fromJson(partJson);
                        request.getParts().add(part);
                    }
                } else {
                    request.setMultipart(false);
                }
            }
        }
        return request;
    }

    public static class HttpRequestBuilder {
        private RestMethod restMethod;
        private final String path;
        private Json params = Json.map();
        private Json headers = Json.map();
        private Json authorization = Json.map();
        private Object body = null;
        private int connectionTimeout = 5000;
        private int readTimeout = 60000;
        private boolean followRedirects = true;
        private boolean fullResponse = false;
        private String filename = "file";
        private boolean forceDownload = false;
        private boolean downloadSync = false;
        private boolean forceDisableCookies = false;
        private boolean removeRefererHeaderOnRedirect = false;
        private boolean followOriginalHttpMethod = false;
        private int maxRedirects = 10;
        private Boolean encodeUrl = null;
        private boolean followAuthorizationHeader = false;
        private boolean useSSL = true;

        public HttpRequestBuilder() {
            this.path = null;
        }

        public HttpRequest build() {
            return new HttpRequest(this);
        }

        public HttpRequestBuilder setRestMethod(RestMethod restMethod) {
            this.restMethod = restMethod;
            return this;
        }

        public HttpRequestBuilder setParams(Json params) {
            this.params = params;
            return this;
        }

        public HttpRequestBuilder setHeaders(Json headers) {
            this.headers = headers;
            return this;
        }

        public HttpRequestBuilder setAuthorization(Json authorization) {
            this.authorization = authorization;
            return this;
        }

        public HttpRequestBuilder setBody(Object body) {
            this.body = body;
            return this;
        }

        public HttpRequestBuilder setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public HttpRequestBuilder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public HttpRequestBuilder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public HttpRequestBuilder setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public HttpRequestBuilder setFullResponse(boolean fullResponse) {
            this.fullResponse = fullResponse;
            return this;
        }

        public HttpRequestBuilder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public HttpRequestBuilder setForceDownload(boolean forceDownload) {
            this.forceDownload = forceDownload;
            return this;
        }

        public HttpRequestBuilder setDownloadSync(boolean downloadSync) {
            this.downloadSync = downloadSync;
            return this;
        }

        public HttpRequestBuilder setForceDisableCookies(boolean forceDisableCookies) {
            this.forceDisableCookies = forceDisableCookies;
            return this;
        }

        public HttpRequestBuilder setEncodeUrl(boolean encodeUrl) {
            this.encodeUrl = encodeUrl;
            return this;
        }

        public HttpRequestBuilder setFollowAuthorizationHeader(boolean followAuthorizationHeader) {
            this.followAuthorizationHeader = followAuthorizationHeader;
            return this;
        }

        public HttpRequestBuilder setRemoveRefererHeaderOnRedirect(boolean removeRefererHeaderOnRedirect) {
            this.removeRefererHeaderOnRedirect = removeRefererHeaderOnRedirect;
            return this;
        }

        public HttpRequestBuilder setUseSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public HttpRequestBuilder setFollowOriginalHttpMethod(boolean followOriginalHttpMethod) {
            this.followOriginalHttpMethod = followOriginalHttpMethod;
            return this;
        }
    }

    public static class Part {
        private String name;
        private PartType type;
        private String fileId;
        private String contentType;
        private Object content;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public PartType getType() {
            return this.type;
        }

        public void setType(PartType type) {
            this.type = type;
        }

        public String getFileId() {
            return this.fileId;
        }

        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public Object getContent() {
            return this.content;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public void fromJson(Json json) {
            this.name = json.string("name");
            this.type = PartType.fromJsonValue(json.string("type"));
            if (this.type == PartType.FILE) {
                this.fileId = json.string("fileId");
            } else {
                this.contentType = json.string("contentType");
                this.content = json.object("content");
            }
        }

        public Object toJson() {
            Json json = Json.map();
            json.set("name", this.name);
            json.set("type", this.type.getJsonValue());
            if (this.type == PartType.FILE) {
                json.set("fileId", this.fileId);
            } else {
                json.setIfNotEmpty("contentType", json.string("contentType"));
                json.setIfNotEmpty("content", json.string("content"));
            }
            return json;
        }
    }

    public static enum PartType {
        FILE("file"),
        OTHER("other");

        private final String jsonValue;

        private PartType(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        public String getJsonValue() {
            return this.jsonValue;
        }

        public static PartType fromString(String string) {
            try {
                return PartType.valueOf(string);
            }
            catch (Exception e) {
                return null;
            }
        }

        public static PartType fromJsonValue(String string) {
            for (PartType type : PartType.values()) {
                if (!type.getJsonValue().equals(string)) continue;
                return type;
            }
            return null;
        }
    }
}

