/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest.authentication;

import io.slingr.services.services.rest.authentication.AuthenticationType;
import io.slingr.services.services.rest.authentication.strategy.AuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.AwsAuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.BasicAuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.DigestAuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.OAuth2AuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.OAuthAuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.OAuthTwitterAuthenticationStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFactory {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationFactory.class);

    public static AuthenticationStrategy createAuthenticationStrategy(AuthenticationType type, Map<String, String> params) {
        logger.info(String.format("Authenticating with %s", type.name()));
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case AuthenticationType.BASIC -> new BasicAuthenticationStrategy(params);
            case AuthenticationType.OAUTH_TWITTER -> new OAuthTwitterAuthenticationStrategy(params);
            case AuthenticationType.OAUTH2 -> new OAuth2AuthenticationStrategy(params);
            case AuthenticationType.OAUTH -> new OAuthAuthenticationStrategy(params);
            case AuthenticationType.DIGEST -> new DigestAuthenticationStrategy(params);
            case AuthenticationType.AWS_SIGNATURE -> new AwsAuthenticationStrategy(params);
        };
    }
}

