/*
 * Decompiled with CFR 0.152.
 */
package grafter_2.rdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;

public class SPARQLSession
extends SPARQLProtocolSession {
    private static final String INCLUDE_INFERRED_PARAM_NAME = "infer";
    private static final String STARDOG_INFERRED_PARAM_NAME = "reasoning";
    private static final String TIMEOUT_QUERY_PARAM_NAME = "timeout";

    public SPARQLSession(String string, String string2, HttpClient httpClient, ExecutorService executorService) {
        super(httpClient, executorService);
        this.setQueryURL(string);
        this.setUpdateURL(string2);
    }

    private HttpParams getHttpParams() {
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        basicHttpParams.setBooleanParameter("http.protocol.handle-redirects", true);
        basicHttpParams.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        int n = (int)this.getConnectionTimeout();
        basicHttpParams.setIntParameter("http.socket.timeout", n);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)100);
        basicHttpParams.setLongParameter("http.conn-manager.timeout", 1L);
        return basicHttpParams;
    }

    private boolean isStardogTimeoutResponse(HttpResponse httpResponse) {
        int n = httpResponse.getStatusLine().getStatusCode();
        Header header = httpResponse.getFirstHeader("SD-Error-Code");
        if (n == 500 && header != null && "QueryEval".equals(header.getValue())) {
            HttpEntity httpEntity = httpResponse.getEntity();
            try {
                String string = EntityUtils.toString((HttpEntity)httpEntity);
                return string != null && string.contains("exceeded query timeout");
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return false;
    }

    private static void removeTimeoutQueryParams(List<NameValuePair> list) {
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        for (NameValuePair nameValuePair : list) {
            if (!TIMEOUT_QUERY_PARAM_NAME.equals(nameValuePair.getName())) continue;
            arrayList.add(nameValuePair);
        }
        list.removeAll(arrayList);
    }

    protected List<NameValuePair> getQueryMethodParameters(QueryLanguage queryLanguage, String string, String string2, Dataset dataset, boolean bl, int n, Binding ... bindingArray) {
        List list = super.getQueryMethodParameters(queryLanguage, string, string2, dataset, bl, n, bindingArray);
        if (bl) {
            list.add(new BasicNameValuePair(INCLUDE_INFERRED_PARAM_NAME, "true"));
            list.add(new BasicNameValuePair(STARDOG_INFERRED_PARAM_NAME, "true"));
        }
        SPARQLSession.removeTimeoutQueryParams(list);
        if (n > 0) {
            Integer n2 = 1000 * n;
            list.add(new BasicNameValuePair(TIMEOUT_QUERY_PARAM_NAME, n2.toString()));
        }
        return list;
    }

    protected HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException, RDF4JException {
        HttpResponse httpResponse;
        HttpClient httpClient = this.getHttpClient();
        HttpContext httpContext = this.getHttpContext();
        boolean bl = true;
        HttpParams httpParams = this.getHttpParams();
        httpUriRequest.setParams(httpParams);
        try {
            httpResponse = httpClient.execute(httpUriRequest, httpContext);
        }
        catch (ConnectionPoolTimeoutException connectionPoolTimeoutException) {
            throw new QueryInterruptedException("Error executing query against remote endpoint.", (Throwable)connectionPoolTimeoutException);
        }
        try {
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n >= 200 && n < 300 || n == 404) {
                bl = false;
                HttpResponse httpResponse2 = httpResponse;
                return httpResponse2;
            }
            if (this.isStardogTimeoutResponse(httpResponse)) {
                throw new QueryInterruptedException();
            }
            switch (n) {
                case 401: {
                    throw new UnauthorizedException();
                }
                case 503: {
                    throw new QueryInterruptedException();
                }
            }
            ErrorInfo errorInfo = this.getErrorInfo(httpResponse);
            if (errorInfo.getErrorType() == ErrorType.MALFORMED_DATA) {
                throw new RDFParseException(errorInfo.getErrorMessage());
            }
            if (errorInfo.getErrorType() == ErrorType.UNSUPPORTED_FILE_FORMAT) {
                throw new UnsupportedRDFormatException(errorInfo.getErrorMessage());
            }
            if (errorInfo.getErrorType() == ErrorType.MALFORMED_QUERY) {
                throw new MalformedQueryException(errorInfo.getErrorMessage());
            }
            if (errorInfo.getErrorType() == ErrorType.UNSUPPORTED_QUERY_LANGUAGE) {
                throw new UnsupportedQueryLanguageException(errorInfo.getErrorMessage());
            }
            if (errorInfo != null) {
                throw new RepositoryException(errorInfo.toString());
            }
            throw new RepositoryException("No Error Info Present, server may not have responded properly");
        }
        finally {
            if (bl) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
    }
}

