(ns happyapi.google.compute-v1
  "Compute Engine API
Creates and runs virtual machines on Google Cloud Platform. 
See: https://cloud.google.com/products/compute")

(defn externalVpnGateways-insert
  "Creates a ExternalVpnGateway in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/externalVpnGateways/insert

project <> 
ExternalVpnGateway:
ExternalVpnGateway

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project ExternalVpnGateway]
    (externalVpnGateways-insert project ExternalVpnGateway nil))
  ([project ExternalVpnGateway optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/externalVpnGateways",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ExternalVpnGateway}))

(defn externalVpnGateways-list
  "Retrieves the list of ExternalVpnGateway available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/externalVpnGateways/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (externalVpnGateways-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/externalVpnGateways",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn externalVpnGateways-get
  "Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making a list() request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/externalVpnGateways/get

project <> 
externalVpnGateway <> "
  [project externalVpnGateway]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/externalVpnGateways/{externalVpnGateway}",
   :uri-template-args
   {"externalVpnGateway" externalVpnGateway, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn externalVpnGateways-delete
  "Deletes the specified externalVpnGateway.
https://cloud.google.com/products/compute/v1/reference/rest/v1/externalVpnGateways/delete

project <> 
externalVpnGateway <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project externalVpnGateway]
    (externalVpnGateways-delete project externalVpnGateway nil))
  ([project externalVpnGateway optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/externalVpnGateways/{externalVpnGateway}",
     :uri-template-args
     {"externalVpnGateway" externalVpnGateway, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn externalVpnGateways-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/externalVpnGateways/testIamPermissions

project <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/externalVpnGateways/{resource}/testIamPermissions",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn externalVpnGateways-setLabels
  "Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/externalVpnGateways/setLabels

project <> 
resource <> 
GlobalSetLabelsRequest:
GlobalSetLabelsRequest"
  [project resource GlobalSetLabelsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/externalVpnGateways/{resource}/setLabels",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetLabelsRequest})

(defn regionZones-list
  "Retrieves the list of Zone resources under the specific region available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionZones/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionZones-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/zones",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionInstantSnapshots-list
  "Retrieves the list of InstantSnapshot resources contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstantSnapshots/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionInstantSnapshots-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instantSnapshots",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionInstantSnapshots-get
  "Returns the specified InstantSnapshot resource in the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstantSnapshots/get

project <> 
region <> 
instantSnapshot <> "
  [project region instantSnapshot]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instantSnapshots/{instantSnapshot}",
   :uri-template-args
   {"instantSnapshot" instantSnapshot,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionInstantSnapshots-insert
  "Creates an instant snapshot in the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstantSnapshots/insert

project <> 
region <> 
InstantSnapshot:
InstantSnapshot

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region InstantSnapshot]
    (regionInstantSnapshots-insert project region InstantSnapshot nil))
  ([project region InstantSnapshot optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instantSnapshots",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InstantSnapshot}))

(defn regionInstantSnapshots-setLabels
  "Sets the labels on a instantSnapshot in the given region. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstantSnapshots/setLabels

project <> 
region <> 
resource <> 
RegionSetLabelsRequest:
RegionSetLabelsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region resource RegionSetLabelsRequest]
    (regionInstantSnapshots-setLabels
      project
      region
      resource
      RegionSetLabelsRequest
      nil))
  ([project region resource RegionSetLabelsRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instantSnapshots/{resource}/setLabels",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionSetLabelsRequest}))

(defn regionInstantSnapshots-delete
  "Deletes the specified InstantSnapshot resource. Keep in mind that deleting a single instantSnapshot might not necessarily delete all the data on that instantSnapshot. If any data on the instantSnapshot that is marked for deletion is needed for subsequent instantSnapshots, the data will be moved to the next corresponding instantSnapshot. For more information, see Deleting instantSnapshots.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstantSnapshots/delete

project <> 
region <> 
instantSnapshot <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region instantSnapshot]
    (regionInstantSnapshots-delete project region instantSnapshot nil))
  ([project region instantSnapshot optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instantSnapshots/{instantSnapshot}",
     :uri-template-args
     {"instantSnapshot" instantSnapshot,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionInstantSnapshots-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstantSnapshots/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (regionInstantSnapshots-getIamPolicy project region resource nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instantSnapshots/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionInstantSnapshots-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstantSnapshots/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instantSnapshots/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn regionInstantSnapshots-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstantSnapshots/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instantSnapshots/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn httpsHealthChecks-list
  "Retrieves the list of HttpsHealthCheck resources available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/httpsHealthChecks/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (httpsHealthChecks-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/httpsHealthChecks",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn httpsHealthChecks-get
  "Returns the specified HttpsHealthCheck resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/httpsHealthChecks/get

project <> 
httpsHealthCheck <> "
  [project httpsHealthCheck]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}",
   :uri-template-args
   {"httpsHealthCheck" httpsHealthCheck, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn httpsHealthChecks-insert
  "Creates a HttpsHealthCheck resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/httpsHealthChecks/insert

project <> 
HttpsHealthCheck:
HttpsHealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project HttpsHealthCheck]
    (httpsHealthChecks-insert project HttpsHealthCheck nil))
  ([project HttpsHealthCheck optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/httpsHealthChecks",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HttpsHealthCheck}))

(defn httpsHealthChecks-delete
  "Deletes the specified HttpsHealthCheck resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/httpsHealthChecks/delete

project <> 
httpsHealthCheck <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project httpsHealthCheck]
    (httpsHealthChecks-delete project httpsHealthCheck nil))
  ([project httpsHealthCheck optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}",
     :uri-template-args
     {"httpsHealthCheck" httpsHealthCheck, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn httpsHealthChecks-update
  "Updates a HttpsHealthCheck resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/httpsHealthChecks/update

project <> 
httpsHealthCheck <> 
HttpsHealthCheck:
HttpsHealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project httpsHealthCheck HttpsHealthCheck]
    (httpsHealthChecks-update
      project
      httpsHealthCheck
      HttpsHealthCheck
      nil))
  ([project httpsHealthCheck HttpsHealthCheck optional]
    {:method :put,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}",
     :uri-template-args
     {"httpsHealthCheck" httpsHealthCheck, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HttpsHealthCheck}))

(defn httpsHealthChecks-patch
  "Updates a HttpsHealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/httpsHealthChecks/patch

project <> 
httpsHealthCheck <> 
HttpsHealthCheck:
HttpsHealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project httpsHealthCheck HttpsHealthCheck]
    (httpsHealthChecks-patch
      project
      httpsHealthCheck
      HttpsHealthCheck
      nil))
  ([project httpsHealthCheck HttpsHealthCheck optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/httpsHealthChecks/{httpsHealthCheck}",
     :uri-template-args
     {"httpsHealthCheck" httpsHealthCheck, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HttpsHealthCheck}))

(defn regionInstanceGroupManagers-patchPerInstanceConfigs
  "Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/patchPerInstanceConfigs

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagerPatchInstanceConfigReq:
RegionInstanceGroupManagerPatchInstanceConfigReq

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagerPatchInstanceConfigReq]
    (regionInstanceGroupManagers-patchPerInstanceConfigs
      project
      region
      instanceGroupManager
      RegionInstanceGroupManagerPatchInstanceConfigReq
      nil))
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagerPatchInstanceConfigReq
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/patchPerInstanceConfigs",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupManagerPatchInstanceConfigReq}))

(defn regionInstanceGroupManagers-list
  "Retrieves the list of managed instance groups that are contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region]
    (regionInstanceGroupManagers-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionInstanceGroupManagers-updatePerInstanceConfigs
  "Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/updatePerInstanceConfigs

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagerUpdateInstanceConfigReq:
RegionInstanceGroupManagerUpdateInstanceConfigReq

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagerUpdateInstanceConfigReq]
    (regionInstanceGroupManagers-updatePerInstanceConfigs
      project
      region
      instanceGroupManager
      RegionInstanceGroupManagerUpdateInstanceConfigReq
      nil))
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagerUpdateInstanceConfigReq
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/updatePerInstanceConfigs",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupManagerUpdateInstanceConfigReq}))

(defn regionInstanceGroupManagers-delete
  "Deletes the specified managed instance group and all of the instances in that group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/delete

project <> 
region <> 
instanceGroupManager <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region instanceGroupManager]
    (regionInstanceGroupManagers-delete
      project
      region
      instanceGroupManager
      nil))
  ([project region instanceGroupManager optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionInstanceGroupManagers-createInstances
  "Creates instances with per-instance configurations in this regional managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/createInstances

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagersCreateInstancesRequest:
RegionInstanceGroupManagersCreateInstancesRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersCreateInstancesRequest]
    (regionInstanceGroupManagers-createInstances
      project
      region
      instanceGroupManager
      RegionInstanceGroupManagersCreateInstancesRequest
      nil))
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersCreateInstancesRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/createInstances",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupManagersCreateInstancesRequest}))

(defn regionInstanceGroupManagers-applyUpdatesToInstances
  "Apply updates to selected instances the managed instance group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/applyUpdatesToInstances

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagersApplyUpdatesRequest:
RegionInstanceGroupManagersApplyUpdatesRequest"
  [project
   region
   instanceGroupManager
   RegionInstanceGroupManagersApplyUpdatesRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/applyUpdatesToInstances",
   :uri-template-args
   {"instanceGroupManager" instanceGroupManager,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionInstanceGroupManagersApplyUpdatesRequest})

(defn regionInstanceGroupManagers-setTargetPools
  "Modifies the target pools to which all new instances in this group are assigned. Existing instances in the group are not affected.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/setTargetPools

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagersSetTargetPoolsRequest:
RegionInstanceGroupManagersSetTargetPoolsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersSetTargetPoolsRequest]
    (regionInstanceGroupManagers-setTargetPools
      project
      region
      instanceGroupManager
      RegionInstanceGroupManagersSetTargetPoolsRequest
      nil))
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersSetTargetPoolsRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setTargetPools",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupManagersSetTargetPoolsRequest}))

(defn regionInstanceGroupManagers-setInstanceTemplate
  "Sets the instance template to use when creating new instances or recreating instances in this group. Existing instances are not affected.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/setInstanceTemplate

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagersSetTemplateRequest:
RegionInstanceGroupManagersSetTemplateRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersSetTemplateRequest]
    (regionInstanceGroupManagers-setInstanceTemplate
      project
      region
      instanceGroupManager
      RegionInstanceGroupManagersSetTemplateRequest
      nil))
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersSetTemplateRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/setInstanceTemplate",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupManagersSetTemplateRequest}))

(defn regionInstanceGroupManagers-recreateInstances
  "Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/recreateInstances

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagersRecreateRequest:
RegionInstanceGroupManagersRecreateRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersRecreateRequest]
    (regionInstanceGroupManagers-recreateInstances
      project
      region
      instanceGroupManager
      RegionInstanceGroupManagersRecreateRequest
      nil))
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersRecreateRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/recreateInstances",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupManagersRecreateRequest}))

(defn regionInstanceGroupManagers-patch
  "Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listmanagedinstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/patch

project <> 
region <> 
instanceGroupManager <> 
InstanceGroupManager:
InstanceGroupManager

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region instanceGroupManager InstanceGroupManager]
    (regionInstanceGroupManagers-patch
      project
      region
      instanceGroupManager
      InstanceGroupManager
      nil))
  ([project region instanceGroupManager InstanceGroupManager optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InstanceGroupManager}))

(defn regionInstanceGroupManagers-abandonInstances
  "Flags the specified instances to be immediately removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/abandonInstances

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagersAbandonInstancesRequest:
RegionInstanceGroupManagersAbandonInstancesRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersAbandonInstancesRequest]
    (regionInstanceGroupManagers-abandonInstances
      project
      region
      instanceGroupManager
      RegionInstanceGroupManagersAbandonInstancesRequest
      nil))
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersAbandonInstancesRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/abandonInstances",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupManagersAbandonInstancesRequest}))

(defn regionInstanceGroupManagers-listManagedInstances
  "Lists the instances in the managed instance group and instances that are scheduled to be created. The list includes any current actions that the group has scheduled for its instances. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/listManagedInstances

project <> 
region <> 
instanceGroupManager <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region instanceGroupManager]
    (regionInstanceGroupManagers-listManagedInstances
      project
      region
      instanceGroupManager
      nil))
  ([project region instanceGroupManager optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listManagedInstances",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionInstanceGroupManagers-deletePerInstanceConfigs
  "Deletes selected per-instance configurations for the managed instance group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/deletePerInstanceConfigs

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagerDeleteInstanceConfigReq:
RegionInstanceGroupManagerDeleteInstanceConfigReq"
  [project
   region
   instanceGroupManager
   RegionInstanceGroupManagerDeleteInstanceConfigReq]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deletePerInstanceConfigs",
   :uri-template-args
   {"instanceGroupManager" instanceGroupManager,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionInstanceGroupManagerDeleteInstanceConfigReq})

(defn regionInstanceGroupManagers-insert
  "Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A regional managed instance group can contain up to 2000 instances.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/insert

project <> 
region <> 
InstanceGroupManager:
InstanceGroupManager

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region InstanceGroupManager]
    (regionInstanceGroupManagers-insert
      project
      region
      InstanceGroupManager
      nil))
  ([project region InstanceGroupManager optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InstanceGroupManager}))

(defn regionInstanceGroupManagers-deleteInstances
  "Flags the specified instances in the managed instance group to be immediately deleted. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. The deleteInstances operation is marked DONE if the deleteInstances request is successful. The underlying actions take additional time. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/deleteInstances

project <> 
region <> 
instanceGroupManager <> 
RegionInstanceGroupManagersDeleteInstancesRequest:
RegionInstanceGroupManagersDeleteInstancesRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersDeleteInstancesRequest]
    (regionInstanceGroupManagers-deleteInstances
      project
      region
      instanceGroupManager
      RegionInstanceGroupManagersDeleteInstancesRequest
      nil))
  ([project
    region
    instanceGroupManager
    RegionInstanceGroupManagersDeleteInstancesRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/deleteInstances",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupManagersDeleteInstancesRequest}))

(defn regionInstanceGroupManagers-resize
  "Changes the intended size of the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes one or more instances. The resize operation is marked DONE if the resize request is successful. The underlying actions take additional time. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/resize

project <> 
region <> 
instanceGroupManager <> 
size <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region instanceGroupManager size]
    (regionInstanceGroupManagers-resize
      project
      region
      instanceGroupManager
      size
      nil))
  ([project region instanceGroupManager size optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/resize",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {"size" size} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionInstanceGroupManagers-get
  "Returns all of the details about the specified managed instance group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/get

project <> 
region <> 
instanceGroupManager <> "
  [project region instanceGroupManager]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}",
   :uri-template-args
   {"instanceGroupManager" instanceGroupManager,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionInstanceGroupManagers-listErrors
  "Lists all errors thrown by actions on instances for a given regional managed instance group. The filter and orderBy query parameters are not supported.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/listErrors

project <> 
region <> 
instanceGroupManager <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region instanceGroupManager]
    (regionInstanceGroupManagers-listErrors
      project
      region
      instanceGroupManager
      nil))
  ([project region instanceGroupManager optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listErrors",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionInstanceGroupManagers-listPerInstanceConfigs
  "Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroupManagers/listPerInstanceConfigs

project <> 
region <> 
instanceGroupManager <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region instanceGroupManager]
    (regionInstanceGroupManagers-listPerInstanceConfigs
      project
      region
      instanceGroupManager
      nil))
  ([project region instanceGroupManager optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroupManagers/{instanceGroupManager}/listPerInstanceConfigs",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkEndpointGroups-list
  "Retrieves the list of network endpoint groups that are located in the specified project and zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (networkEndpointGroups-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/networkEndpointGroups",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkEndpointGroups-delete
  "Deletes the specified network endpoint group. The network endpoints in the NEG and the VM instances they belong to are not terminated when the NEG is deleted. Note that the NEG cannot be deleted if there are backend services referencing it.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/delete

project <> 
zone <> 
networkEndpointGroup <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone networkEndpointGroup]
    (networkEndpointGroups-delete
      project
      zone
      networkEndpointGroup
      nil))
  ([project zone networkEndpointGroup optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}",
     :uri-template-args
     {"networkEndpointGroup" networkEndpointGroup,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn networkEndpointGroups-detachNetworkEndpoints
  "Detach a list of network endpoints from the specified network endpoint group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/detachNetworkEndpoints

project <> 
zone <> 
networkEndpointGroup <> 
NetworkEndpointGroupsDetachEndpointsRequest:
NetworkEndpointGroupsDetachEndpointsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    zone
    networkEndpointGroup
    NetworkEndpointGroupsDetachEndpointsRequest]
    (networkEndpointGroups-detachNetworkEndpoints
      project
      zone
      networkEndpointGroup
      NetworkEndpointGroupsDetachEndpointsRequest
      nil))
  ([project
    zone
    networkEndpointGroup
    NetworkEndpointGroupsDetachEndpointsRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints",
     :uri-template-args
     {"networkEndpointGroup" networkEndpointGroup,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworkEndpointGroupsDetachEndpointsRequest}))

(defn networkEndpointGroups-listNetworkEndpoints
  "Lists the network endpoints in the specified network endpoint group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/listNetworkEndpoints

project <> 
zone <> 
networkEndpointGroup <> 
NetworkEndpointGroupsListEndpointsRequest:
NetworkEndpointGroupsListEndpointsRequest

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project
    zone
    networkEndpointGroup
    NetworkEndpointGroupsListEndpointsRequest]
    (networkEndpointGroups-listNetworkEndpoints
      project
      zone
      networkEndpointGroup
      NetworkEndpointGroupsListEndpointsRequest
      nil))
  ([project
    zone
    networkEndpointGroup
    NetworkEndpointGroupsListEndpointsRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints",
     :uri-template-args
     {"networkEndpointGroup" networkEndpointGroup,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"],
     :body NetworkEndpointGroupsListEndpointsRequest}))

(defn networkEndpointGroups-attachNetworkEndpoints
  "Attach a list of network endpoints to the specified network endpoint group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/attachNetworkEndpoints

project <> 
zone <> 
networkEndpointGroup <> 
NetworkEndpointGroupsAttachEndpointsRequest:
NetworkEndpointGroupsAttachEndpointsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    zone
    networkEndpointGroup
    NetworkEndpointGroupsAttachEndpointsRequest]
    (networkEndpointGroups-attachNetworkEndpoints
      project
      zone
      networkEndpointGroup
      NetworkEndpointGroupsAttachEndpointsRequest
      nil))
  ([project
    zone
    networkEndpointGroup
    NetworkEndpointGroupsAttachEndpointsRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints",
     :uri-template-args
     {"networkEndpointGroup" networkEndpointGroup,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworkEndpointGroupsAttachEndpointsRequest}))

(defn networkEndpointGroups-aggregatedList
  "Retrieves the list of network endpoint groups and sorts them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (networkEndpointGroups-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/networkEndpointGroups",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkEndpointGroups-insert
  "Creates a network endpoint group in the specified project using the parameters that are included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/insert

project <> 
zone <> 
NetworkEndpointGroup:
NetworkEndpointGroup

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone NetworkEndpointGroup]
    (networkEndpointGroups-insert
      project
      zone
      NetworkEndpointGroup
      nil))
  ([project zone NetworkEndpointGroup optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/networkEndpointGroups",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworkEndpointGroup}))

(defn networkEndpointGroups-get
  "Returns the specified network endpoint group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/get

project <> 
zone <> 
networkEndpointGroup <> "
  [project zone networkEndpointGroup]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/networkEndpointGroups/{networkEndpointGroup}",
   :uri-template-args
   {"networkEndpointGroup" networkEndpointGroup,
    "project" project,
    "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn networkEndpointGroups-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkEndpointGroups/testIamPermissions

project <> 
zone <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project zone resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/networkEndpointGroups/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "resource" resource, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn regionDisks-setLabels
  "Sets the labels on the target regional disk.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/setLabels

project <> 
region <> 
resource <> 
RegionSetLabelsRequest:
RegionSetLabelsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region resource RegionSetLabelsRequest]
    (regionDisks-setLabels
      project
      region
      resource
      RegionSetLabelsRequest
      nil))
  ([project region resource RegionSetLabelsRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{resource}/setLabels",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionSetLabelsRequest}))

(defn regionDisks-list
  "Retrieves the list of persistent disks contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionDisks-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionDisks-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn regionDisks-startAsyncReplication
  "Starts asynchronous replication. Must be invoked on the primary disk.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/startAsyncReplication

project <> 
region <> 
disk <> 
RegionDisksStartAsyncReplicationRequest:
RegionDisksStartAsyncReplicationRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region disk RegionDisksStartAsyncReplicationRequest]
    (regionDisks-startAsyncReplication
      project
      region
      disk
      RegionDisksStartAsyncReplicationRequest
      nil))
  ([project
    region
    disk
    RegionDisksStartAsyncReplicationRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}/startAsyncReplication",
     :uri-template-args
     {"disk" disk, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionDisksStartAsyncReplicationRequest}))

(defn regionDisks-removeResourcePolicies
  "Removes resource policies from a regional disk.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/removeResourcePolicies

project <> 
region <> 
disk <> 
RegionDisksRemoveResourcePoliciesRequest:
RegionDisksRemoveResourcePoliciesRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region disk RegionDisksRemoveResourcePoliciesRequest]
    (regionDisks-removeResourcePolicies
      project
      region
      disk
      RegionDisksRemoveResourcePoliciesRequest
      nil))
  ([project
    region
    disk
    RegionDisksRemoveResourcePoliciesRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}/removeResourcePolicies",
     :uri-template-args
     {"disk" disk, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionDisksRemoveResourcePoliciesRequest}))

(defn regionDisks-bulkInsert
  "Bulk create a set of disks.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/bulkInsert

project <> 
region <> 
BulkInsertDiskResource:
BulkInsertDiskResource

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region BulkInsertDiskResource]
    (regionDisks-bulkInsert project region BulkInsertDiskResource nil))
  ([project region BulkInsertDiskResource optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/bulkInsert",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body BulkInsertDiskResource}))

(defn regionDisks-delete
  "Deletes the specified regional persistent disk. Deleting a regional disk removes all the replicas of its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/delete

project <> 
region <> 
disk <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region disk] (regionDisks-delete project region disk nil))
  ([project region disk optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}",
     :uri-template-args
     {"disk" disk, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionDisks-update
  "Update the specified disk with the data included in the request. Update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: user_license.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/update

project <> 
region <> 
disk <> 
Disk:
Disk

optional:
paths <string> 
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> update_mask indicates fields to be updated as part of this request."
  ([project region disk Disk]
    (regionDisks-update project region disk Disk nil))
  ([project region disk Disk optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}",
     :uri-template-args
     {"disk" disk, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Disk}))

(defn regionDisks-stopAsyncReplication
  "Stops asynchronous replication. Can be invoked either on the primary or on the secondary disk.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/stopAsyncReplication

project <> 
region <> 
disk <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region disk]
    (regionDisks-stopAsyncReplication project region disk nil))
  ([project region disk optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}/stopAsyncReplication",
     :uri-template-args
     {"disk" disk, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionDisks-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (regionDisks-getIamPolicy project region resource nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionDisks-insert
  "Creates a persistent regional disk in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/insert

project <> 
region <> 
Disk:
Disk

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
sourceImage <string> Source image to restore onto a disk. This field is optional."
  ([project region Disk] (regionDisks-insert project region Disk nil))
  ([project region Disk optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Disk}))

(defn regionDisks-stopGroupAsyncReplication
  "Stops asynchronous replication for a consistency group of disks. Can be invoked either in the primary or secondary scope.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/stopGroupAsyncReplication

project <> 
region <> 
DisksStopGroupAsyncReplicationResource:
DisksStopGroupAsyncReplicationResource

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region DisksStopGroupAsyncReplicationResource]
    (regionDisks-stopGroupAsyncReplication
      project
      region
      DisksStopGroupAsyncReplicationResource
      nil))
  ([project region DisksStopGroupAsyncReplicationResource optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/stopGroupAsyncReplication",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body DisksStopGroupAsyncReplicationResource}))

(defn regionDisks-resize
  "Resizes the specified regional persistent disk.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/resize

project <> 
region <> 
disk <> 
RegionDisksResizeRequest:
RegionDisksResizeRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region disk RegionDisksResizeRequest]
    (regionDisks-resize
      project
      region
      disk
      RegionDisksResizeRequest
      nil))
  ([project region disk RegionDisksResizeRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}/resize",
     :uri-template-args
     {"disk" disk, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionDisksResizeRequest}))

(defn regionDisks-addResourcePolicies
  "Adds existing resource policies to a regional disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/addResourcePolicies

project <> 
region <> 
disk <> 
RegionDisksAddResourcePoliciesRequest:
RegionDisksAddResourcePoliciesRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region disk RegionDisksAddResourcePoliciesRequest]
    (regionDisks-addResourcePolicies
      project
      region
      disk
      RegionDisksAddResourcePoliciesRequest
      nil))
  ([project region disk RegionDisksAddResourcePoliciesRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}/addResourcePolicies",
     :uri-template-args
     {"disk" disk, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionDisksAddResourcePoliciesRequest}))

(defn regionDisks-get
  "Returns a specified regional persistent disk.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/get

project <> 
region <> 
disk <> "
  [project region disk]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}",
   :uri-template-args
   {"disk" disk, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionDisks-createSnapshot
  "Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider using snapshots.insert instead, as that method supports more features, such as creating snapshots in a project different from the source disk project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/createSnapshot

project <> 
region <> 
disk <> 
Snapshot:
Snapshot

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region disk Snapshot]
    (regionDisks-createSnapshot project region disk Snapshot nil))
  ([project region disk Snapshot optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{disk}/createSnapshot",
     :uri-template-args
     {"disk" disk, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Snapshot}))

(defn regionDisks-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionDisks/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/disks/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn targetInstances-list
  "Retrieves a list of TargetInstance resources available to the specified project and zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetInstances/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (targetInstances-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/targetInstances",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn targetInstances-aggregatedList
  "Retrieves an aggregated list of target instances. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetInstances/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (targetInstances-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/targetInstances",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn targetInstances-get
  "Returns the specified TargetInstance resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetInstances/get

project <> 
zone <> 
targetInstance <> "
  [project zone targetInstance]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/targetInstances/{targetInstance}",
   :uri-template-args
   {"project" project, "targetInstance" targetInstance, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn targetInstances-insert
  "Creates a TargetInstance resource in the specified project and zone using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetInstances/insert

project <> 
zone <> 
TargetInstance:
TargetInstance

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone TargetInstance]
    (targetInstances-insert project zone TargetInstance nil))
  ([project zone TargetInstance optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/targetInstances",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetInstance}))

(defn targetInstances-delete
  "Deletes the specified TargetInstance resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetInstances/delete

project <> 
zone <> 
targetInstance <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone targetInstance]
    (targetInstances-delete project zone targetInstance nil))
  ([project zone targetInstance optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/targetInstances/{targetInstance}",
     :uri-template-args
     {"project" project, "targetInstance" targetInstance, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn targetInstances-setSecurityPolicy
  "Sets the Google Cloud Armor security policy for the specified target instance. For more information, see Google Cloud Armor Overview
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetInstances/setSecurityPolicy

project <> 
zone <> 
targetInstance <> 
SecurityPolicyReference:
SecurityPolicyReference

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone targetInstance SecurityPolicyReference]
    (targetInstances-setSecurityPolicy
      project
      zone
      targetInstance
      SecurityPolicyReference
      nil))
  ([project zone targetInstance SecurityPolicyReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/targetInstances/{targetInstance}/setSecurityPolicy",
     :uri-template-args
     {"project" project, "targetInstance" targetInstance, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyReference}))

(defn imageFamilyViews-get
  "Returns the latest image that is part of an image family, is not deprecated and is rolled out in the specified zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/imageFamilyViews/get

project <> 
zone <> 
family <> "
  [project zone family]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/imageFamilyViews/{family}",
   :uri-template-args
   {"family" family, "project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn globalForwardingRules-list
  "Retrieves a list of GlobalForwardingRule resources available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalForwardingRules/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (globalForwardingRules-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/forwardingRules",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn globalForwardingRules-get
  "Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules by making a list() request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalForwardingRules/get

project <> 
forwardingRule <> "
  [project forwardingRule]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/forwardingRules/{forwardingRule}",
   :uri-template-args
   {"forwardingRule" forwardingRule, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn globalForwardingRules-insert
  "Creates a GlobalForwardingRule resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalForwardingRules/insert

project <> 
ForwardingRule:
ForwardingRule

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project ForwardingRule]
    (globalForwardingRules-insert project ForwardingRule nil))
  ([project ForwardingRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/forwardingRules",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ForwardingRule}))

(defn globalForwardingRules-delete
  "Deletes the specified GlobalForwardingRule resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalForwardingRules/delete

project <> 
forwardingRule <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project forwardingRule]
    (globalForwardingRules-delete project forwardingRule nil))
  ([project forwardingRule optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/forwardingRules/{forwardingRule}",
     :uri-template-args
     {"forwardingRule" forwardingRule, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn globalForwardingRules-setTarget
  "Changes target URL for the GlobalForwardingRule resource. The new target should be of the same type as the old target.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalForwardingRules/setTarget

project <> 
forwardingRule <> 
TargetReference:
TargetReference

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project forwardingRule TargetReference]
    (globalForwardingRules-setTarget
      project
      forwardingRule
      TargetReference
      nil))
  ([project forwardingRule TargetReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/forwardingRules/{forwardingRule}/setTarget",
     :uri-template-args
     {"forwardingRule" forwardingRule, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetReference}))

(defn globalForwardingRules-patch
  "Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalForwardingRules/patch

project <> 
forwardingRule <> 
ForwardingRule:
ForwardingRule

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project forwardingRule ForwardingRule]
    (globalForwardingRules-patch
      project
      forwardingRule
      ForwardingRule
      nil))
  ([project forwardingRule ForwardingRule optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/forwardingRules/{forwardingRule}",
     :uri-template-args
     {"forwardingRule" forwardingRule, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ForwardingRule}))

(defn globalForwardingRules-setLabels
  "Sets the labels on the specified resource. To learn more about labels, read the Labeling resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalForwardingRules/setLabels

project <> 
resource <> 
GlobalSetLabelsRequest:
GlobalSetLabelsRequest"
  [project resource GlobalSetLabelsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/forwardingRules/{resource}/setLabels",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetLabelsRequest})

(defn zones-list
  "Retrieves the list of Zone resources available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/zones/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (zones-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn zones-get
  "Returns the specified Zone resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/zones/get

project <> 
zone <> "
  [project zone]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}",
   :uri-template-args {"project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn subnetworks-list
  "Retrieves a list of subnetworks available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (subnetworks-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn subnetworks-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn subnetworks-delete
  "Deletes the specified subnetwork.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/delete

project <> 
region <> 
subnetwork <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region subnetwork]
    (subnetworks-delete project region subnetwork nil))
  ([project region subnetwork optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}",
     :uri-template-args
     {"project" project, "region" region, "subnetwork" subnetwork},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn subnetworks-expandIpCidrRange
  "Expands the IP CIDR range of the subnetwork to a specified value.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/expandIpCidrRange

project <> 
region <> 
subnetwork <> 
SubnetworksExpandIpCidrRangeRequest:
SubnetworksExpandIpCidrRangeRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region subnetwork SubnetworksExpandIpCidrRangeRequest]
    (subnetworks-expandIpCidrRange
      project
      region
      subnetwork
      SubnetworksExpandIpCidrRangeRequest
      nil))
  ([project
    region
    subnetwork
    SubnetworksExpandIpCidrRangeRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}/expandIpCidrRange",
     :uri-template-args
     {"project" project, "region" region, "subnetwork" subnetwork},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SubnetworksExpandIpCidrRangeRequest}))

(defn subnetworks-patch
  "Patches the specified subnetwork with the data included in the request. Only certain fields can be updated with a patch request as indicated in the field descriptions. You must specify the current fingerprint of the subnetwork resource being patched.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/patch

project <> 
region <> 
subnetwork <> 
Subnetwork:
Subnetwork

optional:
drainTimeoutSeconds <integer> The drain timeout specifies the upper bound in seconds on the amount of time allowed to drain connections from the current ACTIVE subnetwork to the current BACKUP subnetwork. The drain timeout is only applicable when the following conditions are true: - the subnetwork being patched has purpose = INTERNAL_HTTPS_LOAD_BALANCER - the subnetwork being patched has role = BACKUP - the patch request is setting the role to ACTIVE. Note that after this patch operation the roles of the ACTIVE and BACKUP subnetworks will be swapped.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region subnetwork Subnetwork]
    (subnetworks-patch project region subnetwork Subnetwork nil))
  ([project region subnetwork Subnetwork optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}",
     :uri-template-args
     {"project" project, "region" region, "subnetwork" subnetwork},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Subnetwork}))

(defn subnetworks-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (subnetworks-getIamPolicy project region resource nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn subnetworks-aggregatedList
  "Retrieves an aggregated list of subnetworks. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (subnetworks-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/subnetworks",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn subnetworks-insert
  "Creates a subnetwork in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/insert

project <> 
region <> 
Subnetwork:
Subnetwork

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region Subnetwork]
    (subnetworks-insert project region Subnetwork nil))
  ([project region Subnetwork optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Subnetwork}))

(defn subnetworks-setPrivateIpGoogleAccess
  "Set whether VMs in this subnet can access Google services without assigning external IP addresses through Private Google Access.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/setPrivateIpGoogleAccess

project <> 
region <> 
subnetwork <> 
SubnetworksSetPrivateIpGoogleAccessRequest:
SubnetworksSetPrivateIpGoogleAccessRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    subnetwork
    SubnetworksSetPrivateIpGoogleAccessRequest]
    (subnetworks-setPrivateIpGoogleAccess
      project
      region
      subnetwork
      SubnetworksSetPrivateIpGoogleAccessRequest
      nil))
  ([project
    region
    subnetwork
    SubnetworksSetPrivateIpGoogleAccessRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}/setPrivateIpGoogleAccess",
     :uri-template-args
     {"project" project, "region" region, "subnetwork" subnetwork},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SubnetworksSetPrivateIpGoogleAccessRequest}))

(defn subnetworks-get
  "Returns the specified subnetwork.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/get

project <> 
region <> 
subnetwork <> "
  [project region subnetwork]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}",
   :uri-template-args
   {"project" project, "region" region, "subnetwork" subnetwork},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn subnetworks-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn subnetworks-listUsable
  "Retrieves an aggregated list of all usable subnetworks in the project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/subnetworks/listUsable

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (subnetworks-listUsable project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/subnetworks/listUsable",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionHealthCheckServices-list
  "Lists all the HealthCheckService resources that have been configured for the specified project in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthCheckServices/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region]
    (regionHealthCheckServices-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthCheckServices",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionHealthCheckServices-get
  "Returns the specified regional HealthCheckService resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthCheckServices/get

project <> 
region <> 
healthCheckService <> "
  [project region healthCheckService]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}",
   :uri-template-args
   {"healthCheckService" healthCheckService,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionHealthCheckServices-insert
  "Creates a regional HealthCheckService resource in the specified project and region using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthCheckServices/insert

project <> 
region <> 
HealthCheckService:
HealthCheckService

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region HealthCheckService]
    (regionHealthCheckServices-insert
      project
      region
      HealthCheckService
      nil))
  ([project region HealthCheckService optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthCheckServices",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HealthCheckService}))

(defn regionHealthCheckServices-delete
  "Deletes the specified regional HealthCheckService.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthCheckServices/delete

project <> 
region <> 
healthCheckService <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region healthCheckService]
    (regionHealthCheckServices-delete
      project
      region
      healthCheckService
      nil))
  ([project region healthCheckService optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}",
     :uri-template-args
     {"healthCheckService" healthCheckService,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionHealthCheckServices-patch
  "Updates the specified regional HealthCheckService resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthCheckServices/patch

project <> 
region <> 
healthCheckService <> 
HealthCheckService:
HealthCheckService

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region healthCheckService HealthCheckService]
    (regionHealthCheckServices-patch
      project
      region
      healthCheckService
      HealthCheckService
      nil))
  ([project region healthCheckService HealthCheckService optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthCheckServices/{healthCheckService}",
     :uri-template-args
     {"healthCheckService" healthCheckService,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HealthCheckService}))

(defn regionBackendServices-list
  "Retrieves the list of regional BackendService resources available to the specified project in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionBackendServices-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionBackendServices-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn regionBackendServices-delete
  "Deletes the specified regional BackendService resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/delete

project <> 
region <> 
backendService <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region backendService]
    (regionBackendServices-delete project region backendService nil))
  ([project region backendService optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}",
     :uri-template-args
     {"backendService" backendService,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionBackendServices-update
  "Updates the specified regional BackendService resource with the data included in the request. For more information, see Backend services overview .
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/update

project <> 
region <> 
backendService <> 
BackendService:
BackendService

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region backendService BackendService]
    (regionBackendServices-update
      project
      region
      backendService
      BackendService
      nil))
  ([project region backendService BackendService optional]
    {:method :put,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}",
     :uri-template-args
     {"backendService" backendService,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body BackendService}))

(defn regionBackendServices-getHealth
  "Gets the most recent health check results for this regional BackendService.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/getHealth

project <> 
region <> 
backendService <> 
ResourceGroupReference:
ResourceGroupReference"
  [project region backendService ResourceGroupReference]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}/getHealth",
   :uri-template-args
   {"backendService" backendService,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body ResourceGroupReference})

(defn regionBackendServices-patch
  "Updates the specified regional BackendService resource with the data included in the request. For more information, see Understanding backend services This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/patch

project <> 
region <> 
backendService <> 
BackendService:
BackendService

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region backendService BackendService]
    (regionBackendServices-patch
      project
      region
      backendService
      BackendService
      nil))
  ([project region backendService BackendService optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}",
     :uri-template-args
     {"backendService" backendService,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body BackendService}))

(defn regionBackendServices-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (regionBackendServices-getIamPolicy project region resource nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionBackendServices-insert
  "Creates a regional BackendService resource in the specified project using the data included in the request. For more information, see Backend services overview.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/insert

project <> 
region <> 
BackendService:
BackendService

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region BackendService]
    (regionBackendServices-insert project region BackendService nil))
  ([project region BackendService optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body BackendService}))

(defn regionBackendServices-setSecurityPolicy
  "Sets the Google Cloud Armor security policy for the specified backend service. For more information, see Google Cloud Armor Overview
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/setSecurityPolicy

project <> 
region <> 
backendService <> 
SecurityPolicyReference:
SecurityPolicyReference

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region backendService SecurityPolicyReference]
    (regionBackendServices-setSecurityPolicy
      project
      region
      backendService
      SecurityPolicyReference
      nil))
  ([project region backendService SecurityPolicyReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}/setSecurityPolicy",
     :uri-template-args
     {"backendService" backendService,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyReference}))

(defn regionBackendServices-get
  "Returns the specified regional BackendService resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/get

project <> 
region <> 
backendService <> "
  [project region backendService]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{backendService}",
   :uri-template-args
   {"backendService" backendService,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionBackendServices-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn regionBackendServices-listUsable
  "Retrieves an aggregated list of all usable backend services in the specified project in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionBackendServices/listUsable

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region]
    (regionBackendServices-listUsable project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/backendServices/listUsable",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn licenseCodes-get
  "Return a specified license code. License codes are mirrored across all projects that have permissions to read the License Code. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenseCodes/get

project <> 
licenseCode <> "
  [project licenseCode]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenseCodes/{licenseCode}",
   :uri-template-args {"licenseCode" licenseCode, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn licenseCodes-testIamPermissions
  "Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenseCodes/testIamPermissions

project <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenseCodes/{resource}/testIamPermissions",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn healthChecks-list
  "Retrieves the list of HealthCheck resources available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/healthChecks/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (healthChecks-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/healthChecks",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn healthChecks-aggregatedList
  "Retrieves the list of all HealthCheck resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/healthChecks/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (healthChecks-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/healthChecks",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn healthChecks-get
  "Returns the specified HealthCheck resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/healthChecks/get

project <> 
healthCheck <> "
  [project healthCheck]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/healthChecks/{healthCheck}",
   :uri-template-args {"healthCheck" healthCheck, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn healthChecks-insert
  "Creates a HealthCheck resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/healthChecks/insert

project <> 
HealthCheck:
HealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project HealthCheck] (healthChecks-insert project HealthCheck nil))
  ([project HealthCheck optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/healthChecks",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HealthCheck}))

(defn healthChecks-delete
  "Deletes the specified HealthCheck resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/healthChecks/delete

project <> 
healthCheck <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project healthCheck] (healthChecks-delete project healthCheck nil))
  ([project healthCheck optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/healthChecks/{healthCheck}",
     :uri-template-args {"healthCheck" healthCheck, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn healthChecks-update
  "Updates a HealthCheck resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/healthChecks/update

project <> 
healthCheck <> 
HealthCheck:
HealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project healthCheck HealthCheck]
    (healthChecks-update project healthCheck HealthCheck nil))
  ([project healthCheck HealthCheck optional]
    {:method :put,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/healthChecks/{healthCheck}",
     :uri-template-args {"healthCheck" healthCheck, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HealthCheck}))

(defn healthChecks-patch
  "Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/healthChecks/patch

project <> 
healthCheck <> 
HealthCheck:
HealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project healthCheck HealthCheck]
    (healthChecks-patch project healthCheck HealthCheck nil))
  ([project healthCheck HealthCheck optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/healthChecks/{healthCheck}",
     :uri-template-args {"healthCheck" healthCheck, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HealthCheck}))

(defn licenses-get
  "Returns the specified License resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenses/get

project <> 
license <> "
  [project license]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenses/{license}",
   :uri-template-args {"license" license, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn licenses-list
  "Retrieves the list of licenses available in the specified project. This method does not get any licenses that belong to other projects, including licenses attached to publicly-available images, like Debian 9. If you want to get a list of publicly-available licenses, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenses/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (licenses-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenses",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn licenses-delete
  "Deletes the specified license. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenses/delete

project <> 
license <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project license] (licenses-delete project license nil))
  ([project license optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenses/{license}",
     :uri-template-args {"license" license, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn licenses-insert
  "Create a License resource in the specified project. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenses/insert

project <> 
License:
License

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project License] (licenses-insert project License nil))
  ([project License optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenses",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/devstorage.full_control"
      "https://www.googleapis.com/auth/devstorage.read_only"
      "https://www.googleapis.com/auth/devstorage.read_write"],
     :body License}))

(defn licenses-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenses/getIamPolicy

project <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project resource] (licenses-getIamPolicy project resource nil))
  ([project resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenses/{resource}/getIamPolicy",
     :uri-template-args {"project" project, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn licenses-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenses/setIamPolicy

project <> 
resource <> 
GlobalSetPolicyRequest:
GlobalSetPolicyRequest"
  [project resource GlobalSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenses/{resource}/setIamPolicy",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetPolicyRequest})

(defn licenses-testIamPermissions
  "Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/licenses/testIamPermissions

project <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/licenses/{resource}/testIamPermissions",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn interconnects-insert
  "Creates an Interconnect in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnects/insert

project <> 
Interconnect:
Interconnect

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project Interconnect]
    (interconnects-insert project Interconnect nil))
  ([project Interconnect optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnects",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Interconnect}))

(defn interconnects-list
  "Retrieves the list of Interconnects available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnects/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (interconnects-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnects",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn interconnects-getDiagnostics
  "Returns the interconnectDiagnostics for the specified Interconnect. In the event of a global outage, do not use this API to make decisions about where to redirect your network traffic. Unlike a VLAN attachment, which is regional, a Cloud Interconnect connection is a global resource. A global outage can prevent this API from functioning properly.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnects/getDiagnostics

project <> 
interconnect <> "
  [project interconnect]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnects/{interconnect}/getDiagnostics",
   :uri-template-args {"interconnect" interconnect, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn interconnects-getMacsecConfig
  "Returns the interconnectMacsecConfig for the specified Interconnect.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnects/getMacsecConfig

project <> 
interconnect <> "
  [project interconnect]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnects/{interconnect}/getMacsecConfig",
   :uri-template-args {"interconnect" interconnect, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn interconnects-get
  "Returns the specified Interconnect. Get a list of available Interconnects by making a list() request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnects/get

project <> 
interconnect <> "
  [project interconnect]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnects/{interconnect}",
   :uri-template-args {"interconnect" interconnect, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn interconnects-delete
  "Deletes the specified Interconnect.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnects/delete

project <> 
interconnect <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project interconnect]
    (interconnects-delete project interconnect nil))
  ([project interconnect optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnects/{interconnect}",
     :uri-template-args
     {"interconnect" interconnect, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn interconnects-patch
  "Updates the specified Interconnect with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnects/patch

project <> 
interconnect <> 
Interconnect:
Interconnect

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project interconnect Interconnect]
    (interconnects-patch project interconnect Interconnect nil))
  ([project interconnect Interconnect optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnects/{interconnect}",
     :uri-template-args
     {"interconnect" interconnect, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Interconnect}))

(defn interconnects-setLabels
  "Sets the labels on an Interconnect. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnects/setLabels

project <> 
resource <> 
GlobalSetLabelsRequest:
GlobalSetLabelsRequest"
  [project resource GlobalSetLabelsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnects/{resource}/setLabels",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetLabelsRequest})

(defn nodeTemplates-list
  "Retrieves a list of node templates available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTemplates/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (nodeTemplates-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/nodeTemplates",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeTemplates-aggregatedList
  "Retrieves an aggregated list of node templates. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTemplates/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (nodeTemplates-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/nodeTemplates",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeTemplates-get
  "Returns the specified node template.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTemplates/get

project <> 
region <> 
nodeTemplate <> "
  [project region nodeTemplate]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}",
   :uri-template-args
   {"nodeTemplate" nodeTemplate, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn nodeTemplates-insert
  "Creates a NodeTemplate resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTemplates/insert

project <> 
region <> 
NodeTemplate:
NodeTemplate

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region NodeTemplate]
    (nodeTemplates-insert project region NodeTemplate nil))
  ([project region NodeTemplate optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/nodeTemplates",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NodeTemplate}))

(defn nodeTemplates-delete
  "Deletes the specified NodeTemplate resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTemplates/delete

project <> 
region <> 
nodeTemplate <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region nodeTemplate]
    (nodeTemplates-delete project region nodeTemplate nil))
  ([project region nodeTemplate optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/nodeTemplates/{nodeTemplate}",
     :uri-template-args
     {"nodeTemplate" nodeTemplate, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn nodeTemplates-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTemplates/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (nodeTemplates-getIamPolicy project region resource nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeTemplates-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTemplates/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn nodeTemplates-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTemplates/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/nodeTemplates/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn targetSslProxies-setSslPolicy
  "Sets the SSL policy for TargetSslProxy. The SSL policy specifies the server-side support for SSL features. This affects connections between clients and the load balancer. They do not affect the connection between the load balancer and the backends.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/setSslPolicy

project <> 
targetSslProxy <> 
SslPolicyReference:
SslPolicyReference

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project targetSslProxy SslPolicyReference]
    (targetSslProxies-setSslPolicy
      project
      targetSslProxy
      SslPolicyReference
      nil))
  ([project targetSslProxy SslPolicyReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies/{targetSslProxy}/setSslPolicy",
     :uri-template-args
     {"project" project, "targetSslProxy" targetSslProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SslPolicyReference}))

(defn targetSslProxies-list
  "Retrieves the list of TargetSslProxy resources available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (targetSslProxies-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn targetSslProxies-setCertificateMap
  "Changes the Certificate Map for TargetSslProxy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/setCertificateMap

project <> 
targetSslProxy <> 
TargetSslProxiesSetCertificateMapRequest:
TargetSslProxiesSetCertificateMapRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project targetSslProxy TargetSslProxiesSetCertificateMapRequest]
    (targetSslProxies-setCertificateMap
      project
      targetSslProxy
      TargetSslProxiesSetCertificateMapRequest
      nil))
  ([project
    targetSslProxy
    TargetSslProxiesSetCertificateMapRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies/{targetSslProxy}/setCertificateMap",
     :uri-template-args
     {"project" project, "targetSslProxy" targetSslProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetSslProxiesSetCertificateMapRequest}))

(defn targetSslProxies-delete
  "Deletes the specified TargetSslProxy resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/delete

project <> 
targetSslProxy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project targetSslProxy]
    (targetSslProxies-delete project targetSslProxy nil))
  ([project targetSslProxy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies/{targetSslProxy}",
     :uri-template-args
     {"project" project, "targetSslProxy" targetSslProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn targetSslProxies-setBackendService
  "Changes the BackendService for TargetSslProxy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/setBackendService

project <> 
targetSslProxy <> 
TargetSslProxiesSetBackendServiceRequest:
TargetSslProxiesSetBackendServiceRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project targetSslProxy TargetSslProxiesSetBackendServiceRequest]
    (targetSslProxies-setBackendService
      project
      targetSslProxy
      TargetSslProxiesSetBackendServiceRequest
      nil))
  ([project
    targetSslProxy
    TargetSslProxiesSetBackendServiceRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies/{targetSslProxy}/setBackendService",
     :uri-template-args
     {"project" project, "targetSslProxy" targetSslProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetSslProxiesSetBackendServiceRequest}))

(defn targetSslProxies-setSslCertificates
  "Changes SslCertificates for TargetSslProxy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/setSslCertificates

project <> 
targetSslProxy <> 
TargetSslProxiesSetSslCertificatesRequest:
TargetSslProxiesSetSslCertificatesRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project targetSslProxy TargetSslProxiesSetSslCertificatesRequest]
    (targetSslProxies-setSslCertificates
      project
      targetSslProxy
      TargetSslProxiesSetSslCertificatesRequest
      nil))
  ([project
    targetSslProxy
    TargetSslProxiesSetSslCertificatesRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies/{targetSslProxy}/setSslCertificates",
     :uri-template-args
     {"project" project, "targetSslProxy" targetSslProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetSslProxiesSetSslCertificatesRequest}))

(defn targetSslProxies-setProxyHeader
  "Changes the ProxyHeaderType for TargetSslProxy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/setProxyHeader

project <> 
targetSslProxy <> 
TargetSslProxiesSetProxyHeaderRequest:
TargetSslProxiesSetProxyHeaderRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project targetSslProxy TargetSslProxiesSetProxyHeaderRequest]
    (targetSslProxies-setProxyHeader
      project
      targetSslProxy
      TargetSslProxiesSetProxyHeaderRequest
      nil))
  ([project
    targetSslProxy
    TargetSslProxiesSetProxyHeaderRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies/{targetSslProxy}/setProxyHeader",
     :uri-template-args
     {"project" project, "targetSslProxy" targetSslProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetSslProxiesSetProxyHeaderRequest}))

(defn targetSslProxies-insert
  "Creates a TargetSslProxy resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/insert

project <> 
TargetSslProxy:
TargetSslProxy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project TargetSslProxy]
    (targetSslProxies-insert project TargetSslProxy nil))
  ([project TargetSslProxy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetSslProxy}))

(defn targetSslProxies-get
  "Returns the specified TargetSslProxy resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetSslProxies/get

project <> 
targetSslProxy <> "
  [project targetSslProxy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetSslProxies/{targetSslProxy}",
   :uri-template-args
   {"project" project, "targetSslProxy" targetSslProxy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn targetGrpcProxies-list
  "Lists the TargetGrpcProxies for a project in the given scope.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetGrpcProxies/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (targetGrpcProxies-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetGrpcProxies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn targetGrpcProxies-get
  "Returns the specified TargetGrpcProxy resource in the given scope.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetGrpcProxies/get

project <> 
targetGrpcProxy <> "
  [project targetGrpcProxy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}",
   :uri-template-args
   {"project" project, "targetGrpcProxy" targetGrpcProxy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn targetGrpcProxies-insert
  "Creates a TargetGrpcProxy in the specified project in the given scope using the parameters that are included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetGrpcProxies/insert

project <> 
TargetGrpcProxy:
TargetGrpcProxy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project TargetGrpcProxy]
    (targetGrpcProxies-insert project TargetGrpcProxy nil))
  ([project TargetGrpcProxy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetGrpcProxies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetGrpcProxy}))

(defn targetGrpcProxies-delete
  "Deletes the specified TargetGrpcProxy in the given scope
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetGrpcProxies/delete

project <> 
targetGrpcProxy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project targetGrpcProxy]
    (targetGrpcProxies-delete project targetGrpcProxy nil))
  ([project targetGrpcProxy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}",
     :uri-template-args
     {"project" project, "targetGrpcProxy" targetGrpcProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn targetGrpcProxies-patch
  "Patches the specified TargetGrpcProxy resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetGrpcProxies/patch

project <> 
targetGrpcProxy <> 
TargetGrpcProxy:
TargetGrpcProxy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project targetGrpcProxy TargetGrpcProxy]
    (targetGrpcProxies-patch
      project
      targetGrpcProxy
      TargetGrpcProxy
      nil))
  ([project targetGrpcProxy TargetGrpcProxy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}",
     :uri-template-args
     {"project" project, "targetGrpcProxy" targetGrpcProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetGrpcProxy}))

(defn globalOrganizationOperations-list
  "Retrieves a list of Operation resources contained within the specified organization.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalOrganizationOperations/list

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
parentId <string> Parent ID for this request.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([] (globalOrganizationOperations-list nil))
  ([optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/operations",
     :uri-template-args {},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn globalOrganizationOperations-get
  "Retrieves the specified Operations resource. Gets a list of operations by making a `list()` request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalOrganizationOperations/get

operation <> 

optional:
parentId <string> Parent ID for this request."
  ([operation] (globalOrganizationOperations-get operation nil))
  ([operation optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/operations/{operation}",
     :uri-template-args {"operation" operation},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn globalOrganizationOperations-delete
  "Deletes the specified Operations resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalOrganizationOperations/delete

operation <> 

optional:
parentId <string> Parent ID for this request."
  ([operation] (globalOrganizationOperations-delete operation nil))
  ([operation optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/operations/{operation}",
     :uri-template-args {"operation" operation},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn storagePoolTypes-list
  "Retrieves a list of storage pool types available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePoolTypes/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (storagePoolTypes-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePoolTypes",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn storagePoolTypes-aggregatedList
  "Retrieves an aggregated list of storage pool types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePoolTypes/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (storagePoolTypes-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/storagePoolTypes",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn storagePoolTypes-get
  "Returns the specified storage pool type.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePoolTypes/get

project <> 
zone <> 
storagePoolType <> "
  [project zone storagePoolType]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePoolTypes/{storagePoolType}",
   :uri-template-args
   {"project" project, "storagePoolType" storagePoolType, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn autoscalers-list
  "Retrieves a list of autoscalers contained within the specified zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/autoscalers/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (autoscalers-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/autoscalers",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn autoscalers-aggregatedList
  "Retrieves an aggregated list of autoscalers. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/autoscalers/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (autoscalers-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/autoscalers",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn autoscalers-get
  "Returns the specified autoscaler resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/autoscalers/get

project <> 
zone <> 
autoscaler <> "
  [project zone autoscaler]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/autoscalers/{autoscaler}",
   :uri-template-args
   {"autoscaler" autoscaler, "project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn autoscalers-insert
  "Creates an autoscaler in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/autoscalers/insert

project <> 
zone <> 
Autoscaler:
Autoscaler

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone Autoscaler]
    (autoscalers-insert project zone Autoscaler nil))
  ([project zone Autoscaler optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/autoscalers",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Autoscaler}))

(defn autoscalers-update
  "Updates an autoscaler in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/autoscalers/update

project <> 
zone <> 
Autoscaler:
Autoscaler

optional:
autoscaler <string> Name of the autoscaler to update.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone Autoscaler]
    (autoscalers-update project zone Autoscaler nil))
  ([project zone Autoscaler optional]
    {:method :put,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/autoscalers",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Autoscaler}))

(defn autoscalers-patch
  "Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/autoscalers/patch

project <> 
zone <> 
Autoscaler:
Autoscaler

optional:
autoscaler <string> Name of the autoscaler to patch.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone Autoscaler]
    (autoscalers-patch project zone Autoscaler nil))
  ([project zone Autoscaler optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/autoscalers",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Autoscaler}))

(defn autoscalers-delete
  "Deletes the specified autoscaler.
https://cloud.google.com/products/compute/v1/reference/rest/v1/autoscalers/delete

project <> 
zone <> 
autoscaler <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone autoscaler]
    (autoscalers-delete project zone autoscaler nil))
  ([project zone autoscaler optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/autoscalers/{autoscaler}",
     :uri-template-args
     {"autoscaler" autoscaler, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionTargetTcpProxies-list
  "Retrieves a list of TargetTcpProxy resources available to the specified project in a given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionTargetTcpProxies/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionTargetTcpProxies-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetTcpProxies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionTargetTcpProxies-get
  "Returns the specified TargetTcpProxy resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionTargetTcpProxies/get

project <> 
region <> 
targetTcpProxy <> "
  [project region targetTcpProxy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetTcpProxies/{targetTcpProxy}",
   :uri-template-args
   {"project" project,
    "region" region,
    "targetTcpProxy" targetTcpProxy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionTargetTcpProxies-insert
  "Creates a TargetTcpProxy resource in the specified project and region using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionTargetTcpProxies/insert

project <> 
region <> 
TargetTcpProxy:
TargetTcpProxy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region TargetTcpProxy]
    (regionTargetTcpProxies-insert project region TargetTcpProxy nil))
  ([project region TargetTcpProxy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetTcpProxies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetTcpProxy}))

(defn regionTargetTcpProxies-delete
  "Deletes the specified TargetTcpProxy resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionTargetTcpProxies/delete

project <> 
region <> 
targetTcpProxy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetTcpProxy]
    (regionTargetTcpProxies-delete project region targetTcpProxy nil))
  ([project region targetTcpProxy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetTcpProxies/{targetTcpProxy}",
     :uri-template-args
     {"project" project,
      "region" region,
      "targetTcpProxy" targetTcpProxy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn instanceTemplates-list
  "Retrieves a list of instance templates that are contained within the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceTemplates/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (instanceTemplates-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn instanceTemplates-get
  "Returns the specified instance template.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceTemplates/get

project <> 
instanceTemplate <> "
  [project instanceTemplate]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates/{instanceTemplate}",
   :uri-template-args
   {"instanceTemplate" instanceTemplate, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn instanceTemplates-insert
  "Creates an instance template in the specified project using the data that is included in the request. If you are creating a new template to update an existing instance group, your new instance template must use the same network or, if applicable, the same subnetwork as the original template.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceTemplates/insert

project <> 
InstanceTemplate:
InstanceTemplate

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project InstanceTemplate]
    (instanceTemplates-insert project InstanceTemplate nil))
  ([project InstanceTemplate optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InstanceTemplate}))

(defn instanceTemplates-delete
  "Deletes the specified instance template. Deleting an instance template is permanent and cannot be undone. It is not possible to delete templates that are already in use by a managed instance group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceTemplates/delete

project <> 
instanceTemplate <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project instanceTemplate]
    (instanceTemplates-delete project instanceTemplate nil))
  ([project instanceTemplate optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates/{instanceTemplate}",
     :uri-template-args
     {"instanceTemplate" instanceTemplate, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn instanceTemplates-aggregatedList
  "Retrieves the list of all InstanceTemplates resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceTemplates/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (instanceTemplates-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/instanceTemplates",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn instanceTemplates-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceTemplates/getIamPolicy

project <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project resource]
    (instanceTemplates-getIamPolicy project resource nil))
  ([project resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates/{resource}/getIamPolicy",
     :uri-template-args {"project" project, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn instanceTemplates-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceTemplates/setIamPolicy

project <> 
resource <> 
GlobalSetPolicyRequest:
GlobalSetPolicyRequest"
  [project resource GlobalSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates/{resource}/setIamPolicy",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetPolicyRequest})

(defn instanceTemplates-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceTemplates/testIamPermissions

project <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/instanceTemplates/{resource}/testIamPermissions",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn regionNetworkFirewallPolicies-getRule
  "Gets a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/getRule

project <> 
region <> 
firewallPolicy <> 

optional:
priority <integer> The priority of the rule to get from the firewall policy."
  ([project region firewallPolicy]
    (regionNetworkFirewallPolicies-getRule
      project
      region
      firewallPolicy
      nil))
  ([project region firewallPolicy optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/getRule",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionNetworkFirewallPolicies-removeRule
  "Deletes a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/removeRule

project <> 
region <> 
firewallPolicy <> 

optional:
priority <integer> The priority of the rule to remove from the firewall policy.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region firewallPolicy]
    (regionNetworkFirewallPolicies-removeRule
      project
      region
      firewallPolicy
      nil))
  ([project region firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/removeRule",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionNetworkFirewallPolicies-list
  "Lists all the network firewall policies that have been configured for the specified project in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region]
    (regionNetworkFirewallPolicies-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionNetworkFirewallPolicies-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn regionNetworkFirewallPolicies-addRule
  "Inserts a rule into a network firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/addRule

project <> 
region <> 
firewallPolicy <> 
FirewallPolicyRule:
FirewallPolicyRule

optional:
maxPriority <integer> When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
minPriority <integer> When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region firewallPolicy FirewallPolicyRule]
    (regionNetworkFirewallPolicies-addRule
      project
      region
      firewallPolicy
      FirewallPolicyRule
      nil))
  ([project region firewallPolicy FirewallPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/addRule",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyRule}))

(defn regionNetworkFirewallPolicies-cloneRules
  "Copies rules to the specified network firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/cloneRules

project <> 
region <> 
firewallPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
sourceFirewallPolicy <string> The firewall policy from which to copy rules."
  ([project region firewallPolicy]
    (regionNetworkFirewallPolicies-cloneRules
      project
      region
      firewallPolicy
      nil))
  ([project region firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/cloneRules",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionNetworkFirewallPolicies-delete
  "Deletes the specified network firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/delete

project <> 
region <> 
firewallPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region firewallPolicy]
    (regionNetworkFirewallPolicies-delete
      project
      region
      firewallPolicy
      nil))
  ([project region firewallPolicy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionNetworkFirewallPolicies-getEffectiveFirewalls
  "Returns the effective firewalls on a given network.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/getEffectiveFirewalls

project <> 
region <> 
network <> "
  [project region network]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/getEffectiveFirewalls",
   :uri-template-args {"project" project, "region" region},
   :query-params {"network" network},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionNetworkFirewallPolicies-getAssociation
  "Gets an association with the specified name.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/getAssociation

project <> 
region <> 
firewallPolicy <> 

optional:
name <string> The name of the association to get from the firewall policy."
  ([project region firewallPolicy]
    (regionNetworkFirewallPolicies-getAssociation
      project
      region
      firewallPolicy
      nil))
  ([project region firewallPolicy optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/getAssociation",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionNetworkFirewallPolicies-addAssociation
  "Inserts an association for the specified network firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/addAssociation

project <> 
region <> 
firewallPolicy <> 
FirewallPolicyAssociation:
FirewallPolicyAssociation

optional:
replaceExistingAssociation <boolean> Indicates whether or not to replace it if an association already exists. This is false by default, in which case an error will be returned if an association already exists.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region firewallPolicy FirewallPolicyAssociation]
    (regionNetworkFirewallPolicies-addAssociation
      project
      region
      firewallPolicy
      FirewallPolicyAssociation
      nil))
  ([project region firewallPolicy FirewallPolicyAssociation optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/addAssociation",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyAssociation}))

(defn regionNetworkFirewallPolicies-patch
  "Patches the specified network firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/patch

project <> 
region <> 
firewallPolicy <> 
FirewallPolicy:
FirewallPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region firewallPolicy FirewallPolicy]
    (regionNetworkFirewallPolicies-patch
      project
      region
      firewallPolicy
      FirewallPolicy
      nil))
  ([project region firewallPolicy FirewallPolicy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicy}))

(defn regionNetworkFirewallPolicies-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (regionNetworkFirewallPolicies-getIamPolicy
      project
      region
      resource
      nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionNetworkFirewallPolicies-insert
  "Creates a new network firewall policy in the specified project and region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/insert

project <> 
region <> 
FirewallPolicy:
FirewallPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region FirewallPolicy]
    (regionNetworkFirewallPolicies-insert
      project
      region
      FirewallPolicy
      nil))
  ([project region FirewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicy}))

(defn regionNetworkFirewallPolicies-patchRule
  "Patches a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/patchRule

project <> 
region <> 
firewallPolicy <> 
FirewallPolicyRule:
FirewallPolicyRule

optional:
priority <integer> The priority of the rule to patch.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region firewallPolicy FirewallPolicyRule]
    (regionNetworkFirewallPolicies-patchRule
      project
      region
      firewallPolicy
      FirewallPolicyRule
      nil))
  ([project region firewallPolicy FirewallPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/patchRule",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyRule}))

(defn regionNetworkFirewallPolicies-removeAssociation
  "Removes an association for the specified network firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/removeAssociation

project <> 
region <> 
firewallPolicy <> 

optional:
name <string> Name for the association that will be removed.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region firewallPolicy]
    (regionNetworkFirewallPolicies-removeAssociation
      project
      region
      firewallPolicy
      nil))
  ([project region firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}/removeAssociation",
     :uri-template-args
     {"firewallPolicy" firewallPolicy,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionNetworkFirewallPolicies-get
  "Returns the specified network firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/get

project <> 
region <> 
firewallPolicy <> "
  [project region firewallPolicy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{firewallPolicy}",
   :uri-template-args
   {"firewallPolicy" firewallPolicy,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionNetworkFirewallPolicies-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNetworkFirewallPolicies/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/firewallPolicies/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn interconnectLocations-list
  "Retrieves the list of interconnect locations available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectLocations/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (interconnectLocations-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnectLocations",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn interconnectLocations-get
  "Returns the details for the specified interconnect location. Gets a list of available interconnect locations by making a list() request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectLocations/get

project <> 
interconnectLocation <> "
  [project interconnectLocation]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnectLocations/{interconnectLocation}",
   :uri-template-args
   {"interconnectLocation" interconnectLocation, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn forwardingRules-list
  "Retrieves a list of ForwardingRule resources available to the specified project and region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/forwardingRules/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (forwardingRules-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/forwardingRules",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn forwardingRules-aggregatedList
  "Retrieves an aggregated list of forwarding rules. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/forwardingRules/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (forwardingRules-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/forwardingRules",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn forwardingRules-get
  "Returns the specified ForwardingRule resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/forwardingRules/get

project <> 
region <> 
forwardingRule <> "
  [project region forwardingRule]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}",
   :uri-template-args
   {"forwardingRule" forwardingRule,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn forwardingRules-insert
  "Creates a ForwardingRule resource in the specified project and region using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/forwardingRules/insert

project <> 
region <> 
ForwardingRule:
ForwardingRule

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region ForwardingRule]
    (forwardingRules-insert project region ForwardingRule nil))
  ([project region ForwardingRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/forwardingRules",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ForwardingRule}))

(defn forwardingRules-delete
  "Deletes the specified ForwardingRule resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/forwardingRules/delete

project <> 
region <> 
forwardingRule <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region forwardingRule]
    (forwardingRules-delete project region forwardingRule nil))
  ([project region forwardingRule optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}",
     :uri-template-args
     {"forwardingRule" forwardingRule,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn forwardingRules-setTarget
  "Changes target URL for forwarding rule. The new target should be of the same type as the old target.
https://cloud.google.com/products/compute/v1/reference/rest/v1/forwardingRules/setTarget

project <> 
region <> 
forwardingRule <> 
TargetReference:
TargetReference

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region forwardingRule TargetReference]
    (forwardingRules-setTarget
      project
      region
      forwardingRule
      TargetReference
      nil))
  ([project region forwardingRule TargetReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget",
     :uri-template-args
     {"forwardingRule" forwardingRule,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetReference}))

(defn forwardingRules-patch
  "Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.
https://cloud.google.com/products/compute/v1/reference/rest/v1/forwardingRules/patch

project <> 
region <> 
forwardingRule <> 
ForwardingRule:
ForwardingRule

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region forwardingRule ForwardingRule]
    (forwardingRules-patch
      project
      region
      forwardingRule
      ForwardingRule
      nil))
  ([project region forwardingRule ForwardingRule optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/forwardingRules/{forwardingRule}",
     :uri-template-args
     {"forwardingRule" forwardingRule,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ForwardingRule}))

(defn forwardingRules-setLabels
  "Sets the labels on the specified resource. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/forwardingRules/setLabels

project <> 
region <> 
resource <> 
RegionSetLabelsRequest:
RegionSetLabelsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region resource RegionSetLabelsRequest]
    (forwardingRules-setLabels
      project
      region
      resource
      RegionSetLabelsRequest
      nil))
  ([project region resource RegionSetLabelsRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/forwardingRules/{resource}/setLabels",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionSetLabelsRequest}))

(defn acceleratorTypes-list
  "Retrieves a list of accelerator types that are available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/acceleratorTypes/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (acceleratorTypes-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/acceleratorTypes",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn acceleratorTypes-aggregatedList
  "Retrieves an aggregated list of accelerator types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/acceleratorTypes/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (acceleratorTypes-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/acceleratorTypes",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn acceleratorTypes-get
  "Returns the specified accelerator type.
https://cloud.google.com/products/compute/v1/reference/rest/v1/acceleratorTypes/get

project <> 
zone <> 
acceleratorType <> "
  [project zone acceleratorType]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/acceleratorTypes/{acceleratorType}",
   :uri-template-args
   {"acceleratorType" acceleratorType, "project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionHealthChecks-list
  "Retrieves the list of HealthCheck resources available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthChecks/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionHealthChecks-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthChecks",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionHealthChecks-get
  "Returns the specified HealthCheck resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthChecks/get

project <> 
region <> 
healthCheck <> "
  [project region healthCheck]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthChecks/{healthCheck}",
   :uri-template-args
   {"healthCheck" healthCheck, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionHealthChecks-insert
  "Creates a HealthCheck resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthChecks/insert

project <> 
region <> 
HealthCheck:
HealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region HealthCheck]
    (regionHealthChecks-insert project region HealthCheck nil))
  ([project region HealthCheck optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthChecks",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HealthCheck}))

(defn regionHealthChecks-delete
  "Deletes the specified HealthCheck resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthChecks/delete

project <> 
region <> 
healthCheck <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region healthCheck]
    (regionHealthChecks-delete project region healthCheck nil))
  ([project region healthCheck optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthChecks/{healthCheck}",
     :uri-template-args
     {"healthCheck" healthCheck, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionHealthChecks-update
  "Updates a HealthCheck resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthChecks/update

project <> 
region <> 
healthCheck <> 
HealthCheck:
HealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region healthCheck HealthCheck]
    (regionHealthChecks-update
      project
      region
      healthCheck
      HealthCheck
      nil))
  ([project region healthCheck HealthCheck optional]
    {:method :put,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthChecks/{healthCheck}",
     :uri-template-args
     {"healthCheck" healthCheck, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HealthCheck}))

(defn regionHealthChecks-patch
  "Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionHealthChecks/patch

project <> 
region <> 
healthCheck <> 
HealthCheck:
HealthCheck

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region healthCheck HealthCheck]
    (regionHealthChecks-patch
      project
      region
      healthCheck
      HealthCheck
      nil))
  ([project region healthCheck HealthCheck optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/healthChecks/{healthCheck}",
     :uri-template-args
     {"healthCheck" healthCheck, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body HealthCheck}))

(defn resourcePolicies-list
  "A list all the resource policies that have been configured for the specified project in specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (resourcePolicies-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/resourcePolicies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn resourcePolicies-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn resourcePolicies-delete
  "Deletes the specified resource policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/delete

project <> 
region <> 
resourcePolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region resourcePolicy]
    (resourcePolicies-delete project region resourcePolicy nil))
  ([project region resourcePolicy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}",
     :uri-template-args
     {"project" project,
      "region" region,
      "resourcePolicy" resourcePolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn resourcePolicies-patch
  "Modify the specified resource policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/patch

project <> 
region <> 
resourcePolicy <> 
ResourcePolicy:
ResourcePolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> update_mask indicates fields to be updated as part of this request."
  ([project region resourcePolicy ResourcePolicy]
    (resourcePolicies-patch
      project
      region
      resourcePolicy
      ResourcePolicy
      nil))
  ([project region resourcePolicy ResourcePolicy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}",
     :uri-template-args
     {"project" project,
      "region" region,
      "resourcePolicy" resourcePolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ResourcePolicy}))

(defn resourcePolicies-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (resourcePolicies-getIamPolicy project region resource nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn resourcePolicies-aggregatedList
  "Retrieves an aggregated list of resource policies. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (resourcePolicies-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/resourcePolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn resourcePolicies-insert
  "Creates a new resource policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/insert

project <> 
region <> 
ResourcePolicy:
ResourcePolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region ResourcePolicy]
    (resourcePolicies-insert project region ResourcePolicy nil))
  ([project region ResourcePolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/resourcePolicies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ResourcePolicy}))

(defn resourcePolicies-get
  "Retrieves all information of the specified resource policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/get

project <> 
region <> 
resourcePolicy <> "
  [project region resourcePolicy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resourcePolicy}",
   :uri-template-args
   {"project" project,
    "region" region,
    "resourcePolicy" resourcePolicy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn resourcePolicies-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/resourcePolicies/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/resourcePolicies/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn regionInstanceTemplates-list
  "Retrieves a list of instance templates that are contained within the specified project and region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceTemplates/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionInstanceTemplates-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceTemplates",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionInstanceTemplates-get
  "Returns the specified instance template.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceTemplates/get

project <> 
region <> 
instanceTemplate <> "
  [project region instanceTemplate]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceTemplates/{instanceTemplate}",
   :uri-template-args
   {"instanceTemplate" instanceTemplate,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionInstanceTemplates-insert
  "Creates an instance template in the specified project and region using the global instance template whose URL is included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceTemplates/insert

project <> 
region <> 
InstanceTemplate:
InstanceTemplate

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region InstanceTemplate]
    (regionInstanceTemplates-insert
      project
      region
      InstanceTemplate
      nil))
  ([project region InstanceTemplate optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceTemplates",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InstanceTemplate}))

(defn regionInstanceTemplates-delete
  "Deletes the specified instance template. Deleting an instance template is permanent and cannot be undone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceTemplates/delete

project <> 
region <> 
instanceTemplate <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region instanceTemplate]
    (regionInstanceTemplates-delete
      project
      region
      instanceTemplate
      nil))
  ([project region instanceTemplate optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceTemplates/{instanceTemplate}",
     :uri-template-args
     {"instanceTemplate" instanceTemplate,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionSslPolicies-list
  "Lists all the SSL policies that have been configured for the specified project and region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslPolicies/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionSslPolicies-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslPolicies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionSslPolicies-get
  "Lists all of the ordered rules present in a single specified policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslPolicies/get

project <> 
region <> 
sslPolicy <> "
  [project region sslPolicy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslPolicies/{sslPolicy}",
   :uri-template-args
   {"project" project, "region" region, "sslPolicy" sslPolicy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionSslPolicies-insert
  "Creates a new policy in the specified project and region using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslPolicies/insert

project <> 
region <> 
SslPolicy:
SslPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region SslPolicy]
    (regionSslPolicies-insert project region SslPolicy nil))
  ([project region SslPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslPolicies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SslPolicy}))

(defn regionSslPolicies-delete
  "Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in use by any TargetHttpsProxy or TargetSslProxy resources.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslPolicies/delete

project <> 
region <> 
sslPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region sslPolicy]
    (regionSslPolicies-delete project region sslPolicy nil))
  ([project region sslPolicy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslPolicies/{sslPolicy}",
     :uri-template-args
     {"project" project, "region" region, "sslPolicy" sslPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionSslPolicies-patch
  "Patches the specified SSL policy with the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslPolicies/patch

project <> 
region <> 
sslPolicy <> 
SslPolicy:
SslPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region sslPolicy SslPolicy]
    (regionSslPolicies-patch project region sslPolicy SslPolicy nil))
  ([project region sslPolicy SslPolicy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslPolicies/{sslPolicy}",
     :uri-template-args
     {"project" project, "region" region, "sslPolicy" sslPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SslPolicy}))

(defn regionSslPolicies-listAvailableFeatures
  "Lists all features that can be specified in the SSL policy when using custom profile.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslPolicies/listAvailableFeatures

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region]
    (regionSslPolicies-listAvailableFeatures project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslPolicies/listAvailableFeatures",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn publicDelegatedPrefixes-list
  "Lists the PublicDelegatedPrefixes for a project in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/publicDelegatedPrefixes/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (publicDelegatedPrefixes-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/publicDelegatedPrefixes",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn publicDelegatedPrefixes-get
  "Returns the specified PublicDelegatedPrefix resource in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/publicDelegatedPrefixes/get

project <> 
region <> 
publicDelegatedPrefix <> "
  [project region publicDelegatedPrefix]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}",
   :uri-template-args
   {"project" project,
    "publicDelegatedPrefix" publicDelegatedPrefix,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn publicDelegatedPrefixes-insert
  "Creates a PublicDelegatedPrefix in the specified project in the given region using the parameters that are included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/publicDelegatedPrefixes/insert

project <> 
region <> 
PublicDelegatedPrefix:
PublicDelegatedPrefix

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region PublicDelegatedPrefix]
    (publicDelegatedPrefixes-insert
      project
      region
      PublicDelegatedPrefix
      nil))
  ([project region PublicDelegatedPrefix optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/publicDelegatedPrefixes",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body PublicDelegatedPrefix}))

(defn publicDelegatedPrefixes-delete
  "Deletes the specified PublicDelegatedPrefix in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/publicDelegatedPrefixes/delete

project <> 
region <> 
publicDelegatedPrefix <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region publicDelegatedPrefix]
    (publicDelegatedPrefixes-delete
      project
      region
      publicDelegatedPrefix
      nil))
  ([project region publicDelegatedPrefix optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}",
     :uri-template-args
     {"project" project,
      "publicDelegatedPrefix" publicDelegatedPrefix,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn publicDelegatedPrefixes-patch
  "Patches the specified PublicDelegatedPrefix resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/publicDelegatedPrefixes/patch

project <> 
region <> 
publicDelegatedPrefix <> 
PublicDelegatedPrefix:
PublicDelegatedPrefix

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region publicDelegatedPrefix PublicDelegatedPrefix]
    (publicDelegatedPrefixes-patch
      project
      region
      publicDelegatedPrefix
      PublicDelegatedPrefix
      nil))
  ([project
    region
    publicDelegatedPrefix
    PublicDelegatedPrefix
    optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}",
     :uri-template-args
     {"project" project,
      "publicDelegatedPrefix" publicDelegatedPrefix,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body PublicDelegatedPrefix}))

(defn publicDelegatedPrefixes-announce
  "Announces the specified PublicDelegatedPrefix in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/publicDelegatedPrefixes/announce

project <> 
region <> 
publicDelegatedPrefix <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region publicDelegatedPrefix]
    (publicDelegatedPrefixes-announce
      project
      region
      publicDelegatedPrefix
      nil))
  ([project region publicDelegatedPrefix optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}/announce",
     :uri-template-args
     {"project" project,
      "publicDelegatedPrefix" publicDelegatedPrefix,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn publicDelegatedPrefixes-withdraw
  "Withdraws the specified PublicDelegatedPrefix in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/publicDelegatedPrefixes/withdraw

project <> 
region <> 
publicDelegatedPrefix <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region publicDelegatedPrefix]
    (publicDelegatedPrefixes-withdraw
      project
      region
      publicDelegatedPrefix
      nil))
  ([project region publicDelegatedPrefix optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/publicDelegatedPrefixes/{publicDelegatedPrefix}/withdraw",
     :uri-template-args
     {"project" project,
      "publicDelegatedPrefix" publicDelegatedPrefix,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn publicDelegatedPrefixes-aggregatedList
  "Lists all PublicDelegatedPrefix resources owned by the specific project across all scopes. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/publicDelegatedPrefixes/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (publicDelegatedPrefixes-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/publicDelegatedPrefixes",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn globalOperations-list
  "Retrieves a list of Operation resources contained within the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalOperations/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (globalOperations-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/operations",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn globalOperations-aggregatedList
  "Retrieves an aggregated list of all operations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalOperations/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (globalOperations-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/operations",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn globalOperations-get
  "Retrieves the specified Operations resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalOperations/get

project <> 
operation <> "
  [project operation]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/operations/{operation}",
   :uri-template-args {"operation" operation, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn globalOperations-wait
  "Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method differs from the `GET` method in that it waits for no more than the default deadline (2 minutes) and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalOperations/wait

project <> 
operation <> "
  [project operation]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/operations/{operation}/wait",
   :uri-template-args {"operation" operation, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn globalOperations-delete
  "Deletes the specified Operations resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalOperations/delete

project <> 
operation <> "
  [project operation]
  {:method :delete,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/operations/{operation}",
   :uri-template-args {"operation" operation, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"]})

(defn networks-switchToCustomMode
  "Switches the network mode from auto subnet mode to custom subnet mode.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/switchToCustomMode

project <> 
network <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project network] (networks-switchToCustomMode project network nil))
  ([project network optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}/switchToCustomMode",
     :uri-template-args {"network" network, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn networks-list
  "Retrieves the list of networks available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (networks-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networks-delete
  "Deletes the specified network.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/delete

project <> 
network <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project network] (networks-delete project network nil))
  ([project network optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}",
     :uri-template-args {"network" network, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn networks-listPeeringRoutes
  "Lists the peering routes exchanged over peering connection.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/listPeeringRoutes

project <> 
network <> 

optional:
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
peeringName <string> The response will show routes exchanged over the given peering connection.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
direction <string> The direction of the exchanged routes.
region <string> The region of the request. The response will include all subnet routes, static routes and dynamic routes in the region.
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions."
  ([project network] (networks-listPeeringRoutes project network nil))
  ([project network optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}/listPeeringRoutes",
     :uri-template-args {"project" project, "network" network},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networks-updatePeering
  "Updates the specified network peering with the data included in the request. You can only modify the NetworkPeering.export_custom_routes field and the NetworkPeering.import_custom_routes field.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/updatePeering

project <> 
network <> 
NetworksUpdatePeeringRequest:
NetworksUpdatePeeringRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project network NetworksUpdatePeeringRequest]
    (networks-updatePeering
      project
      network
      NetworksUpdatePeeringRequest
      nil))
  ([project network NetworksUpdatePeeringRequest optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}/updatePeering",
     :uri-template-args {"network" network, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworksUpdatePeeringRequest}))

(defn networks-getEffectiveFirewalls
  "Returns the effective firewalls on a given network.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/getEffectiveFirewalls

project <> 
network <> "
  [project network]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}/getEffectiveFirewalls",
   :uri-template-args {"network" network, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn networks-patch
  "Patches the specified network with the data included in the request. Only routingConfig can be modified.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/patch

project <> 
network <> 
Network:
Network

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project network Network]
    (networks-patch project network Network nil))
  ([project network Network optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}",
     :uri-template-args {"network" network, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Network}))

(defn networks-removePeering
  "Removes a peering from the specified network.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/removePeering

project <> 
network <> 
NetworksRemovePeeringRequest:
NetworksRemovePeeringRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project network NetworksRemovePeeringRequest]
    (networks-removePeering
      project
      network
      NetworksRemovePeeringRequest
      nil))
  ([project network NetworksRemovePeeringRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}/removePeering",
     :uri-template-args {"network" network, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworksRemovePeeringRequest}))

(defn networks-insert
  "Creates a network in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/insert

project <> 
Network:
Network

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project Network] (networks-insert project Network nil))
  ([project Network optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Network}))

(defn networks-addPeering
  "Adds a peering to the specified network.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/addPeering

project <> 
network <> 
NetworksAddPeeringRequest:
NetworksAddPeeringRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project network NetworksAddPeeringRequest]
    (networks-addPeering
      project
      network
      NetworksAddPeeringRequest
      nil))
  ([project network NetworksAddPeeringRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}/addPeering",
     :uri-template-args {"network" network, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworksAddPeeringRequest}))

(defn networks-get
  "Returns the specified network.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networks/get

project <> 
network <> "
  [project network]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/networks/{network}",
   :uri-template-args {"network" network, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn networkFirewallPolicies-getRule
  "Gets a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/getRule

project <> 
firewallPolicy <> 

optional:
priority <integer> The priority of the rule to get from the firewall policy."
  ([project firewallPolicy]
    (networkFirewallPolicies-getRule project firewallPolicy nil))
  ([project firewallPolicy optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}/getRule",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkFirewallPolicies-removeRule
  "Deletes a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/removeRule

project <> 
firewallPolicy <> 

optional:
priority <integer> The priority of the rule to remove from the firewall policy.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewallPolicy]
    (networkFirewallPolicies-removeRule project firewallPolicy nil))
  ([project firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}/removeRule",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn networkFirewallPolicies-list
  "Lists all the policies that have been configured for the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (networkFirewallPolicies-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkFirewallPolicies-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/setIamPolicy

project <> 
resource <> 
GlobalSetPolicyRequest:
GlobalSetPolicyRequest"
  [project resource GlobalSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{resource}/setIamPolicy",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetPolicyRequest})

(defn networkFirewallPolicies-addRule
  "Inserts a rule into a firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/addRule

project <> 
firewallPolicy <> 
FirewallPolicyRule:
FirewallPolicyRule

optional:
maxPriority <integer> When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
minPriority <integer> When rule.priority is not specified, auto choose a unused priority between minPriority and maxPriority>. This field is exclusive with rule.priority.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewallPolicy FirewallPolicyRule]
    (networkFirewallPolicies-addRule
      project
      firewallPolicy
      FirewallPolicyRule
      nil))
  ([project firewallPolicy FirewallPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}/addRule",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyRule}))

(defn networkFirewallPolicies-cloneRules
  "Copies rules to the specified firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/cloneRules

project <> 
firewallPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
sourceFirewallPolicy <string> The firewall policy from which to copy rules."
  ([project firewallPolicy]
    (networkFirewallPolicies-cloneRules project firewallPolicy nil))
  ([project firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}/cloneRules",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn networkFirewallPolicies-delete
  "Deletes the specified policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/delete

project <> 
firewallPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewallPolicy]
    (networkFirewallPolicies-delete project firewallPolicy nil))
  ([project firewallPolicy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn networkFirewallPolicies-getAssociation
  "Gets an association with the specified name.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/getAssociation

project <> 
firewallPolicy <> 

optional:
name <string> The name of the association to get from the firewall policy."
  ([project firewallPolicy]
    (networkFirewallPolicies-getAssociation
      project
      firewallPolicy
      nil))
  ([project firewallPolicy optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}/getAssociation",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkFirewallPolicies-addAssociation
  "Inserts an association for the specified firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/addAssociation

project <> 
firewallPolicy <> 
FirewallPolicyAssociation:
FirewallPolicyAssociation

optional:
replaceExistingAssociation <boolean> Indicates whether or not to replace it if an association of the attachment already exists. This is false by default, in which case an error will be returned if an association already exists.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewallPolicy FirewallPolicyAssociation]
    (networkFirewallPolicies-addAssociation
      project
      firewallPolicy
      FirewallPolicyAssociation
      nil))
  ([project firewallPolicy FirewallPolicyAssociation optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}/addAssociation",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyAssociation}))

(defn networkFirewallPolicies-patch
  "Patches the specified policy with the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/patch

project <> 
firewallPolicy <> 
FirewallPolicy:
FirewallPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewallPolicy FirewallPolicy]
    (networkFirewallPolicies-patch
      project
      firewallPolicy
      FirewallPolicy
      nil))
  ([project firewallPolicy FirewallPolicy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicy}))

(defn networkFirewallPolicies-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/getIamPolicy

project <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project resource]
    (networkFirewallPolicies-getIamPolicy project resource nil))
  ([project resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{resource}/getIamPolicy",
     :uri-template-args {"project" project, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkFirewallPolicies-insert
  "Creates a new policy in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/insert

project <> 
FirewallPolicy:
FirewallPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project FirewallPolicy]
    (networkFirewallPolicies-insert project FirewallPolicy nil))
  ([project FirewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicy}))

(defn networkFirewallPolicies-patchRule
  "Patches a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/patchRule

project <> 
firewallPolicy <> 
FirewallPolicyRule:
FirewallPolicyRule

optional:
priority <integer> The priority of the rule to patch.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewallPolicy FirewallPolicyRule]
    (networkFirewallPolicies-patchRule
      project
      firewallPolicy
      FirewallPolicyRule
      nil))
  ([project firewallPolicy FirewallPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}/patchRule",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyRule}))

(defn networkFirewallPolicies-removeAssociation
  "Removes an association for the specified firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/removeAssociation

project <> 
firewallPolicy <> 

optional:
name <string> Name for the attachment that will be removed.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewallPolicy]
    (networkFirewallPolicies-removeAssociation
      project
      firewallPolicy
      nil))
  ([project firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}/removeAssociation",
     :uri-template-args
     {"firewallPolicy" firewallPolicy, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn networkFirewallPolicies-get
  "Returns the specified network firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/get

project <> 
firewallPolicy <> "
  [project firewallPolicy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{firewallPolicy}",
   :uri-template-args
   {"firewallPolicy" firewallPolicy, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn networkFirewallPolicies-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkFirewallPolicies/testIamPermissions

project <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewallPolicies/{resource}/testIamPermissions",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn regionNotificationEndpoints-list
  "Lists the NotificationEndpoints for a project in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNotificationEndpoints/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region]
    (regionNotificationEndpoints-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/notificationEndpoints",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionNotificationEndpoints-get
  "Returns the specified NotificationEndpoint resource in the given region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNotificationEndpoints/get

project <> 
region <> 
notificationEndpoint <> "
  [project region notificationEndpoint]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}",
   :uri-template-args
   {"notificationEndpoint" notificationEndpoint,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionNotificationEndpoints-insert
  "Create a NotificationEndpoint in the specified project in the given region using the parameters that are included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNotificationEndpoints/insert

project <> 
region <> 
NotificationEndpoint:
NotificationEndpoint

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region NotificationEndpoint]
    (regionNotificationEndpoints-insert
      project
      region
      NotificationEndpoint
      nil))
  ([project region NotificationEndpoint optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/notificationEndpoints",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NotificationEndpoint}))

(defn regionNotificationEndpoints-delete
  "Deletes the specified NotificationEndpoint in the given region
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionNotificationEndpoints/delete

project <> 
region <> 
notificationEndpoint <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region notificationEndpoint]
    (regionNotificationEndpoints-delete
      project
      region
      notificationEndpoint
      nil))
  ([project region notificationEndpoint optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/notificationEndpoints/{notificationEndpoint}",
     :uri-template-args
     {"notificationEndpoint" notificationEndpoint,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn targetPools-list
  "Retrieves a list of target pools available to the specified project and region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (targetPools-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn targetPools-removeInstance
  "Removes instance URL from a target pool.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/removeInstance

project <> 
region <> 
targetPool <> 
TargetPoolsRemoveInstanceRequest:
TargetPoolsRemoveInstanceRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetPool TargetPoolsRemoveInstanceRequest]
    (targetPools-removeInstance
      project
      region
      targetPool
      TargetPoolsRemoveInstanceRequest
      nil))
  ([project
    region
    targetPool
    TargetPoolsRemoveInstanceRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}/removeInstance",
     :uri-template-args
     {"project" project, "region" region, "targetPool" targetPool},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetPoolsRemoveInstanceRequest}))

(defn targetPools-delete
  "Deletes the specified target pool.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/delete

project <> 
region <> 
targetPool <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetPool]
    (targetPools-delete project region targetPool nil))
  ([project region targetPool optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}",
     :uri-template-args
     {"project" project, "region" region, "targetPool" targetPool},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn targetPools-addInstance
  "Adds an instance to a target pool.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/addInstance

project <> 
region <> 
targetPool <> 
TargetPoolsAddInstanceRequest:
TargetPoolsAddInstanceRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetPool TargetPoolsAddInstanceRequest]
    (targetPools-addInstance
      project
      region
      targetPool
      TargetPoolsAddInstanceRequest
      nil))
  ([project region targetPool TargetPoolsAddInstanceRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}/addInstance",
     :uri-template-args
     {"project" project, "region" region, "targetPool" targetPool},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetPoolsAddInstanceRequest}))

(defn targetPools-getHealth
  "Gets the most recent health check results for each IP for the instance that is referenced by the given target pool.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/getHealth

project <> 
region <> 
targetPool <> 
InstanceReference:
InstanceReference"
  [project region targetPool InstanceReference]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}/getHealth",
   :uri-template-args
   {"project" project, "region" region, "targetPool" targetPool},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body InstanceReference})

(defn targetPools-removeHealthCheck
  "Removes health check URL from a target pool.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/removeHealthCheck

project <> 
region <> 
targetPool <> 
TargetPoolsRemoveHealthCheckRequest:
TargetPoolsRemoveHealthCheckRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetPool TargetPoolsRemoveHealthCheckRequest]
    (targetPools-removeHealthCheck
      project
      region
      targetPool
      TargetPoolsRemoveHealthCheckRequest
      nil))
  ([project
    region
    targetPool
    TargetPoolsRemoveHealthCheckRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck",
     :uri-template-args
     {"project" project, "region" region, "targetPool" targetPool},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetPoolsRemoveHealthCheckRequest}))

(defn targetPools-aggregatedList
  "Retrieves an aggregated list of target pools. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (targetPools-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/targetPools",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn targetPools-insert
  "Creates a target pool in the specified project and region using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/insert

project <> 
region <> 
TargetPool:
TargetPool

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region TargetPool]
    (targetPools-insert project region TargetPool nil))
  ([project region TargetPool optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetPool}))

(defn targetPools-addHealthCheck
  "Adds health check URLs to a target pool.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/addHealthCheck

project <> 
region <> 
targetPool <> 
TargetPoolsAddHealthCheckRequest:
TargetPoolsAddHealthCheckRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetPool TargetPoolsAddHealthCheckRequest]
    (targetPools-addHealthCheck
      project
      region
      targetPool
      TargetPoolsAddHealthCheckRequest
      nil))
  ([project
    region
    targetPool
    TargetPoolsAddHealthCheckRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck",
     :uri-template-args
     {"project" project, "region" region, "targetPool" targetPool},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetPoolsAddHealthCheckRequest}))

(defn targetPools-setSecurityPolicy
  "Sets the Google Cloud Armor security policy for the specified target pool. For more information, see Google Cloud Armor Overview
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/setSecurityPolicy

project <> 
region <> 
targetPool <> 
SecurityPolicyReference:
SecurityPolicyReference

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetPool SecurityPolicyReference]
    (targetPools-setSecurityPolicy
      project
      region
      targetPool
      SecurityPolicyReference
      nil))
  ([project region targetPool SecurityPolicyReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}/setSecurityPolicy",
     :uri-template-args
     {"project" project, "region" region, "targetPool" targetPool},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyReference}))

(defn targetPools-setBackup
  "Changes a backup target pool's configurations.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/setBackup

project <> 
region <> 
targetPool <> 
TargetReference:
TargetReference

optional:
failoverRatio <number> New failoverRatio value for the target pool.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetPool TargetReference]
    (targetPools-setBackup
      project
      region
      targetPool
      TargetReference
      nil))
  ([project region targetPool TargetReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}/setBackup",
     :uri-template-args
     {"project" project, "region" region, "targetPool" targetPool},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetReference}))

(defn targetPools-get
  "Returns the specified target pool.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetPools/get

project <> 
region <> 
targetPool <> "
  [project region targetPool]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetPools/{targetPool}",
   :uri-template-args
   {"project" project, "region" region, "targetPool" targetPool},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn interconnectAttachments-list
  "Retrieves the list of interconnect attachments contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectAttachments/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (interconnectAttachments-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/interconnectAttachments",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn interconnectAttachments-aggregatedList
  "Retrieves an aggregated list of interconnect attachments. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectAttachments/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (interconnectAttachments-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/interconnectAttachments",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn interconnectAttachments-get
  "Returns the specified interconnect attachment.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectAttachments/get

project <> 
region <> 
interconnectAttachment <> "
  [project region interconnectAttachment]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}",
   :uri-template-args
   {"interconnectAttachment" interconnectAttachment,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn interconnectAttachments-insert
  "Creates an InterconnectAttachment in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectAttachments/insert

project <> 
region <> 
InterconnectAttachment:
InterconnectAttachment

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
validateOnly <boolean> If true, the request will not be committed."
  ([project region InterconnectAttachment]
    (interconnectAttachments-insert
      project
      region
      InterconnectAttachment
      nil))
  ([project region InterconnectAttachment optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/interconnectAttachments",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InterconnectAttachment}))

(defn interconnectAttachments-patch
  "Updates the specified interconnect attachment with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectAttachments/patch

project <> 
region <> 
interconnectAttachment <> 
InterconnectAttachment:
InterconnectAttachment

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region interconnectAttachment InterconnectAttachment]
    (interconnectAttachments-patch
      project
      region
      interconnectAttachment
      InterconnectAttachment
      nil))
  ([project
    region
    interconnectAttachment
    InterconnectAttachment
    optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}",
     :uri-template-args
     {"interconnectAttachment" interconnectAttachment,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InterconnectAttachment}))

(defn interconnectAttachments-delete
  "Deletes the specified interconnect attachment.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectAttachments/delete

project <> 
region <> 
interconnectAttachment <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region interconnectAttachment]
    (interconnectAttachments-delete
      project
      region
      interconnectAttachment
      nil))
  ([project region interconnectAttachment optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/interconnectAttachments/{interconnectAttachment}",
     :uri-template-args
     {"interconnectAttachment" interconnectAttachment,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn interconnectAttachments-setLabels
  "Sets the labels on an InterconnectAttachment. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectAttachments/setLabels

project <> 
region <> 
resource <> 
RegionSetLabelsRequest:
RegionSetLabelsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region resource RegionSetLabelsRequest]
    (interconnectAttachments-setLabels
      project
      region
      resource
      RegionSetLabelsRequest
      nil))
  ([project region resource RegionSetLabelsRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/interconnectAttachments/{resource}/setLabels",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionSetLabelsRequest}))

(defn targetVpnGateways-list
  "Retrieves a list of target VPN gateways available to the specified project and region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetVpnGateways/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (targetVpnGateways-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetVpnGateways",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn targetVpnGateways-aggregatedList
  "Retrieves an aggregated list of target VPN gateways. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetVpnGateways/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (targetVpnGateways-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/targetVpnGateways",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn targetVpnGateways-get
  "Returns the specified target VPN gateway.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetVpnGateways/get

project <> 
region <> 
targetVpnGateway <> "
  [project region targetVpnGateway]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}",
   :uri-template-args
   {"project" project,
    "region" region,
    "targetVpnGateway" targetVpnGateway},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn targetVpnGateways-insert
  "Creates a target VPN gateway in the specified project and region using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetVpnGateways/insert

project <> 
region <> 
TargetVpnGateway:
TargetVpnGateway

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region TargetVpnGateway]
    (targetVpnGateways-insert project region TargetVpnGateway nil))
  ([project region TargetVpnGateway optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetVpnGateways",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body TargetVpnGateway}))

(defn targetVpnGateways-delete
  "Deletes the specified target VPN gateway.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetVpnGateways/delete

project <> 
region <> 
targetVpnGateway <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region targetVpnGateway]
    (targetVpnGateways-delete project region targetVpnGateway nil))
  ([project region targetVpnGateway optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}",
     :uri-template-args
     {"project" project,
      "region" region,
      "targetVpnGateway" targetVpnGateway},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn targetVpnGateways-setLabels
  "Sets the labels on a TargetVpnGateway. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/targetVpnGateways/setLabels

project <> 
region <> 
resource <> 
RegionSetLabelsRequest:
RegionSetLabelsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region resource RegionSetLabelsRequest]
    (targetVpnGateways-setLabels
      project
      region
      resource
      RegionSetLabelsRequest
      nil))
  ([project region resource RegionSetLabelsRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/targetVpnGateways/{resource}/setLabels",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionSetLabelsRequest}))

(defn regionOperations-list
  "Retrieves a list of Operation resources contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionOperations/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionOperations-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/operations",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionOperations-get
  "Retrieves the specified region-specific Operations resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionOperations/get

project <> 
region <> 
operation <> "
  [project region operation]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/operations/{operation}",
   :uri-template-args
   {"operation" operation, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionOperations-wait
  "Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method differs from the `GET` method in that it waits for no more than the default deadline (2 minutes) and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`. 
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionOperations/wait

project <> 
region <> 
operation <> "
  [project region operation]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/operations/{operation}/wait",
   :uri-template-args
   {"operation" operation, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionOperations-delete
  "Deletes the specified region-specific Operations resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionOperations/delete

project <> 
region <> 
operation <> "
  [project region operation]
  {:method :delete,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/operations/{operation}",
   :uri-template-args
   {"operation" operation, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"]})

(defn sslPolicies-list
  "Lists all the SSL policies that have been configured for the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslPolicies/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (sslPolicies-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslPolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn sslPolicies-get
  "Lists all of the ordered rules present in a single specified policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslPolicies/get

project <> 
sslPolicy <> "
  [project sslPolicy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslPolicies/{sslPolicy}",
   :uri-template-args {"project" project, "sslPolicy" sslPolicy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn sslPolicies-insert
  "Returns the specified SSL policy resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslPolicies/insert

project <> 
SslPolicy:
SslPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project SslPolicy] (sslPolicies-insert project SslPolicy nil))
  ([project SslPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslPolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SslPolicy}))

(defn sslPolicies-delete
  "Deletes the specified SSL policy. The SSL policy resource can be deleted only if it is not in use by any TargetHttpsProxy or TargetSslProxy resources.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslPolicies/delete

project <> 
sslPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project sslPolicy] (sslPolicies-delete project sslPolicy nil))
  ([project sslPolicy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslPolicies/{sslPolicy}",
     :uri-template-args {"project" project, "sslPolicy" sslPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn sslPolicies-patch
  "Patches the specified SSL policy with the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslPolicies/patch

project <> 
sslPolicy <> 
SslPolicy:
SslPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project sslPolicy SslPolicy]
    (sslPolicies-patch project sslPolicy SslPolicy nil))
  ([project sslPolicy SslPolicy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslPolicies/{sslPolicy}",
     :uri-template-args {"project" project, "sslPolicy" sslPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SslPolicy}))

(defn sslPolicies-listAvailableFeatures
  "Lists all features that can be specified in the SSL policy when using custom profile.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslPolicies/listAvailableFeatures

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (sslPolicies-listAvailableFeatures project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslPolicies/listAvailableFeatures",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn sslPolicies-aggregatedList
  "Retrieves the list of all SslPolicy resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslPolicies/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (sslPolicies-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/sslPolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn securityPolicies-setLabels
  "Sets the labels on a security policy. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/setLabels

project <> 
resource <> 
GlobalSetLabelsRequest:
GlobalSetLabelsRequest"
  [project resource GlobalSetLabelsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/{resource}/setLabels",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetLabelsRequest})

(defn securityPolicies-getRule
  "Gets a rule at the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/getRule

project <> 
securityPolicy <> 

optional:
priority <integer> The priority of the rule to get from the security policy."
  ([project securityPolicy]
    (securityPolicies-getRule project securityPolicy nil))
  ([project securityPolicy optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/{securityPolicy}/getRule",
     :uri-template-args
     {"project" project, "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn securityPolicies-removeRule
  "Deletes a rule at the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/removeRule

project <> 
securityPolicy <> 

optional:
priority <integer> The priority of the rule to remove from the security policy."
  ([project securityPolicy]
    (securityPolicies-removeRule project securityPolicy nil))
  ([project securityPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/{securityPolicy}/removeRule",
     :uri-template-args
     {"project" project, "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn securityPolicies-list
  "List all the policies that have been configured for the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (securityPolicies-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn securityPolicies-addRule
  "Inserts a rule into a security policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/addRule

project <> 
securityPolicy <> 
SecurityPolicyRule:
SecurityPolicyRule

optional:
validateOnly <boolean> If true, the request will not be committed."
  ([project securityPolicy SecurityPolicyRule]
    (securityPolicies-addRule
      project
      securityPolicy
      SecurityPolicyRule
      nil))
  ([project securityPolicy SecurityPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/{securityPolicy}/addRule",
     :uri-template-args
     {"project" project, "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyRule}))

(defn securityPolicies-listPreconfiguredExpressionSets
  "Gets the current list of preconfigured Web Application Firewall (WAF) expressions.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/listPreconfiguredExpressionSets

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project]
    (securityPolicies-listPreconfiguredExpressionSets project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/listPreconfiguredExpressionSets",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn securityPolicies-delete
  "Deletes the specified policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/delete

project <> 
securityPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project securityPolicy]
    (securityPolicies-delete project securityPolicy nil))
  ([project securityPolicy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/{securityPolicy}",
     :uri-template-args
     {"project" project, "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn securityPolicies-patch
  "Patches the specified policy with the data included in the request. To clear fields in the policy, leave the fields empty and specify them in the updateMask. This cannot be used to be update the rules in the policy. Please use the per rule methods like addRule, patchRule, and removeRule instead.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/patch

project <> 
securityPolicy <> 
SecurityPolicy:
SecurityPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> Indicates fields to be cleared as part of this request."
  ([project securityPolicy SecurityPolicy]
    (securityPolicies-patch project securityPolicy SecurityPolicy nil))
  ([project securityPolicy SecurityPolicy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/{securityPolicy}",
     :uri-template-args
     {"project" project, "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicy}))

(defn securityPolicies-aggregatedList
  "Retrieves the list of all SecurityPolicy resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (securityPolicies-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/securityPolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn securityPolicies-insert
  "Creates a new policy in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/insert

project <> 
SecurityPolicy:
SecurityPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
validateOnly <boolean> If true, the request will not be committed."
  ([project SecurityPolicy]
    (securityPolicies-insert project SecurityPolicy nil))
  ([project SecurityPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicy}))

(defn securityPolicies-patchRule
  "Patches a rule at the specified priority. To clear fields in the rule, leave the fields empty and specify them in the updateMask.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/patchRule

project <> 
securityPolicy <> 
SecurityPolicyRule:
SecurityPolicyRule

optional:
priority <integer> The priority of the rule to patch.
updateMask <string> Indicates fields to be cleared as part of this request.
validateOnly <boolean> If true, the request will not be committed."
  ([project securityPolicy SecurityPolicyRule]
    (securityPolicies-patchRule
      project
      securityPolicy
      SecurityPolicyRule
      nil))
  ([project securityPolicy SecurityPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/{securityPolicy}/patchRule",
     :uri-template-args
     {"project" project, "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyRule}))

(defn securityPolicies-get
  "List all of the ordered rules present in a single specified policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/securityPolicies/get

project <> 
securityPolicy <> "
  [project securityPolicy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/securityPolicies/{securityPolicy}",
   :uri-template-args
   {"project" project, "securityPolicy" securityPolicy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn nodeGroups-deleteNodes
  "Deletes specified nodes from the node group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/deleteNodes

project <> 
zone <> 
nodeGroup <> 
NodeGroupsDeleteNodesRequest:
NodeGroupsDeleteNodesRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone nodeGroup NodeGroupsDeleteNodesRequest]
    (nodeGroups-deleteNodes
      project
      zone
      nodeGroup
      NodeGroupsDeleteNodesRequest
      nil))
  ([project zone nodeGroup NodeGroupsDeleteNodesRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/deleteNodes",
     :uri-template-args
     {"nodeGroup" nodeGroup, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NodeGroupsDeleteNodesRequest}))

(defn nodeGroups-list
  "Retrieves a list of node groups available to the specified project. Note: use nodeGroups.listNodes for more details about each group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (nodeGroups-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeGroups-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/setIamPolicy

project <> 
zone <> 
resource <> 
ZoneSetPolicyRequest:
ZoneSetPolicyRequest"
  [project zone resource ZoneSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "resource" resource, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body ZoneSetPolicyRequest})

(defn nodeGroups-simulateMaintenanceEvent
  "Simulates maintenance event on specified nodes from the node group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/simulateMaintenanceEvent

project <> 
zone <> 
nodeGroup <> 
NodeGroupsSimulateMaintenanceEventRequest:
NodeGroupsSimulateMaintenanceEventRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone nodeGroup NodeGroupsSimulateMaintenanceEventRequest]
    (nodeGroups-simulateMaintenanceEvent
      project
      zone
      nodeGroup
      NodeGroupsSimulateMaintenanceEventRequest
      nil))
  ([project
    zone
    nodeGroup
    NodeGroupsSimulateMaintenanceEventRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/simulateMaintenanceEvent",
     :uri-template-args
     {"nodeGroup" nodeGroup, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NodeGroupsSimulateMaintenanceEventRequest}))

(defn nodeGroups-delete
  "Deletes the specified NodeGroup resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/delete

project <> 
zone <> 
nodeGroup <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone nodeGroup]
    (nodeGroups-delete project zone nodeGroup nil))
  ([project zone nodeGroup optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}",
     :uri-template-args
     {"nodeGroup" nodeGroup, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn nodeGroups-addNodes
  "Adds specified number of nodes to the node group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/addNodes

project <> 
zone <> 
nodeGroup <> 
NodeGroupsAddNodesRequest:
NodeGroupsAddNodesRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone nodeGroup NodeGroupsAddNodesRequest]
    (nodeGroups-addNodes
      project
      zone
      nodeGroup
      NodeGroupsAddNodesRequest
      nil))
  ([project zone nodeGroup NodeGroupsAddNodesRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/addNodes",
     :uri-template-args
     {"nodeGroup" nodeGroup, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NodeGroupsAddNodesRequest}))

(defn nodeGroups-listNodes
  "Lists nodes in the node group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/listNodes

project <> 
zone <> 
nodeGroup <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone nodeGroup]
    (nodeGroups-listNodes project zone nodeGroup nil))
  ([project zone nodeGroup optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/listNodes",
     :uri-template-args
     {"nodeGroup" nodeGroup, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeGroups-patch
  "Updates the specified node group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/patch

project <> 
zone <> 
nodeGroup <> 
NodeGroup:
NodeGroup

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone nodeGroup NodeGroup]
    (nodeGroups-patch project zone nodeGroup NodeGroup nil))
  ([project zone nodeGroup NodeGroup optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}",
     :uri-template-args
     {"nodeGroup" nodeGroup, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NodeGroup}))

(defn nodeGroups-setNodeTemplate
  "Updates the node template of the node group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/setNodeTemplate

project <> 
zone <> 
nodeGroup <> 
NodeGroupsSetNodeTemplateRequest:
NodeGroupsSetNodeTemplateRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone nodeGroup NodeGroupsSetNodeTemplateRequest]
    (nodeGroups-setNodeTemplate
      project
      zone
      nodeGroup
      NodeGroupsSetNodeTemplateRequest
      nil))
  ([project zone nodeGroup NodeGroupsSetNodeTemplateRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/setNodeTemplate",
     :uri-template-args
     {"nodeGroup" nodeGroup, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NodeGroupsSetNodeTemplateRequest}))

(defn nodeGroups-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/getIamPolicy

project <> 
zone <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project zone resource]
    (nodeGroups-getIamPolicy project zone resource nil))
  ([project zone resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "resource" resource, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeGroups-aggregatedList
  "Retrieves an aggregated list of node groups. Note: use nodeGroups.listNodes for more details about each group. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (nodeGroups-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/nodeGroups",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeGroups-insert
  "Creates a NodeGroup resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/insert

project <> 
zone <> 
initialNodeCount <> 
NodeGroup:
NodeGroup

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone initialNodeCount NodeGroup]
    (nodeGroups-insert project zone initialNodeCount NodeGroup nil))
  ([project zone initialNodeCount NodeGroup optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups",
     :uri-template-args {"project" project, "zone" zone},
     :query-params
     (merge {"initialNodeCount" initialNodeCount} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NodeGroup}))

(defn nodeGroups-get
  "Returns the specified NodeGroup. Get a list of available NodeGroups by making a list() request. Note: the \"nodes\" field should not be used. Use nodeGroups.listNodes instead.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/get

project <> 
zone <> 
nodeGroup <> "
  [project zone nodeGroup]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}",
   :uri-template-args
   {"nodeGroup" nodeGroup, "project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn nodeGroups-performMaintenance
  "Perform maintenance on a subset of nodes in the node group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/performMaintenance

project <> 
zone <> 
nodeGroup <> 
NodeGroupsPerformMaintenanceRequest:
NodeGroupsPerformMaintenanceRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone nodeGroup NodeGroupsPerformMaintenanceRequest]
    (nodeGroups-performMaintenance
      project
      zone
      nodeGroup
      NodeGroupsPerformMaintenanceRequest
      nil))
  ([project
    zone
    nodeGroup
    NodeGroupsPerformMaintenanceRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/performMaintenance",
     :uri-template-args
     {"nodeGroup" nodeGroup, "project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NodeGroupsPerformMaintenanceRequest}))

(defn nodeGroups-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeGroups/testIamPermissions

project <> 
zone <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project zone resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "resource" resource, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn instantSnapshots-setLabels
  "Sets the labels on a instantSnapshot in the given zone. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/setLabels

project <> 
zone <> 
resource <> 
ZoneSetLabelsRequest:
ZoneSetLabelsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone resource ZoneSetLabelsRequest]
    (instantSnapshots-setLabels
      project
      zone
      resource
      ZoneSetLabelsRequest
      nil))
  ([project zone resource ZoneSetLabelsRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instantSnapshots/{resource}/setLabels",
     :uri-template-args
     {"project" project, "resource" resource, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ZoneSetLabelsRequest}))

(defn instantSnapshots-list
  "Retrieves the list of InstantSnapshot resources contained within the specified zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (instantSnapshots-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instantSnapshots",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn instantSnapshots-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/setIamPolicy

project <> 
zone <> 
resource <> 
ZoneSetPolicyRequest:
ZoneSetPolicyRequest"
  [project zone resource ZoneSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instantSnapshots/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "resource" resource, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body ZoneSetPolicyRequest})

(defn instantSnapshots-delete
  "Deletes the specified InstantSnapshot resource. Keep in mind that deleting a single instantSnapshot might not necessarily delete all the data on that instantSnapshot. If any data on the instantSnapshot that is marked for deletion is needed for subsequent instantSnapshots, the data will be moved to the next corresponding instantSnapshot. For more information, see Deleting instantSnapshots.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/delete

project <> 
zone <> 
instantSnapshot <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone instantSnapshot]
    (instantSnapshots-delete project zone instantSnapshot nil))
  ([project zone instantSnapshot optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instantSnapshots/{instantSnapshot}",
     :uri-template-args
     {"instantSnapshot" instantSnapshot,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn instantSnapshots-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/getIamPolicy

project <> 
zone <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project zone resource]
    (instantSnapshots-getIamPolicy project zone resource nil))
  ([project zone resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instantSnapshots/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "resource" resource, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn instantSnapshots-aggregatedList
  "Retrieves an aggregated list of instantSnapshots. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (instantSnapshots-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/instantSnapshots",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn instantSnapshots-insert
  "Creates an instant snapshot in the specified zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/insert

project <> 
zone <> 
InstantSnapshot:
InstantSnapshot

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone InstantSnapshot]
    (instantSnapshots-insert project zone InstantSnapshot nil))
  ([project zone InstantSnapshot optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instantSnapshots",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InstantSnapshot}))

(defn instantSnapshots-get
  "Returns the specified InstantSnapshot resource in the specified zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/get

project <> 
zone <> 
instantSnapshot <> "
  [project zone instantSnapshot]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instantSnapshots/{instantSnapshot}",
   :uri-template-args
   {"instantSnapshot" instantSnapshot, "project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn instantSnapshots-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instantSnapshots/testIamPermissions

project <> 
zone <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project zone resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instantSnapshots/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "resource" resource, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn firewalls-list
  "Retrieves the list of firewall rules available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewalls/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (firewalls-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewalls",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn firewalls-get
  "Returns the specified firewall.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewalls/get

project <> 
firewall <> "
  [project firewall]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewalls/{firewall}",
   :uri-template-args {"firewall" firewall, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn firewalls-insert
  "Creates a firewall rule in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewalls/insert

project <> 
Firewall:
Firewall

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project Firewall] (firewalls-insert project Firewall nil))
  ([project Firewall optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewalls",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Firewall}))

(defn firewalls-delete
  "Deletes the specified firewall.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewalls/delete

project <> 
firewall <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewall] (firewalls-delete project firewall nil))
  ([project firewall optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewalls/{firewall}",
     :uri-template-args {"firewall" firewall, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn firewalls-update
  "Updates the specified firewall rule with the data included in the request. Note that all fields will be updated if using PUT, even fields that are not specified. To update individual fields, please use PATCH instead.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewalls/update

project <> 
firewall <> 
Firewall:
Firewall

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewall Firewall]
    (firewalls-update project firewall Firewall nil))
  ([project firewall Firewall optional]
    {:method :put,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewalls/{firewall}",
     :uri-template-args {"firewall" firewall, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Firewall}))

(defn firewalls-patch
  "Updates the specified firewall rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewalls/patch

project <> 
firewall <> 
Firewall:
Firewall

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project firewall Firewall]
    (firewalls-patch project firewall Firewall nil))
  ([project firewall Firewall optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/firewalls/{firewall}",
     :uri-template-args {"firewall" firewall, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Firewall}))

(defn regionInstanceGroups-list
  "Retrieves the list of instance group resources contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroups/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionInstanceGroups-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroups",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionInstanceGroups-get
  "Returns the specified instance group resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroups/get

project <> 
region <> 
instanceGroup <> "
  [project region instanceGroup]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroups/{instanceGroup}",
   :uri-template-args
   {"instanceGroup" instanceGroup, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionInstanceGroups-listInstances
  "Lists the instances in the specified instance group and displays information about the named ports. Depending on the specified options, this method can list all instances or only the instances that are running. The orderBy query parameter is not supported.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroups/listInstances

project <> 
region <> 
instanceGroup <> 
RegionInstanceGroupsListInstancesRequest:
RegionInstanceGroupsListInstancesRequest

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project
    region
    instanceGroup
    RegionInstanceGroupsListInstancesRequest]
    (regionInstanceGroups-listInstances
      project
      region
      instanceGroup
      RegionInstanceGroupsListInstancesRequest
      nil))
  ([project
    region
    instanceGroup
    RegionInstanceGroupsListInstancesRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/listInstances",
     :uri-template-args
     {"instanceGroup" instanceGroup,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"],
     :body RegionInstanceGroupsListInstancesRequest}))

(defn regionInstanceGroups-setNamedPorts
  "Sets the named ports for the specified regional instance group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionInstanceGroups/setNamedPorts

project <> 
region <> 
instanceGroup <> 
RegionInstanceGroupsSetNamedPortsRequest:
RegionInstanceGroupsSetNamedPortsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    region
    instanceGroup
    RegionInstanceGroupsSetNamedPortsRequest]
    (regionInstanceGroups-setNamedPorts
      project
      region
      instanceGroup
      RegionInstanceGroupsSetNamedPortsRequest
      nil))
  ([project
    region
    instanceGroup
    RegionInstanceGroupsSetNamedPortsRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/instanceGroups/{instanceGroup}/setNamedPorts",
     :uri-template-args
     {"instanceGroup" instanceGroup,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionInstanceGroupsSetNamedPortsRequest}))

(defn regionAutoscalers-list
  "Retrieves a list of autoscalers contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionAutoscalers/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionAutoscalers-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/autoscalers",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionAutoscalers-get
  "Returns the specified autoscaler.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionAutoscalers/get

project <> 
region <> 
autoscaler <> "
  [project region autoscaler]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/autoscalers/{autoscaler}",
   :uri-template-args
   {"autoscaler" autoscaler, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionAutoscalers-insert
  "Creates an autoscaler in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionAutoscalers/insert

project <> 
region <> 
Autoscaler:
Autoscaler

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region Autoscaler]
    (regionAutoscalers-insert project region Autoscaler nil))
  ([project region Autoscaler optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/autoscalers",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Autoscaler}))

(defn regionAutoscalers-update
  "Updates an autoscaler in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionAutoscalers/update

project <> 
region <> 
Autoscaler:
Autoscaler

optional:
autoscaler <string> Name of the autoscaler to update.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region Autoscaler]
    (regionAutoscalers-update project region Autoscaler nil))
  ([project region Autoscaler optional]
    {:method :put,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/autoscalers",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Autoscaler}))

(defn regionAutoscalers-patch
  "Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionAutoscalers/patch

project <> 
region <> 
Autoscaler:
Autoscaler

optional:
autoscaler <string> Name of the autoscaler to patch.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region Autoscaler]
    (regionAutoscalers-patch project region Autoscaler nil))
  ([project region Autoscaler optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/autoscalers",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Autoscaler}))

(defn regionAutoscalers-delete
  "Deletes the specified autoscaler.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionAutoscalers/delete

project <> 
region <> 
autoscaler <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region autoscaler]
    (regionAutoscalers-delete project region autoscaler nil))
  ([project region autoscaler optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/autoscalers/{autoscaler}",
     :uri-template-args
     {"autoscaler" autoscaler, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn futureReservations-insert
  "Creates a new Future Reservation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/futureReservations/insert

project <> 
zone <> 
FutureReservation:
FutureReservation

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone FutureReservation]
    (futureReservations-insert project zone FutureReservation nil))
  ([project zone FutureReservation optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/futureReservations",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FutureReservation}))

(defn futureReservations-get
  "Retrieves information about the specified future reservation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/futureReservations/get

project <> 
zone <> 
futureReservation <> "
  [project zone futureReservation]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/futureReservations/{futureReservation}",
   :uri-template-args
   {"futureReservation" futureReservation,
    "project" project,
    "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn futureReservations-delete
  "Deletes the specified future reservation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/futureReservations/delete

project <> 
zone <> 
futureReservation <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone futureReservation]
    (futureReservations-delete project zone futureReservation nil))
  ([project zone futureReservation optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/futureReservations/{futureReservation}",
     :uri-template-args
     {"futureReservation" futureReservation,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn futureReservations-list
  "A list of all the future reservations that have been configured for the specified project in specified zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/futureReservations/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (futureReservations-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/futureReservations",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn futureReservations-aggregatedList
  "Retrieves an aggregated list of future reservations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/futureReservations/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (futureReservations-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/futureReservations",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn futureReservations-update
  "Updates the specified future reservation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/futureReservations/update

project <> 
zone <> 
futureReservation <> 
FutureReservation:
FutureReservation

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> update_mask indicates fields to be updated as part of this request."
  ([project zone futureReservation FutureReservation]
    (futureReservations-update
      project
      zone
      futureReservation
      FutureReservation
      nil))
  ([project zone futureReservation FutureReservation optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/futureReservations/{futureReservation}",
     :uri-template-args
     {"futureReservation" futureReservation,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FutureReservation}))

(defn futureReservations-cancel
  "Cancel the specified future reservation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/futureReservations/cancel

project <> 
zone <> 
futureReservation <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone futureReservation]
    (futureReservations-cancel project zone futureReservation nil))
  ([project zone futureReservation optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/futureReservations/{futureReservation}/cancel",
     :uri-template-args
     {"futureReservation" futureReservation,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn nodeTypes-list
  "Retrieves a list of node types available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTypes/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (nodeTypes-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeTypes",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeTypes-aggregatedList
  "Retrieves an aggregated list of node types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTypes/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (nodeTypes-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/nodeTypes",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn nodeTypes-get
  "Returns the specified node type.
https://cloud.google.com/products/compute/v1/reference/rest/v1/nodeTypes/get

project <> 
zone <> 
nodeType <> "
  [project zone nodeType]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/nodeTypes/{nodeType}",
   :uri-template-args
   {"nodeType" nodeType, "project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn instanceSettings-get
  "Get Instance settings.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceSettings/get

project <> 
zone <> "
  [project zone]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instanceSettings",
   :uri-template-args {"project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn instanceSettings-patch
  "Patch Instance settings
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceSettings/patch

project <> 
zone <> 
InstanceSettings:
InstanceSettings

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> update_mask indicates fields to be updated as part of this request."
  ([project zone InstanceSettings]
    (instanceSettings-patch project zone InstanceSettings nil))
  ([project zone InstanceSettings optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instanceSettings",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InstanceSettings}))

(defn networkAttachments-list
  "Lists the NetworkAttachments for a project in the given scope.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (networkAttachments-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/networkAttachments",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkAttachments-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/networkAttachments/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn networkAttachments-delete
  "Deletes the specified NetworkAttachment in the given scope
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/delete

project <> 
region <> 
networkAttachment <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder"
  ([project region networkAttachment]
    (networkAttachments-delete project region networkAttachment nil))
  ([project region networkAttachment optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/networkAttachments/{networkAttachment}",
     :uri-template-args
     {"networkAttachment" networkAttachment,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn networkAttachments-patch
  "Patches the specified NetworkAttachment resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/patch

project <> 
region <> 
networkAttachment <> 
NetworkAttachment:
NetworkAttachment

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder"
  ([project region networkAttachment NetworkAttachment]
    (networkAttachments-patch
      project
      region
      networkAttachment
      NetworkAttachment
      nil))
  ([project region networkAttachment NetworkAttachment optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/networkAttachments/{networkAttachment}",
     :uri-template-args
     {"networkAttachment" networkAttachment,
      "project" project,
      "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworkAttachment}))

(defn networkAttachments-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (networkAttachments-getIamPolicy project region resource nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/networkAttachments/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkAttachments-aggregatedList
  "Retrieves the list of all NetworkAttachment resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (networkAttachments-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/networkAttachments",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn networkAttachments-insert
  "Creates a NetworkAttachment in the specified project in the given scope using the parameters that are included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/insert

project <> 
region <> 
NetworkAttachment:
NetworkAttachment

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000). end_interface: MixerMutationRequestBuilder"
  ([project region NetworkAttachment]
    (networkAttachments-insert project region NetworkAttachment nil))
  ([project region NetworkAttachment optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/networkAttachments",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworkAttachment}))

(defn networkAttachments-get
  "Returns the specified NetworkAttachment resource in the given scope.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/get

project <> 
region <> 
networkAttachment <> "
  [project region networkAttachment]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/networkAttachments/{networkAttachment}",
   :uri-template-args
   {"networkAttachment" networkAttachment,
    "project" project,
    "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn networkAttachments-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/networkAttachments/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/networkAttachments/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn instanceGroupManagerResizeRequests-get
  "Returns all of the details about the specified resize request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceGroupManagerResizeRequests/get

project <> 
zone <> 
instanceGroupManager <> 
resizeRequest <> "
  [project zone instanceGroupManager resizeRequest]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}",
   :uri-template-args
   {"instanceGroupManager" instanceGroupManager,
    "project" project,
    "resizeRequest" resizeRequest,
    "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn instanceGroupManagerResizeRequests-insert
  "Creates a new resize request that starts provisioning VMs immediately or queues VM creation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceGroupManagerResizeRequests/insert

project <> 
zone <> 
instanceGroupManager <> 
InstanceGroupManagerResizeRequest:
InstanceGroupManagerResizeRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    zone
    instanceGroupManager
    InstanceGroupManagerResizeRequest]
    (instanceGroupManagerResizeRequests-insert
      project
      zone
      instanceGroupManager
      InstanceGroupManagerResizeRequest
      nil))
  ([project
    zone
    instanceGroupManager
    InstanceGroupManagerResizeRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body InstanceGroupManagerResizeRequest}))

(defn instanceGroupManagerResizeRequests-list
  "Retrieves a list of resize requests that are contained in the managed instance group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceGroupManagerResizeRequests/list

project <> 
zone <> 
instanceGroupManager <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone instanceGroupManager]
    (instanceGroupManagerResizeRequests-list
      project
      zone
      instanceGroupManager
      nil))
  ([project zone instanceGroupManager optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn instanceGroupManagerResizeRequests-cancel
  "Cancels the specified resize request and removes it from the queue. Cancelled resize request does no longer wait for the resources to be provisioned. Cancel is only possible for requests that are accepted in the queue.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceGroupManagerResizeRequests/cancel

project <> 
zone <> 
instanceGroupManager <> 
resizeRequest <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone instanceGroupManager resizeRequest]
    (instanceGroupManagerResizeRequests-cancel
      project
      zone
      instanceGroupManager
      resizeRequest
      nil))
  ([project zone instanceGroupManager resizeRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}/cancel",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "resizeRequest" resizeRequest,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn instanceGroupManagerResizeRequests-delete
  "Deletes the specified, inactive resize request. Requests that are still active cannot be deleted. Deleting request does not delete instances that were provisioned previously.
https://cloud.google.com/products/compute/v1/reference/rest/v1/instanceGroupManagerResizeRequests/delete

project <> 
zone <> 
instanceGroupManager <> 
resizeRequest <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone instanceGroupManager resizeRequest]
    (instanceGroupManagerResizeRequests-delete
      project
      zone
      instanceGroupManager
      resizeRequest
      nil))
  ([project zone instanceGroupManager resizeRequest optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/instanceGroupManagers/{instanceGroupManager}/resizeRequests/{resizeRequest}",
     :uri-template-args
     {"instanceGroupManager" instanceGroupManager,
      "project" project,
      "resizeRequest" resizeRequest,
      "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn firewallPolicies-getRule
  "Gets a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/getRule

firewallPolicy <> 

optional:
priority <integer> The priority of the rule to get from the firewall policy."
  ([firewallPolicy] (firewallPolicies-getRule firewallPolicy nil))
  ([firewallPolicy optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/getRule",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn firewallPolicies-removeRule
  "Deletes a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/removeRule

firewallPolicy <> 

optional:
priority <integer> The priority of the rule to remove from the firewall policy.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([firewallPolicy] (firewallPolicies-removeRule firewallPolicy nil))
  ([firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/removeRule",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn firewallPolicies-list
  "Lists all the policies that have been configured for the specified folder or organization.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/list

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
parentId <string> Parent ID for this request. The ID can be either be \"folders/[FOLDER_ID]\" if the parent is a folder or \"organizations/[ORGANIZATION_ID]\" if the parent is an organization.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([] (firewallPolicies-list nil))
  ([optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies",
     :uri-template-args {},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn firewallPolicies-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/setIamPolicy

resource <> 
GlobalOrganizationSetPolicyRequest:
GlobalOrganizationSetPolicyRequest"
  [resource GlobalOrganizationSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{resource}/setIamPolicy",
   :uri-template-args {"resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalOrganizationSetPolicyRequest})

(defn firewallPolicies-addRule
  "Inserts a rule into a firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/addRule

firewallPolicy <> 
FirewallPolicyRule:
FirewallPolicyRule

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([firewallPolicy FirewallPolicyRule]
    (firewallPolicies-addRule firewallPolicy FirewallPolicyRule nil))
  ([firewallPolicy FirewallPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/addRule",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyRule}))

(defn firewallPolicies-cloneRules
  "Copies rules to the specified firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/cloneRules

firewallPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
sourceFirewallPolicy <string> The firewall policy from which to copy rules."
  ([firewallPolicy] (firewallPolicies-cloneRules firewallPolicy nil))
  ([firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/cloneRules",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn firewallPolicies-delete
  "Deletes the specified policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/delete

firewallPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([firewallPolicy] (firewallPolicies-delete firewallPolicy nil))
  ([firewallPolicy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn firewallPolicies-listAssociations
  "Lists associations of a specified target, i.e., organization or folder.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/listAssociations

optional:
targetResource <string> The target resource to list associations. It is an organization, or a folder."
  ([] (firewallPolicies-listAssociations nil))
  ([optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/listAssociations",
     :uri-template-args {},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn firewallPolicies-getAssociation
  "Gets an association with the specified name.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/getAssociation

firewallPolicy <> 

optional:
name <string> The name of the association to get from the firewall policy."
  ([firewallPolicy]
    (firewallPolicies-getAssociation firewallPolicy nil))
  ([firewallPolicy optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/getAssociation",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn firewallPolicies-addAssociation
  "Inserts an association for the specified firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/addAssociation

firewallPolicy <> 
FirewallPolicyAssociation:
FirewallPolicyAssociation

optional:
replaceExistingAssociation <boolean> Indicates whether or not to replace it if an association of the attachment already exists. This is false by default, in which case an error will be returned if an association already exists.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([firewallPolicy FirewallPolicyAssociation]
    (firewallPolicies-addAssociation
      firewallPolicy
      FirewallPolicyAssociation
      nil))
  ([firewallPolicy FirewallPolicyAssociation optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/addAssociation",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyAssociation}))

(defn firewallPolicies-patch
  "Patches the specified policy with the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/patch

firewallPolicy <> 
FirewallPolicy:
FirewallPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([firewallPolicy FirewallPolicy]
    (firewallPolicies-patch firewallPolicy FirewallPolicy nil))
  ([firewallPolicy FirewallPolicy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicy}))

(defn firewallPolicies-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/getIamPolicy

resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([resource] (firewallPolicies-getIamPolicy resource nil))
  ([resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{resource}/getIamPolicy",
     :uri-template-args {"resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn firewallPolicies-move
  "Moves the specified firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/move

firewallPolicy <> 

optional:
parentId <string> The new parent of the firewall policy. The ID can be either be \"folders/[FOLDER_ID]\" if the parent is a folder or \"organizations/[ORGANIZATION_ID]\" if the parent is an organization.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([firewallPolicy] (firewallPolicies-move firewallPolicy nil))
  ([firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/move",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn firewallPolicies-insert
  "Creates a new policy in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/insert

FirewallPolicy:
FirewallPolicy

optional:
parentId <string> Parent ID for this request. The ID can be either be \"folders/[FOLDER_ID]\" if the parent is a folder or \"organizations/[ORGANIZATION_ID]\" if the parent is an organization.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([FirewallPolicy] (firewallPolicies-insert FirewallPolicy nil))
  ([FirewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies",
     :uri-template-args {},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicy}))

(defn firewallPolicies-patchRule
  "Patches a rule of the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/patchRule

firewallPolicy <> 
FirewallPolicyRule:
FirewallPolicyRule

optional:
priority <integer> The priority of the rule to patch.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([firewallPolicy FirewallPolicyRule]
    (firewallPolicies-patchRule firewallPolicy FirewallPolicyRule nil))
  ([firewallPolicy FirewallPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/patchRule",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body FirewallPolicyRule}))

(defn firewallPolicies-removeAssociation
  "Removes an association for the specified firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/removeAssociation

firewallPolicy <> 

optional:
name <string> Name for the attachment that will be removed.
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([firewallPolicy]
    (firewallPolicies-removeAssociation firewallPolicy nil))
  ([firewallPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}/removeAssociation",
     :uri-template-args {"firewallPolicy" firewallPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn firewallPolicies-get
  "Returns the specified firewall policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/get

firewallPolicy <> "
  [firewallPolicy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{firewallPolicy}",
   :uri-template-args {"firewallPolicy" firewallPolicy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn firewallPolicies-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/firewallPolicies/testIamPermissions

resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/locations/global/firewallPolicies/{resource}/testIamPermissions",
   :uri-template-args {"resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn reservations-list
  "A list of all the reservations that have been configured for the specified project in specified zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (reservations-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn reservations-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/setIamPolicy

project <> 
zone <> 
resource <> 
ZoneSetPolicyRequest:
ZoneSetPolicyRequest"
  [project zone resource ZoneSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "resource" resource, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body ZoneSetPolicyRequest})

(defn reservations-delete
  "Deletes the specified reservation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/delete

project <> 
zone <> 
reservation <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone reservation]
    (reservations-delete project zone reservation nil))
  ([project zone reservation optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations/{reservation}",
     :uri-template-args
     {"project" project, "reservation" reservation, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn reservations-update
  "Update share settings of the reservation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/update

project <> 
zone <> 
reservation <> 
Reservation:
Reservation

optional:
paths <string> 
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> Update_mask indicates fields to be updated as part of this request."
  ([project zone reservation Reservation]
    (reservations-update project zone reservation Reservation nil))
  ([project zone reservation Reservation optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations/{reservation}",
     :uri-template-args
     {"project" project, "reservation" reservation, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Reservation}))

(defn reservations-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/getIamPolicy

project <> 
zone <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project zone resource]
    (reservations-getIamPolicy project zone resource nil))
  ([project zone resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "resource" resource, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn reservations-aggregatedList
  "Retrieves an aggregated list of reservations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (reservations-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/reservations",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn reservations-insert
  "Creates a new reservation. For more information, read Reserving zonal resources.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/insert

project <> 
zone <> 
Reservation:
Reservation

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone Reservation]
    (reservations-insert project zone Reservation nil))
  ([project zone Reservation optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Reservation}))

(defn reservations-resize
  "Resizes the reservation (applicable to standalone reservations only). For more information, read Modifying reservations.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/resize

project <> 
zone <> 
reservation <> 
ReservationsResizeRequest:
ReservationsResizeRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone reservation ReservationsResizeRequest]
    (reservations-resize
      project
      zone
      reservation
      ReservationsResizeRequest
      nil))
  ([project zone reservation ReservationsResizeRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations/{reservation}/resize",
     :uri-template-args
     {"project" project, "reservation" reservation, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ReservationsResizeRequest}))

(defn reservations-get
  "Retrieves information about the specified reservation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/get

project <> 
zone <> 
reservation <> "
  [project zone reservation]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations/{reservation}",
   :uri-template-args
   {"project" project, "reservation" reservation, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn reservations-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/reservations/testIamPermissions

project <> 
zone <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project zone resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/reservations/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "resource" resource, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn regionSecurityPolicies-getRule
  "Gets a rule at the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/getRule

project <> 
region <> 
securityPolicy <> 

optional:
priority <integer> The priority of the rule to get from the security policy."
  ([project region securityPolicy]
    (regionSecurityPolicies-getRule project region securityPolicy nil))
  ([project region securityPolicy optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies/{securityPolicy}/getRule",
     :uri-template-args
     {"project" project,
      "region" region,
      "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionSecurityPolicies-removeRule
  "Deletes a rule at the specified priority.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/removeRule

project <> 
region <> 
securityPolicy <> 

optional:
priority <integer> The priority of the rule to remove from the security policy."
  ([project region securityPolicy]
    (regionSecurityPolicies-removeRule
      project
      region
      securityPolicy
      nil))
  ([project region securityPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies/{securityPolicy}/removeRule",
     :uri-template-args
     {"project" project,
      "region" region,
      "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionSecurityPolicies-list
  "List all the policies that have been configured for the specified project and region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionSecurityPolicies-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionSecurityPolicies-addRule
  "Inserts a rule into a security policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/addRule

project <> 
region <> 
securityPolicy <> 
SecurityPolicyRule:
SecurityPolicyRule

optional:
validateOnly <boolean> If true, the request will not be committed."
  ([project region securityPolicy SecurityPolicyRule]
    (regionSecurityPolicies-addRule
      project
      region
      securityPolicy
      SecurityPolicyRule
      nil))
  ([project region securityPolicy SecurityPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies/{securityPolicy}/addRule",
     :uri-template-args
     {"project" project,
      "region" region,
      "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyRule}))

(defn regionSecurityPolicies-delete
  "Deletes the specified policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/delete

project <> 
region <> 
securityPolicy <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region securityPolicy]
    (regionSecurityPolicies-delete project region securityPolicy nil))
  ([project region securityPolicy optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies/{securityPolicy}",
     :uri-template-args
     {"project" project,
      "region" region,
      "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn regionSecurityPolicies-patch
  "Patches the specified policy with the data included in the request. To clear fields in the policy, leave the fields empty and specify them in the updateMask. This cannot be used to be update the rules in the policy. Please use the per rule methods like addRule, patchRule, and removeRule instead.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/patch

project <> 
region <> 
securityPolicy <> 
SecurityPolicy:
SecurityPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> Indicates fields to be cleared as part of this request."
  ([project region securityPolicy SecurityPolicy]
    (regionSecurityPolicies-patch
      project
      region
      securityPolicy
      SecurityPolicy
      nil))
  ([project region securityPolicy SecurityPolicy optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies/{securityPolicy}",
     :uri-template-args
     {"project" project,
      "region" region,
      "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicy}))

(defn regionSecurityPolicies-insert
  "Creates a new policy in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/insert

project <> 
region <> 
SecurityPolicy:
SecurityPolicy

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
validateOnly <boolean> If true, the request will not be committed."
  ([project region SecurityPolicy]
    (regionSecurityPolicies-insert project region SecurityPolicy nil))
  ([project region SecurityPolicy optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicy}))

(defn regionSecurityPolicies-patchRule
  "Patches a rule at the specified priority. To clear fields in the rule, leave the fields empty and specify them in the updateMask.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/patchRule

project <> 
region <> 
securityPolicy <> 
SecurityPolicyRule:
SecurityPolicyRule

optional:
priority <integer> The priority of the rule to patch.
updateMask <string> Indicates fields to be cleared as part of this request.
validateOnly <boolean> If true, the request will not be committed."
  ([project region securityPolicy SecurityPolicyRule]
    (regionSecurityPolicies-patchRule
      project
      region
      securityPolicy
      SecurityPolicyRule
      nil))
  ([project region securityPolicy SecurityPolicyRule optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies/{securityPolicy}/patchRule",
     :uri-template-args
     {"project" project,
      "region" region,
      "securityPolicy" securityPolicy},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyRule}))

(defn regionSecurityPolicies-get
  "List all of the ordered rules present in a single specified policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSecurityPolicies/get

project <> 
region <> 
securityPolicy <> "
  [project region securityPolicy]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/securityPolicies/{securityPolicy}",
   :uri-template-args
   {"project" project,
    "region" region,
    "securityPolicy" securityPolicy},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn diskTypes-list
  "Retrieves a list of disk types available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/diskTypes/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (diskTypes-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/diskTypes",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn diskTypes-aggregatedList
  "Retrieves an aggregated list of disk types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/diskTypes/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (diskTypes-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/diskTypes",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn diskTypes-get
  "Returns the specified disk type.
https://cloud.google.com/products/compute/v1/reference/rest/v1/diskTypes/get

project <> 
zone <> 
diskType <> "
  [project zone diskType]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/diskTypes/{diskType}",
   :uri-template-args
   {"diskType" diskType, "project" project, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionCommitments-list
  "Retrieves a list of commitments contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionCommitments/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionCommitments-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/commitments",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionCommitments-aggregatedList
  "Retrieves an aggregated list of commitments by region. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionCommitments/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (regionCommitments-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/commitments",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionCommitments-get
  "Returns the specified commitment resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionCommitments/get

project <> 
region <> 
commitment <> "
  [project region commitment]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/commitments/{commitment}",
   :uri-template-args
   {"commitment" commitment, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionCommitments-insert
  "Creates a commitment in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionCommitments/insert

project <> 
region <> 
Commitment:
Commitment

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region Commitment]
    (regionCommitments-insert project region Commitment nil))
  ([project region Commitment optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/commitments",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Commitment}))

(defn regionCommitments-update
  "Updates the specified commitment with the data included in the request. Update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: auto_renew.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionCommitments/update

project <> 
region <> 
commitment <> 
Commitment:
Commitment

optional:
paths <string> 
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> update_mask indicates fields to be updated as part of this request."
  ([project region commitment Commitment]
    (regionCommitments-update
      project
      region
      commitment
      Commitment
      nil))
  ([project region commitment Commitment optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/commitments/{commitment}",
     :uri-template-args
     {"commitment" commitment, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Commitment}))

(defn regionSslCertificates-list
  "Retrieves the list of SslCertificate resources available to the specified project in the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslCertificates/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (regionSslCertificates-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslCertificates",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn regionSslCertificates-get
  "Returns the specified SslCertificate resource in the specified region. Get a list of available SSL certificates by making a list() request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslCertificates/get

project <> 
region <> 
sslCertificate <> "
  [project region sslCertificate]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslCertificates/{sslCertificate}",
   :uri-template-args
   {"project" project,
    "region" region,
    "sslCertificate" sslCertificate},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn regionSslCertificates-insert
  "Creates a SslCertificate resource in the specified project and region using the data included in the request
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslCertificates/insert

project <> 
region <> 
SslCertificate:
SslCertificate

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region SslCertificate]
    (regionSslCertificates-insert project region SslCertificate nil))
  ([project region SslCertificate optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslCertificates",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SslCertificate}))

(defn regionSslCertificates-delete
  "Deletes the specified SslCertificate resource in the region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/regionSslCertificates/delete

project <> 
region <> 
sslCertificate <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region sslCertificate]
    (regionSslCertificates-delete project region sslCertificate nil))
  ([project region sslCertificate optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/sslCertificates/{sslCertificate}",
     :uri-template-args
     {"project" project,
      "region" region,
      "sslCertificate" sslCertificate},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn machineImages-list
  "Retrieves a list of machine images that are contained within the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/machineImages/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (machineImages-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/machineImages",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn machineImages-get
  "Returns the specified machine image.
https://cloud.google.com/products/compute/v1/reference/rest/v1/machineImages/get

project <> 
machineImage <> "
  [project machineImage]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/machineImages/{machineImage}",
   :uri-template-args {"machineImage" machineImage, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn machineImages-insert
  "Creates a machine image in the specified project using the data that is included in the request. If you are creating a new machine image to update an existing instance, your new machine image should use the same network or, if applicable, the same subnetwork as the original instance.
https://cloud.google.com/products/compute/v1/reference/rest/v1/machineImages/insert

project <> 
MachineImage:
MachineImage

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
sourceInstance <string> Required. Source instance that is used to create the machine image from."
  ([project MachineImage]
    (machineImages-insert project MachineImage nil))
  ([project MachineImage optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/machineImages",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body MachineImage}))

(defn machineImages-delete
  "Deletes the specified machine image. Deleting a machine image is permanent and cannot be undone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/machineImages/delete

project <> 
machineImage <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project machineImage]
    (machineImages-delete project machineImage nil))
  ([project machineImage optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/machineImages/{machineImage}",
     :uri-template-args
     {"machineImage" machineImage, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn machineImages-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/machineImages/getIamPolicy

project <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project resource]
    (machineImages-getIamPolicy project resource nil))
  ([project resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/machineImages/{resource}/getIamPolicy",
     :uri-template-args {"project" project, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn machineImages-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/machineImages/setIamPolicy

project <> 
resource <> 
GlobalSetPolicyRequest:
GlobalSetPolicyRequest"
  [project resource GlobalSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/machineImages/{resource}/setIamPolicy",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetPolicyRequest})

(defn machineImages-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/machineImages/testIamPermissions

project <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/machineImages/{resource}/testIamPermissions",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn serviceAttachments-list
  "Lists the ServiceAttachments for a project in the given scope.
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (serviceAttachments-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/serviceAttachments",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn serviceAttachments-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/setIamPolicy

project <> 
region <> 
resource <> 
RegionSetPolicyRequest:
RegionSetPolicyRequest"
  [project region resource RegionSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/serviceAttachments/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body RegionSetPolicyRequest})

(defn serviceAttachments-delete
  "Deletes the specified ServiceAttachment in the given scope
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/delete

project <> 
region <> 
serviceAttachment <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region serviceAttachment]
    (serviceAttachments-delete project region serviceAttachment nil))
  ([project region serviceAttachment optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}",
     :uri-template-args
     {"project" project,
      "region" region,
      "serviceAttachment" serviceAttachment},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn serviceAttachments-patch
  "Patches the specified ServiceAttachment resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/patch

project <> 
region <> 
serviceAttachment <> 
ServiceAttachment:
ServiceAttachment

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region serviceAttachment ServiceAttachment]
    (serviceAttachments-patch
      project
      region
      serviceAttachment
      ServiceAttachment
      nil))
  ([project region serviceAttachment ServiceAttachment optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}",
     :uri-template-args
     {"project" project,
      "region" region,
      "serviceAttachment" serviceAttachment},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ServiceAttachment}))

(defn serviceAttachments-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/getIamPolicy

project <> 
region <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project region resource]
    (serviceAttachments-getIamPolicy project region resource nil))
  ([project region resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/serviceAttachments/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn serviceAttachments-aggregatedList
  "Retrieves the list of all ServiceAttachment resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (serviceAttachments-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/serviceAttachments",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn serviceAttachments-insert
  "Creates a ServiceAttachment in the specified project in the given scope using the parameters that are included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/insert

project <> 
region <> 
ServiceAttachment:
ServiceAttachment

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region ServiceAttachment]
    (serviceAttachments-insert project region ServiceAttachment nil))
  ([project region ServiceAttachment optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/serviceAttachments",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body ServiceAttachment}))

(defn serviceAttachments-get
  "Returns the specified ServiceAttachment resource in the given scope.
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/get

project <> 
region <> 
serviceAttachment <> "
  [project region serviceAttachment]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}",
   :uri-template-args
   {"project" project,
    "region" region,
    "serviceAttachment" serviceAttachment},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn serviceAttachments-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/serviceAttachments/testIamPermissions

project <> 
region <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project region resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/serviceAttachments/{resource}/testIamPermissions",
   :uri-template-args
   {"project" project, "region" region, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn sslCertificates-list
  "Retrieves the list of SslCertificate resources available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslCertificates/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (sslCertificates-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslCertificates",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn sslCertificates-get
  "Returns the specified SslCertificate resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslCertificates/get

project <> 
sslCertificate <> "
  [project sslCertificate]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslCertificates/{sslCertificate}",
   :uri-template-args
   {"project" project, "sslCertificate" sslCertificate},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn sslCertificates-insert
  "Creates a SslCertificate resource in the specified project using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslCertificates/insert

project <> 
SslCertificate:
SslCertificate

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project SslCertificate]
    (sslCertificates-insert project SslCertificate nil))
  ([project SslCertificate optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslCertificates",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SslCertificate}))

(defn sslCertificates-delete
  "Deletes the specified SslCertificate resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslCertificates/delete

project <> 
sslCertificate <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project sslCertificate]
    (sslCertificates-delete project sslCertificate nil))
  ([project sslCertificate optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/sslCertificates/{sslCertificate}",
     :uri-template-args
     {"project" project, "sslCertificate" sslCertificate},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn sslCertificates-aggregatedList
  "Retrieves the list of all SslCertificate resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/sslCertificates/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (sslCertificates-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/sslCertificates",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn addresses-list
  "Retrieves a list of addresses contained within the specified region.
https://cloud.google.com/products/compute/v1/reference/rest/v1/addresses/list

project <> 
region <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project region] (addresses-list project region nil))
  ([project region optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/addresses",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn addresses-aggregatedList
  "Retrieves an aggregated list of addresses. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/addresses/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (addresses-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/addresses",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn addresses-get
  "Returns the specified address resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/addresses/get

project <> 
region <> 
address <> "
  [project region address]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/addresses/{address}",
   :uri-template-args
   {"address" address, "project" project, "region" region},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn addresses-insert
  "Creates an address resource in the specified project by using the data included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/addresses/insert

project <> 
region <> 
Address:
Address

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region Address]
    (addresses-insert project region Address nil))
  ([project region Address optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/addresses",
     :uri-template-args {"project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body Address}))

(defn addresses-delete
  "Deletes the specified address resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/addresses/delete

project <> 
region <> 
address <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region address]
    (addresses-delete project region address nil))
  ([project region address optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/addresses/{address}",
     :uri-template-args
     {"address" address, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn addresses-move
  "Moves the specified address resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/addresses/move

project <> 
region <> 
address <> 
RegionAddressesMoveRequest:
RegionAddressesMoveRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region address RegionAddressesMoveRequest]
    (addresses-move
      project
      region
      address
      RegionAddressesMoveRequest
      nil))
  ([project region address RegionAddressesMoveRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/addresses/{address}/move",
     :uri-template-args
     {"address" address, "project" project, "region" region},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionAddressesMoveRequest}))

(defn addresses-setLabels
  "Sets the labels on an Address. To learn more about labels, read the Labeling Resources documentation.
https://cloud.google.com/products/compute/v1/reference/rest/v1/addresses/setLabels

project <> 
region <> 
resource <> 
RegionSetLabelsRequest:
RegionSetLabelsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project region resource RegionSetLabelsRequest]
    (addresses-setLabels
      project
      region
      resource
      RegionSetLabelsRequest
      nil))
  ([project region resource RegionSetLabelsRequest optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/regions/{region}/addresses/{resource}/setLabels",
     :uri-template-args
     {"project" project, "region" region, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body RegionSetLabelsRequest}))

(defn interconnectRemoteLocations-list
  "Retrieves the list of interconnect remote locations available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectRemoteLocations/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (interconnectRemoteLocations-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnectRemoteLocations",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn interconnectRemoteLocations-get
  "Returns the details for the specified interconnect remote location. Gets a list of available interconnect remote locations by making a list() request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/interconnectRemoteLocations/get

project <> 
interconnectRemoteLocation <> "
  [project interconnectRemoteLocation]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/interconnectRemoteLocations/{interconnectRemoteLocation}",
   :uri-template-args
   {"interconnectRemoteLocation" interconnectRemoteLocation,
    "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn globalNetworkEndpointGroups-list
  "Retrieves the list of network endpoint groups that are located in the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalNetworkEndpointGroups/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (globalNetworkEndpointGroups-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networkEndpointGroups",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn globalNetworkEndpointGroups-get
  "Returns the specified network endpoint group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalNetworkEndpointGroups/get

project <> 
networkEndpointGroup <> "
  [project networkEndpointGroup]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}",
   :uri-template-args
   {"networkEndpointGroup" networkEndpointGroup, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn globalNetworkEndpointGroups-insert
  "Creates a network endpoint group in the specified project using the parameters that are included in the request.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalNetworkEndpointGroups/insert

project <> 
NetworkEndpointGroup:
NetworkEndpointGroup

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project NetworkEndpointGroup]
    (globalNetworkEndpointGroups-insert
      project
      NetworkEndpointGroup
      nil))
  ([project NetworkEndpointGroup optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networkEndpointGroups",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body NetworkEndpointGroup}))

(defn globalNetworkEndpointGroups-delete
  "Deletes the specified network endpoint group.Note that the NEG cannot be deleted if there are backend services referencing it.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalNetworkEndpointGroups/delete

project <> 
networkEndpointGroup <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project networkEndpointGroup]
    (globalNetworkEndpointGroups-delete
      project
      networkEndpointGroup
      nil))
  ([project networkEndpointGroup optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}",
     :uri-template-args
     {"networkEndpointGroup" networkEndpointGroup, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn globalNetworkEndpointGroups-attachNetworkEndpoints
  "Attach a network endpoint to the specified network endpoint group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalNetworkEndpointGroups/attachNetworkEndpoints

project <> 
networkEndpointGroup <> 
GlobalNetworkEndpointGroupsAttachEndpointsRequest:
GlobalNetworkEndpointGroupsAttachEndpointsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    networkEndpointGroup
    GlobalNetworkEndpointGroupsAttachEndpointsRequest]
    (globalNetworkEndpointGroups-attachNetworkEndpoints
      project
      networkEndpointGroup
      GlobalNetworkEndpointGroupsAttachEndpointsRequest
      nil))
  ([project
    networkEndpointGroup
    GlobalNetworkEndpointGroupsAttachEndpointsRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/attachNetworkEndpoints",
     :uri-template-args
     {"networkEndpointGroup" networkEndpointGroup, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body GlobalNetworkEndpointGroupsAttachEndpointsRequest}))

(defn globalNetworkEndpointGroups-detachNetworkEndpoints
  "Detach the network endpoint from the specified network endpoint group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalNetworkEndpointGroups/detachNetworkEndpoints

project <> 
networkEndpointGroup <> 
GlobalNetworkEndpointGroupsDetachEndpointsRequest:
GlobalNetworkEndpointGroupsDetachEndpointsRequest

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project
    networkEndpointGroup
    GlobalNetworkEndpointGroupsDetachEndpointsRequest]
    (globalNetworkEndpointGroups-detachNetworkEndpoints
      project
      networkEndpointGroup
      GlobalNetworkEndpointGroupsDetachEndpointsRequest
      nil))
  ([project
    networkEndpointGroup
    GlobalNetworkEndpointGroupsDetachEndpointsRequest
    optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/detachNetworkEndpoints",
     :uri-template-args
     {"networkEndpointGroup" networkEndpointGroup, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body GlobalNetworkEndpointGroupsDetachEndpointsRequest}))

(defn globalNetworkEndpointGroups-listNetworkEndpoints
  "Lists the network endpoints in the specified network endpoint group.
https://cloud.google.com/products/compute/v1/reference/rest/v1/globalNetworkEndpointGroups/listNetworkEndpoints

project <> 
networkEndpointGroup <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project networkEndpointGroup]
    (globalNetworkEndpointGroups-listNetworkEndpoints
      project
      networkEndpointGroup
      nil))
  ([project networkEndpointGroup optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/networkEndpointGroups/{networkEndpointGroup}/listNetworkEndpoints",
     :uri-template-args
     {"networkEndpointGroup" networkEndpointGroup, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn snapshotSettings-get
  "Get snapshot settings.
https://cloud.google.com/products/compute/v1/reference/rest/v1/snapshotSettings/get

project <> "
  [project]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/snapshotSettings",
   :uri-template-args {"project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn snapshotSettings-patch
  "Patch snapshot settings.
https://cloud.google.com/products/compute/v1/reference/rest/v1/snapshotSettings/patch

project <> 
SnapshotSettings:
SnapshotSettings

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> update_mask indicates fields to be updated as part of this request."
  ([project SnapshotSettings]
    (snapshotSettings-patch project SnapshotSettings nil))
  ([project SnapshotSettings optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/snapshotSettings",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SnapshotSettings}))

(defn backendServices-list
  "Retrieves the list of BackendService resources available to the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/list

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (backendServices-list project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn backendServices-addSignedUrlKey
  "Adds a key for validating requests with signed URLs for this backend service.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/addSignedUrlKey

project <> 
backendService <> 
SignedUrlKey:
SignedUrlKey

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project backendService SignedUrlKey]
    (backendServices-addSignedUrlKey
      project
      backendService
      SignedUrlKey
      nil))
  ([project backendService SignedUrlKey optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}/addSignedUrlKey",
     :uri-template-args
     {"backendService" backendService, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SignedUrlKey}))

(defn backendServices-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/setIamPolicy

project <> 
resource <> 
GlobalSetPolicyRequest:
GlobalSetPolicyRequest"
  [project resource GlobalSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{resource}/setIamPolicy",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body GlobalSetPolicyRequest})

(defn backendServices-delete
  "Deletes the specified BackendService resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/delete

project <> 
backendService <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project backendService]
    (backendServices-delete project backendService nil))
  ([project backendService optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}",
     :uri-template-args
     {"backendService" backendService, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn backendServices-update
  "Updates the specified BackendService resource with the data included in the request. For more information, see Backend services overview.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/update

project <> 
backendService <> 
BackendService:
BackendService

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project backendService BackendService]
    (backendServices-update project backendService BackendService nil))
  ([project backendService BackendService optional]
    {:method :put,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}",
     :uri-template-args
     {"backendService" backendService, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body BackendService}))

(defn backendServices-getHealth
  "Gets the most recent health check results for this BackendService. Example request body: { \"group\": \"/zones/us-east1-b/instanceGroups/lb-backend-example\" }
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/getHealth

project <> 
backendService <> 
ResourceGroupReference:
ResourceGroupReference"
  [project backendService ResourceGroupReference]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}/getHealth",
   :uri-template-args
   {"backendService" backendService, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body ResourceGroupReference})

(defn backendServices-deleteSignedUrlKey
  "Deletes a key for validating requests with signed URLs for this backend service.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/deleteSignedUrlKey

project <> 
backendService <> 
keyName <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project backendService keyName]
    (backendServices-deleteSignedUrlKey
      project
      backendService
      keyName
      nil))
  ([project backendService keyName optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}/deleteSignedUrlKey",
     :uri-template-args
     {"backendService" backendService, "project" project},
     :query-params (merge {"keyName" keyName} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn backendServices-patch
  "Patches the specified BackendService resource with the data included in the request. For more information, see Backend services overview. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/patch

project <> 
backendService <> 
BackendService:
BackendService

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project backendService BackendService]
    (backendServices-patch project backendService BackendService nil))
  ([project backendService BackendService optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}",
     :uri-template-args
     {"backendService" backendService, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body BackendService}))

(defn backendServices-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/getIamPolicy

project <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project resource]
    (backendServices-getIamPolicy project resource nil))
  ([project resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{resource}/getIamPolicy",
     :uri-template-args {"project" project, "resource" resource},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn backendServices-setEdgeSecurityPolicy
  "Sets the edge security policy for the specified backend service.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/setEdgeSecurityPolicy

project <> 
backendService <> 
SecurityPolicyReference:
SecurityPolicyReference

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project backendService SecurityPolicyReference]
    (backendServices-setEdgeSecurityPolicy
      project
      backendService
      SecurityPolicyReference
      nil))
  ([project backendService SecurityPolicyReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}/setEdgeSecurityPolicy",
     :uri-template-args
     {"backendService" backendService, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyReference}))

(defn backendServices-aggregatedList
  "Retrieves the list of all BackendService resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (backendServices-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/backendServices",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn backendServices-insert
  "Creates a BackendService resource in the specified project using the data included in the request. For more information, see Backend services overview .
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/insert

project <> 
BackendService:
BackendService

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project BackendService]
    (backendServices-insert project BackendService nil))
  ([project BackendService optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body BackendService}))

(defn backendServices-setSecurityPolicy
  "Sets the Google Cloud Armor security policy for the specified backend service. For more information, see Google Cloud Armor Overview
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/setSecurityPolicy

project <> 
backendService <> 
SecurityPolicyReference:
SecurityPolicyReference

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project backendService SecurityPolicyReference]
    (backendServices-setSecurityPolicy
      project
      backendService
      SecurityPolicyReference
      nil))
  ([project backendService SecurityPolicyReference optional]
    {:method :post,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}/setSecurityPolicy",
     :uri-template-args
     {"backendService" backendService, "project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body SecurityPolicyReference}))

(defn backendServices-get
  "Returns the specified BackendService resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/get

project <> 
backendService <> "
  [project backendService]
  {:method :get,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{backendService}",
   :uri-template-args
   {"backendService" backendService, "project" project},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"]})

(defn backendServices-testIamPermissions
  "Returns permissions that a caller has on the specified resource.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/testIamPermissions

project <> 
resource <> 
TestPermissionsRequest:
TestPermissionsRequest"
  [project resource TestPermissionsRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/{resource}/testIamPermissions",
   :uri-template-args {"project" project, "resource" resource},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"
    "https://www.googleapis.com/auth/compute.readonly"],
   :body TestPermissionsRequest})

(defn backendServices-listUsable
  "Retrieves an aggregated list of all usable backend services in the specified project.
https://cloud.google.com/products/compute/v1/reference/rest/v1/backendServices/listUsable

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project] (backendServices-listUsable project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/global/backendServices/listUsable",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn storagePools-list
  "Retrieves a list of storage pools contained within the specified zone.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePools/list

project <> 
zone <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code."
  ([project zone] (storagePools-list project zone nil))
  ([project zone optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools",
     :uri-template-args {"project" project, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn storagePools-setIamPolicy
  "Sets the access control policy on the specified resource. Replaces any existing policy.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePools/setIamPolicy

project <> 
zone <> 
resource <> 
ZoneSetPolicyRequest:
ZoneSetPolicyRequest"
  [project zone resource ZoneSetPolicyRequest]
  {:method :post,
   :uri-template
   "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{resource}/setIamPolicy",
   :uri-template-args
   {"project" project, "resource" resource, "zone" zone},
   :query-params {},
   :scopes
   ["https://www.googleapis.com/auth/cloud-platform"
    "https://www.googleapis.com/auth/compute"],
   :body ZoneSetPolicyRequest})

(defn storagePools-delete
  "Deletes the specified storage pool. Deleting a storagePool removes its data permanently and is irreversible. However, deleting a storagePool does not delete any snapshots previously made from the storagePool. You must separately delete snapshots.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePools/delete

project <> 
zone <> 
storagePool <> 

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000)."
  ([project zone storagePool]
    (storagePools-delete project zone storagePool nil))
  ([project zone storagePool optional]
    {:method :delete,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}",
     :uri-template-args
     {"project" project, "storagePool" storagePool, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"]}))

(defn storagePools-update
  "Updates the specified storagePool with the data included in the request. The update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: pool_provisioned_capacity_gb, pool_provisioned_iops and pool_provisioned_throughput.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePools/update

project <> 
zone <> 
storagePool <> 
StoragePool:
StoragePool

optional:
requestId <string> An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
updateMask <string> update_mask indicates fields to be updated as part of this request."
  ([project zone storagePool StoragePool]
    (storagePools-update project zone storagePool StoragePool nil))
  ([project zone storagePool StoragePool optional]
    {:method :patch,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{storagePool}",
     :uri-template-args
     {"project" project, "storagePool" storagePool, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"],
     :body StoragePool}))

(defn storagePools-getIamPolicy
  "Gets the access control policy for a resource. May be empty if no such policy or resource exists.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePools/getIamPolicy

project <> 
zone <> 
resource <> 

optional:
optionsRequestedPolicyVersion <integer> Requested IAM Policy version."
  ([project zone resource]
    (storagePools-getIamPolicy project zone resource nil))
  ([project zone resource optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/zones/{zone}/storagePools/{resource}/getIamPolicy",
     :uri-template-args
     {"project" project, "resource" resource, "zone" zone},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn storagePools-aggregatedList
  "Retrieves an aggregated list of storage pools. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePools/aggregatedList

project <> 

optional:
filter <string> A filter expression that filters resources listed in the response. Most Compute resources support two types of filter expressions: expressions that support regular expressions and expressions that follow API improvement proposal AIP-160. These two types of filter expressions cannot be mixed in one request. If you want to use AIP-160, your expression must specify the field name, an operator, and the value that you want to use for filtering. The value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can exclude instances named `example-instance` by specifying `name != example-instance`. The `:*` comparison can be used to test whether a key has been defined. For example, to find all objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For example, you could specify `scheduling.automaticRestart = false` to include instances only if they are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on resource labels. To filter on multiple expressions, provide each separate expression within parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = \"Intel Skylake\") ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = \"Intel Skylake\") OR (cpuPlatform = \"Intel Broadwell\") AND (scheduling.automaticRestart = true) ``` If you want to use a regular expression, use the `eq` (equal) or `ne` (not equal) operator against a single un-parenthesized expression with or without quotes or against multiple parenthesized expressions. Examples: `fieldname eq unquoted literal` `fieldname eq 'single quoted literal'` `fieldname eq \"double quoted literal\"` `(fieldname1 eq literal) (fieldname2 ne \"literal\")` The literal value is interpreted as a regular expression using Google RE2 library syntax. The literal value must match the entire field. For example, to filter for instances that do not end with name \"instance\", you would use `name ne .*instance`. You cannot combine constraints on multiple fields using regular expressions.
includeAllScopes <boolean> Indicates whether every visible scope for each scope type (zone, region, global) should be included in the response. For new resource types added after this field, the flag has no effect as new resource types will always include every visible scope for each scope type in response. For resource types which predate this field, if this flag is omitted or false, only scopes of the scope types where the resource type is expected to be found will be included.
maxResults <integer> The maximum number of results per page that should be returned. If the number of available results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive. (Default: `500`)
orderBy <string> Sorts list results by a certain order. By default, results are returned in alphanumerical order based on the resource name. You can also sort results in descending order based on the creation timestamp using `orderBy=\"creationTimestamp desc\"`. This sorts results based on the `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort resources like operations so that the newest operation is returned first. Currently, only sorting by `name` or `creationTimestamp desc` is supported.
returnPartialSuccess <boolean> Opt-in for partial success behavior which provides partial results in case of failure. The default value is false. For example, when partial success behavior is enabled, aggregatedList for a single zone scope either returns all resources in the zone or no resources, with an error code.
serviceProjectNumber <string> The Shared VPC service project id or service project number for which aggregated list request is invoked for subnetworks list-usable api."
  ([project] (storagePools-aggregatedList project nil))
  ([project optional]
    {:method :get,
     :uri-template
     "https://compute.googleapis.com/compute/v1/projects/{project}/aggregated/storagePools",
     :uri-template-args {"project" project},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/cloud-platform"
      "https://www.googleapis.com/auth/compute"
      "https://www.googleapis.com/auth/compute.readonly"]}))

(defn storagePools-listDisks
  "Lists the disks in a specified storage pool.
https://cloud.google.com/products/compute/v1/reference/rest/v1/storagePools/listDisks

project <> 
zone <> 
storagePool <> 

optional:
filter <string> A filter expres