(ns happyapi.google.doubleclickbidmanager-v2
  "DoubleClick Bid Manager API
DoubleClick Bid Manager API allows users to manage and create campaigns and reports.
See: https://developers.google.com/bid-manager/")

(defn queries-create
  "Creates a new query.
https://developers.google.com/bid-manager/v2/reference/rest/v2/queries/create

Query:
Query"
  [Query]
  {:method :post,
   :uri-template
   "https://doubleclickbidmanager.googleapis.com/v2/queries",
   :uri-template-args {},
   :query-params {},
   :scopes ["https://www.googleapis.com/auth/doubleclickbidmanager"],
   :body Query})

(defn queries-delete
  "Deletes an existing query as well as its generated reports.
https://developers.google.com/bid-manager/v2/reference/rest/v2/queries/delete

queryId <> "
  [queryId]
  {:method :delete,
   :uri-template
   "https://doubleclickbidmanager.googleapis.com/v2/queries/{queryId}",
   :uri-template-args {"queryId" queryId},
   :query-params {},
   :scopes ["https://www.googleapis.com/auth/doubleclickbidmanager"]})

(defn queries-get
  "Retrieves a query.
https://developers.google.com/bid-manager/v2/reference/rest/v2/queries/get

queryId <> "
  [queryId]
  {:method :get,
   :uri-template
   "https://doubleclickbidmanager.googleapis.com/v2/queries/{queryId}",
   :uri-template-args {"queryId" queryId},
   :query-params {},
   :scopes ["https://www.googleapis.com/auth/doubleclickbidmanager"]})

(defn queries-list
  "Lists queries created by the current user.
https://developers.google.com/bid-manager/v2/reference/rest/v2/queries/list

optional:
pageSize <integer> Maximum number of results per page. Must be between `1` and `100`. Defaults to `100` if unspecified.
orderBy <string> Field to sort the list by. Accepts the following values: * `queryId` (default) * `metadata.title` The default sorting order is ascending. To specify descending order for a field, add the suffix `desc` to the field name. For example, `queryId desc`."
  ([] (queries-list nil))
  ([optional]
    {:method :get,
     :uri-template
     "https://doubleclickbidmanager.googleapis.com/v2/queries",
     :uri-template-args {},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/doubleclickbidmanager"]}))

(defn queries-run
  "Runs an existing query to generate a report.
https://developers.google.com/bid-manager/v2/reference/rest/v2/queries/run

queryId <> 
RunQueryRequest:
RunQueryRequest

optional:
synchronous <boolean> Whether the query should be run synchronously. When `true`, the request won't return until the resulting report has finished running. This parameter is `false` by default. Setting this parameter to `true` is **not recommended**."
  ([queryId RunQueryRequest] (queries-run queryId RunQueryRequest nil))
  ([queryId RunQueryRequest optional]
    {:method :post,
     :uri-template
     "https://doubleclickbidmanager.googleapis.com/v2/queries/{queryId}:run",
     :uri-template-args {"queryId" queryId},
     :query-params (merge {} optional),
     :scopes ["https://www.googleapis.com/auth/doubleclickbidmanager"],
     :body RunQueryRequest}))

(defn queries-reports-list
  "Lists reports generated by the provided query.
https://developers.google.com/bid-manager/v2/reference/rest/v2/queries/reports/list

queryId <> 

optional:
pageSize <integer> Maximum number of results per page. Must be between `1` and `100`. Defaults to `100` if unspecified.
orderBy <string> Field to sort the list by. Accepts the following values: * `key.reportId` (default) The default sorting order is ascending. To specify descending order for a field, add the suffix `desc` to the field name. For example, `key.reportId desc`."
  ([queryId] (queries-reports-list queryId nil))
  ([queryId optional]
    {:method :get,
     :uri-template
     "https://doubleclickbidmanager.googleapis.com/v2/queries/{queryId}/reports",
     :uri-template-args {"queryId" queryId},
     :query-params (merge {} optional),
     :scopes
     ["https://www.googleapis.com/auth/doubleclickbidmanager"]}))

(defn queries-reports-get
  "Retrieves a report.
https://developers.google.com/bid-manager/v2/reference/rest/v2/queries/reports/get

queryId <> 
reportId <> "
  [queryId reportId]
  {:method :get,
   :uri-template
   "https://doubleclickbidmanager.googleapis.com/v2/queries/{queryId}/reports/{reportId}",
   :uri-template-args {"queryId" queryId, "reportId" reportId},
   :query-params {},
   :scopes ["https://www.googleapis.com/auth/doubleclickbidmanager"]})
