(ns mulify.apikit
  (:require [clojure.data.xml :as dx]
            [clojure.string :as str]
            [clojure.java.io :as io]
            [mulify.core :refer (defprocess global-process-map camelize)]))

(defprocess config {:name                      "apikit-config"
                    :outbound-headers-map-name "outboundHeaders"
                    :http-status-var-name      "httpStatus"}
  :xml-real-ns "mulify.mule-apikit")

;; (defn config [{:keys [name outbound-headers-map-name http-status-var-name raml]
;;                :or {name "apikit-config"
;;                     outbound-headers-map-name "outboundHeaders"
;;                     http-status-var-name "httpStatus"}}
;;               & body]
;;   (apply dx/element ::config {:name name,
;;                               :raml raml,
;;                               :outboundHeadersMapName outbound-headers-map-name
;;                               :httpStatusVarName http-status-var-name}
;;          body))

(defprocess router {:config-ref "apikit-config"} :xml-real-ns "mulify.mule-apikit")

;; (defn router [& [{:keys [config-ref] :or {config-ref "apikit-config"}}]]
;;   (dx/element ::router {:config-ref config-ref}))

(defprocess console {:config-ref "apikit-config"} :xml-real-ns "mulify.mule-apikit")

;; (defn console [& [{:keys [config-ref] :or {config-ref "apikit-config"}}]]
;;   (dx/element ::console {:config-ref config-ref}))

(defprocess flow-mappings {} :xml-real-ns "mulify.mule-apikit")

;; (defn flow-mappings [& body]
;;   (apply dx/element ::flow-mappings {} body))

(defprocess flow-mapping {:resource-path "/" :action "get" :content-type "application/json"}
  :xml-real-ns "mulify.mule-apikit")

;; (defn flow-mapping [& [{:keys [resource-path
;;                                action
;;                                content-type]
;;                         :or {resource-path "/"
;;                              action "get"
;;                              content-type "application/json"}}]]
;;   ;; (when-not flow-ref
;;   ;;   (throw (ex-info "flow-ref required" {})))
;;   (dx/element ::flow-mapping {:resource resource-path
;;                               :action action
;;                               :content-type content-type
;;                               :flow-ref (str/replace (str action "::" resource-path) #"/+" "\\\\")}))
