(ns mulify.core
  (:gen-class )
  (:refer-clojure :exclude [error-handler try])
  (:import [org.mule.runtime.module.launcher MuleContainer])
  (:import [webapi Raml10])
  (:require [clojure.tools.cli :refer (parse-opts)]
            [clojure.string :as str]
            [clojure.java.io :as io]
            [clojure.xml :as xml]
            [clojure.zip :as zip]
            [clojure.data.xml :as dx]
            [silvur.datetime]
            [silvur.util :refer [uuid]]
            [taoensso.timbre :as log]
            [camel-snake-kebab.core :as csk]
            [camel-snake-kebab.extras :as cske]
            [mulify.dataweave :as dw]
            [clj-yaml.core :as yaml]
            ))


(def schema-location [["http://www.mulesoft.org/schema/mule/core"
                       "http://www.mulesoft.org/schema/mule/core/current/mule.xsd"]
                      ["http://www.mulesoft.org/schema/mule/file"
                       "http://www.mulesoft.org/schema/mule/file/current/mule-file.xsd"]
                      ;; ["http://www.mulesoft.org/schema/mule/batch"
                      ;;  "http://www.mulesoft.org/schema/mule/batch/current/mule-batch.xsd"]
                      ["http://www.mulesoft.org/schema/mule/http"
                       "http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd"]
                      ;; ["http://www.mulesoft.org/schema/mule/mule-apikit"
                      ;;  "http://www.mulesoft.org/schema/mule/mule-apikit/current/mule-apikit.xsd"]
                      ["http://www.mulesoft.org/schema/mule/db"
                       "http://www.mulesoft.org/schema/mule/db/current/mule-db.xsd"]
                      ["http://www.mulesoft.org/schema/mule/mongo"
                       "http://www.mulesoft.org/schema/mule/mongo/current/mule-mongo.xsd"]
                      ;; ["http://www.mulesoft.org/schema/mule/ee/core"
                      ;;  "http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd"]
                      ["http://www.mulesoft.org/schema/mule/salesforce"
                       "http://www.mulesoft.org/schema/mule/salesforce/current/mule-salesforce.xsd"]
                      ;; ["http://www.mulesoft.org/schema/mule/apikit-soap"
                      ;;  "http://www.mulesoft.org/schema/mule/apikit-soap/current/mule-apikit-soap.xsd"]
                      ;; ["http://www.mulesoft.org/schema/mule/wsc"
                      ;;  "http://www.mulesoft.org/schema/mule/wsc/current/mule-wsc.xsd"]
                      ;; ["http://www.mulesoft.org/schema/mule/google-sheets"
                      ;;  "http://www.mulesoft.org/schema/mule/google-sheets/current/mule-google-sheets.xsd"]
                      ["http://www.mulesoft.org/schema/mule/tls"
                       "http://www.mulesoft.org/schema/mule/tls/current/mule-tls.xsd"]
                      
                      ["http://www.mulesoft.org/schema/mule/mqtt3"
                       "http://www.mulesoft.org/schema/mule/mqtt3/current/mule-mqtt3.xsd"]
                      ;; Enterprise 
                      ["http://www.mulesoft.org/schema/mule/core"
                       "http://www.mulesoft.org/schema/mule/core/current/mule.xsd"]
                      ;; ["http://www.mulesoft.org/schema/mule/ee/tracking"
                      ;;  "http://www.mulesoft.org/schema/mule/ee/tracking/current/mule-tracking-ee.xsd"]
                      ["http://www.mulesoft.org/schema/mule/validation"
                       "http://www.mulesoft.org/schema/mule/validation/current/mule-validation.xsd"]
                      ])

;; (defn camelize [m]
;;   (let [keep-map (select-keys m [:config-ref])
;;         keep-keys (set (keys keep-map))]
;;     (->> m
;;          (filter #(not (keep-keys (first %))))
;;          (into {})
;;          (cske/transform-keys csk/->camelCaseKeyword)
;;          (merge keep-map))))


;;
(defn camelize [m]
  (reduce (fn [r [k v]]
            (conj r {(keyword (if (.matches (name k) ".*-ref$")
                                (str (csk/->camelCaseString  (str/replace (name k) #"-ref$" "")) "-ref")
                                (csk/->camelCaseKeyword k)))
                     v}))
          {}
          m))

;;  {:mulify.core/when mulify.core/+when, ...}
(def global-process-map (atom {}))

;; Maco to define functions
(defmacro defprocess [process-name & default-params-and-key-params]
  (let [[default-params
         {:keys [key key-fn update-fn xml-real-ns merge-params?]
          :or   {key-fn        camelize
                 merge-params? true
                 update-fn     identity}}] (cond
                                       ;; handle attributes given as map
                                             (map? (first default-params-and-key-params))
                                             (do
                                               [(first default-params-and-key-params) (into {} (map vec (partition 2 (rest default-params-and-key-params))))])
                                             ;; handle variables 
                                             (symbol? (first default-params-and-key-params))
                                             (do
                                               [(first default-params-and-key-params) (into {} (map vec (partition 2 (rest default-params-and-key-params))))])
                                             :else
                                             (do
                                               [{} (into {} (map vec (partition 2 default-params-and-key-params)))]))

        current-ns    (str (ns-name *ns*))
        qualified-key (or key (keyword (or xml-real-ns current-ns) (str process-name)))
        target-key    (keyword current-ns (str process-name))
        body 'body
        params 'params]
    (swap! global-process-map assoc qualified-key (symbol target-key))
    (do
      (list 'defn process-name
            (list []
                  (list process-name {}))
            (list (vector {:keys (mapv (comp symbol name) (keys default-params)) :as params} '& body)
                  `(let [key#            ~qualified-key
                         key-fn# (comp ~key-fn #(update-keys %
                                                             (fn [k#]
                                                               (if (= :display-name k#)
                                                                 :doc:name
                                                                 k#))))
                         ]
                     (->> (cond
                            (or (:tag ~params) (instance? clojure.data.xml.node.CData ~params))
                            (apply dx/element key#  (key-fn# ~params) ~body)

                            (string? ~params)
                            (dx/element key#  (key-fn# ~default-params) (~update-fn ~params))

                            :else
                            (apply dx/element key# (let [user-params# (cond-> ~params
                                                                        (:name ~params) (update :name str/replace #" +" "_"))
                                                         merged-params# (cond
                                                                          (and ~merge-params? (seq user-params#))
                                                                          (merge-with (fn [l# r#] (or r# l#)) ~default-params user-params#)
                                                                          (and (not ~merge-params?) (seq user-params#))
                                                                          user-params#
                                                                          :else
                                                                          (merge-with (fn [l# r#] (or r# l#)) ~default-params user-params#))]
                                                     
                                                     (key-fn# merged-params#))
                                   (map ~update-fn ~body))))))))))

(defprocess configuration-properties {:file "mule-artifact.properties"})

(defprocess configuration {:default-error-handler-ref "default-error-handler"})

;; If it is not preferred to merge params when users give the params, set  :merge-params? to false.
(defprocess mule  {:xmlns:core          "http://www.mulesoft.org/schema/mule/core"
                   :xmlns:batch         "http://www.mulesoft.org/schema/mule/batch"
                   :xmlns:apikit-soap   "http://www.mulesoft.org/schema/mule/apikit-soap"
                   :xmlns:mqtt3         "http://www.mulesoft.org/schema/mule/mqtt3"         
                   :xmlns:http          "http://www.mulesoft.org/schema/mule/http"
                   :xmlns:db            "http://www.mulesoft.org/schema/mule/db"
                   :xmlns:file          "http://www.mulesoft.org/schema/mule/file"
                   :xmlns:wsc           "http://www.mulesoft.org/schema/mule/wsc"
                   :xmlns:apikit        "http://www.mulesoft.org/schema/mule/mule-apikit"
                   :xmlns:xsi           "http://www.w3.org/2001/XMLSchema-instance"
                   :xmlns:mongo         "http://www.mulesoft.org/schema/mule/mongo"
                   :xmlns:doc           "http://www.mulesoft.org/schema/mule/documentation"
                   :xmlns:google-sheets "http://www.mulesoft.org/schema/mule/google-sheets"
                   :xmlns:salesforce    "http://www.mulesoft.org/schema/mule/salesforce"
                   :xmlns:tls           "http://www.mulesoft.org/schema/mule/tls"
                   :xmlns:validation    "http://www.mulesoft.org/schema/mule/validation"
                   ;; Enterprise
                   :xmlns:ee            "http://www.mulesoft.org/schema/mule/ee/core"
                   :xmlns:tracking      "http://www.mulesoft.org/schema/mule/ee/tracking"
                   ;; XSI
                   :xsi:schemaLocation (str/join " " (flatten schema-location))
                   } :key-fn identity)

(defprocess flow {:name (str (gensym "Flow_"))})

(defprocess choice {:display-name "choice"})

(defprocess +when {:expression "#[payload.handler.name == \"order\"]"} :key ::when)
(defprocess +otherwise {} :key ::otherwise)

(defprocess logger {:display-name "logger" :level "INFO" :message ""}  :key-fn #(update % :level (comp str/upper-case name)))

(defn logger* [level message]
  (logger {:level level :message message}))

(defprocess set-variable {:value "" :variable-name ""})



(defprocess set-payload {:value ""})

(defprocess async)

(defprocess error-handler {:name "error-handler"})


(defprocess on-error-propagate {:type "ANY"})

(defprocess on-error-continue {:type "ANY" :log-exception true :enable-notifications true})

(defprocess on-error {:ref "error-ref-name"})

(defprocess raise-error {:type "MULE:EXPRESSION" :description "error occurred"})

(defprocess foreach {:collection (dw/fx "payload")
                     :batchSize "10"
                     :root-message-variable-name "rootMessageVar"
                     :counter-variable-name "counter"})

(defprocess flow-ref {:name "flow-pointed-target"})

(defprocess sub-flow)

(defprocess first-successful)

(defprocess round-robin)

(defprocess scatter-gather)

(defprocess +route {} :key ::route)

(defprocess configuration-properties {:file "mule-artifact.properties"})

(defprocess try)

(defprocess scheduler)
(defprocess scheduling-strategy)
(defprocess fixed-frequency {:frequency "60000", :start-delay "10", :time-unit "MILLISECONDS"})



(defn mule-schema-seq [mule-xsd-key-or-schema-location]
  (let [xs (->> (dx/parse-str (slurp (cond (keyword? mule-xsd-key-or-schema-location)
                                           (str "http://www.mulesoft.org/schema/mule/"
                                                (name mule-xsd-key-or-schema-location)
                                                "/current/mule"
                                                (when-not (= mule-xsd-key-or-schema-location :core)
                                                  (str "-" (name mule-xsd-key-or-schema-location)))
                                                ".xsd")
                                           (and (map? mule-xsd-key-or-schema-location)
                                                (get-in mule-xsd-key-or-schema-location [:attrs :schemaLocation]))
                                           (get-in mule-xsd-key-or-schema-location [:attrs :schemaLocation])
                                           
                                           
                                           :else mule-xsd-key-or-schema-location)) :namespace-aware false)
                (clojure.walk/postwalk (fn [z]
                                         (cond (seq? z)    (filter (complement empty?) z)
                                               (string? z) (str/trim z)
                                               :else       z)))
                (xml-seq))]
    ;; Get recursively the elements of :xsd:include
    (if-let [zs (seq (filter (comp #{:xsd:include} :tag) xs))]
      (apply concat xs (map mule-schema-seq zs))
      xs)))


(def e (memoize mule-schema-seq))

(defn query-by-name [element-name xml-tree-seq]
  (first (filter (comp #{element-name} :name :attrs) xml-tree-seq)))


(defn gen-schema [xml-tree-seq]
  (reduce (fn [r x]
            (let [{{name :name type :type ref :ref} :attrs tag :tag} x]
              (cond
                ;; r {type {
                (and (#{:xsd:element} tag) type) (let []
                                                   (-> r
                                                       (assoc-in [(keyword name) :elements]
                                                                 (->> (query-by-name type xml-tree-seq)
                                                                      :content
                                                                      (mapcat (fn [z]
                                                                                (filter (comp #{:xsd:element} :tag) (xml-seq z))))
                                                                      (mapv :attrs)))
                                                       (assoc-in [(keyword name) :attrs]
                                                                 (->> (query-by-name type xml-tree-seq)
                                                                      :content
                                                                      (mapcat (fn [z]
                                                                                (filter (comp #{:xsd:attribute} :tag) (xml-seq z))))
                                                                      (mapv :attrs)))))
                :else r)))
          {}
          xml-tree-seq))

(defn query [e-name xml-tree-seq]
  (get  (gen-schema xml-tree-seq) e-name))



(comment
  (query :listener-config (e :httpn)))





