(ns mulify.shell
  (:require [clojure.zip :as zip]
            [clojure.data.xml :as dx]
            [clojure.java.io :as io]
            [clojure.string :as str]
            [camel-snake-kebab.core :as csk]
            [camel-snake-kebab.extras :as cske]
            [mulify.core :refer [global-process-map]]
            [mulify http apikit db ee file wsc]
            [mulify.utils :as utils]
            ))

(def mule-app
  (mulify.core/mule
   {:xmlns:http         "http://www.mulesoft.org/schema/mule/http",
    :xmlns:core         "http://www.mulesoft.org/schema/mule/core",
    :xmlns:mule-apikit  "http://www.mulesoft.org/schema/mule/mule-apikit",
    :xsi:schemaLocation "http://www.w3.org/2001/XMLSchema-instance",
    :xmlns:xsi          "http://www.w3.org/2001/XMLSchema-instance"}
   (mulify.core/configuration-properties
    {:file "mule-artifact.properties"})
   (mulify.apikit/config
    {:name                   "router-config",
     :raml                   "api.raml",
     :outboundHeadersMapName "outboundHeaders",
     :httpStatusVarName      "httpStatus"})
   (mulify.http/listener-config
    {:name "httpListenerConfigDefault"}
    (mulify.http/listener-connection
     {:host "0.0.0.0", :port "${http.port}"}))
   (mulify.core/flow
    {:name "main-api"}
    (mulify.http/listener
     {:config-ref "httpListenerConfigDefault", :path "/api/*"}
     (mulify.http/response
      {:statusCode "#[vars.httpStatus default 200]"}
      (mulify.http/headers "#[vars.outboundHeaders default {}]"))
     (mulify.http/error-response
      {:statusCode "#[vars.httpStatus default 500]"}
      (mulify.http/body "#[payload]")
      (mulify.http/headers "#[vars.outboundHeaders default {}]")))
    (mulify.apikit/router {:config-ref "router-config"})
    (mulify.core/error-handler
     (mulify.core/on-error-propagate
      {:type "APIKIT:BAD_REQUEST"}
      (mulify.core/set-variable
       {:variableName "outboundHeaders",
        :value        "#[{'Content-Type':'application/json'}]"})
      (mulify.core/set-payload
       {:value "{ \"message\": \"Bad request\" }"})
      (mulify.core/set-variable
       {:variableName "httpStatus", :value "400"}))
     (mulify.core/on-error-propagate
      {:type "APIKIT:NOT_FOUND"}
      (mulify.core/set-variable
       {:variableName "outboundHeaders",
        :value        "#[{'Content-Type':'application/json'}]"})
      (mulify.core/set-payload
       {:value "{ \"message\": \"Resource not found\" }"})
      (mulify.core/set-variable
       {:variableName "httpStatus", :value "404"}))
     (mulify.core/on-error-propagate
      {:type "APIKIT:METHOD_NOT_ALLOWED"}
      (mulify.core/set-variable
       {:variableName "outboundHeaders",
        :value        "#[{'Content-Type':'application/json'}]"})
      (mulify.core/set-payload
       {:value "{ \"message\": \"Method not allowed\" }"})
      (mulify.core/set-variable
       {:variableName "httpStatus", :value "405"}))
     (mulify.core/on-error-propagate
      {:type "APIKIT:NOT_ACCEPTABLE"}
      (mulify.core/set-variable
       {:variableName "outboundHeaders",
        :value        "#[{'Content-Type':'application/json'}]"})
      (mulify.core/set-payload
       {:value "{ \"message\": \"Not acceptable\" }"})
      (mulify.core/set-variable
       {:variableName "httpStatus", :value "406"}))
     (mulify.core/on-error-propagate
      {:type "APIKIT:UNSUPPORTED_MEDIA_TYPE"}
      (mulify.core/set-variable
       {:variableName "outboundHeaders",
        :value        "#[{'Content-Type':'application/json'}]"})
      (mulify.core/set-payload
       {:value "{ \"message\": \"Unsupported media type\" }"})
      (mulify.core/set-variable
       {:variableName "httpStatus", :value "415"}))
     (mulify.core/on-error-propagate
      {:type "APIKIT:NOT_IMPLEMENTED"}
      (mulify.core/set-variable
       {:variableName "outboundHeaders",
        :value        "#[{'Content-Type':'application/json'}]"})
      (mulify.core/set-payload
       {:value "{ \"message\": \"Not implemented\" }"})
      (mulify.core/set-variable
       {:variableName "httpStatus", :value "501"}))))
   (mulify.core/flow
    {:name "main-console"}
    (mulify.http/listener
     {:config-ref "httpListenerConfigDefault", :path "/console/*"}
     (mulify.http/response
      {:statusCode "#[vars.httpStatus default 200]"}
      (mulify.http/headers "#[vars.outboundHeaders default {}]"))
     (mulify.http/error-response
      {:statusCode "#[vars.httpStatus default 500]"}
      (mulify.http/body "#[payload]")
      (mulify.http/headers "#[vars.outboundHeaders default {}]")))
    (mulify.apikit/console {:config-ref "router-config"})

    ;; Error handling
    (mulify.core/error-handler
     (mulify.core/on-error-propagate
      {:type "APIKIT:NOT_FOUND"}
      (mulify.core/set-variable
       {:variableName "outboundHeaders",
        :value        "#[{'Content-Type':'application/json'}]"})
      (mulify.core/set-payload
       {:value "{ \"message\": \"Resource not found\" }"})
      (mulify.core/set-variable
       {:variableName "httpStatus", :value "404"}))))
   (mulify.core/flow
    {:name "get:\\flights:router-config"}
    (mulify.core/logger
     {:level "INFO", :message "get:\\flights:router-config"})))
)


(defn -main [& args]
  
  )
