(ns mulify.pom
 (:gen-class)
 (:require
  [clojure.string :as str]
  [silvur.util :refer (json->edn edn->json edn->xml)]))

(def pom-content
 {:project
  {:properties
   {:project.build.sourceEncoding "UTF-8",
    :mule.maven.plugin.version "3.8.0",
    :app.runtime "4.4.0-20220622",
    :project.reporting.outputEncoding "UTF-8"},
   :groupId "my-group",
   :packaging "mule-application",
   :name "hello-world",
   :-xsi:schemaLocation
   "http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd",
   :-xmlns "http://maven.apache.org/POM/4.0.0",
   :repositories
   {:repository
    [{:layout "default",
      :name "Anypoint Exchange",
      :id "anypoint-exchange-v3",
      :url "https://maven.anypoint.mulesoft.com/api/v3/maven"}
     {:layout "default",
      :name "MuleSoft Releases Repository",
      :id "mulesoft-releases",
      :url "https://repository.mulesoft.org/releases/"}]},
   :-xmlns:xsi "http://www.w3.org/2001/XMLSchema-instance",
   :build
   {:plugins
    {:plugin
     [{:groupId "org.apache.maven.plugins",
       :artifactId "maven-clean-plugin",
       :version "3.2.0"}
      {:groupId "org.mule.tools.maven",
       :artifactId "mule-maven-plugin",
       :extensions "true",
       :version "${mule.maven.plugin.version}",
       :configuration {:sharedLibraries [{:sharedLibrary {:groupId "mysql", :artifactId "mysql-connector-java"}}
                                         {:sharedLibrary {:groupId "org.codehaus.groovy", :artifactId "groovy-all"}}]
                       :classifier "mule-application"}}]}},
   :artifactId "hello-world",
   :pluginRepositories
   {:pluginRepository
    {:layout "default",
     :name "MuleSoft Releases Repository",
     :id "mulesoft-releases",
     :snapshots {:enabled "false"},
     :url "https://repository.mulesoft.org/releases/"}},
   :version "1.0.0-SNAPSHOT",
   :dependencies
   {:dependency
    [{:groupId "com.mulesoft.connectors",
      :classifier "mule-plugin",
      :artifactId "mule-salesforce-connector",
      :version "10.15.0"}
     {:groupId "org.mule.modules",
      :classifier "mule-plugin",
      :artifactId "mule-apikit-module",
      :version "1.5.11"}
     {:groupId "org.mule.connectors",
      :classifier "mule-plugin",
      :artifactId "mule-db-connector",
      :version "1.12.1"}
     {:groupId "mysql",
      :artifactId "mysql-connector-java",
      :version "8.0.30"}
     {:groupId "org.mule.connectors",
      :classifier "mule-plugin",
      :artifactId "mule-http-connector",
      :version "1.7.1"}
     {:groupId "org.mule.connectors",
      :classifier "mule-plugin",
      :artifactId "mule-sockets-connector",
      :version "1.2.2"}
     {:groupId "org.mule.modules",
      :classifier "mule-plugin",
      :artifactId "mule-scripting-module",
      :version "2.0.3"}
     {:groupId "org.mule.connectors",
      :classifier "mule-plugin",
      :artifactId "mule-file-connector",
      :version "1.5.0"}
     {:groupId "org.codehaus.groovy",
      :classifier "indy",
      :artifactId "groovy-all",
      :version "2.4.21"}
     ]},
   :modelVersion "4.0.0"}})

(defn gen-pom! [group artifact version & {:keys [raw?]}]
  (cond-> pom-content
    :run (assoc-in [:project :groupId] (name group))
    :run (assoc-in [:project :name] (name artifact))
    :run  (assoc-in [:project :artifactId] (name artifact))
    :run (assoc-in [:project :version] version)
    (not raw?) (edn->xml)
    (not raw?) (->> (spit "pom.xml"))))

(defn pom-update! 
  ([app]
   (let
       [{:keys [group artifact version]} (meta app)]
     (pom-update! group artifact version)
     app))
  ([group artifact version]
   (spit
     "pom.xml"
     (->
       pom-content
       (assoc-in [:project :groupId] group)
       (assoc-in [:project :name] artifact)
       (assoc-in [:project :artifactId] artifact)
       (assoc-in [:project :version] version)
       (edn->xml)))))

