(ns mulify.ibm-mq
  (:refer-clojure :exclude [update binding])
  (:require [clojure.data.xml :as dx]
            [silvur.util :refer [uuid]]
            [clojure.string :as str]
            [clojure.spec.alpha :as s]
            [clojure.spec.test.alpha :as t]
            [mulify.core :refer (defprocess >camel contains-tag?)]))

		;; <dependency>
		;; 	<groupId>com.mulesoft.connectors</groupId>
		;; 	<artifactId>mule-ibm-mq-connector</artifactId>
		;; 	<version>1.6.16</version>
		;; 	<classifier>mule-plugin</classifier>
		;; </dependency>
		;; <dependency>
		;; 	<groupId>com.ibm.mq</groupId>
		;; 	<artifactId>com.ibm.mq.allclient</artifactId>
		;; 	<version>9.3.1.0</version>
		;; </dependency>

;; <sharedLibraries>
;; 						<sharedLibrary>
;; 							<groupId>com.ibm.mq</groupId>
;; 							<artifactId>com.ibm.mq.allclient</artifactId>
;; 						</sharedLibrary>
;; 					</sharedLibraries>

(defprocess config {:name "IBM_MQ_Config"})
(defprocess connection {:username "" :password "" :client-id "" :ccs-id ""})
(defprocess connection-mode)
(defprocess binding {:queue-manager ""})

(defprocess listener {:config-ref "IBM_MQ_Config" :destination "" :ack-mode "AUTO"})
(defprocess consume {:config-ref "IBM_MQ_Config" :destination "" :ack-mode "AUTO"})
(defprocess publish {:config-ref "IBM_MQ_Config" :destination "" :ack-mode "AUTO"})
(defprocess message)
(defprocess body)

;; Config
(s/fdef config
  :args (s/cat
          :attr (s/? (s/keys :req-un [::name]))
          :connection (contains-tag? ::connection)))

(s/fdef connection
  :args (s/cat
          :attr (s/keys :req-un [::username ::password ::client-id ::ccs-id])
          :connection-mode (contains-tag? ::connection-mode)))

(s/fdef connection-mode
  :args (s/cat
          :binding (contains-tag? ::binding)))

(s/fdef binding
  :args (s/cat
          :attr (s/keys :req-un [::queue-manager])))


;; Listener

(s/fdef listener
  :args (s/cat
          :attr (s/keys :req-un [::config-ref ::destination ::ack-mode])))

;; Processors
(s/fdef consume
  :args (s/cat
          :attr (s/keys :req-un [::config-ref ::destination ::ack-mode])))

(s/fdef publish
  :args (s/cat
          :attr (s/keys :req-un [::config-ref ::destination ::ack-mode])
          :items (s/? (contains-tag? ::message))))

;; Message

(s/fdef message
  :args (s/cat :body (contains-tag? ::body)))

(s/fdef body
  :args (s/cat :cdata (partial instance? clojure.data.xml.node.CData)))



(t/instrument)

