(ns silvur.cli
  (:gen-class)
  (:require [clojure.tools.cli :refer (parse-opts)]
            [clojure.string :as str]
            [silvur.openssl :as ssl]))

(def specs [["-h" "--help"]])

(defn usage [summary]
  (->> ["Usage: silvur <sub command> [options]" 
        ""
        "sub commands:"
        ""
        " - tls <build-ca|gen-self-cert> [options]"
        ""
        "global options:"
        summary
        ]
      (str/join \newline)))

(defn -main [& args]
  (let [{:keys [options arguments summary]} (parse-opts args specs)]
    (cond
      (#{"tls" "ssl"} (first arguments)) (apply ssl/main (rest args))
      :else  (println (usage summary))))
  (shutdown-agents))
