(ns silvur.x
  (:require [silvur.http :as http]
            [silvur.util :refer [edn->json]]
            [silvur.log :as log]))


(def sample-config
  {:port 9180,
   :auth-endpoint "https://twitter.com/i/oauth2/authorize",
   
   :auth-options {:client-id "dmoxTE92TS1TbU5rWWRQaS1ER1U6MTpjaQ",
                  :response-type "code",
                  :scope ["tweet.read" "users.read" "tweet.write" "offline.access"],
                  :code-challenge "challenge"
                  :code-challenge-method "plain"
                  :state "state"
                  :redirect-uri "http://localhost:9180/oauth2/callback"}
   ,
   :token-endpoint "https://api.x.com/2/oauth2/token",
   :token-headers {"Authorization" "Basic ZG1veFRFOTJUUzFUYlU1cldXUlFhUzFFUjFVNk1UcGphUTpJWnM3Q1VaeDRfOEdUZHJ6MkxYdjJoVWhlOE9Vb2xnUEJmTDdwNERMeGE3ak9YOFVGbw=="}
   :token-options {:grant-type "authorization_code",
                   :client-id "dmoxTE92TS1TbU5rWWRQaS1ER1U6MTpjaQ",
                   :code-verifier "challenge"
                   :client-secret "IZs7CUZx4_8GTdrz2LXv2hUhe8OUolgPBfL7p4DLxa7jOX8UFo",
                   :redirect-uri "http://localhost:9180/oauth2/callback"}})

(defn tweet [text access-token refresh-token-fn]
  (letfn [(tw []
            (http/post "https://api.x.com/2/tweets" {:headers {"Content-Type" "application/json"
                                                               "Authorization" (str "Bearer " access-token)}
                                                     :body (edn->json {:text text})}))]
    (loop [i 1 ret (tw)]
      (let [{:keys [status body]} ret]
        (if (= 401 status)
          (if (= i 0)
            (log/warn "Failed to tweet even token refreshed")
            (do
              (log/info "Try to refresh token")
              (refresh-token-fn)
              (recur (dec i) (tw))))
          (log/info "tweet status: " status))))))
