/*
 * Decompiled with CFR 0.152.
 */
package jepsen;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class history$fn__2926
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"jepsen.history")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Support functions for working with histories. This provides two things you\n  need for writing efficient checkers:\n\n  1. A dedicated Op defrecord which speeds up the most commonly accessed\n  fields and reduces memory footprint.\n\n  2. A History datatype which generally works like a vector, but also supports\n  efficient fetching of operations by index, mapping back and forth between\n  invocations and completions, efficient lazy map/filter, fusable concurrent\n  reduce/fold, and a dependency-oriented task executor.\n\n  ## Ops\n\n  Create operations with the `op` function. Unlike most defrecords, we\n  pretty-print these as if they were maps--we print a LOT of them.\n\n    (require '[jepsen.history :as h])\n    (def o (h/op {:process 0, :type :invoke, :f :read, :value [:x nil],\n                  :index 0, :time 0}))\n    (pprint o)\n    ; {:process 0,\n    ;  :type :invoke,\n    ;  :f :read,\n    ;  :value [:x nil],\n    ;  :index 0,\n    ;  :time 0}\n\n  We provide a few common functions for interacting with operations:\n\n    (invoke? o)    ; true\n    (client-op? o) ; true\n    (info? o)      ; false\n\n  And of course you can use fast field accessors here too:\n\n    (.process o) ; 0\n\n  ## Histories\n\n  Given a collection of operations, create a history like so:\n\n    (def h (h/history [{:process 0, :type :invoke, :f :read}\n                       {:process 0, :type :ok, :f :read, :value 5}]))\n\n  `history` automatically lifts maps into Ops if they aren't already, and adds\n  indices (sequential) and times (-1) if you omit them. There are options to\n  control how indices are added; see `history` for details.\n\n    (pprint h)\n    ; [{:process 0, :type :invoke, :f :read, :value nil, :index 0, :time -1}\n    ;  {:process 0, :type :ok, :f :read, :value 5, :index 1, :time -1}]\n\n  If you need to convert these back to plain-old maps for writing tests, use\n  `as-maps`.\n\n    (h/as-maps h)\n    ; [{:index 0, :time -1, :type :invoke, :process 0, :f :read, :value nil}\n    ;  {:index 1, :time -1, :type :ok, :process 0, :f :read, :value 5}]\n\n  Histories work almost exactly like vectors (though you can't assoc or conj\n  into them).\n\n    (count h)\n    ; 2\n    (nth h 1)\n    ; {:index 1, :time -1, :type :ok, :process 0, :f :read, :value 5}\n    (map :type h)\n    ; [:invoke :ok]\n\n  But they have a few extra powers. You can get the Op with a particular :index\n  regardless of where it is in the collection.\n\n    (h/get-index h 0)\n    ; {:index 0, :time -1, :type :invoke, :process 0, :f :read, :value nil}\n\n  And you can find the corresponding invocation for a completion, and\n  vice-versa:\n\n    (h/invocation h {:index 1, :time -1, :type :ok, :process 0, :f :read,\n                     :value 5})\n    ; {:index 0, :time -1, :type :invoke, :process 0, :f :read, :value nil}\n\n    (h/completion h {:index 0, :time -1, :type :invoke, :process 0, :f :read, :value nil})\n    ; {:index 1, :time -1, :type :ok, :process 0, :f :read, :value 5}\n\n  We call histories where the :index fields are 0, 1, 2, ... 'dense', and other\n  histories 'sparse'. With dense histories, `get-index` is just `nth`. Sparse\n  histories are common when you're restricting yourself to just a subset of the\n  history, like operations on clients. If you pass sparse indices to `(history\n  ops)`, then ask for an op by index, it'll do a one-time fold over the ops to\n  find their indices, then cache a lookup table to make future lookups fast.\n\n    (def h (history [{:index 3, :process 0, :type :invoke, :f :cas,\n                      :value [7 8]}]))\n    (h/dense-indices? h)\n    ; false\n    (get-index h 3)\n    ; {:index 3, :time -1, :type :invoke, :process 0, :f :cas, :value [7 8]}\n\n  Let's get a slightly more involved history. This one has a concurrent nemesis\n  crashing while process 0 writes 3.\n\n    (def h (h/history\n             [{:process 0, :type :invoke, :f :write, :value 3}\n              {:process :nemesis, :type :info, :f :crash}\n              {:process 0, :type :ok, :f :write, :value 3}\n              {:process :nemesis, :type :info, :f :crash}]))\n\n  Of course we can filter this to just client operations using regular seq\n  operations...\n\n    (filter h/client-op? h)\n    ; [{:process 0, :type :invoke, :f :write, :value 3, :index 0, :time -1}\n    ;  {:process 0, :type :ok, :f :write, :value 3, :index 2, :time -1}]\n\n  But `jepsen.history` also exposes a more efficient version:\n\n    (h/filter h/client-op? h)\n    ; [{:index 0, :time -1, :type :invoke, :process 0, :f :write, :value 3}\n    ;  {:index 2, :time -1, :type :ok, :process 0, :f :write, :value 3}]\n\n  There are also shortcuts for common filtering ops: `client-ops`, `invokes`,\n  `oks`, `infos`, and so on.\n\n    (def ch (h/client-ops h))\n    (type ch)\n    ; jepsen.history.FilteredHistory\n\n  Creating a filtered history is O(1), and acts as a lazy view on top of the\n  underlying history. Like `clojure.core/filter`, it materializes elements as\n  needed. Unlike Clojure's `filter`, it does not (for most ops) cache results\n  in memory, so we can work with collections bigger than RAM. Instead, each\n  seq/reduce/fold/etc applies the filtering function to the underlying history\n  on-demand.\n\n  When you ask for a count, or to fetch operations by index, or to map between\n  invocations and completions, a FilteredHistory computes a small, reduced data\n  structure on the fly, and caches it to make later operations of the same type\n  fast.\n\n    (count ch) ; Folds over entire history to count how many match the predicate\n    ; 2\n    (count ch) ; Cached\n\n    ; (h/completion ch (first ch)) ; Folds over history to pair up ops, caches\n    {:index 2, :time -1, :type :ok, :process 0, :f :write, :value 3}\n\n    ; (h/get-index ch 2) ; No fold required; underlying history does get-index\n    {:index 2, :time -1, :type :ok, :process 0, :f :write, :value 3}\n\n  Similarly, `h/map` constructs an O(1) lazy view over another history. These\n  compose just like normal Clojure `map`/`filter`, and all share structure with\n  the underlying history.\n\n  ### Folds\n\n  All histories support `reduce`, `clojure.core.reducers/fold`, Tesser's\n  `tesser`, and `jepsen.history.fold/fold`. All four mechanisms are backed by\n  a `jepsen.history.fold` Folder, which allows concurrent folds to be joined\n  together on-the-fly and executed in fewer passes over the underlying data.\n  Reducers, Tesser, and history folds can also be executed in parallel.\n\n  Histories created with `map` and `filter` share the folder of their\n  underlying history, which means that two threads analyzing different views of\n  the same underlying history can have their folds joined into a single pass\n  automatically. This should hopefully be invisible to users, other than making\n  things Automatically Faster.\n\n  If you filter a history to a small subset of operations, or are comfortable\n  working in-memory, it may be sensible to materialize a history. Just use\n  `(vec h)` to convert a history a plain-old Clojure vector again.\n\n  ### Tasks\n\n  Analyzers often perform several independent reductions over a history, and\n  then compute new values based on those previous reductions. You can of course\n  use `future` for this, but histories also come with a shared,\n  dependency-aware threadpool executor for executing compute-bound concurrent\n  tasks. All histories derived from the same history share the same executor,\n  which means multiple checkers can launch tasks on it without launching a\n  bazillion threads. For instance, we might need to know if a history includes\n  crashes:\n\n    (def first-crash (h/task h find-first-crash []\n      (->> h (h/filter (comp #{:crash} :f)) first)))\n\n  Like futures, deref'ing a task yields its result, or throws.\n\n    @first-crash\n    {:index 1, :time -1, :type :info, :process :nemesis, :f :crash,\n     :value nil}\n\n  Unlike futures, tasks can express *dependencies* on other tasks:\n\n    (def ops-before-crash (h/task h writes [fc first-crash]\n      (let [i (:index first-crash)]\n        (into [] (take-while #(< (:index %) i)) h))))\n\n  This task won't run until first-crash has completed, and receives the result\n  of the first-crash task as its argument.\n\n    @ops-before-crash\n    ; [{:index 0, :time -1, :type :invoke, :process 0, :f :write, :value 3}]\n\n  See `jepsen.history.task` for more details."}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return history$fn__2926.invokeStatic();
    }
}

