/*
 * Decompiled with CFR 0.152.
 */
package jepsen.tests;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class kafka$fn__5063
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"jepsen.tests.kafka")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "This workload is intended for systems which behave like the popular Kafka\n  queue. This includes Kafka itself, as well as compatible systems like\n  Redpanda.\n\n  At the abstract level of this workload, these systems provide a set of\n  totally-ordered append-only logs called *partitions*, each of which stores a\n  single arbitrary (and, for our purposes, unique) *message* at a particular\n  *offset* into the log. Partitions are grouped together into *topics*: each\n  topic is therefore partially ordered.\n\n  Each client has a *producer* and a *consumer* aspect; in Kafka these are\n  separate clients, but for Jepsen's purposes we combine them. A\n  producer can *send* a message to a topic-partition, which assigns it a\n  unique, theoretically monotonically-increasing offset and saves it durably at\n  that offset. A consumer can *subscribe* to a topic, in which case the system\n  aautomatically assigns it any number of partitions in that topic--this\n  assignment can change at any time. Consumers can also assign themselves\n  specific partitions manually. When a consumer *polls*, it receives messages\n  and their offsets from whatever topic-partitions it is currently assigned to,\n  and advances its internal state so that the next poll (barring a change in\n  assignment) receives the immediately following messages.\n\n  ## Operations\n\n  To subscribe to a new set of topics, we issue an operation like:\n\n    {:f :subscribe, :value [k1, k2, ...]}\n\n  or\n\n    {:f :assign, :value [k1, k2, ...]}\n\n  ... where k1, k2, etc denote specific partitions. For subscribe,\n  we convert those partitions to the topics which contain them, and subscribe\n  to those topics; the database then controls which specific partitions we get.\n  Just like the Kafka client API, both subscribe and assign replace the current\n  topics for the consumer.\n\n  Assign ops can also have a special key `:seek-to-beginning? true` which\n  indicates that the client should seek to the beginning of all its partitions.\n\n  Reads and writes (and mixes thereof) are encoded as a vector of\n  micro-operations:\n\n    {:f :poll, :value [op1, op2, ...]}\n    {:f :send, :value [op1, op2, ...]}\n    {:f :txn,  :value [op1, op2, ...]}\n\n  Where :poll and :send denote transactions comprising only reads or writes,\n  respectively, and :txn indicates a general-purpose transaction. Operations\n  are of two forms:\n\n    [:send key value]\n\n  ... instructs a client to append `value` to the integer `key`--which maps\n  uniquely to a single topic and partition. These operations are returned as:\n\n    [:send key [offset value]]\n\n  where offset is the returned offset of the write, if available, or `nil` if\n  it is unknown (e.g. if the write times out).\n\n  Reads are invoked as:\n\n    [:poll]\n\n  ... which directs the client to perform a single `poll` operation on its\n  consumer. The results of that poll are expanded to:\n\n    [:poll {key1 [[offset1 value1] [offset2 value2] ...],\n            key2 [...]}]\n\n  Where key1, key2, etc are integer keys obtained from the topic-partitions\n  returned by the call to poll, and the value for that key is a vector of\n  [offset value] pairs, corresponding to the offset of that message in that\n  particular topic-partition, and the value of the message---presumably,\n  whatever was written by `[:send key value]` earlier.\n\n  When polling *without* using assign, clients should call `.commitSync` before\n  returning a completion operation.\n\n  Before a transaction completes, we commit its offsets.\n\n  All transactions may return an optional key :rebalance-log, which is a vector\n  of rebalancing events (changes in assigned partitions) that occurred during\n  the execution of that transaction. Each rebalance event is a map like:\n\n    {:keys [k1 k2 ...]}\n\n  There may be more keys in this map; I can't remember right now.\n\n  ## Topic-partition Mapping\n\n  We identify topics and partitions using abstract integer *keys*, rather than\n  explicit topics and partitions. The client is responsible for mapping these\n  keys bijectively to topics and partitions.\n\n  ## Analysis\n\n  From this history we can perform a number of analyses:\n\n  1. For any observed value of a key, we check to make sure that its writer was\n  either :ok or :info; if the writer :failed, we know this constitutes an\n  aborted read.\n\n  2. We verify that all sends and polls agree on the value for a given key and\n  offset. We do not require contiguity in offsets, because transactions add\n  invisible messages which take up an offset slot but are not visible to the\n  API. If we find divergence, we know that Kakfa disagreed about the value at\n  some offset.\n\n  Having verified that each [key offset] pair uniquely identifies a single\n  value, we eliminate the offsets altogether and perform the remainder of the\n  analysis purely in terms of keys and values. We construct a graph where\n  vertices are values, and an edge v1 -> v2 means that v1 immediately precedes\n  v2 in the offset order (ignoring gaps in the offsets, which we assume are due\n  to transaction metadata messages).\n\n  3. For each key, we take the highest observed offset, and then check that\n  every :ok :send operation with an equal or lower offset was *also* read by at\n  least one consumer. If we find one, we know a write was lost!\n\n  4. We build a dependency graph between pairs of transactions T1 and T2, where\n  T1 != T2, like so:\n\n    ww. T1 sent value v1 to key k, and T2 sent v2 to k, and o1 < o2\n        in the version order for k.\n\n    wr. T1 sent v1 to k, and T2's highest read of k was v1.\n\n    rw. T1's highest read of key k was offset o1, and T2 sent offset o2 to k,\n        and o1 < o2 in the version order for k.\n\n  Our use of \"highest offset\" is intended to capture the fact that each poll\n  operation observes a *range* of offsets, but in general those offsets could\n  have been generated by *many* transactions. If we drew wr edges for every\n  offset polled, we'd generate superfluous edges--all writers are already\n  related via ww dependencies, so the final wr edge, plus those ww edges,\n  captures those earlier read values.\n\n  We draw rw edges only for the final versions of each key observed by a\n  transaction. If we drew rw edges for an earlier version, we would incorrectly\n  be asserting that later transactions were *not* observed!\n\n  We perform cycle detection and categorization of anomalies from this graph\n  using Elle.\n\n  5. Internal Read Contiguity: Within a transaction, each pair of reads on the\n  same key should be directly related in the version order. If we observe a gap\n  (e.g. v1 < ... < v2) that indicates this transaction skipped over some\n  values. If we observe an inversion (e.g. v2 < v1, or v2 < ... < v1) then we\n  know that the transaction observed an order which disagreed with the \"true\"\n  order of the log.\n\n  6. Internal Write Contiguity: Gaps between sequential pairs of writes to the\n  same key are detected via Elle as write cycles. Inversions are not, so we\n  check for them explicitly: a transaction sends v1, then v2, but v2 < v1 or v2\n  < ... v1 in the version order.\n\n  7. Intermediate reads? I assume these happen constantly, but are they\n  supposed to? It's not totally clear what this MEANS, but I think it might\n  look like a transaction T1 which writes [v1 v2 v3] to k, and another T2 which\n  polls k and observes any of v1, v2, or v3, but not *all* of them. This\n  miiight be captured as a wr-rw cycle in some cases, but perhaps not all,\n  since we're only generating rw edges for final reads.\n\n  8. Precommitted reads. These occur when a transaction observes a value that\n  it wrote. This is fine in most transaction systems, but illegal in Kafka,\n  which assumes that consumers (running at read committed) *never* observe\n  uncommitted records."}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return kafka$fn__5063.invokeStatic();
    }
}

