# clojure-polyline

Decoding and encoding of the google polyline algorithm. Forked from [mgaare/clojure-polyline](https://github.com/mgaare/clojure-polyline)

# usage

```clojure
[io.jesi/clojure-polyline "0.1.1"]
```

```clojure
(ns io.jesi.clojure-polyline.example
	(:require [clojure-polyline.core :as polyline]))

; Decode a polyline string:
(polyline/decode polystring) ; Returns a vector of maps: [{:latitude lat :longitude lon} ...]
(polyline/decode polystring vec->lonlat) ; Returns a vector of vectors: [[lon lat] ...]
(polyline/decode polystring vec->latlon) ; Returns a vector of vectors: [[lat lon] ...]

;Encode a vector of coordinates:
(def ^:private coords [[38.5 -120.2] [40.7 -120.95] [43.252 -126.453]])
(polyline/encode coords) ; Returns a polyline-encoded string "_p~iF~ps|U_ulLnnqC_mqNvxq`@"

; NOTE:
; encode expects a sequence of vectors of the format [latitude longitude] - if you have this as a sequence of maps of
; the format {:longitude longitude :latitude latitude} you can use (coords->vec) to turn it into the right format.
; You can also use to-coords to turn a vector of [latitude longitude] vectors into this format)
```

## License

Copyright © 2012 Michael Gaare

Distributed under the Eclipse Public License, the same as Clojure.
