/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.checker;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingException;
import java.security.SecureRandom;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestsWindowChecker {
    private static final Logger log = LoggerFactory.getLogger(RequestsWindowChecker.class);
    private static final int MIN_BIT_SET_SIZE = 128;
    private final ThrottlingWindowUnit unit;
    private final int maxTicksPerWindow;
    private final int threshold;
    private final SecureRandom random;
    private final BitSet bitSet;
    private long currentWindow;

    protected RequestsWindowChecker(ThrottlingWindowUnit unit, int threshold) {
        this.unit = unit;
        this.currentWindow = 0L;
        this.maxTicksPerWindow = RequestsWindowChecker.nPower(threshold);
        this.threshold = threshold;
        this.bitSet = new BitSet(this.maxTicksPerWindow);
        this.random = new SecureRandom(Long.toBinaryString(System.currentTimeMillis()).getBytes());
    }

    private static int nPower(int number) {
        if (number < 0 || number == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int n = 1;
        while (number >= (n <<= 1)) {
        }
        return Math.max(n, 128);
    }

    public abstract long getCurrentWindow();

    private boolean locate(int location) {
        long window = this.getCurrentWindow();
        if (this.currentWindow != window) {
            this.currentWindow = window;
            this.bitSet.clear();
        }
        if (this.bitSet.get(location)) {
            return false;
        }
        this.bitSet.set(location);
        log.debug("Set at location: " + location + " cardinality: " + this.cardinality());
        return true;
    }

    public synchronized boolean release(int location) {
        this.bitSet.clear(location);
        return true;
    }

    public synchronized int cardinality() {
        return this.bitSet.cardinality();
    }

    public synchronized int acquire() {
        int marker;
        if (this.bitSet.cardinality() >= this.threshold) {
            log.warn("Cardinality " + this.cardinality() + " is about to exceed allowed limit " + this.threshold);
            throw ThrottlingException.builder().unit(this.unit).window(this.getCurrentWindow()).cardinality(this.bitSet.cardinality()).threshold(this.threshold).message("Thank you contacting us! :-)").build();
        }
        log.info("Cardinality " + this.cardinality() + " allowed limit " + this.threshold);
        while (!this.locate(marker = this.random.nextInt(this.maxTicksPerWindow))) {
        }
        return marker;
    }
}

