/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.impl;

import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.RequestsWindowChecker;

public class RequestsPerMillisChecker
extends RequestsWindowChecker {
    public RequestsPerMillisChecker(int threshold) {
        super(ThrottlingWindowUnit.MILLISECOND, threshold);
    }

    @Override
    public long getCurrentWindow() {
        return System.currentTimeMillis();
    }

    public static RequestsPerMillisCheckerBuilder builder() {
        return new RequestsPerMillisCheckerBuilder();
    }

    public String toString() {
        return "RequestsPerMillisChecker(super=" + super.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestsPerMillisChecker)) {
            return false;
        }
        RequestsPerMillisChecker other = (RequestsPerMillisChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestsPerMillisChecker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    public static class RequestsPerMillisCheckerBuilder {
        private int threshold;

        RequestsPerMillisCheckerBuilder() {
        }

        public RequestsPerMillisCheckerBuilder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public RequestsPerMillisChecker build() {
            return new RequestsPerMillisChecker(this.threshold);
        }

        public String toString() {
            return "RequestsPerMillisChecker.RequestsPerMillisCheckerBuilder(threshold=" + this.threshold + ")";
        }
    }
}

