/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.aop;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import io.kalp.athang.durg.kirtimukh.throttling.ThrottlingManager;
import io.kalp.athang.durg.kirtimukh.throttling.annotation.Throttle;
import io.kalp.athang.durg.kirtimukh.throttling.annotation.Throttleable;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingStage;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingException;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingExceptionTranslator;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.ticker.StrategyChecker;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ThrottlingFunctionWrapper {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingFunctionWrapper.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ThrottlingFunctionWrapper ajc$perSingletonInstance;

    @Pointcut(value="@annotation(io.kalp.athang.durg.kirtimukh.throttling.annotation.Throttle)")
    public void throttlePointcutFunction() {
    }

    @Pointcut(value="@annotation(io.kalp.athang.durg.kirtimukh.throttling.annotation.Throttleable)")
    public void throttleablePointcutFunction() {
    }

    @Pointcut(value="execution(* *(..))")
    public void pointCutExecution() {
    }

    private String getCommandName(Signature signature) {
        MethodSignature methodSignature = (MethodSignature)MethodSignature.class.cast(signature);
        Throttle rateLimited = methodSignature.getMethod().getAnnotation(Throttle.class);
        if (Strings.isNullOrEmpty((String)rateLimited.name())) {
            return methodSignature.getDeclaringType().getSimpleName() + '.' + methodSignature.getMethod().getName();
        }
        return rateLimited.name();
    }

    public StrategyChecker getStrategyChecker(String commandName) {
        return ThrottlingManager.register(commandName);
    }

    public StrategyChecker getStrategyChecker(Throttleable throttleable, String commandName) {
        return ThrottlingManager.register(throttleable, commandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="throttlePointcutFunction() && pointCutExecution()")
    public Object process(ProceedingJoinPoint joinPoint) throws Throwable {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String commandName = this.getCommandName(joinPoint.getSignature());
        StrategyChecker checker = this.getStrategyChecker(commandName);
        ThrottlingExceptionTranslator translator = ThrottlingManager.getTranslator();
        try {
            checker.enter();
            ThrottlingManager.ticker(commandName, ThrottlingStage.ENTERED, stopwatch);
        }
        catch (ThrottlingException e) {
            stopwatch.stop();
            ThrottlingManager.ticker(commandName, ThrottlingStage.THROTTLED, stopwatch);
            if (translator != null) {
                throw translator.throwable(e);
            }
            throw e;
        }
        Object response = null;
        try {
            response = joinPoint.proceed();
            stopwatch.stop();
            ThrottlingManager.ticker(commandName, ThrottlingStage.COMPLETED, stopwatch);
        }
        catch (Exception e) {
            stopwatch.stop();
            ThrottlingManager.ticker(commandName, ThrottlingStage.ERROR, stopwatch);
        }
        finally {
            checker.exit();
            ThrottlingManager.ticker(commandName, ThrottlingStage.ACCEPTED, stopwatch);
        }
        return response;
    }

    static {
        try {
            ThrottlingFunctionWrapper.ajc$perSingletonInstance = new ThrottlingFunctionWrapper();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static ThrottlingFunctionWrapper aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.kalp.athang.aop.ThrottlingFunctionWrapper", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

