/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling;

import com.google.inject.Singleton;
import io.kalp.athang.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.ticker.StrategyChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.ticker.impl.LeakyBucketTicker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.ticker.impl.PriorityBucketTicker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.ticker.impl.QuotaStrategyTicker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.window.PriorityWindowChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.window.TimedWindowChecker;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class ThrottlingController {
    private final Map<String, TimedWindowChecker> windowCheckerMap = new HashMap<String, TimedWindowChecker>();
    private final Map<String, ThrottlingStrategyType> strategyTypeMap = new HashMap<String, ThrottlingStrategyType>();
    private final ThrottlingStrategyConfig defaultStrategyConfig;

    public ThrottlingController(ThrottlingStrategyConfig defaultConfig, Map<String, ThrottlingStrategyConfig> commandConfigs) {
        this.defaultStrategyConfig = defaultConfig;
        for (Map.Entry<String, ThrottlingStrategyConfig> entry : commandConfigs.entrySet()) {
            this.strategyTypeMap.put(entry.getKey(), entry.getValue().getType());
            this.windowCheckerMap.put(entry.getKey(), this.getWindowChecker(entry.getKey(), entry.getValue()));
        }
    }

    private TimedWindowChecker getTimedWindowChecker(String commandName, ThrottlingStrategyConfig strategyConfig) {
        return TimedWindowChecker.builder().commandName(commandName).strategyConfig(strategyConfig).build();
    }

    private TimedWindowChecker getWindowChecker(final String commandName, final ThrottlingStrategyConfig strategyConfig) {
        return strategyConfig.getUnit().accept(new ThrottlingWindowUnit.ThrottlingWindowVisitor<TimedWindowChecker>(){

            @Override
            public TimedWindowChecker visitMillisecond() {
                return ThrottlingController.this.getTimedWindowChecker(commandName, strategyConfig);
            }

            @Override
            public TimedWindowChecker visitSecond() {
                return ThrottlingController.this.getTimedWindowChecker(commandName, strategyConfig);
            }

            @Override
            public TimedWindowChecker visitMinute() {
                return ThrottlingController.this.getTimedWindowChecker(commandName, strategyConfig);
            }
        });
    }

    private synchronized TimedWindowChecker getWindowChecker(String commandName) {
        if (!this.windowCheckerMap.containsKey(commandName)) {
            this.windowCheckerMap.put(commandName, this.getWindowChecker(commandName, this.defaultStrategyConfig));
        }
        return this.windowCheckerMap.get(commandName);
    }

    private PriorityWindowChecker getPriorityWindowChecker(String commandName) {
        return PriorityWindowChecker.builder().commandName(commandName).build();
    }

    private StrategyChecker getStrategyChecker(final String commandName) {
        ThrottlingStrategyType strategyType = this.strategyTypeMap.getOrDefault(commandName, this.defaultStrategyConfig.getType());
        return strategyType.accept(new ThrottlingStrategyType.ThrottlingStrategyTypeVisitor<StrategyChecker>(){

            @Override
            public StrategyChecker visitQuota() {
                TimedWindowChecker windowChecker = ThrottlingController.this.getWindowChecker(commandName);
                return new QuotaStrategyTicker(windowChecker);
            }

            @Override
            public StrategyChecker visitLeakyBucket() {
                TimedWindowChecker windowChecker = ThrottlingController.this.getWindowChecker(commandName);
                return new LeakyBucketTicker(windowChecker);
            }

            @Override
            public StrategyChecker visitPriorityBuckets() {
                PriorityWindowChecker windowChecker = ThrottlingController.this.getPriorityWindowChecker(commandName);
                return new PriorityBucketTicker(windowChecker);
            }

            @Override
            public StrategyChecker visitNg() {
                throw new UnsupportedOperationException("Ng strategy unsupported");
            }
        });
    }

    public Map<String, TimedWindowChecker> getInfo() {
        return this.windowCheckerMap;
    }

    public StrategyChecker register(String rateLimitedFunctionName) {
        return this.getStrategyChecker(rateLimitedFunctionName);
    }
}

