/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import io.kalp.athang.durg.kirtimukh.throttling.ThrottlingController;
import io.kalp.athang.durg.kirtimukh.throttling.annotation.Throttleable;
import io.kalp.athang.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingStage;
import io.kalp.athang.durg.kirtimukh.throttling.exception.ThrottlingExceptionTranslator;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.ticker.StrategyChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.window.TimedWindowChecker;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class ThrottlingManager {
    private static ThrottlingController controller;
    private static ThrottlingExceptionTranslator translator;
    private static MetricRegistry metrics;
    private static final String prefix = "kirtimukh";

    public static void initialise(ThrottlingStrategyConfig defaultConfig, Map<String, ThrottlingStrategyConfig> commandConfigs, ThrottlingExceptionTranslator exceptionTranslator, MetricRegistry metricRegistry) {
        controller = new ThrottlingController(defaultConfig, commandConfigs);
        translator = exceptionTranslator;
        metrics = metricRegistry;
    }

    public static Map<String, TimedWindowChecker> getInfo() {
        return controller.getInfo();
    }

    public static StrategyChecker register(Throttleable throttleable, String commandName) {
        return controller.register(throttleable.bucket());
    }

    public static StrategyChecker register(String rateLimitedFunctionName) {
        return controller.register(rateLimitedFunctionName);
    }

    public static void ticker(String commandName, ThrottlingStage stage, Stopwatch stopwatch) {
        ThrottlingManager.ticker("", commandName, stage, stopwatch);
    }

    public static void ticker(String bucketName, String commandName, ThrottlingStage stage, Stopwatch stopwatch) {
        if (metrics == null) {
            return;
        }
        Timer timer = null;
        timer = Strings.isNullOrEmpty((String)bucketName) ? metrics.timer(String.join((CharSequence)".", prefix, commandName, stage.getName())) : metrics.timer(String.join((CharSequence)".", prefix, bucketName, commandName, stage.getName()));
        if (timer != null) {
            timer.update(stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
    }

    private ThrottlingManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static ThrottlingExceptionTranslator getTranslator() {
        return translator;
    }
}

