/*
 * Decompiled with CFR 0.152.
 */
package io.kalp.athang.durg.kirtimukh.throttling;

import com.google.inject.Singleton;
import io.kalp.athang.durg.kirtimukh.throttling.config.ThrottlingStrategyConfig;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingStrategyType;
import io.kalp.athang.durg.kirtimukh.throttling.enums.ThrottlingWindowUnit;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.LeakyBucketTicker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.QuotaStrategyTicker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.StrategyChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.RequestsWindowChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.impl.RequestsPerMillisChecker;
import io.kalp.athang.durg.kirtimukh.throttling.strategies.checker.impl.RequestsPerSecondChecker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class ThrottlingController {
    private final Map<String, RequestsWindowChecker> windowCheckerMap = new HashMap<String, RequestsWindowChecker>();
    private final Map<String, ThrottlingStrategyType> strategyTypeMap = new HashMap<String, ThrottlingStrategyType>();
    private final ThrottlingStrategyConfig defaultStrategyConfig;

    public ThrottlingController(ThrottlingStrategyConfig defaultConfig, List<ThrottlingStrategyConfig> configs) {
        this.defaultStrategyConfig = defaultConfig;
        for (ThrottlingStrategyConfig config : configs) {
            this.strategyTypeMap.put(config.getName(), config.getType());
            this.windowCheckerMap.put(config.getName(), this.getWindowChecker(config));
        }
    }

    private RequestsWindowChecker getWindowChecker(ThrottlingStrategyConfig strategyConfig) {
        if (strategyConfig.getUnit() == ThrottlingWindowUnit.MILLISECOND) {
            return RequestsPerMillisChecker.builder().threshold(strategyConfig.getThreshold()).build();
        }
        return RequestsPerSecondChecker.builder().threshold(strategyConfig.getThreshold()).build();
    }

    private synchronized RequestsWindowChecker getWindowChecker(String commandName) {
        if (!this.windowCheckerMap.containsKey(commandName)) {
            this.windowCheckerMap.put(commandName, this.getWindowChecker(this.defaultStrategyConfig));
        }
        return this.windowCheckerMap.get(commandName);
    }

    private StrategyChecker getStrategyChecker(String commandName) {
        RequestsWindowChecker windowChecker = this.getWindowChecker(commandName);
        ThrottlingStrategyType strategyType = this.strategyTypeMap.getOrDefault(commandName, this.defaultStrategyConfig.getType());
        if (strategyType == ThrottlingStrategyType.QUOTA) {
            return new QuotaStrategyTicker(windowChecker);
        }
        return new LeakyBucketTicker(windowChecker);
    }

    public Map<String, RequestsWindowChecker> getInfo() {
        return this.windowCheckerMap;
    }

    public StrategyChecker register(String rateLimitedFunctionName) {
        return this.getStrategyChecker(rateLimitedFunctionName);
    }
}

