/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.IHDF5CompoundReader;
import ch.systemsx.cisd.hdf5.IHDF5EnumReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class HDF5CompoundReader
extends HDF5CompoundInformationRetriever
implements IHDF5CompoundReader {
    HDF5CompoundReader(HDF5BaseReader baseReader, IHDF5EnumReader enumReader) {
        super(baseReader, enumReader);
    }

    @Override
    public <T> T getAttr(String objectPath, String attributeName, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.primGetCompoundAttribute(objectPath, attributeName, type, null);
    }

    @Override
    public <T> T getAttr(String objectPath, String attributeName, Class<T> pojoClass) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5CompoundType<T> attributeCompoundType = this.getAttributeType(objectPath, attributeName, pojoClass);
        attributeCompoundType.checkMappingComplete();
        return this.primGetCompoundAttribute(objectPath, attributeName, attributeCompoundType, null);
    }

    @Override
    public <T> T[] getArrayAttr(String objectPath, String attributeName, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.primGetCompoundArrayAttribute(objectPath, attributeName, type, null);
    }

    @Override
    public <T> T[] getArrayAttr(String objectPath, String attributeName, Class<T> pojoClass) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5CompoundType<T> attributeCompoundType = this.getAttributeType(objectPath, attributeName, pojoClass);
        attributeCompoundType.checkMappingComplete();
        return this.primGetCompoundArrayAttribute(objectPath, attributeName, attributeCompoundType, null);
    }

    @Override
    public <T> MDArray<T> getMDArrayAttr(String objectPath, String attributeName, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.primGetCompoundMDArrayAttribute(objectPath, attributeName, type, null);
    }

    @Override
    public <T> MDArray<T> getMDArrayAttr(String objectPath, String attributeName, Class<T> pojoClass) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5CompoundType<T> attributeCompoundType = this.getAttributeType(objectPath, attributeName, pojoClass);
        attributeCompoundType.checkMappingComplete();
        return this.primGetCompoundMDArrayAttribute(objectPath, attributeName, attributeCompoundType, null);
    }

    private <T> T primGetCompoundAttribute(final String objectPath, final String attributeName, final HDF5CompoundType<T> type, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        ICallableWithCleanUp writeRunnable = new ICallableWithCleanUp<T>(){

            @Override
            public T call(ICleanUpRegistry registry) {
                int objectId = HDF5CompoundReader.this.baseReader.h5.openObject(HDF5CompoundReader.this.baseReader.fileId, objectPath, registry);
                int attributeId = HDF5CompoundReader.this.baseReader.h5.openAttribute(objectId, attributeName, registry);
                int storageDataTypeId = HDF5CompoundReader.this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                HDF5CompoundReader.this.checkCompoundType(storageDataTypeId, objectPath, type);
                int nativeDataTypeId = type.getNativeTypeId();
                byte[] byteArr = HDF5CompoundReader.this.baseReader.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, type.getObjectByteifyer().getRecordSize());
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArr);
                }
                return type.getObjectByteifyer().arrayifyScalar(storageDataTypeId, byteArr, type.getCompoundType());
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    private <T> T[] primGetCompoundArrayAttribute(final String objectPath, final String attributeName, final HDF5CompoundType<T> type, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        ICallableWithCleanUp<T[]> writeRunnable = new ICallableWithCleanUp<T[]>(){

            @Override
            public T[] call(ICleanUpRegistry registry) {
                int compoundTypeId;
                int len;
                Object[] arrayDimensions;
                int dataSetId = HDF5CompoundReader.this.baseReader.h5.openObject(HDF5CompoundReader.this.baseReader.fileId, objectPath, registry);
                int attributeId = HDF5CompoundReader.this.baseReader.h5.openAttribute(dataSetId, attributeName, registry);
                int storageDataTypeId = HDF5CompoundReader.this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                int nativeDataTypeId = HDF5CompoundReader.this.baseReader.h5.getNativeDataType(storageDataTypeId, registry);
                if (HDF5CompoundReader.this.baseReader.h5.getClassType(storageDataTypeId) == HDF5Constants.H5T_ARRAY) {
                    arrayDimensions = HDF5CompoundReader.this.baseReader.h5.getArrayDimensions(storageDataTypeId);
                    len = HDF5Utils.getOneDimensionalArraySize(arrayDimensions);
                    compoundTypeId = HDF5CompoundReader.this.baseReader.h5.getBaseDataType(storageDataTypeId, registry);
                    if (HDF5CompoundReader.this.baseReader.h5.getClassType(compoundTypeId) != HDF5Constants.H5T_COMPOUND) {
                        throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of type compound array.");
                    }
                } else {
                    if (HDF5CompoundReader.this.baseReader.h5.getClassType(storageDataTypeId) != HDF5Constants.H5T_COMPOUND) {
                        throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of type compound array.");
                    }
                    compoundTypeId = storageDataTypeId;
                    arrayDimensions = HDF5CompoundReader.this.baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
                    len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
                }
                HDF5CompoundReader.this.checkCompoundType(compoundTypeId, objectPath, type);
                byte[] byteArr = HDF5CompoundReader.this.baseReader.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, len * type.getRecordSize());
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArr);
                }
                return type.getObjectByteifyer().arrayify(storageDataTypeId, byteArr, type.getCompoundType());
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    private <T> MDArray<T> primGetCompoundMDArrayAttribute(final String objectPath, final String attributeName, final HDF5CompoundType<T> type, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        ICallableWithCleanUp writeRunnable = new ICallableWithCleanUp<MDArray<T>>(){

            @Override
            public MDArray<T> call(ICleanUpRegistry registry) {
                int compoundTypeId;
                int len;
                int[] arrayDimensions;
                int dataSetId = HDF5CompoundReader.this.baseReader.h5.openObject(HDF5CompoundReader.this.baseReader.fileId, objectPath, registry);
                int attributeId = HDF5CompoundReader.this.baseReader.h5.openAttribute(dataSetId, attributeName, registry);
                int storageDataTypeId = HDF5CompoundReader.this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                int nativeDataTypeId = HDF5CompoundReader.this.baseReader.h5.getNativeDataType(storageDataTypeId, registry);
                if (HDF5CompoundReader.this.baseReader.h5.getClassType(storageDataTypeId) == HDF5Constants.H5T_ARRAY) {
                    arrayDimensions = HDF5CompoundReader.this.baseReader.h5.getArrayDimensions(storageDataTypeId);
                    len = MDAbstractArray.getLength((int[])arrayDimensions);
                    compoundTypeId = HDF5CompoundReader.this.baseReader.h5.getBaseDataType(storageDataTypeId, registry);
                    if (HDF5CompoundReader.this.baseReader.h5.getClassType(compoundTypeId) != HDF5Constants.H5T_COMPOUND) {
                        throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of type compound array.");
                    }
                } else {
                    if (HDF5CompoundReader.this.baseReader.h5.getClassType(storageDataTypeId) != HDF5Constants.H5T_COMPOUND) {
                        throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of type compound array.");
                    }
                    compoundTypeId = storageDataTypeId;
                    arrayDimensions = MDAbstractArray.toInt((long[])HDF5CompoundReader.this.baseReader.h5.getDataDimensionsForAttribute(attributeId, registry));
                    len = MDAbstractArray.getLength((int[])arrayDimensions);
                }
                HDF5CompoundReader.this.checkCompoundType(compoundTypeId, objectPath, type);
                byte[] byteArr = HDF5CompoundReader.this.baseReader.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, len * type.getRecordSize());
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArr);
                }
                return new MDArray((Object[])type.getObjectByteifyer().arrayify(storageDataTypeId, byteArr, type.getCompoundType()), arrayDimensions);
            }
        };
        return (MDArray)this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public <T> T read(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.read(objectPath, type, null);
    }

    @Override
    public <T> T read(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5CompoundType<T> dataSetCompoundType = this.getDataSetType(objectPath, pojoClass);
        dataSetCompoundType.checkMappingComplete();
        return this.read(objectPath, dataSetCompoundType, null);
    }

    @Override
    public <T> T read(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        return this.primReadCompound(objectPath, -1, -1L, type, inspectorOrNull);
    }

    @Override
    public <T> T[] readArray(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.readArray(objectPath, type, null);
    }

    @Override
    public <T> T[] readArray(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        return this.primReadCompoundArray(objectPath, -1, -1L, type, inspectorOrNull);
    }

    @Override
    public <T> T[] readArray(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5CompoundType<T> dataSetCompoundType = this.getDataSetType(objectPath, pojoClass);
        dataSetCompoundType.checkMappingComplete();
        return this.readArray(objectPath, dataSetCompoundType, null);
    }

    @Override
    public <T> T[] readArrayBlock(String objectPath, HDF5CompoundType<T> type, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.readArrayBlock(objectPath, type, blockSize, blockNumber, null);
    }

    @Override
    public <T> T[] readArrayBlock(String objectPath, HDF5CompoundType<T> type, int blockSize, long blockNumber, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        return this.primReadCompoundArray(objectPath, blockSize, (long)blockSize * blockNumber, type, inspectorOrNull);
    }

    @Override
    public <T> T[] readArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int blockSize, long offset) throws HDF5JavaException {
        return this.readArrayBlockWithOffset(objectPath, type, blockSize, offset, null);
    }

    @Override
    public <T> T[] readArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int blockSize, long offset, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        return this.primReadCompoundArray(objectPath, blockSize, offset, type, inspectorOrNull);
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getArrayBlocks(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.getArrayBlocks(objectPath, type, null);
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getArrayBlocks(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        return this.primGetCompoundArrayNaturalBlocks(objectPath, type, params, inspectorOrNull);
    }

    private <T> Iterable<HDF5DataBlock<T[]>> primGetCompoundArrayNaturalBlocks(final String objectPath, final HDF5CompoundType<T> type, final HDF5NaturalBlock1DParameters params, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        return new Iterable<HDF5DataBlock<T[]>>(){

            @Override
            public Iterator<HDF5DataBlock<T[]>> iterator() {
                return new Iterator<HDF5DataBlock<T[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<T[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        T[] block = HDF5CompoundReader.this.readArrayBlockWithOffset(objectPath, type, this.index.getBlockSize(), offset, inspectorOrNull);
                        return new HDF5DataBlock<T[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public <T> Iterable<HDF5DataBlock<T[]>> getArrayBlocks(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        HDF5CompoundType<T> dataSetCompoundType = this.getDataSetType(objectPath, pojoClass);
        dataSetCompoundType.checkMappingComplete();
        return this.primGetCompoundArrayNaturalBlocks(objectPath, dataSetCompoundType, params, null);
    }

    private <T> T primReadCompound(final String objectPath, final int blockSize, final long offset, final HDF5CompoundType<T> type, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        ICallableWithCleanUp writeRunnable = new ICallableWithCleanUp<T>(){

            @Override
            public T call(ICleanUpRegistry registry) {
                int dataSetId = HDF5CompoundReader.this.baseReader.h5.openDataSet(HDF5CompoundReader.this.baseReader.fileId, objectPath, registry);
                int storageDataTypeId = HDF5CompoundReader.this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                HDF5CompoundReader.this.checkCompoundType(storageDataTypeId, objectPath, type);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5CompoundReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                int nativeDataTypeId = type.getNativeTypeId();
                byte[] byteArr = new byte[spaceParams.blockSize * type.getObjectByteifyer().getRecordSize()];
                HDF5CompoundReader.this.baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, byteArr);
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArr);
                }
                return type.getObjectByteifyer().arrayifyScalar(storageDataTypeId, byteArr, type.getCompoundType());
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    private <T> T[] primReadCompoundArray(final String objectPath, final int blockSize, final long offset, final HDF5CompoundType<T> type, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        ICallableWithCleanUp<T[]> writeRunnable = new ICallableWithCleanUp<T[]>(){

            @Override
            public T[] call(ICleanUpRegistry registry) {
                int dataSetId = HDF5CompoundReader.this.baseReader.h5.openDataSet(HDF5CompoundReader.this.baseReader.fileId, objectPath, registry);
                int storageDataTypeId = HDF5CompoundReader.this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                HDF5CompoundReader.this.checkCompoundType(storageDataTypeId, objectPath, type);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5CompoundReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                int nativeDataTypeId = type.getNativeTypeId();
                byte[] byteArr = new byte[spaceParams.blockSize * type.getObjectByteifyer().getRecordSize()];
                HDF5CompoundReader.this.baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, byteArr);
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArr);
                }
                return type.getObjectByteifyer().arrayify(storageDataTypeId, byteArr, type.getCompoundType());
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    private void checkCompoundType(int dataTypeId, String path, HDF5CompoundType<?> type) throws HDF5JavaException {
        boolean isCompound;
        boolean bl = isCompound = this.baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_COMPOUND;
        if (!isCompound) {
            throw new HDF5JavaException("Data set '" + path + "' is no compound.");
        }
        boolean isEqual = this.baseReader.h5.dataTypesAreEqual(dataTypeId, type.getStorageTypeId());
        if (!isEqual) {
            throw new HDF5JavaException("The compound type '" + type.getName() + "' is not suitable for data set '" + path + "'.");
        }
    }

    @Override
    public <T> MDArray<T> readMDArray(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.readMDArrayBlockWithOffset(objectPath, type, null, null, null);
    }

    @Override
    public <T> MDArray<T> readMDArray(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        return this.readMDArrayBlockWithOffset(objectPath, type, null, null, inspectorOrNull);
    }

    @Override
    public <T> MDArray<T> readMDArray(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        HDF5CompoundType<T> dataSetCompoundType = this.getDataSetType(objectPath, pojoClass);
        dataSetCompoundType.checkMappingComplete();
        return this.readMDArrayBlockWithOffset(objectPath, dataSetCompoundType, null, null, null);
    }

    @Override
    public <T> MDArray<T> readMDArrayBlock(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] blockNumber) throws HDF5JavaException {
        return this.readMDArrayBlock(objectPath, type, blockDimensions, blockNumber, null);
    }

    @Override
    public <T> MDArray<T> readMDArrayBlock(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] blockNumber, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = (long)blockDimensions[i] * blockNumber[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(objectPath, type, blockDimensions, offset, inspectorOrNull);
    }

    @Override
    public <T> MDArray<T> readMDArrayBlockWithOffset(String objectPath, HDF5CompoundType<T> type, int[] blockDimensions, long[] offset) throws HDF5JavaException {
        return this.readMDArrayBlockWithOffset(objectPath, type, blockDimensions, offset, null);
    }

    @Override
    public <T> MDArray<T> readMDArrayBlockWithOffset(final String objectPath, final HDF5CompoundType<T> type, final int[] dimensionsOrNull, final long[] offsetOrNull, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        ICallableWithCleanUp writeRunnable = new ICallableWithCleanUp<MDArray<T>>(){

            @Override
            public MDArray<T> call(ICleanUpRegistry registry) {
                int dataSetId = HDF5CompoundReader.this.baseReader.h5.openDataSet(HDF5CompoundReader.this.baseReader.fileId, objectPath, registry);
                int storageDataTypeId = HDF5CompoundReader.this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                HDF5CompoundReader.this.checkCompoundType(storageDataTypeId, objectPath, type);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5CompoundReader.this.baseReader.getSpaceParameters(dataSetId, offsetOrNull, dimensionsOrNull, registry);
                int nativeDataTypeId = type.getNativeTypeId();
                byte[] byteArr = new byte[spaceParams.blockSize * type.getObjectByteifyer().getRecordSize()];
                HDF5CompoundReader.this.baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, byteArr);
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArr);
                }
                return new MDArray((Object[])type.getObjectByteifyer().arrayify(storageDataTypeId, byteArr, type.getCompoundType()), spaceParams.dimensions);
            }
        };
        return (MDArray)this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getMDArrayBlocks(String objectPath, HDF5CompoundType<T> type) throws HDF5JavaException {
        return this.getMDArrayBlocks(objectPath, type, null);
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getMDArrayBlocks(String objectPath, HDF5CompoundType<T> type, IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) throws HDF5JavaException {
        this.baseReader.checkOpen();
        type.check(this.baseReader.fileId);
        HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL));
        return this.primGetCompoundMDArrayNaturalBlocks(objectPath, type, params, inspectorOrNull);
    }

    private <T> Iterable<HDF5MDDataBlock<MDArray<T>>> primGetCompoundMDArrayNaturalBlocks(final String objectPath, final HDF5CompoundType<T> type, final HDF5NaturalBlockMDParameters params, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        return new Iterable<HDF5MDDataBlock<MDArray<T>>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDArray<T>>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDArray<T>>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDArray<T>> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDArray block = HDF5CompoundReader.this.readMDArrayBlockWithOffset(objectPath, type, this.index.getBlockSize(), offset, inspectorOrNull);
                        return new HDF5MDDataBlock(block, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public <T> Iterable<HDF5MDDataBlock<MDArray<T>>> getMDArrayBlocks(String objectPath, Class<T> pojoClass) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(objectPath));
        HDF5CompoundType<T> dataSetCompoundType = this.getDataSetType(objectPath, pojoClass);
        dataSetCompoundType.checkMappingComplete();
        return this.primGetCompoundMDArrayNaturalBlocks(objectPath, dataSetCompoundType, params, null);
    }
}

