/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5UnsignedShortWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;

class HDF5UnsignedShortWriter
implements IHDF5UnsignedShortWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5UnsignedShortWriter(HDF5BaseWriter baseWriter) {
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setAttr(String objectPath, String name, short value) {
        assert (objectPath != null);
        assert (name != null);
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, HDF5Constants.H5T_STD_U16LE, HDF5Constants.H5T_NATIVE_UINT16, new short[]{value});
    }

    @Override
    public void setArrayAttr(final String objectPath, final String name, final short[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT16, value.length, registry);
                int storageTypeId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_U16LE, value.length, registry);
                HDF5UnsignedShortWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value);
                return null;
            }
        };
        this.baseWriter.runner.call(setAttributeRunnable);
    }

    @Override
    public void setMDArrayAttr(final String objectPath, final String name, final MDShortArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> addAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int memoryTypeId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT16, value.dimensions(), registry);
                int storageTypeId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.createArrayType(HDF5Constants.H5T_STD_U16LE, value.dimensions(), registry);
                HDF5UnsignedShortWriter.this.baseWriter.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(addAttributeRunnable);
    }

    @Override
    public void setMatrixAttr(String objectPath, String name, short[][] value) {
        this.setMDArrayAttr(objectPath, name, new MDShortArray(value));
    }

    @Override
    public void write(String objectPath, short value) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, HDF5Constants.H5T_STD_U16LE, HDF5Constants.H5T_NATIVE_UINT16, value);
    }

    @Override
    public void writeArray(String objectPath, short[] data) {
        this.writeArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeArray(final String objectPath, final short[] data, final HDF5IntStorageFeatures features) {
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5UnsignedShortWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_U16LE, new long[]{data.length}, 2, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createArray(String objectPath, int size) {
        this.createArray(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createArray(String objectPath, long size, int blockSize) {
        this.createArray(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createArray(final String objectPath, final int size, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5UnsignedShortWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U16LE, features, new long[1], new long[]{size}, 2, registry);
                } else {
                    HDF5UnsignedShortWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U16LE, features, new long[]{size}, null, 2, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createArray(final String objectPath, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5UnsignedShortWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U16LE, features, new long[]{size}, new long[]{blockSize}, 2, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeArrayBlock(String objectPath, short[] data, long blockNumber) {
        this.writeArrayBlockWithOffset(objectPath, data, data.length, (long)data.length * blockNumber);
    }

    @Override
    public void writeArrayBlockWithOffset(final String objectPath, final short[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.fileId, objectPath, ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data);
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMatrix(String objectPath, short[][] data) {
        this.writeMatrix(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeMatrix(String objectPath, short[][] data, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        assert (HDF5Utils.areMatrixDimensionsConsistent(data));
        this.writeMDArray(objectPath, new MDShortArray(data), features);
    }

    @Override
    public void createMatrix(String objectPath, int sizeX, int sizeY) {
        assert (objectPath != null);
        assert (sizeX >= 0);
        assert (sizeY >= 0);
        this.createMDArray(objectPath, new int[]{sizeX, sizeY});
    }

    @Override
    public void createMatrix(String objectPath, int sizeX, int sizeY, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0);
        assert (sizeY >= 0);
        this.createMDArray(objectPath, new int[]{sizeX, sizeY}, features);
    }

    @Override
    public void createMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.createMDArray(objectPath, new long[]{sizeX, sizeY}, new int[]{blockSizeX, blockSizeY});
    }

    @Override
    public void createMatrix(String objectPath, long sizeX, long sizeY, int blockSizeX, int blockSizeY, HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (sizeX >= 0L);
        assert (sizeY >= 0L);
        assert (blockSizeX >= 0 && ((long)blockSizeX <= sizeX || sizeX == 0L));
        assert (blockSizeY >= 0 && ((long)blockSizeY <= sizeY || sizeY == 0L));
        this.createMDArray(objectPath, new long[]{sizeX, sizeY}, new int[]{blockSizeX, blockSizeY}, features);
    }

    @Override
    public void writeMatrixBlock(String objectPath, short[][] data, long blockNumberX, long blockNumberY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlock(objectPath, new MDShortArray(data), new long[]{blockNumberX, blockNumberY});
    }

    @Override
    public void writeMatrixBlockWithOffset(String objectPath, short[][] data, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlockWithOffset(objectPath, new MDShortArray(data, new int[]{data.length, data[0].length}), new long[]{offsetX, offsetY});
    }

    @Override
    public void writeMatrixBlockWithOffset(String objectPath, short[][] data, int dataSizeX, int dataSizeY, long offsetX, long offsetY) {
        assert (objectPath != null);
        assert (data != null);
        this.writeMDArrayBlockWithOffset(objectPath, new MDShortArray(data, new int[]{dataSizeX, dataSizeY}), new long[]{offsetX, offsetY});
    }

    @Override
    public void writeMDArray(String objectPath, MDShortArray data) {
        this.writeMDArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeMDArray(final String objectPath, final MDShortArray data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = HDF5UnsignedShortWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_U16LE, data.longDimensions(), 2, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createMDArray(String objectPath, int[] dimensions) {
        this.createMDArray(objectPath, dimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(String objectPath, long[] dimensions, int[] blockDimensions) {
        this.createMDArray(objectPath, dimensions, blockDimensions, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createMDArray(final String objectPath, final int[] dimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    long[] nullDimensions = new long[dimensions.length];
                    HDF5UnsignedShortWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U16LE, features, nullDimensions, MDArray.toLong((int[])dimensions), 2, registry);
                } else {
                    HDF5UnsignedShortWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U16LE, features, MDArray.toLong((int[])dimensions), null, 2, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createMDArray(final String objectPath, final long[] dimensions, final int[] blockDimensions, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (dimensions != null);
        assert (blockDimensions != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5UnsignedShortWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_U16LE, features, dimensions, MDArray.toLong((int[])blockDimensions), 2, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeMDArrayBlock(String objectPath, MDShortArray data, long[] blockNumber) {
        assert (blockNumber != null);
        long[] dimensions = data.longDimensions();
        long[] offset = new long[dimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * dimensions[i];
            ++i;
        }
        this.writeMDArrayBlockWithOffset(objectPath, data, offset);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDShortArray data, final long[] offset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] dimensions = data.longDimensions();
                if (!$assertionsDisabled && dimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[dimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + dimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.fileId, objectPath, ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, dimensions);
                int memorySpaceId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.createSimpleDataSpace(dimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeMDArrayBlockWithOffset(final String objectPath, final MDShortArray data, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        assert (data != null);
        assert (offset != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] memoryDimensions = data.longDimensions();
                if (!$assertionsDisabled && memoryDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] longBlockDimensions = MDArray.toLong((int[])blockDimensions);
                if (!$assertionsDisabled && longBlockDimensions.length != offset.length) {
                    throw new AssertionError();
                }
                long[] dataSetDimensions = new long[blockDimensions.length];
                int i = 0;
                while (i < offset.length) {
                    dataSetDimensions[i] = offset[i] + (long)blockDimensions[i];
                    ++i;
                }
                int dataSetId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.fileId, objectPath, ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.fileFormat, dataSetDimensions, -1, registry);
                int dataSpaceId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, offset, longBlockDimensions);
                int memorySpaceId = ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.createSimpleDataSpace(memoryDimensions, registry);
                ((HDF5UnsignedShortWriter)HDF5UnsignedShortWriter.this).baseWriter.h5.setHyperslabBlock(memorySpaceId, MDArray.toLong((int[])memoryOffset), longBlockDimensions);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, data.getAsFlatArray());
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

