(ns io.monetashi.eosjs
  (:require [cljs.core.async :refer [chan put!]]
            [io.monetashi.yesod :refer-macros [let-returning]]
            [oops.core :refer [ocall]]
            [promesa.core :as p]

            ["eosjs" :refer [Api JsonRpc RpcError]]
            ["eosjs/dist/eosjs-jssig" :as JsSignatureProvider]
            ["node-fetch" :as fetch]
            ["util" :refer [TextEncoder TextDecoder]]))

(defn signature-provider! [private-keys]
  (JsSignatureProvider. (clj->js private-keys)))

(defn api! [end-point signature-provider]
  (let [rpc (JsonRpc end-point  {:fetch fetch})]
    (Api.  {:rpc rpc
               :signatureProvider signature-provider
               :textDecoder (TextDecoder.)
               :textEncoder (TextEncoder.)})))


(defn transact! [api actions]
  (let-returning [c (chan)]
    (-> (ocall api :transact (clj->js actions))
        (p/then #(put! c %))
        (p/catch #(put! c %)))))
