(ns io.monetashi.testing
  (:require [cljs.test :refer-macros [async deftest is]]
            [taoensso.timbre :as timbre]
            [io.monetashi.yesod.async :refer-macros [<? go-catching]]))

(defmacro deftest-async [name & body]
  `(cljs.test/deftest ~name
     (cljs.test/async done#
            (io.monetashi.yesod.async/go-catching
             (try 
               (let [ret# (do ~@body)]
                 (if (io.monetashi.yesod.async/chan? ret#)
                   (io.monetashi.yesod.async/<? ret#)
                   ret#))
               (catch js/Error e#
                 (.log js/console e# ))
               (finally
                 (done#)))))))


(macroexpand-1 '(deftest-async t-campaign
                  (is (true? true))))
