(ns ok)

(defn count-bits [n]
  (let [seed-mask (bit-shift-left 1 (- Long/SIZE 2))]
    (reduce +
            (for [mask (iterate #(bit-shift-right % 1) seed-mask)
                  :while (not (zero? mask))
                  :when  (not (zero? (bit-and n mask)))]
              1))))

(defn parity [n]
  (if (odd? (count-bits n)) 1 0))

(defn parity-decompose [x]
  (bit-xor (parity (bit-and x 0xFFFF))
           (parity (bit-and (bit-shift-right x 16) 0xFFFF))
           (parity (bit-and (bit-shift-right x 32) 0xFFFF))
           (parity (bit-shift-right x 48))))
