(ns fink-nottle.scratch
  (:require [clojure.zip :as z]
            [clojure.zip :as zip]
            [clojure.walk :as walk]
            ))

(def data
  [{"a" {"b" 1 "c" 2}
    "children" [{"a" {"b" 3 "c" 4} "children" []}]}
   {"a" {"b" 5 "c" 6} "children" []}
   {"a" {"b" 7 "c" 8}
    "children" [{"a" {"b" 9 "c" 10} "children" []} {"a" {"b" 10 "c" 10} "children" []}]}])

(defn walk [x & [{:keys [path paths]}]]
  (println x path paths)
  (cond (map? x)
        (if (x "children")
          (walk (x "children" {:path (conj path "children")}))
          (conj paths [path x])))
  (vector? x) (map-indexed
               (fn [i v]
                 (walk v {:path (conj path i)}))
               x)
  :else nil)

(defn walk [x & [{:keys [path paths]}]]
  (if (map? x)
    (into paths [])
    [(x "a") (walk x "children")]))
(def zip-data (partial z/zipper vector? seq (fn [_ x] x)))

(defn ->map [data]
  {:children
   (walk/postwalk
    (fn [x]
      (if (and (map? x) (x "children"))
        (let [[[name attrs]] (seq (dissoc x "children"))]
          {:name name :attrs attrs :children (x "children")})
        x))
    data)})

(def ->tree
  (partial
   walk/postwalk
   (fn [x]
     (if (and (map? x) (x "children"))
       (let [[[name attrs]] (seq (dissoc x "children"))]
         [name attrs (x "children")])
       x))))

(defn editable? [x]
  (= 10 (get-in x ["a" "b"])))

(defn edit [x]
  (update x "children" reverse))

(defn doit [loc]
  (loop [loc loc]
    (if (z/end? loc)
      (z/root loc)
      (if (editable? (z/node loc))
        (recur (-> loc z/up (z/edit edit) z/up z/next))
        (recur (z/next loc))))))

(defn interesting-paths [data]
  )

(defn tree-seq-depth
  "Returns a lazy sequence of vectors of the nodes in a tree and their
  depth as [node depth], via a depth-first walk.  branch? must be a fn
  of one arg that returns true if passed a node that can have
  children (but may not).  children must be a fn of one arg that
  returns a sequence of the children. Will only be called on nodes for
  which branch? returns true. Root is the root node of the tree."
  [branch? children root]
  (let [walk (fn walk [depth node]
               (lazy-seq
                (cons [node depth]
                      (when (branch? node)
                        (mapcat (partial walk (inc depth)) (children node))))))]
    (walk 0 root)))

(defn tree-seq-path
  "Like core's tree-seq but returns a lazy sequence of vectors of the
  paths of the nodes in a tree, via a depth-first walk. It optionally
  applies node-fn to each node before adding it to the path. branch?
  must be a fn of one arg that returns true if passed a node that can
  have children (but may not).  children must be a fn of one arg that
  returns a sequence of the children. Will only be called on nodes for
  which branch? returns true. Root is the root node of the tree."
  [branch? children root & [node-fn]]
  (let [node-fn (or node-fn identity)
        walk (fn walk [path node]
               (let [new-path (conj path (node-fn node))]
                 (lazy-seq
                  (cons new-path
                        (when (branch? node)
                          (mapcat (partial walk new-path) (children node)))))))]
    (walk [] root)))
