(ns leiningen.cljs-lambda.zip-tedium
  (:require [clojure.java.io :as io])
  (:import [java.io File]
           [java.util.zip ZipEntry ZipOutputStream]))

(defn- zip-entry [zip-stream file & [path]]
  (.putNextEntry zip-stream (ZipEntry. (or path (.getPath file))))
  (io/copy file zip-stream)
  (.closeEntry zip-stream))

(defn extension [file]
  (let [path (.getPath file)]
    (when-let [i (.lastIndexOf path ".")]
      (subs path (inc i)))))

(defn- zip-below [zip-stream dir]
  (println "Adding files from" (.getAbsolutePath dir))
  (doseq [file (file-seq dir)]
    (when (and (.isFile file)
               (not= (extension file) "zip"))
      (zip-entry zip-stream file))))

(defmulti  stuff-zip (fn [_ {:keys [optimizations]} _] optimizations))
(defmethod stuff-zip :default [zip-stream {:keys [output-dir]} {:keys [index-path]}]
  (zip-entry zip-stream (io/file index-path) "index.js")
  (zip-below zip-stream (io/file output-dir))
  (zip-below zip-stream (io/file "node_modules")))

(defmethod stuff-zip :advanced [zip-stream {:keys [output-to]} {:keys [index-path]}]
  (zip-entry zip-stream (io/file index-path) "index.js")
  (zip-entry zip-stream (io/file output-to)))

(defn write-zip [{:keys [output-dir] :as compiler-opts}
                 {:keys [project-name zip-name] :as spec}]
  (let [zip-file   (File/createTempFile project-name nil)
        zip-stream (ZipOutputStream. (io/output-stream (.getPath zip-file)))]
    (stuff-zip zip-stream compiler-opts spec)
    (.close zip-stream)
    (let [destination-file (io/file output-dir zip-name)
          path (.getAbsolutePath destination-file)]
      (println "Writing zip to" path)
      (.delete destination-file)
      (.renameTo zip-file destination-file)
      path)))
