(ns sputter.op.spec
  (:require [sputter.op         :as op]
            [sputter.op.table   :as op.table]
            [sputter.word       :as word]
            [clojure.spec.alpha :as s]))

(s/def ::word          word/word?)
(s/def ::op/mnemonic   (into #{} (map ::op/mnemonic) (vals op.table/ops)))
(s/def ::op/data       ::word)
(s/def ::op/stack-push (s/or :zero zero? :pos pos-int?))
(s/def ::op/width      pos-int?)
(s/def ::op/variant    pos-int?)
(s/def ::op/popped     (s/coll-of ::word))

(s/def :sputter/op
  (s/keys :req [::op/mnemonic ::op/stack-push ::op/width]
          :opt [::op/variant]))

(s/def ::op/prepared
  (s/merge :sputter/op (s/keys :req [::op/popped] :opt [::op/data])))
