(ns sputter.state.inmem.trie
  (:require [sputter.state.inmem.node  :as node]
            [sputter.util.nibble      :as nibble]
            [sputter.util             :as util] :reload))

(def ^:private hash-bytes 32)
(defn- inline-node? [rlp] (< (count rlp) hash-bytes))

;; (defn- realize [child store]
;;   (if (and child (not (node/node? child)))
;;     (-> child
;;         (cond->> (= (count child) 32) (kv/retrieve store))
;;         trie.rlp/vector->node)
;;     child))

(defprotocol Trie
  (-search      [trie node k])
  (-insert      [trie k v])
  (commit       [trie])
  (-prove       [trie node k]))

;; (defn- node->rlp [node]
;;   (-> node trie.rlp/->vector rlp/encode))

;; (defn- flatten-node [node root?]
;;   (let [nvec (trie.rlp/->vector node)
;;         rlp  (rlp/encode nvec)]
;;     (if (and (not root?) (inline-node? rlp))
;;       [nil nvec]
;;       (let [id (util/sha3-bytes rlp)]
;;         [id rlp]))))

;; (defn- hash-node [node & [root?]]
;;   (first (flatten-node node root?)))


(defn- walk-one [node k outer inner]
  (println "WALKING" node)
  (if-let [[child tail consumed-k] (node/descend node k)]
    (do
      (println "FINNA REARRACH" consumed-k)
      (println ".")
      (outer k (node/reattach node consumed-k (inner tail child))))
    (outer k node #{:terminal?})))

(defn- walk [f k node]
  (walk-one node k f (partial walk f)))

;; (defn collect [f state node & [parent]]
;;   (if (node/node? node)
;;     (node/collect node state f (partial collect f) parent)
;;     (f state node parent)))

;; (defn- insert-one [store node root?]
;;   (let [[byte-hash bytes] (flatten-node node root?)
;;         store             (cond-> store
;;                             byte-hash (kv/insert byte-hash bytes))]

;;     [store (if root?
;;              node
;;              (or byte-hash bytes))]))

;; (defn- flatten-trie [store node]
;;   (collect
;;    (fn [store node parent]
;;      (if (and node (node/node? node))
;;        (insert-one store node (not parent))
;;        [store node]))
;;    store node))

(defn- attach-walker [v k node & [opts]]
  (cond-> node (:terminal? opts) (node/attach k v)))

(defrecord KVTrie [root]
  Trie
  (-insert [this k v]
    (let [root (walk (partial attach-walker v) k root)]
      (assoc this :root root)))
  (commit [this]
    ;; (let [[store root] (flatten-trie store root)]
    ;;   (assoc this :root root :store store))
    )
  (-search [this node k]
    (lazy-seq
     (cons [node k]
           (when-let [[child rest-k] (node/descend node k)]
             (-search this child rest-k))))))

(defn insert [t k v]
  (-insert t (nibble/->nibbles k) v))

(defn search [t k]
  (let [path (-search t (:root t) (nibble/->nibbles k))]
    (apply node/value (last path))))

(defn prove [t k]
  (let [[root & nodes] (->> (-search t (:root t) (nibble/->nibbles k))
                            (map (comp node->rlp first)))]
    (into [root] (filter (complement inline-node?) nodes))))

(defn- descend-inline [node k]
  (when-let [[child rest-k] (node/descend node k)]
    (if-not (node/node? child)
      [child rest-k]
      (recur child rest-k))))

;; (defn verify [hash k [head & rest-proof]]
;;   (if (and head (= (util/hex->bytes hash) (util/sha3 head)))
;;     (let [node (trie.rlp/bytes->node head)]
;;       (if (node/terminates? node k)
;;         (if rest-proof
;;           ::invalid
;;           (node/value node))
;;         (when-let [[next-hash rest-k] (descend-inline head k)]
;;           (recur next-hash rest-k rest-proof)
;;           (when rest-proof
;;             ::invalid))))
;;     ::invalid))

(defn map->KVTrie [opts]
  (let [store (:store opts)
        node  (some-> (:root opts)
                      (realize store))]
    (KVTrie. node)))

;; (def ^:private rlp-translator
;;   (reify leveldb/LevelDBTranslator
;;     (outgoing-key [_ k]
;;       (cond-> k (string? k) util/hex->bytes))
;;     (outgoing-value [_ v]
;;       v)
;;     (incoming-value [_ v]
;;       (rlp/decode-bytes v {:shallow? true}))))
