/*
 * Decompiled with CFR 0.152.
 */
package io.partx.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Date;

public class Metadata {
    private String name;
    private String version;
    private Date startTime;

    @JsonProperty(value="liveTimeMs")
    public long getLiveTimeMs() {
        return System.currentTimeMillis() - this.startTime.getTime();
    }

    private static Date $default$startTime() {
        return new Date();
    }

    @ConstructorProperties(value={"name", "version", "startTime"})
    Metadata(String name, String version, Date startTime) {
        this.name = name;
        this.version = version;
        this.startTime = startTime;
    }

    public static MetadataBuilder builder() {
        return new MetadataBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public static class MetadataBuilder {
        private String name;
        private String version;
        private boolean startTime$set;
        private Date startTime;

        MetadataBuilder() {
        }

        public MetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetadataBuilder version(String version) {
            this.version = version;
            return this;
        }

        public MetadataBuilder startTime(Date startTime) {
            this.startTime = startTime;
            this.startTime$set = true;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.name, this.version, this.startTime$set ? this.startTime : Metadata.$default$startTime());
        }

        public String toString() {
            return "Metadata.MetadataBuilder(name=" + this.name + ", version=" + this.version + ", startTime=" + this.startTime + ")";
        }
    }
}

